/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Freescale Semiconductor - modified by and for Freescale
 *******************************************************************************/
package com.freescale.system.browser.internal.ui.tabbed;


import org.eclipse.jface.resource.ImageDescriptor;

import com.freescale.system.browser.internal.ui.Tab;


/**
 * Represents a tab to be displayed in the tab list in the tabbed sheet
 * page.
 */
public interface ITabDescriptor {

	/**
	 * Get the ID for the tab.
	 * 
	 * @return the ID for the tab.
	 */
	public String getId();
	
	/**
	 * Get the icon image for the tab.
	 * 
	 * @return the icon image for the tab.
	 */
	public ImageDescriptor getImage();

	/**
	 * Get the text label for the tab.
	 * 
	 * @return the text label for the tab.
	 */
	public String getLabel();

	/**
	 * Determine if this tab is selected.
	 * 
	 * @return <code>true</code> if this tab is selected.
	 */
	public boolean isSelected();

	/**
	 * Determine if this tab is indented.
	 * 
	 * @return <code>true</code> if this tab is indented.
	 */
	public boolean isIndented();

	public boolean showForInput(Object input);

	public Tab createTab();
}
