/**
* Copyright 2019, 2023 NXP
*
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*/ 

package com.nxp.s32ds.ext.rcp.utils.epl.viewers;

import org.eclipse.jface.viewers.ICheckStateProvider;

/**
 * Class is used in {@link ContainerFilteredCheckboxTreeViewer}.
 *
 */
public class TreeContentCheckStateProvider implements ICheckStateProvider {

	private final TreeContentCheckStateHolder stateHolder;

	public TreeContentCheckStateProvider(TreeContentCheckStateHolder stateHolder) {
		this.stateHolder = stateHolder;
	}

	@Override
	public boolean isChecked(Object element) {
		// we should set checked if grayed is true
		return stateHolder.isChecked(element) || isGrayed(element);
	}

	@Override
	public boolean isGrayed(Object element) {
		return !stateHolder.isChecked(element) && stateHolder.isChildChecked(element);
	}
}