/**
 * Copyright 2018-2019 NXP
 * Created: Feb 16, 2018
 */

package com.nxp.swtools.periphs.gui.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.utils.view.ToolView;

/**
 * Default component settings view displayed on tool startup in the place of component settings views.
 * @author David Danaj (b57899/nxa30572)
 */
public class DefaultComponentSettingsView extends ToolView {
	/** ID of the view */
	public static final @NonNull String ID = "com.nxp.swtools.periphs.gui.view.DefaultComponentSettingsView"; //$NON-NLS-1$
	/** the number of pixels of horizontal margin that will be placed along the left and right edges of the layout */
	private static final int MARGIN_WIDTH = 10;
	/** the number of pixels of vertical margin that will be placed along the top and bottom edges of the layout */
	private static final int MARGIN_HEIGHT = 10;
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parentComposite) {
		Composite contentComposite = new Composite(parentComposite, SWT.NONE);
		FillLayout layout = new FillLayout();
		layout.marginHeight = MARGIN_HEIGHT;
		layout.marginWidth = MARGIN_WIDTH;
		contentComposite.setLayout(layout);
		Label label = new Label(contentComposite, SWT.NONE);
		label.setText(UtilsText.safeString(Messages.get().DefaultComponentSettingsView_Label));
		FontFactory.scaleFontSize(label, 1.2);
		setToolMainControl(contentComposite);
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
	 */
	@Override
	public void setFocus() {
		// intentionally empty
	}
}
