/**
 * Copyright 2021 NXP
 * Created: Sep 9, 2021
 */
package com.nxp.swtools.periphs.gui.handler;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.gui.view.MigrationOfferDialog;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.utils.ConfigurationUtils.OpenAction;
import com.nxp.swtools.utils.IOpenConfigurationExtension;

/**
 * Extension point that reacts on event: Configuration opened
 * @author Tomas Rudolf - nxf31690
 *
 */
public class ReactAfterOpeningConfiguration implements IOpenConfigurationExtension {

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.IOpenConfigurationExtension#afterConfigurationOpened(org.eclipse.swt.widgets.Shell, com.nxp.swtools.provider.configuration.ISharedConfiguration, com.nxp.swtools.utils.ConfigurationUtils.OpenAction, org.eclipse.core.runtime.IProgressMonitor)
	 */
	@Override
	public void afterConfigurationOpened(@Nullable Shell shell, ISharedConfiguration configuration, OpenAction action,
			@NonNull IProgressMonitor monitor) {
		openMigrationOfferDialog(shell, configuration);
	}

	/**
	 * Opens {@link MigrationOfferDialog} when Peripherals perspective is activated
	 * @param shell used as a parent in dialog
	 * @param configuration on which will be dialog opened
	 */
	private static void openMigrationOfferDialog(@SuppressWarnings("unused") @Nullable Shell shell, ISharedConfiguration configuration) {
		if (configuration.isEmpty() || SWToolsProperties.isHeadlessOn()) {
			return;
		}
		MigrationOfferDialogHelper.openNowOrWhenPeripheralsPerspectiveIsActive();
	}
}
