/*******************************************************************************
 * Copyright 2023 NXP
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/

package com.freescale.s32ds.ext.cdt.utils.epl.help;

import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import com.freescale.s32ds.ext.cdt.utils.epl.EclipseUtilsEpl;

public enum OSFamilyEpl {

	WINDOWS("windows", osStartsWith("win")), 
	LINUX("linux", osStartsWith(Platform.OS_LINUX)), 
	OSX("osx", osStartsWith("mac")),
	OTHER("other", false);

	public static final OSFamilyEpl current = Stream.of(values()).filter(f -> f.isCurrent).findAny().orElse(OTHER);
	public final String family; 
	private final boolean isCurrent;
	
	private OSFamilyEpl(String family, boolean isCurrent) {
		this.family = family;
		this.isCurrent = isCurrent;
	}
	
	public boolean isCurrent() {
		return equals(current);
	}
	
	private static boolean osStartsWith(String prefix) {
		return System.getProperty(EclipseUtilsEpl.PROPERTY_OS_NAME).toLowerCase().startsWith(prefix);
	}
	
}
