/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.integration.diags.CustomLineChart;
import com.nxp.swtools.mem.validation.integration.diags.Messages;
import com.nxp.swtools.mem.validation.model.DiagsEyeResultHandler;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsFigure;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import java.util.ArrayList;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class VDiagsOverlayFigure
extends VDiagsFigure {
    private static final Logger LOGGER = LogManager.getLogger(VDiagsOverlayFigure.class);
    @Nullable
    private CustomLineChart lineChart;

    public VDiagsOverlayFigure(VTable vTable) {
        super(vTable);
    }

    public void drawOverlappedCharts() {
        int count = -1;
        ArrayList<XYChart.Data> lastDataList = new ArrayList<XYChart.Data>();
        XYChart.Data firstData = new XYChart.Data();
        XYChart.Data lastData = new XYChart.Data();
        ArrayList crtDiagsData = this.diagsData;
        CustomLineChart lineChartLoc = this.lineChart;
        if (crtDiagsData != null && lineChartLoc != null) {
            ArrayList<XYChart.Data<Number, Number>> centerDataList = new ArrayList<XYChart.Data<Number, Number>>();
            for (DiagsEyeResultHandler.EyeTable table : crtDiagsData) {
                XYChart.Series currentSeries = (XYChart.Series)lineChartLoc.getData().get(++count);
                int[][] data = table.data();
                ArrayList yAxis = table.yAxis();
                ArrayList xAxis = table.xAxis();
                if (xAxis == null || yAxis == null || data == null) {
                    LOGGER.severe(Messages.InvalidDataMessage);
                    break;
                }
                int dataWidth = xAxis.size();
                int dataHeight = yAxis.size();
                int i = 0;
                while (i < dataHeight) {
                    int maxCount = 0;
                    int counter = 0;
                    int firstX = 0;
                    int j = 0;
                    while (j < dataWidth) {
                        if (data[i][j] == 0 || data[i][j] == -1) {
                            if (data[i][j] == -1 && ((Double)yAxis.get(i)).doubleValue() == table.goldenVref()) {
                                centerDataList.add((XYChart.Data<Number, Number>)new XYChart.Data((Object)((Number)xAxis.get(j)), (Object)((Number)yAxis.get(i))));
                            }
                            if (firstX == 0) {
                                firstX = j;
                            }
                            ++counter;
                        } else {
                            if (counter > maxCount) {
                                maxCount = counter;
                                firstData = new XYChart.Data((Object)((Number)xAxis.get(firstX)), (Object)((Number)yAxis.get(i)));
                                lastData = new XYChart.Data((Object)((Number)xAxis.get(j - 1)), (Object)((Number)yAxis.get(i)));
                            }
                            firstX = 0;
                            counter = 0;
                        }
                        ++j;
                    }
                    if (maxCount > 0 || maxCount == 0 && firstX != 0) {
                        if (maxCount == 0 && firstX != 0) {
                            firstData = new XYChart.Data((Object)((Number)xAxis.get(firstX)), (Object)((Number)yAxis.get(i)));
                            lastData = new XYChart.Data((Object)((Integer)xAxis.get(dataWidth - 1) + 1), (Object)((Number)yAxis.get(i)));
                        }
                        if (firstData != lastData) {
                            lastData.setNode((Node)new HoveredThresholdNode((XYChart.Data<Number, Number>)lastData, 50));
                            lastDataList.add(lastData);
                        }
                        firstData.setNode((Node)new HoveredThresholdNode((XYChart.Data<Number, Number>)firstData, 50));
                        currentSeries.getData().add((Object)firstData);
                    }
                    ++i;
                }
                i = lastDataList.size() - 1;
                while (i >= 0) {
                    currentSeries.getData().add((Object)((XYChart.Data)lastDataList.get(i)));
                    --i;
                }
                lastDataList.clear();
            }
            if (!centerDataList.isEmpty()) {
                lineChartLoc.setCenterPoints(centerDataList);
            }
            lineChartLoc.addLegendListener();
        }
    }

    public void updateDiagsInfo(CustomLineChart lineAreaChart) {
        this.lineChart = lineAreaChart;
    }

    static class HoveredThresholdNode
    extends StackPane {
        HoveredThresholdNode(XYChart.Data<Number, Number> item, int xTranslation) {
            this.setPrefSize(5.0, 5.0);
            this.setOpacity(0.0);
            final Label label = new Label(String.format(Messages.CoordinatesLabel, item.getXValue(), item.getYValue()));
            label.getStyleClass().add((Object)"chart-node");
            label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            label.setTranslateX((double)xTranslation);
            this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    this.setOpacity(2000.0);
                    this.getChildren().setAll((Object[])new Node[]{label});
                    this.toFront();
                }
            });
            this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    this.setOpacity(0.0);
                    this.getChildren().clear();
                }
            });
        }
    }
}

