/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.IDiagsProvider;
import com.nxp.swtools.mem.validation.integration.diags.DiagsOverlapView;
import com.nxp.swtools.mem.validation.integration.diags.Messages;
import com.nxp.swtools.mem.validation.integration.diags.VDiagsOverlayFigure;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import java.util.Map;
import java.util.Objects;
import javafx.embed.swt.FXCanvas;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Control;

public class DiagsProvider
implements IDiagsProvider {
    @Nullable
    private CTabItem diagsOverlapTab = null;
    @Nullable
    private ScrolledComposite overlapScrolledPanel;
    @Nullable
    private DiagsOverlapView diagOverlapChart;
    private static final int OVERLAP_DIAGS_TAB_POS = 2;
    @Nullable
    private FXCanvas overlapGraphCanvas;

    public void createOverlappedChartsTab(@Nullable CTabFolder scenTabFolder) {
        if (this.diagsOverlapTab == null || this.diagsOverlapTab != null && this.diagsOverlapTab.isDisposed()) {
            CTabItem diagsOverlapTabLoc = this.diagsOverlapTab = new CTabItem(Objects.requireNonNull(scenTabFolder), 0, 2);
            diagsOverlapTabLoc.setText(Messages.DiagsTabName);
            diagsOverlapTabLoc.setControl((Control)this.overlapScrolledPanel);
        }
    }

    public void updateOverlappedCharts(CTabFolder scenTabFolder, VStagePresentation selectedStage) {
        if (this.diagOverlapChart == null) {
            this.diagOverlapChart = new DiagsOverlapView();
        }
        if (this.diagsOverlapTab != null && this.diagOverlapChart != null && selectedStage != null) {
            VDiagsOverlayFigure diagsFigure;
            VDiagsPresentation diagsScenario;
            IDisplayFigure figure;
            this.overlapGraphCanvas = this.diagOverlapChart.setInput(selectedStage, scenTabFolder, this.diagsOverlapTab);
            VScenarioPresentation scenario = selectedStage.getSelectedScenario();
            if (scenario instanceof VDiagsPresentation && (figure = (diagsScenario = (VDiagsPresentation)scenario).getChart()) instanceof VDiagsOverlayFigure && (diagsFigure = (VDiagsOverlayFigure)figure) != null) {
                diagsFigure.drawOverlappedCharts();
            }
        }
    }

    public void disposeDiagsTab() {
        if (this.diagsOverlapTab != null) {
            this.diagsOverlapTab.dispose();
        }
    }

    public void populateOverlappedChartsFigures(VScenario model, VDiagsPresentation diagsPresentation) {
        VTableGroup[] tableGroups = model.getTableGroups();
        Map diagFiguresMap = diagsPresentation.getDiagOverFiguresMap();
        if (tableGroups != null) {
            VDiagsOverlayFigure[][] crtOverTableFigures = new VDiagsOverlayFigure[tableGroups.length][];
            int i = 0;
            while (i < crtOverTableFigures.length) {
                VTableGroup tableGrp = tableGroups[i];
                VTable[] tables = tableGrp.getTables();
                crtOverTableFigures[i] = new VDiagsOverlayFigure[tables.length];
                int j = 0;
                while (j < tables.length) {
                    VDiagsOverlayFigure tableOverFigure;
                    crtOverTableFigures[i][j] = tableOverFigure = new VDiagsOverlayFigure(tables[j]);
                    diagFiguresMap.put(tables[j].getId(), tableOverFigure);
                    ++j;
                }
                ++i;
            }
            diagsPresentation.setDiagOverFigures((IDisplayFigure[][])crtOverTableFigures);
        }
    }

    public FXCanvas getOverlapGraphCanvas() {
        return this.overlapGraphCanvas;
    }
}

