/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.diags;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.integration.diags.CustomLineChart;
import com.nxp.swtools.mem.validation.integration.diags.Messages;
import com.nxp.swtools.mem.validation.integration.diags.VDiagsOverlayFigure;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.net.URL;
import javafx.embed.swt.FXCanvas;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DiagsOverlapView {
    @Nullable
    private ScrolledComposite graphScrolledPanel;
    @Nullable
    private FXCanvas graphCanvas;
    private int numGraphs = 0;
    @Nullable
    private VStagePresentation selectedStage;
    @Nullable
    private CustomLineChart lineAreaChart;

    public @Nullable FXCanvas createChart(CTabFolder scenTabFolder, @Nullable CTabItem diagsOverlapTab) {
        this.numGraphs = this.readNumGraphs();
        ScrolledComposite graphScrolledPanelLoc = this.graphScrolledPanel = new ScrolledComposite((Composite)scenTabFolder, 2816);
        graphScrolledPanelLoc.setExpandHorizontal(true);
        graphScrolledPanelLoc.setExpandVertical(true);
        FXCanvas graphCanvasLoc = this.graphCanvas = new FXCanvas((Composite)this.graphScrolledPanel, 0);
        graphCanvasLoc.setData((Object)Messages.DiagsTabName);
        if (this.numGraphs == 0) {
            this.createStatusLabel(graphCanvasLoc);
            this.lineAreaChart = null;
        } else if (this.selectedStage != null) {
            URL chartsSkin;
            VDiagsPresentation selectedScenario = (VDiagsPresentation)this.selectedStage.getSelectedScenario();
            NumberAxis xAxis = new NumberAxis();
            NumberAxis yAxis = new NumberAxis();
            if (selectedScenario != null) {
                VScenario scenario = selectedScenario.getModel();
                if (!scenario.isDiagsReadMargins()) {
                    xAxis = new NumberAxis(50.0, 90.0, 2.0);
                    yAxis = new NumberAxis(0.1, 0.5, 0.05);
                } else {
                    xAxis = new NumberAxis(-3.0, 33.0, 2.0);
                    yAxis = new NumberAxis(0.01, 0.36, 0.05);
                }
            }
            xAxis.setLabel(Messages.StrobeDelayLabel);
            yAxis.setLabel(Messages.VrefLabel);
            CustomLineChart lineAreaChartLoc = this.lineAreaChart = new CustomLineChart((Axis<Number>)xAxis, (Axis<Number>)yAxis);
            lineAreaChartLoc.setCreateSymbols(false);
            lineAreaChartLoc.setAnimated(false);
            lineAreaChartLoc.setCursor(Cursor.CROSSHAIR);
            lineAreaChartLoc.setLegendSide(Side.RIGHT);
            lineAreaChartLoc.setAxisSortingPolicy(LineChart.SortingPolicy.NONE);
            int graph = 0;
            while (graph < this.numGraphs) {
                XYChart.Series series = new XYChart.Series();
                series.setName(String.format(Messages.DefaultDq, graph));
                lineAreaChartLoc.getData().add((Object)series);
                ++graph;
            }
            HBox hBox = new HBox();
            HBox.setHgrow((Node)this.lineAreaChart, (Priority)Priority.ALWAYS);
            hBox.getChildren().addAll((Object[])new Node[]{this.lineAreaChart});
            Scene scene = new Scene((Parent)hBox, (Paint)Color.rgb((int)graphScrolledPanelLoc.getBackground().getRed(), (int)graphScrolledPanelLoc.getBackground().getGreen(), (int)graphScrolledPanelLoc.getBackground().getBlue()));
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader != null && (chartsSkin = classLoader.getResource("resources/overlapped-charts-skin.css")) != null) {
                scene.getStylesheets().add((Object)chartsSkin.getPath());
            }
            graphCanvasLoc.setScene(scene);
        }
        graphScrolledPanelLoc.setContent((Control)this.graphCanvas);
        graphScrolledPanelLoc.setMinSize(graphScrolledPanelLoc.computeSize(-1, -1));
        CTabItem diagsOverlapTabLoc = diagsOverlapTab;
        if (diagsOverlapTabLoc != null && !diagsOverlapTabLoc.isDisposed()) {
            diagsOverlapTabLoc.setControl((Control)this.graphScrolledPanel);
        }
        return this.graphCanvas;
    }

    private void createStatusLabel(FXCanvas gCanvas) {
        VParamVariation cell;
        VTable table;
        VStagePresentation stage = this.selectedStage;
        Label label = new Label();
        label.setAlignment(Pos.TOP_LEFT);
        label.setFont(new Font(15.0));
        if (stage != null && (table = stage.getSelectedScenarioTable()) != null && (cell = table.getParamVariation(new Point(0, 0))) != null) {
            VRunResult runResult = cell.getResult(0);
            if (runResult != null && runResult.getType() == VRunResult.ResultType.FAILED) {
                label.setText(runResult.getErrorMessage());
            } else if (table.getState() == VTable.TableState.RUNNING) {
                label.setText(Messages.CollectingDataLabel);
            } else {
                label.setText(Messages.NoDataCollectedLabel);
            }
        }
        Scene scene = new Scene((Parent)label);
        gCanvas.setScene(scene);
    }

    private int readNumGraphs() {
        VDiagsOverlayFigure diagsFigure;
        VDiagsPresentation diagsScenario;
        IDisplayFigure figure;
        VScenarioPresentation scenario;
        if (this.selectedStage != null && (scenario = this.selectedStage.getSelectedScenario()) instanceof VDiagsPresentation && (figure = (diagsScenario = (VDiagsPresentation)scenario).getChart()) instanceof VDiagsOverlayFigure && (diagsFigure = (VDiagsOverlayFigure)figure) != null) {
            return diagsFigure.getNoEyeTables();
        }
        return 0;
    }

    public @Nullable FXCanvas setInput(VStagePresentation selectedStage, CTabFolder scenTabFolder, CTabItem overlappedChartsTab) {
        VDiagsOverlayFigure diagsFigure;
        VDiagsPresentation diagsScenario;
        IDisplayFigure figure;
        this.selectedStage = selectedStage;
        this.graphCanvas = this.createChart(scenTabFolder, overlappedChartsTab);
        VScenarioPresentation scenario = selectedStage.getSelectedScenario();
        if (scenario instanceof VDiagsPresentation && (figure = (diagsScenario = (VDiagsPresentation)scenario).getChart()) instanceof VDiagsOverlayFigure && (diagsFigure = (VDiagsOverlayFigure)figure) != null) {
            diagsFigure.updateDiagsInfo(this.lineAreaChart);
            if (this.graphCanvas != null) {
                this.graphCanvas.redraw();
            }
        }
        return this.graphCanvas;
    }
}

