/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.ui.syntaxcoloring;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.rules.IWordDetector;

public class LinkerScriptWordDetector
implements IWordDetector {
    private static final LinkerScriptWordDetector instance = new LinkerScriptWordDetector();
    private static final Set<String> wordGroup1 = new HashSet<String>();
    private static final Set<String> wordGroup2 = new HashSet<String>();
    private static final Set<String> words = new HashSet<String>();

    static {
        wordGroup1.add("ALIGNALL");
        wordGroup1.add("INCLUDE");
        wordGroup1.add("OBJECT");
        wordGroup1.add("SIZEOF");
        wordGroup1.add("WRITEH");
        wordGroup1.add("ZERO_FILL_UNINITIALIZED");
        wordGroup1.add("ADDR");
        wordGroup1.add("EXCEPTION");
        wordGroup1.add("KEEP_SECTION");
        wordGroup1.add("REF_INCLUDE");
        wordGroup1.add("SIZEOF_ROM");
        wordGroup1.add("WRITEW");
        wordGroup1.add("ALIGN");
        wordGroup1.add("FORCE_ACTIVE");
        wordGroup1.add("MEMORY");
        wordGroup1.add("ENTRY");
        wordGroup1.add("KEEP");
        wordGroup1.add("LONG");
        wordGroup1.add("PROVIDE");
        wordGroup1.add("PROVIDE_HIDDEN");
        wordGroup1.add("SECTIONS");
        wordGroup1.add("WRITEB");
        wordGroup1.add("WRITES0COMMENT");
        wordGroup2.add("ORIGIN");
        wordGroup2.add("LENGTH");
        wordGroup2.add("OBJECT");
        wordGroup2.add("STATICINIT");
        wordGroup2.add("AT");
        wordGroup2.add("AFTER");
        wordGroup2.add("GROUP");
        words.addAll(wordGroup1);
        words.addAll(wordGroup2);
    }

    private LinkerScriptWordDetector() {
    }

    public static LinkerScriptWordDetector getInstance() {
        return instance;
    }

    public static Set<String> getWordgroup1() {
        return wordGroup1;
    }

    public static Set<String> getWordgroup2() {
        return wordGroup2;
    }

    public static Set<String> getWords() {
        return words;
    }

    public boolean isWordStart(char c) {
        String ch = String.valueOf(c);
        for (String word : words) {
            if (!word.startsWith(ch)) continue;
            return true;
        }
        return false;
    }

    public boolean isWordPart(char c) {
        String ch = String.valueOf(c);
        for (String word : words) {
            if (!word.contains(ch)) continue;
            return true;
        }
        return false;
    }
}

