/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.DivCommonSlave;
import com.nxp.swtools.clocks.model.Divider;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.FrequencyRange;
import com.nxp.swtools.clocks.model.INode;
import com.nxp.swtools.clocks.model.MulConstr;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.List;

public class Node
implements INode {
    @NonNull
    protected String id;
    @NonNull
    protected String originalID;
    @NonNull
    protected ENodeType type;
    protected boolean called;
    protected boolean enabled;
    protected boolean wasComputed = false;
    @NonNull
    protected BigRational accuracy;
    @Nullable
    protected BigRational minOutputFreq;
    @Nullable
    protected BigRational maxOutputFreq;
    @Nullable
    protected BigRational minInputFreq;
    @Nullable
    protected BigRational maxInputFreq;
    @Nullable
    protected List<@NonNull FrequencyRange> inputFrequencyRanges;
    @Nullable
    protected List<@NonNull FrequencyRange> outputFrequencyRanges;
    protected ECompState lastComp;
    protected boolean testFreqLimits;
    @NonNull
    public static final BigRational STARTING_DEVIATION = new BigRational(64, 100);
    @NonNull
    public static final BigRational ENDING_DEVIATION = new BigRational(1, 200);
    @Nullable
    protected FreqLimitErrorI logFLE = null;
    protected boolean stopComputation = false;

    public Node(@NonNull String id, @NonNull ENodeType type) {
        this.id = this.originalID = id;
        this.type = type;
        this.called = false;
        this.enabled = true;
        this.minOutputFreq = null;
        this.maxOutputFreq = null;
        this.minInputFreq = null;
        this.maxInputFreq = null;
        this.inputFrequencyRanges = null;
        this.outputFrequencyRanges = null;
        this.lastComp = ECompState.NoComp;
        this.testFreqLimits = true;
        this.accuracy = TimingScale.defaultAccuracy;
    }

    public @NonNull String getID() {
        return this.id;
    }

    public @NonNull String getOriginalID() {
        return this.originalID;
    }

    public @NonNull ENodeType getType() {
        return this.type;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void includeDefaults() {
    }

    public void excludeDefaults() {
    }

    @Override
    public void addChild(@NonNull Node child) {
        throw new UnsupportedOperationException("Method addChild node is not applicable.");
    }

    @Override
    public void addPred(@NonNull Node pred) {
        throw new UnsupportedOperationException("Method addPred node is not applicable.");
    }

    @Override
    public void setChild(@NonNull Node child) {
        throw new UnsupportedOperationException("Method setChild node is not applicable.");
    }

    @Override
    public void setPred(@NonNull Node pred) {
        throw new UnsupportedOperationException("Method setPred node is not applicable.");
    }

    @Override
    public void setMaster(@NonNull Divider master) {
        throw new UnsupportedOperationException("Method setMaster is not applicable.");
    }

    @Override
    public void setSlave(@NonNull Divider slave) {
        throw new UnsupportedOperationException("Method setSlave is not applicable.");
    }

    @Override
    public void addSlave(@NonNull Divider divider) {
        throw new UnsupportedOperationException("Method addSlave node is not applicable.");
    }

    @Override
    public void addMaster(@NonNull Divider master) {
        throw new UnsupportedOperationException("Method addMaster node is not applicable.");
    }

    @Override
    public @NonNull List<@NonNull Divider> getMasters() {
        throw new UnsupportedOperationException("Method getMasters node is not applicable.");
    }

    @Override
    public @Nullable Divider getSlave() {
        throw new UnsupportedOperationException("Method getSlave is not applicable.");
    }

    @Override
    public void addPredChildPair(@NonNull Node pred, @NonNull Node child) {
        throw new UnsupportedOperationException("Method addPredChildPair node is not applicable.");
    }

    @Override
    public void addPredChildPair(@NonNull String pairId, @NonNull Node pred, @NonNull Node child) {
        throw new UnsupportedOperationException("Method addPredChildPair node is not applicable.");
    }

    @Override
    public void setSelected(@Nullable Node node) {
        throw new UnsupportedOperationException("Method setSelected node is not applicable.");
    }

    @Override
    public void setDefaultSelected(@NonNull Node node) {
        throw new UnsupportedOperationException("Method setDefaultSelected node is not applicable.");
    }

    @Override
    public TimingScale getTimingScaleValues() {
        throw new UnsupportedOperationException("Method setTimingScaleValues node is not applicable.");
    }

    @Override
    public void setTimingScaleValues(@NonNull TimingScale scaler) {
        throw new UnsupportedOperationException("Method setTimingScaleValues node is not applicable.");
    }

    @Override
    public boolean setDefaultScale(@NonNull BigRational defaultScale) {
        throw new UnsupportedOperationException("Method setDefaultScale node is not applicable.");
    }

    @Override
    public @Nullable BigRational getDefaultScale() {
        throw new UnsupportedOperationException("Method getDefaultScale node is not applicable.");
    }

    @Override
    public boolean setScale(@Nullable BigRational newScale) {
        throw new UnsupportedOperationException("Method setScale node is not applicable.");
    }

    @Override
    public @Nullable BigRational getScale() {
        throw new UnsupportedOperationException("Method getScale node is not applicable.");
    }

    @Override
    public void setMulDivTimingScale(@NonNull TimingScale multiplier, @Nullable TimingScale divider) {
        throw new UnsupportedOperationException("Method setMulDivTimingScale node is not applicable.");
    }

    @Override
    public void setMultiplierDivider(@Nullable BigRational multiply, @Nullable BigRational divide) {
        throw new UnsupportedOperationException("Method setMultiplierDivider node is not applicable.");
    }

    @Override
    public @Nullable BigRational getMultiplier() {
        throw new UnsupportedOperationException("Method getMultiplierRational is not applicable for this node.");
    }

    @Override
    public @Nullable BigRational getDivider() {
        throw new UnsupportedOperationException("Method getDividerRational is not applicable for this node.");
    }

    @Override
    public void setDefaultMultiplierDivider(@Nullable BigRational multiply, @Nullable BigRational divide) {
        throw new UnsupportedOperationException("Method setDefaultMultiplierDivider node is not applicable.");
    }

    @Override
    public void setMultiplier(@Nullable BigRational multiply) {
        throw new UnsupportedOperationException("Method setMultiplier node is not applicable.");
    }

    @Override
    public void setDefaultMultiplier(@Nullable BigRational multiply) {
        throw new UnsupportedOperationException("Method setDefaultMultiplier node is not applicable.");
    }

    @Override
    public @Nullable BigRational getDefaultMultiplier() {
        throw new UnsupportedOperationException("Method getDefaultMultiplier is not applicable for this node.");
    }

    @Override
    public @Nullable BigRational getDefaultDivider() {
        throw new UnsupportedOperationException("Method getDefaultDividerRational is not applicable for this node.");
    }

    @Override
    public void setMinDividerFreq(@Nullable BigRational freq) {
        throw new UnsupportedOperationException("Method setMinDividerFreq is not applicable.");
    }

    @Override
    public void setMaxDividerFreq(@Nullable BigRational freq) {
        throw new UnsupportedOperationException("Method setMaxDividerFreq is not applicable.");
    }

    @Override
    public void setFraction(@Nullable BigInteger fraction) {
        throw new UnsupportedOperationException("Method setFraction is not applicable.");
    }

    @Override
    public @Nullable BigInteger getFraction() {
        throw new UnsupportedOperationException("Method getFraction is not applicable.");
    }

    @Override
    public boolean setInputFrequency(@NonNull BigRational freq) {
        throw new UnsupportedOperationException("Method setInputFrequency node is not applicable.");
    }

    @Override
    public boolean setInputFrequency(@NonNull BigInteger freq) {
        throw new UnsupportedOperationException("Method setInputFrequency node is not applicable.");
    }

    @Override
    public boolean setInputFrequency(byte freq) {
        throw new UnsupportedOperationException("Method setInputFrequency node is not applicable.");
    }

    @Override
    public boolean setInputFrequency(short freq) {
        throw new UnsupportedOperationException("Method setInputFrequency node is not applicable.");
    }

    @Override
    public boolean setInputFrequency(int freq) {
        throw new UnsupportedOperationException("Method setInputFrequency node is not applicable.");
    }

    @Override
    public boolean setInputFrequency(long freq) {
        throw new UnsupportedOperationException("Method setInputFrequency node is not applicable.");
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        throw new UnsupportedOperationException("Method setFrequency node is not applicable.");
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigInteger freq) {
        throw new UnsupportedOperationException("Method setFrequency node is not applicable.");
    }

    @Override
    public boolean setOutputFrequency(byte freq) {
        throw new UnsupportedOperationException("Method setFrequency node is not applicable.");
    }

    @Override
    public boolean setOutputFrequency(short freq) {
        throw new UnsupportedOperationException("Method setFrequency node is not applicable.");
    }

    @Override
    public boolean setOutputFrequency(int freq) {
        throw new UnsupportedOperationException("Method setFrequency node is not applicable.");
    }

    @Override
    public boolean setOutputFrequency(long freq) {
        throw new UnsupportedOperationException("Method setFrequency node is not applicable.");
    }

    @Override
    public @Nullable BigRational getFrequency() {
        throw new UnsupportedOperationException("Method getFrequency node is not applicable.");
    }

    @Override
    public void setAccuracy(@NonNull BigRational acc) {
        throw new UnsupportedOperationException("Method setAccuracy for node is not applicable.");
    }

    @Override
    public @Nullable BigRational getInputClock() {
        throw new UnsupportedOperationException("Method getInputClock of node is not applicable.");
    }

    @Override
    public @Nullable BigRational getOutputClock() {
        throw new UnsupportedOperationException("Method getOutputClock of node is not applicable.");
    }

    @Override
    public @Nullable BigRational getPLLdivClock() {
        throw new UnsupportedOperationException("Method getPLLdivClock of node is not applicable.");
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        unset.add(this);
        return false;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        unset.add(this);
        return false;
    }

    @Override
    public void resetCall() {
        this.called = false;
    }

    @Override
    public @NonNull EErrorType testInputFreq(@Nullable BigRational clock) {
        if (!this.testFreqLimits) {
            return EErrorType.None;
        }
        if (clock == null) {
            return EErrorType.ArgNull;
        }
        List<@NonNull FrequencyRange> inputRanges = this.inputFrequencyRanges;
        if (inputRanges != null) {
            for (FrequencyRange range : inputRanges) {
                if (!range.isInRange(clock)) continue;
                return EErrorType.None;
            }
            if (inputRanges.get(0).getMinimalFrequency().compareTo(clock) > 0) {
                return EErrorType.TooSlow;
            }
            if (inputRanges.get(inputRanges.size() - 1).getMaximalFrequency().compareTo(clock) < 0) {
                return EErrorType.TooFast;
            }
            return EErrorType.BothFastSlow;
        }
        BigRational xxMinInputFreq = this.minInputFreq;
        if (xxMinInputFreq != null && xxMinInputFreq.compareTo(clock) > 0) {
            return EErrorType.TooSlow;
        }
        BigRational xxMaxInputFreq = this.maxInputFreq;
        if (xxMaxInputFreq != null && xxMaxInputFreq.compareTo(clock) < 0) {
            return EErrorType.TooFast;
        }
        return EErrorType.None;
    }

    @Override
    public @NonNull EErrorType testOutputFreq(@Nullable BigRational clock) {
        if (!this.testFreqLimits) {
            return EErrorType.None;
        }
        if (clock == null) {
            return EErrorType.ArgNull;
        }
        List<@NonNull FrequencyRange> outputRanges = this.outputFrequencyRanges;
        if (outputRanges != null) {
            for (FrequencyRange range : outputRanges) {
                if (!range.isInRange(clock)) continue;
                return EErrorType.None;
            }
            if (outputRanges.get(0).getMinimalFrequency().compareTo(clock) > 0) {
                return EErrorType.TooSlow;
            }
            if (outputRanges.get(outputRanges.size() - 1).getMaximalFrequency().compareTo(clock) < 0) {
                return EErrorType.TooFast;
            }
            return EErrorType.BothFastSlow;
        }
        BigRational xxMinOutputFreq = this.minOutputFreq;
        if (xxMinOutputFreq != null && xxMinOutputFreq.compareTo(clock) > 0) {
            return EErrorType.TooSlow;
        }
        BigRational xxMaxOutputFreq = this.maxOutputFreq;
        if (xxMaxOutputFreq != null && xxMaxOutputFreq.compareTo(clock) < 0) {
            return EErrorType.TooFast;
        }
        return EErrorType.None;
    }

    @Override
    public void clean() {
    }

    @Override
    public void addMulConstWConstr(@NonNull BigRational mul, @Nullable BigRational inputLow, @Nullable BigRational inputHigh, @Nullable BigRational outputLow, @Nullable BigRational outputHigh) {
        throw new UnsupportedOperationException("Method addMulConstWConstr for Node is not applicable.");
    }

    @Override
    public void addMulConst(@NonNull BigRational mul) {
        throw new UnsupportedOperationException("Method addMulConst for Node is not applicable.");
    }

    @Override
    public void addMulConstWInputConstr(@NonNull BigRational mul, @Nullable BigRational inputLow, @Nullable BigRational inputHigh) {
        throw new UnsupportedOperationException("Method addMulConstWInputConstr for Node is not applicable.");
    }

    @Override
    public void addMulConstWOutputConstr(@NonNull BigRational mul, @Nullable BigRational outputLow, @Nullable BigRational outputHigh) {
        throw new UnsupportedOperationException("Method addMulConstWOutputConstr for Node is not applicable.");
    }

    @Override
    public boolean setDefaultMulConst(@NonNull BigRational mul) {
        throw new UnsupportedOperationException("Method setDefaultMulConst for Node is not applicable.");
    }

    @Override
    public @Nullable BigRational getDefaultMulConst() {
        throw new UnsupportedOperationException("Method getDefaultMulConstRational for Node is not applicable.");
    }

    @Override
    public boolean setMulConst(@NonNull BigRational mul) {
        throw new UnsupportedOperationException("Method setMulConst for Node is not applicable.");
    }

    @Override
    public @Nullable BigRational getMulConst() {
        throw new UnsupportedOperationException("Method getMulConstRational for Node is not applicable.");
    }

    @Override
    public @Nullable BigRational getMinOutputFreq() {
        return this.minOutputFreq;
    }

    @Override
    public void setMinOutputFreq(@Nullable BigRational minOutputFreq) {
        this.minOutputFreq = minOutputFreq;
        if (minOutputFreq != null) {
            this.outputFrequencyRanges = null;
        }
    }

    @Override
    public @Nullable BigRational getMaxOutputFreq() {
        return this.maxOutputFreq;
    }

    @Override
    public void setMaxOutputFreq(@Nullable BigRational maxOutputFreq) {
        this.maxOutputFreq = maxOutputFreq;
        if (maxOutputFreq != null) {
            this.outputFrequencyRanges = null;
        }
    }

    @Override
    public @Nullable BigRational getMinInputFreq() {
        return this.minInputFreq;
    }

    @Override
    public void setMinInputFreq(@Nullable BigRational minInputFreq) {
        this.minInputFreq = minInputFreq;
        if (minInputFreq != null) {
            this.inputFrequencyRanges = null;
        }
    }

    @Override
    public @Nullable BigRational getMaxInputFreq() {
        return this.maxInputFreq;
    }

    @Override
    public void setMaxInputFreq(@Nullable BigRational maxInputFreq) {
        this.maxInputFreq = maxInputFreq;
        if (maxInputFreq != null) {
            this.inputFrequencyRanges = null;
        }
    }

    @Override
    public void setInputFrequencyRanges(@Nullable List<@NonNull FrequencyRange> inputRanges) {
        if (inputRanges == null) {
            this.inputFrequencyRanges = null;
        } else {
            this.minInputFreq = null;
            this.maxInputFreq = null;
            this.inputFrequencyRanges = inputRanges;
        }
    }

    @Override
    public void setOutputFrequencyRanges(@Nullable List<@NonNull FrequencyRange> outputRanges) {
        if (outputRanges == null) {
            this.outputFrequencyRanges = null;
        } else {
            this.minOutputFreq = null;
            this.maxOutputFreq = null;
            this.outputFrequencyRanges = outputRanges;
        }
    }

    @Override
    public @Nullable List<@NonNull FrequencyRange> getInputFrequencyRanges() {
        return this.inputFrequencyRanges;
    }

    @Override
    public @Nullable List<@NonNull FrequencyRange> getOutputFrequencyRanges() {
        return this.outputFrequencyRanges;
    }

    @Override
    public ECompState getLastCompState() {
        return this.lastComp;
    }

    @Override
    public void setFreqLimitErrorLog(@Nullable FreqLimitErrorI flog) {
        this.logFLE = flog;
    }

    @Override
    public void enableMultiplexerAutoSelect() {
        throw new UnsupportedOperationException("Method enableMultiplexerAutoSelect is not applicable.");
    }

    @Override
    public void disableMultiplexerAutoSelect() {
        throw new UnsupportedOperationException("Method disableMultiplexerAutoSelect is not applicable.");
    }

    @Override
    public void trackAutoWR(@NonNull Node callee) {
        throw new UnsupportedOperationException("Method trackAutoWR is not applicable for class Node.");
    }

    @Override
    public boolean getReversePath(@NonNull Node callee, @NonNull List<@NonNull Node> path) {
        throw new UnsupportedOperationException("Method getReversePath is not applicable for class Node.");
    }

    @Override
    public boolean getInternalDivError() {
        throw new UnsupportedOperationException("Method getInternalDivError is not applicable for class Node.");
    }

    @Override
    public boolean wasNodeComputed() {
        return this.wasComputed;
    }

    @Override
    public void resetNodeComputed() {
        this.wasComputed = false;
    }

    @Override
    public void resetFirstTrackFlag() {
    }

    @Override
    public @NonNull BigRational initSearchWithinInterval() {
        @NonNull BigRational result = this.accuracy;
        this.accuracy = STARTING_DEVIATION;
        return result;
    }

    @Override
    public @Nullable BigRational narrowSearchInterval() {
        if (this.accuracy.compareTo(ENDING_DEVIATION) <= 0) {
            return null;
        }
        @NonNull BigRational result = this.accuracy;
        this.accuracy = this.accuracy.divide((byte)2);
        return result;
    }

    @Override
    public @NonNull BigRational halfStepBackInterval() {
        this.accuracy = this.accuracy.add(this.accuracy.divide((byte)2));
        return this.accuracy;
    }

    @Override
    public void setMaximalRatio(@Nullable BigInteger maxRatio) {
        throw new UnsupportedOperationException("Method setMaximalRatio is not applicable for class Node.");
    }

    @Override
    public @Nullable BigInteger getMaximalRatio() {
        throw new UnsupportedOperationException("Method getMaximalRatio is not applicable for class Node.");
    }

    @Override
    public @NonNull List<@NonNull DivCommonSlave> getSlaveDividers() {
        throw new UnsupportedOperationException("Method getSlaveDividers is not applicable for this class.");
    }

    @Override
    public @Nullable Divider getMasterDivider() {
        throw new UnsupportedOperationException("Method getMasterDivider is not applicable for this class.");
    }

    @Override
    public void setAllowedRatios(@NonNull List<@NonNull BigRational> ratios) {
        throw new UnsupportedOperationException("Method setAllowedRatios is not applicable for this class.");
    }

    @Override
    public void resetAndCleanScale() {
        throw new UnsupportedOperationException("Method resetAndCleanScale is not applicable for this class.");
    }

    @Override
    public @Nullable TimingScale getMultiplicativeScale() {
        throw new UnsupportedOperationException("Method getmultiplicativeScale is not applicable for this class.");
    }

    @Override
    public @Nullable TimingScale getDivisionScale() {
        throw new UnsupportedOperationException("Method getDivisionScale is not applicable for this class.");
    }

    @Override
    public @Nullable BigRational getPLLMinDividerOutput() {
        throw new UnsupportedOperationException("Method getPLLMinDividerOutput is not applicable for this class.");
    }

    @Override
    public @Nullable BigRational getPLLMaxDividerOutput() {
        throw new UnsupportedOperationException("Method getPLLMaxDividerOutput is not applicable for this class.");
    }

    @Override
    public @NonNull List<@NonNull MulConstr> getMultiplicativeScaleWConstraints() {
        throw new UnsupportedOperationException("Method getmultiplicativeScaleWConstraints is not applicable for this class.");
    }

    @Override
    public void stopComputation() {
        this.stopComputation = true;
    }

    @Override
    public void allowComputation() {
        this.stopComputation = false;
    }

    @Override
    public void setAllowedLimits(@NonNull BigInteger mulLow, @NonNull BigInteger mulMax, @NonNull BigInteger numMax, @NonNull BigInteger denMax) {
        throw new UnsupportedOperationException("Method setAllowedLimits is not applicable for this class.");
    }

    @Override
    public void setAllowedLimits(@NonNull BigInteger mulLow, @NonNull BigInteger mulMax, @NonNull BigInteger numMax, @NonNull BigInteger denMax, @NonNull BigInteger numMin, @NonNull BigInteger denMin) {
        throw new UnsupportedOperationException("Method setAllowedLimits is not applicable for this class.");
    }

    @Override
    public boolean setGeneratorValues(@NonNull BigInteger mulFactor, @NonNull BigInteger numerator, @NonNull BigInteger denominator) {
        throw new UnsupportedOperationException("Method setGeneratorValues is not applicable for this class.");
    }

    @Override
    public BigInteger getMul() {
        throw new UnsupportedOperationException("Method getMul is not applicable for this class.");
    }

    @Override
    public BigInteger getNumerator() {
        throw new UnsupportedOperationException("Method getNumerator is not applicable for this class.");
    }

    @Override
    public BigInteger getDenominator() {
        throw new UnsupportedOperationException("Method getDenominator is not applicable for this class.");
    }

    @Override
    public void setSuitableFrequencies(@Nullable List<@NonNull BigRational> suitableFrequencies) {
        throw new UnsupportedOperationException("Method setSuitableFrequencies is not applicable for this class.");
    }

    @Override
    public void setPostDivider(@NonNull BigRational postDividerValue) {
        throw new UnsupportedOperationException("Method setPostDivider is not applicable for this class.");
    }

    @Override
    public BigRational getPostDivider() {
        throw new UnsupportedOperationException("Method getPostDivider is not applicable for this class.");
    }

    @Override
    public void setJustMultiplier(@Nullable BigRational multiply) {
        throw new UnsupportedOperationException("Method setJustMutliplier is not applicable for this class.");
    }

    @Override
    public EErrorType reverseCompute(@NonNull BigRational requiredFreq) {
        throw new UnsupportedOperationException("Method reverseCompute is not applicable for this class.");
    }

    static interface IClockModify {
        public @NonNull BigRational clockModify(@NonNull BigRational var1);
    }
}

