/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.MulConstr;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeSimpleCon;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class FLLext
extends NodeSimpleCon {
    @NonNull
    private @NonNull ArrayList<@NonNull MulConstr> scaleList = new ArrayList();
    @Nullable
    private MulConstr defaultScale = null;
    @Nullable
    private MulConstr setScale = null;
    @Nullable
    private MulConstr compScale = null;
    private boolean useDefaults = true;
    @Nullable
    private BigRational outputClock = null;
    @Nullable
    private BigRational inputClock = null;
    @Nullable
    private BigRational setOutputFreq = null;
    private boolean importedFreq;
    @NonNull
    private BigRational savedAcc;

    public FLLext(@NonNull String id) {
        super(id, ENodeType.FLLext);
        this.accuracy = TimingScale.defaultAccuracy;
        this.importedFreq = false;
        this.savedAcc = this.accuracy;
    }

    @Override
    public void includeDefaults() {
        this.useDefaults = true;
    }

    @Override
    public void excludeDefaults() {
        this.useDefaults = false;
    }

    @Override
    public void addMulConstWConstr(@NonNull BigRational mul, @Nullable BigRational inputLow, @Nullable BigRational inputHigh, @Nullable BigRational outputLow, @Nullable BigRational outputHigh) {
        MulConstr mulConstr = new MulConstr(mul);
        mulConstr.inLo = inputLow;
        mulConstr.inHi = inputHigh;
        mulConstr.outLo = outputLow;
        mulConstr.outHi = outputHigh;
        this.scaleList.add(mulConstr);
    }

    @Override
    public void addMulConst(@NonNull BigRational mul) {
        MulConstr mulConstr = new MulConstr(mul);
        mulConstr.inLo = null;
        mulConstr.inHi = null;
        mulConstr.outLo = null;
        mulConstr.outHi = null;
        this.scaleList.add(mulConstr);
    }

    @Override
    public void addMulConstWInputConstr(@NonNull BigRational mul, @Nullable BigRational inputLow, @Nullable BigRational inputHigh) {
        MulConstr mulConstr = new MulConstr(mul);
        mulConstr.inLo = inputLow;
        mulConstr.inHi = inputHigh;
        mulConstr.outLo = null;
        mulConstr.outHi = null;
        this.scaleList.add(mulConstr);
    }

    @Override
    public void addMulConstWOutputConstr(@NonNull BigRational mul, @Nullable BigRational outputLow, @Nullable BigRational outputHigh) {
        MulConstr mulConstr = new MulConstr(mul);
        mulConstr.inLo = null;
        mulConstr.inHi = null;
        mulConstr.outLo = outputLow;
        mulConstr.outHi = outputHigh;
        this.scaleList.add(mulConstr);
    }

    @Override
    public boolean setDefaultMulConst(@NonNull BigRational mul) {
        assert (this.scaleList.size() > 0) : "Empty scale in FLLext " + this.id;
        for (MulConstr mulConstr : this.scaleList) {
            if (!mul.equals((Object)mulConstr.mulBy)) continue;
            this.defaultScale = mulConstr;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable BigRational getDefaultMulConst() {
        MulConstr locDefaultScale = this.defaultScale;
        if (locDefaultScale == null) {
            return null;
        }
        return locDefaultScale.mulBy;
    }

    @Override
    public boolean setMulConst(@NonNull BigRational mul) {
        assert (this.scaleList.size() > 0) : "Empty scale in FLLext " + this.id;
        for (MulConstr mulConstr : this.scaleList) {
            if (!mul.equals((Object)mulConstr.mulBy)) continue;
            this.setScale = mulConstr;
            return true;
        }
        FreqLimitErrorI tmpLogFLE = this.logFLE;
        if (tmpLogFLE != null && this.enabled) {
            tmpLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
        }
        return false;
    }

    @Override
    public @Nullable BigRational getMulConst() {
        MulConstr locSetScale = this.setScale;
        if (locSetScale == null) {
            return null;
        }
        return locSetScale.mulBy;
    }

    @Override
    public @NonNull List<@NonNull MulConstr> getMultiplicativeScaleWConstraints() {
        @NonNull ArrayList<@NonNull MulConstr> result = new ArrayList<MulConstr>(this.scaleList.size());
        for (MulConstr mulConstr : this.scaleList) {
            result.add(mulConstr.clone());
        }
        return result;
    }

    @Override
    public boolean setOutputFrequency(byte freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(short freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(int freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(long freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigInteger freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        this.setOutputFreq = freq;
        return this.checkOutputFreq(freq);
    }

    @Override
    public @Nullable BigRational getFrequency() {
        return this.setOutputFreq;
    }

    @Override
    public void setAccuracy(@NonNull BigRational acc) {
        this.accuracy = acc;
        assert (this.accuracy.compareTo(BigRational.ZERO) >= 0);
    }

    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        String ps = null;
        ps = this.pred != null ? this.pred.id : "";
        String cs = null;
        cs = this.inputClock == null ? "" : "@" + this.inputClock;
        if (this.outputClock != null) {
            cs = String.valueOf(cs) + "#" + this.outputClock;
        }
        System.out.println(String.valueOf(pref) + "+--" + this.id + "(" + ps + ")" + cs);
        if (this.child != null) {
            if ("".equals(prefLast)) {
                this.child.printT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    ");
            } else {
                this.child.printT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     ");
            }
        }
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer ps = new StringBuffer();
        if (this.pred != null) {
            ps.append(this.pred.id);
        }
        StringBuffer cs = new StringBuffer();
        if (this.inputClock != null) {
            cs.append('@');
            cs.append(this.inputClock);
        }
        if (this.outputClock != null) {
            cs.append('#');
            cs.append(this.outputClock);
        }
        StringBuffer res = new StringBuffer(pref);
        res.append("+--");
        res.append(this.id);
        res.append('(');
        res.append(ps);
        res.append(')');
        res.append(cs);
        res.append('\n');
        if (this.child != null) {
            if ("".equals(prefLast)) {
                res.append(this.child.stringT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    "));
            } else {
                res.append(this.child.stringT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     "));
            }
        }
        return res;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        if (this.setScale == null) {
            unset.add(this);
            return false;
        }
        return true;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        if (this.setScale == null && this.defaultScale == null) {
            unset.add(this);
            return false;
        }
        return true;
    }

    @Override
    public void clean() {
        this.setOutputFreq = null;
        this.setScale = null;
        this.compScale = null;
    }

    @Override
    public void resetAndCleanScale() {
        this.scaleList = new ArrayList();
        this.defaultScale = null;
        this.setScale = null;
        this.compScale = null;
        this.inputClock = null;
        this.setOutputFreq = null;
        this.accuracy = TimingScale.defaultAccuracy;
        this.importedFreq = false;
        this.savedAcc = this.accuracy;
    }

    private static @NonNull EErrorType checkInFreq(@NonNull BigRational clock, @NonNull MulConstr mulConstr) {
        if (mulConstr.inLo != null && clock.compareTo(mulConstr.inLo) < 0) {
            return EErrorType.TooSlow;
        }
        if (mulConstr.inHi != null && clock.compareTo(mulConstr.inHi) > 0) {
            return EErrorType.TooFast;
        }
        return EErrorType.None;
    }

    private static @NonNull EErrorType checkOutFreq(@NonNull BigRational clock, @NonNull MulConstr mulConstr) {
        if (mulConstr.outLo != null && clock.compareTo(mulConstr.outLo) < 0) {
            return EErrorType.TooSlow;
        }
        if (mulConstr.outHi != null && clock.compareTo(mulConstr.outHi) > 0) {
            return EErrorType.TooFast;
        }
        return EErrorType.None;
    }

    @Override
    public boolean checkInputFreq(@Nullable BigRational clock) {
        boolean res = super.checkInputFreq(clock);
        if (res && clock != null) {
            MulConstr actScale = this.setScale;
            if (actScale == null && this.useDefaults) {
                actScale = this.defaultScale;
            }
            if (actScale != null) {
                FreqLimitErrorI xxLogFLE = this.logFLE;
                if (FLLext.checkInFreq(clock, actScale) != EErrorType.None) {
                    if (xxLogFLE != null && this.enabled) {
                        xxLogFLE.logFreqLimitError(true, this);
                    }
                    res = false;
                }
            }
        }
        return res;
    }

    @Override
    public boolean checkOutputFreq(@Nullable BigRational clock) {
        boolean res = super.checkOutputFreq(clock);
        if (res && clock != null) {
            MulConstr actScale = this.setScale;
            if (actScale == null && this.useDefaults) {
                actScale = this.defaultScale;
            }
            if (actScale != null) {
                FreqLimitErrorI xxLogFLE = this.logFLE;
                if (FLLext.checkOutFreq(clock, actScale) != EErrorType.None) {
                    if (xxLogFLE != null && this.enabled) {
                        xxLogFLE.logFreqLimitError(false, this);
                    }
                    res = false;
                }
            }
        }
        return res;
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        BigRational locOutputClock;
        if (!this.enabled) {
            return true;
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        FreqLimitErrorI locLogFLE = this.logFLE;
        MulConstr locSetScale = this.setScale;
        if (locSetScale != null) {
            if (FLLext.checkInFreq(clock, locSetScale) != EErrorType.None) {
                res = false;
                if (locLogFLE != null) {
                    locLogFLE.logFreqLimitError(true, this);
                }
            }
            if (FLLext.checkOutFreq(locOutputClock = clock.multiply(locSetScale.mulBy), locSetScale) != EErrorType.None) {
                res = false;
                if (locLogFLE != null) {
                    locLogFLE.logFreqLimitError(false, this);
                }
            }
        } else {
            assert (this.useDefaults) : "Default vaule used even if forbidden in " + this.id;
            MulConstr locDefaultScale = this.defaultScale;
            assert (locDefaultScale != null) : "Default value not initialized and expected to be used in " + this.id;
            if (FLLext.checkInFreq(clock, locDefaultScale) != EErrorType.None) {
                res = false;
                if (locLogFLE != null) {
                    locLogFLE.logFreqLimitError(true, this);
                }
            }
            if (FLLext.checkOutFreq(locOutputClock = clock.multiply(locDefaultScale.mulBy), locDefaultScale) != EErrorType.None) {
                res = false;
                if (locLogFLE != null) {
                    locLogFLE.logFreqLimitError(false, this);
                }
            }
        }
        this.outputClock = locOutputClock;
        if (this.child.compute(this, locOutputClock)) {
            return res;
        }
        return false;
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        if (!this.enabled) {
            this.child.prepareAuto(this, false);
        } else if (this.setScale != null || this.useDefaults && this.defaultScale != null) {
            this.child.prepareAuto(this, false);
        } else if (this.setOutputFreq != null) {
            this.child.prepareAuto(this, false);
        } else {
            BigRational[] freq_accuracy = this.child.prepareAuto(this, true);
            if (freq_accuracy != null) {
                this.importedFreq = true;
                this.savedAcc = this.accuracy;
                this.setOutputFreq = freq_accuracy[0];
                BigRational tmpAccuracy = freq_accuracy[1];
                assert (tmpAccuracy != null);
                this.accuracy = tmpAccuracy;
            }
        }
        return null;
    }

    @Override
    public void closeAuto() {
        if (this.importedFreq) {
            this.importedFreq = false;
            this.savedAcc = this.accuracy = this.savedAcc;
            this.setOutputFreq = null;
        }
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        EErrorType res;
        BigRational actClock;
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        assert (this.scaleList.size() > 0) : "FLLext not fully defined - " + this.id;
        MulConstr actMulConstr = this.setScale != null ? this.setScale : (this.useDefaults && this.defaultScale != null ? this.defaultScale : null);
        BigRational locSetOutputFreq = this.setOutputFreq;
        if (actMulConstr != null) {
            EErrorType res2 = FLLext.checkInFreq(clock, actMulConstr);
            if (res2 != EErrorType.None) {
                return res2;
            }
            BigRational actClock2 = clock.multiply(actMulConstr.mulBy);
            res2 = FLLext.checkOutFreq(actClock2, actMulConstr);
            if (res2 != EErrorType.None) {
                return res2;
            }
            this.inputClock = clock;
            this.outputClock = actClock2;
            this.lastComp = ECompState.OnceSatisfied;
            res2 = this.child.computeAutoWR(this, actClock2);
            if (res2 == EErrorType.None || res2 == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return res2;
        }
        if (locSetOutputFreq != null) {
            this.compScale = null;
            for (MulConstr mulConstr : this.scaleList) {
                BigRational ac;
                BigRational actClock3;
                if (FLLext.checkInFreq(clock, mulConstr) != EErrorType.None || FLLext.checkOutFreq(actClock3 = clock.multiply(mulConstr.mulBy), mulConstr) != EErrorType.None || (ac = locSetOutputFreq.compareTo(actClock3) < 0 ? actClock3.divide(locSetOutputFreq).subtract(BigRational.ONE) : BigRational.ONE.subtract(actClock3.divide(locSetOutputFreq))).compareTo(this.accuracy) > 0) continue;
                this.inputClock = clock;
                this.outputClock = actClock3;
                this.compScale = mulConstr;
                this.lastComp = ECompState.OnceSatisfied;
                if (this.stopComputation) {
                    return EErrorType.None;
                }
                EErrorType res3 = this.child.computeAutoWR(this, actClock3);
                if (res3 == EErrorType.None || res3 == EErrorType.NotEnabled) {
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
                return res3;
            }
            return EErrorType.CannotSetup;
        }
        this.compScale = null;
        BigRational locMulBy = null;
        MulConstr locDefaultScale = this.defaultScale;
        if (locDefaultScale != null && FLLext.checkInFreq(clock, locDefaultScale) == EErrorType.None && FLLext.checkOutFreq(actClock = clock.multiply(locMulBy = locDefaultScale.mulBy), locDefaultScale) == EErrorType.None) {
            this.inputClock = clock;
            this.outputClock = actClock;
            this.compScale = locDefaultScale;
            this.lastComp = ECompState.OnceSatisfied;
            if (this.stopComputation) {
                return EErrorType.None;
            }
            res = this.child.computeAutoWR(this, actClock);
            if (res == EErrorType.None || res == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
        }
        for (MulConstr mulConstr : this.scaleList) {
            BigRational actClock4;
            if (mulConstr.mulBy.equals((Object)locMulBy) || FLLext.checkInFreq(clock, mulConstr) != EErrorType.None || FLLext.checkOutFreq(actClock4 = clock.multiply(mulConstr.mulBy), mulConstr) != EErrorType.None) continue;
            this.inputClock = clock;
            this.outputClock = actClock4;
            this.compScale = mulConstr;
            this.lastComp = ECompState.OnceSatisfied;
            if (this.stopComputation) {
                return EErrorType.None;
            }
            res = this.child.computeAutoWR(this, actClock4);
            if (res == EErrorType.None || res == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            if (res != EErrorType.BothFastSlow) continue;
            return res;
        }
        return EErrorType.CannotSetup;
    }

    @Override
    public void setScaleComputed() {
        assert (this.scaleList != null && this.scaleList.size() > 0) : "FLLext not fully defined - " + this.id;
        if (this.compScale == null) {
            return;
        }
        if (this.setScale != null) {
            return;
        }
        if (this.useDefaults && this.defaultScale != null) {
            return;
        }
        this.setScale = this.compScale;
    }

    @Override
    public @Nullable BigRational getOutputClock() {
        return this.outputClock;
    }

    @Override
    public @Nullable BigRational getInputClock() {
        return this.inputClock;
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node callee, @NonNull Node node) {
        assert (this.child != null) : "Null child in FLLext " + this.id;
        @NonNull List<@NonNull Node> res = this.child.getDirectlyConnectedTo(this, node);
        if (res.size() > 0) {
            if (this == node) {
                res.add(this);
            } else if (!res.contains(node)) {
                res.clear();
            }
        }
        return res;
    }

    @Override
    public void resetInputOutputClock() {
        this.inputClock = null;
        this.outputClock = null;
    }
}

