/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.platform.ide.product.configuration;

import com.nxp.s32ds.ext.rcp.datacollection.core.DataCollections;
import com.nxp.s32ds.platform.ide.product.internal.configuration.ProductConfigurationActivator;
import com.nxp.s32ds.rcp.license.core.FNOId;
import com.nxp.s32ds.rcp.license.core.LicenseException;
import com.nxp.s32ds.rcp.license.core.LicenseFeature;
import com.nxp.s32ds.rcp.license.core.LicenseService;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;

public class ProductConfigurationProvider
implements IStartup {
    private static final String UNKNOWN_VERSION = "unknown";
    private static final String productId = "SW32_S32DS_3.4";
    private static final String featureId = "Activated";

    public void earlyStartup() {
        FNOId fno = new FNOId(productId, featureId, "");
        try {
            LicenseService licenseService = ProductConfigurationActivator.getInstance().getLicenseService();
            if (licenseService == null) {
                ProductConfigurationActivator.getInstance().logError("License service not available");
                return;
            }
            LicenseFeature fetchLicenseFeature = licenseService.fetchLicenseFeature(fno);
            String actId = fetchLicenseFeature.getActivationId();
            String version = UNKNOWN_VERSION;
            IProduct product = Platform.getProduct();
            if (product != null && (version = product.getProperty("version")) == null) {
                version = UNKNOWN_VERSION;
            }
            DataCollections.sendEventCollectProduct((String)actId, (String)productId, (String)version);
        }
        catch (LicenseException e) {
            ProductConfigurationActivator.getInstance().logError(e.getMessage());
        }
    }
}

