/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.arm.mbs.common.option.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ToolChainOption {
    private String baseId;
    private String optName;
    private String optValue;
    private String optEnumValue;
    private List<String> params;
    private boolean isApplyParams;

    public ToolChainOption(String baseId, String name, String value) {
        this.baseId = baseId;
        this.setOptName(name);
        this.optValue = value;
        this.optEnumValue = value;
        this.params = new ArrayList<String>();
        this.isApplyParams = false;
    }

    public ToolChainOption(String baseId, String name, String value, String optEnumValue) {
        this.baseId = baseId;
        this.setOptName(name);
        this.optValue = value;
        this.optEnumValue = optEnumValue;
        this.params = new ArrayList<String>();
        this.isApplyParams = false;
    }

    public ToolChainOption(String baseId, String name, String value, String optEnumValue, List<String> params, boolean isApplyParams) {
        this.baseId = baseId;
        this.setOptName(name);
        this.optValue = value;
        this.optEnumValue = optEnumValue;
        this.params = params;
        this.isApplyParams = isApplyParams;
    }

    public ToolChainOption(String baseId, String name, String value, List<String> params, boolean isApplyParams) {
        this.baseId = baseId;
        this.setOptName(name);
        this.optValue = value;
        this.optEnumValue = value;
        this.params = params;
        this.isApplyParams = isApplyParams;
    }

    public String getOptBaseId() {
        return String.format("%s.%s", this.baseId, this.optName);
    }

    public String getOptionValue() {
        return this.optValue;
    }

    public String getOptionEnumValue() {
        return this.optEnumValue;
    }

    public String getOptName() {
        return this.optName;
    }

    public String getOptionIdValue() {
        return String.format("%s.%s.%s", this.baseId, this.optName, this.optValue);
    }

    public void setOptName(String optName) {
        this.optName = optName;
    }

    public void addParam(String param) {
        this.params.add(param);
    }

    public void removeParam(String param) {
        this.params.remove(param);
    }

    public Collection<String> getParams() {
        return Collections.unmodifiableCollection(this.params);
    }

    public boolean isApplyParams() {
        return this.isApplyParams;
    }
}

