/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.arm.mbs.common;

import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class IoRtParameterHandler
implements IParameterHandler {
    private static final String RT_PRINTF_IO = "rt_printf";
    private static final String HOSTED_IO = "hosted";
    private static final String NOIO_HOSTED_SET = "noio_hosted";
    private static final String NOIO_SET = "only_noio";
    private static final String RT_PRINTF_NOIO_HOSTED_SET = "rt_printf_noio_hosted";
    private static final String PNE_DEBUGGER = "pne";
    private static final String ISYSTEM_DEBUGGER = "isystem";
    private static final String WARNING_MSG_OPTION_RT_PRINT = "Real-time printf with ITM";
    private static final String WARNING_MSG_OPTION_DEBUGGER_CONSOLE = "Debugger Console";
    private static final String WARNING_MSG = "{0} option is not compatible with selected debugger";
    private boolean isWarningSet = false;

    public boolean isEnabled(String tag, AbstractContext context) {
        return false;
    }

    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        return null;
    }

    public ChangeResult onEdit(String tag, Object newValue, AbstractContext context) {
        this.isWarningSet = false;
        if (!(context instanceof CProjectMasterContext) || newValue == null) {
            return null;
        }
        CProjectMasterContext projectContext = (CProjectMasterContext)context;
        ModelRegistry registry = context.getRegistry();
        ArrayList<ContextChange> cChange = new ArrayList<ContextChange>();
        ContextChange contextChange = new ContextChange(context, tag);
        String currentDebugger = projectContext.getStringValue("debugger");
        String currentIO = projectContext.getStringValue("io");
        DataSet dataSetIO = projectContext.getDataSet("io");
        List<String> ioOptions = this.getOptionsByGlobalContext(projectContext, "io");
        if ("io".equals(tag)) {
            DataSet dataSet;
            if (PNE_DEBUGGER.equals(currentDebugger)) {
                if (!dataSetIO.getValues().contains(RT_PRINTF_IO)) {
                    dataSet = registry.getDataSet("ioSet", RT_PRINTF_NOIO_HOSTED_SET);
                    cChange.addAll(this.changeGlobalContext(projectContext, dataSet, tag));
                }
            } else if (ISYSTEM_DEBUGGER.equals(currentDebugger)) {
                if (dataSetIO.getValues().contains(HOSTED_IO) || dataSetIO.getValues().contains(RT_PRINTF_IO)) {
                    dataSet = registry.getDataSet("ioSet", NOIO_SET);
                    cChange.addAll(this.changeGlobalContext(projectContext, dataSet, tag));
                }
            } else if (dataSetIO.getValues().contains(RT_PRINTF_IO)) {
                dataSet = registry.getDataSet("ioSet", NOIO_HOSTED_SET);
                cChange.addAll(this.changeGlobalContext(projectContext, dataSet, tag));
            }
        }
        String msg = "";
        if ("debugger".equals(tag)) {
            DataSet dataSet;
            if (newValue instanceof String) {
                String debuggerValue = (String)newValue;
                DataSet dbgDataSet = registry.getDataSet("debuggerSet", "debuggerSet");
                cChange.addAll(this.changeGlobalContext(projectContext, dbgDataSet, "debugger", debuggerValue));
            }
            if (PNE_DEBUGGER.equals(newValue)) {
                if (!dataSetIO.getValues().contains(RT_PRINTF_IO)) {
                    DataSet ioDataSet = registry.getDataSet("ioSet", RT_PRINTF_NOIO_HOSTED_SET);
                    cChange.addAll(this.changeGlobalContext(projectContext, ioDataSet, "io", currentIO));
                }
            } else if (ISYSTEM_DEBUGGER.equals(newValue)) {
                if (dataSetIO.getValues().contains(RT_PRINTF_IO) || dataSetIO.getValues().contains(HOSTED_IO)) {
                    if (RT_PRINTF_IO.equals(currentIO) || HOSTED_IO.equals(currentIO)) {
                        this.isWarningSet = true;
                        if (RT_PRINTF_IO.equals(currentIO)) {
                            msg = WARNING_MSG_OPTION_RT_PRINT;
                        }
                        if (HOSTED_IO.equals(currentIO)) {
                            msg = WARNING_MSG_OPTION_DEBUGGER_CONSOLE;
                        }
                    } else {
                        contextChange.addValue("io", (Object)currentIO);
                    }
                    dataSet = registry.getDataSet("ioSet", NOIO_SET);
                    contextChange.addDataSet(dataSet);
                }
            } else if (dataSetIO.getValues().contains(RT_PRINTF_IO) || !dataSetIO.getValues().contains(HOSTED_IO)) {
                if (ioOptions.contains(RT_PRINTF_IO)) {
                    this.isWarningSet = true;
                    msg = WARNING_MSG_OPTION_RT_PRINT;
                } else {
                    contextChange.addValue("io", (Object)currentIO);
                }
                dataSet = registry.getDataSet("ioSet", NOIO_HOSTED_SET);
                contextChange.addDataSet(dataSet);
                cChange.addAll(this.changeGlobalContext(projectContext, dataSet, tag));
            }
        }
        cChange.add(contextChange);
        ChangeResult result = new ChangeResult(cChange);
        if (this.isWarningSet) {
            result.setWarningMessage(NLS.bind((String)WARNING_MSG, (Object)msg));
        }
        return result;
    }

    public Object parseValue(String tag, String value, AbstractContext context) {
        return null;
    }

    public List<ContextChange> changeGlobalContext(CProjectMasterContext projectContext, DataSet dataSet, String contextTag) {
        ProcessorContext processorContext = projectContext.getProcessorContext();
        List projectContexts = processorContext.getProjectContexts();
        ArrayList<ContextChange> changes = new ArrayList<ContextChange>();
        for (CProjectContext pcontext : projectContexts) {
            projectContext.addRelatedContext((ProjectContext)pcontext);
            ContextChange contextLocalChange = new ContextChange((AbstractContext)pcontext, contextTag);
            contextLocalChange.addDataSet(dataSet);
            changes.add(contextLocalChange);
        }
        return changes;
    }

    public List<ContextChange> changeGlobalContext(CProjectMasterContext projectContext, DataSet dataSet, String tag, String value) {
        ProcessorContext processorContext = projectContext.getProcessorContext();
        List projectContexts = processorContext.getProjectContexts();
        ArrayList<ContextChange> changes = new ArrayList<ContextChange>();
        for (CProjectContext pcontext : projectContexts) {
            projectContext.addRelatedContext((ProjectContext)pcontext);
            ContextChange contextLocalChange = new ContextChange((AbstractContext)pcontext, tag);
            contextLocalChange.addDataSet(dataSet);
            contextLocalChange.addValue(tag, (Object)value);
            changes.add(contextLocalChange);
        }
        return changes;
    }

    public List<String> getOptionsByGlobalContext(CProjectMasterContext projectContext, String tag) {
        ProcessorContext processorContext = projectContext.getProcessorContext();
        List projectContexts = processorContext.getProjectContexts();
        ArrayList<String> result = new ArrayList<String>();
        for (CProjectContext pcontext : projectContexts) {
            result.add(pcontext.getStringValue(tag));
        }
        return result;
    }
}

