/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.BackupComposite;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrateProjectComposite;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrateProjectWizardDiagnosticPage;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationWizardPageBase;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class MigrateProjectWizardPage
extends MigrationWizardPageBase {
    private static final String WIZARD_PAGE_NAME = MigrateProjectWizardPage.class.getSimpleName();
    private final IStructuredSelection selection;
    private MigrateProjectComposite migrationComposite;
    private BackupComposite backupComposite;
    private final MigrateProjectWizardDiagnosticPage diagnosticPage;

    protected MigrateProjectWizardPage(IStructuredSelection selection) {
        super(WIZARD_PAGE_NAME, Messages.MigrateProjectWizardPage_title);
        this.selection = selection;
        this.setDefaultMessage(Messages.MigrateProjectWizardPage_migrate_project_s_using_the_migration);
        this.diagnosticPage = new MigrateProjectWizardDiagnosticPage(this);
    }

    public MigrateProjectWizardDiagnosticPage getDiagnosticPage() {
        return this.diagnosticPage;
    }

    @Override
    protected void doCreateControl(Composite parent) {
        this.migrationComposite = new MigrateProjectComposite(parent, this.selection);
        this.migrationComposite.setPage(this);
        this.backupComposite = new BackupComposite(parent, this.migrationComposite);
        this.backupComposite.setPage(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.freescale.s32ds.cross.wizard.MIGRATE_WIZ_context");
    }

    public IWizardPage getNextPage() {
        MigrationSequenceDescriptor migration = this.getMigration();
        if (!this.getSelectedProjects().stream().allMatch(p -> migration.getSequence().match(p, new MigrationDiagnostic(p)))) {
            return this.diagnosticPage;
        }
        return null;
    }

    public List<IProject> getSelectedProjects() {
        return this.migrationComposite.getSelectedProjects();
    }

    public MigrationSequenceDescriptor getMigration() {
        return this.migrationComposite.getMigration();
    }

    @Override
    public void updatePageComplete() {
        this.diagnosticPage.updatePageComplete();
        super.updatePageComplete();
    }

    @Override
    protected IStatus validate() {
        IStatus status = this.migrationComposite.validate();
        if (!status.isOK()) {
            return status;
        }
        return this.backupComposite.validate();
    }

    public IRunnableWithProgress getMigrationOperation() {
        return this.migrationComposite.getMigrationOperation();
    }

    public BackupComposite getBackupComposite() {
        return this.backupComposite;
    }

    @Override
    protected void restoreWidgetState(IDialogSettings settings) {
        this.backupComposite.restoreWidgetState(settings);
    }

    @Override
    protected void saveWidgetState(IDialogSettings settings) {
        this.backupComposite.saveWidgetState(settings);
    }
}

