/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree;

import com.nxp.s32ds.cle.runtime.hardware.registry.ClusterDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceClusterDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareContentProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HardwareDeviceCoreContentProvider
extends HardwareContentProvider {
    private final Map<FamilyDescriptor, Map<DeviceDescriptor, List<DeviceCoreDescriptor>>> families;

    public HardwareDeviceCoreContentProvider() {
        this("");
    }

    public HardwareDeviceCoreContentProvider(String debuggerId) {
        this.families = HardwareDeviceCoreContentProvider.getFamilyToDeviceMap(debuggerId);
    }

    private Map<DeviceDescriptor, List<DeviceCoreDescriptor>> getDevices() {
        return this.families.values().stream().flatMap(familyDesc -> familyDesc.entrySet().stream()).collect(Collectors.toMap(deviceDesc -> (DeviceDescriptor)deviceDesc.getKey(), deviceCoreDesc -> (List)deviceCoreDesc.getValue()));
    }

    private Set<DeviceCoreDescriptor> getDeviceCores() {
        return this.getDevices().values().stream().flatMap(deviceCoreDesc -> deviceCoreDesc.stream()).collect(Collectors.toSet());
    }

    public Object[] getChildren(Object arg) {
        if (arg instanceof List) {
            List lstObjects = (List)arg;
            return lstObjects.toArray(new Object[0]);
        }
        if (arg instanceof FamilyDescriptor) {
            FamilyDescriptor family = (FamilyDescriptor)arg;
            Set<DeviceDescriptor> devices = this.families.get(family).keySet();
            return devices.toArray(new DeviceDescriptor[0]);
        }
        if (arg instanceof DeviceClusterDescriptor) {
            DeviceClusterDescriptor descriptor = (DeviceClusterDescriptor)arg;
            List deviceCoreDescriptors = DeviceDescriptors.getDeviceCoreDescriptorsByCluster((String)descriptor.getId(), (ClusterDescriptor)descriptor.getCluster());
            return deviceCoreDescriptors.toArray(new DeviceCoreDescriptor[0]);
        }
        if (arg instanceof DeviceDescriptor) {
            DeviceDescriptor deviceDescriptor = (DeviceDescriptor)arg;
            ArrayList clusterDescriptors = new ArrayList();
            List clusterDescriptorList = DeviceDescriptors.getClusterDescriptorsByDeviceId((String)deviceDescriptor.getId());
            if (!clusterDescriptorList.isEmpty()) {
                clusterDescriptorList.stream().filter(cluster -> DeviceDescriptors.getDeviceCoreDescriptorsByCluster((String)deviceDescriptor.getId(), (ClusterDescriptor)cluster).stream().filter(core -> this.getDeviceCores().contains(core)).findAny().isPresent()).forEach(cluster -> {
                    DeviceClusterDescriptor descriptor = new DeviceClusterDescriptor(deviceDescriptor, cluster);
                    clusterDescriptors.add(descriptor);
                });
                List nonClusteringDescriptors = DeviceDescriptors.getDeviceCoreDescriptorsByNSCluster((String)deviceDescriptor.getId());
                clusterDescriptors.addAll(nonClusteringDescriptors);
                return clusterDescriptors.toArray();
            }
            return this.getDevices().get(deviceDescriptor).toArray(new DeviceCoreDescriptor[0]);
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        if (element instanceof FamilyDescriptor) {
            FamilyDescriptor fmlDescriptor = (FamilyDescriptor)element;
            return !this.families.get(fmlDescriptor).isEmpty();
        }
        if (element instanceof DeviceDescriptor) {
            DeviceDescriptor deviceDescriptor = element instanceof DeviceClusterDescriptor ? DeviceDescriptors.getDeviceDescriptor((String)((DeviceClusterDescriptor)element).getId()) : (DeviceDescriptor)element;
            return !this.getDevices().get(deviceDescriptor).isEmpty();
        }
        return false;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        return null;
    }

    @Override
    public Class<?> getSelectionType() {
        return DeviceCoreDescriptor.class;
    }

    @Override
    public List<String> getFamilyIds() {
        return this.families.keySet().stream().map(familyDesc -> familyDesc.getId()).collect(Collectors.toList());
    }

    @Override
    public List<String> getDeviceIds() {
        return this.getDevices().keySet().stream().map(deviceDesc -> deviceDesc.getId()).collect(Collectors.toList());
    }

    @Override
    public List<String> getDeviceCoreIds() {
        return this.getDeviceCores().stream().map(deviceCoreDesc -> deviceCoreDesc.getId()).collect(Collectors.toList());
    }

    @Override
    public List<FamilyDescriptor> getFamilyDescriptors() {
        return this.families.keySet().stream().collect(Collectors.toList());
    }
}

