/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.registry.ui.tree;

import com.nxp.s32ds.cle.runtime.hardware.internal.registry.ui.tree.HardwareNameColumnLabelProvider;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.ui.tree.HardwareTreeMessages;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.ui.tree.HardwareViewerComparator;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.ui.tree.HardwareViewerFilter;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceRevisionDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareTree;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HardwareTreeImpl
extends Composite
implements HardwareTree {
    private static final int COLUMN_HW_WITHD = 170;
    private FamilyDescriptor familyDescriptor;
    private DeviceDescriptor deviceDescriptor;
    private DeviceCoreDescriptor deviceCoreDescriptor;
    private String deviceRevision;
    private Text txtDescription;
    private TreeViewer treeViewer;

    public HardwareTreeImpl(Composite parent, ITreeContentProvider contentProvider, ISelectionChangedListener listener) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Text filterTxt = new Text((Composite)this, 18436);
        filterTxt.setMessage(HardwareTreeMessages.HardwareTree_filter_tooltip_message);
        GridData filterGridData = new GridData(768);
        filterTxt.setLayoutData((Object)filterGridData);
        this.treeViewer = new TreeViewer((Composite)this, 2820);
        GridData treeViewerGridData = new GridData(1808);
        this.treeViewer.getTree().setLayoutData((Object)treeViewerGridData);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new HardwareNameColumnLabelProvider());
        this.treeViewer.setComparator((ViewerComparator)new HardwareViewerComparator());
        GridData descrTextGridData = new GridData();
        descrTextGridData.grabExcessHorizontalSpace = true;
        descrTextGridData.horizontalAlignment = 4;
        this.txtDescription = new Text((Composite)this, 2050);
        this.txtDescription.setEditable(false);
        this.txtDescription.setLayoutData((Object)descrTextGridData);
        this.treeViewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof TreeSelection) {
                this.parseSelection((TreeSelection)selection);
            }
            if (listener != null) {
                listener.selectionChanged(event);
            }
        });
        filterTxt.addModifyListener(modifyListener -> {
            this.treeViewer.refresh();
            if (!filterTxt.getText().trim().isEmpty()) {
                this.treeViewer.expandAll();
            } else {
                this.treeViewer.collapseAll();
            }
        });
        HardwareViewerFilter contentNameFilter = new HardwareViewerFilter(filterTxt, contentProvider);
        this.treeViewer.addFilter((ViewerFilter)contentNameFilter);
    }

    private void setDescriptionTxt(String text) {
        this.txtDescription.setText(text);
    }

    @Override
    public void setAdvancedMode() {
        TreeViewerColumn hardwareColumn = new TreeViewerColumn(this.treeViewer, 0);
        hardwareColumn.getColumn().setWidth(170);
        hardwareColumn.getColumn().setText(HardwareTreeMessages.Hardware_tree_column_name);
        hardwareColumn.setLabelProvider((CellLabelProvider)new HardwareNameColumnLabelProvider());
    }

    private void parseSelection(TreeSelection selection) {
        this.deviceRevision = "";
        this.familyDescriptor = null;
        this.deviceDescriptor = null;
        this.deviceCoreDescriptor = null;
        TreePath[] paths = selection.getPaths();
        if (paths.length > 0) {
            TreePath existingNodePath = paths[0];
            int i = 0;
            while (i < existingNodePath.getSegmentCount()) {
                Object selectionSegment = existingNodePath.getSegment(i);
                if (selectionSegment instanceof FamilyDescriptor) {
                    this.familyDescriptor = (FamilyDescriptor)selectionSegment;
                    this.setDescriptionTxt(this.familyDescriptor.getDescription());
                }
                if (selectionSegment instanceof DeviceDescriptor) {
                    this.deviceDescriptor = (DeviceDescriptor)selectionSegment;
                    this.setDescriptionTxt(this.deviceDescriptor.getDescription());
                }
                if (selectionSegment instanceof DeviceCoreDescriptor) {
                    this.deviceCoreDescriptor = (DeviceCoreDescriptor)selectionSegment;
                    this.setDescriptionTxt(this.deviceCoreDescriptor.getDescription());
                }
                if (selectionSegment instanceof DeviceRevisionDescriptor) {
                    this.deviceRevision = ((DeviceRevisionDescriptor)selectionSegment).getRevision();
                }
                if (selectionSegment instanceof CoreDescriptor) {
                    CoreDescriptor coreDescriptor = (CoreDescriptor)selectionSegment;
                    if (this.deviceDescriptor != null) {
                        this.deviceCoreDescriptor = (DeviceCoreDescriptor)DeviceDescriptors.getDeviceCoreDescriptors((String)this.deviceDescriptor.getId(), (String)coreDescriptor.getId()).get(0);
                    }
                }
                ++i;
            }
        } else {
            this.setDescriptionTxt("");
        }
    }

    @Override
    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    @Override
    public void addFilter(ViewerFilter filter) {
        ViewerFilter[] filters = this.treeViewer.getFilters();
        if (filters != null) {
            this.treeViewer.resetFilters();
            this.treeViewer.addFilter(filter);
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter existingFilter = viewerFilterArray[n2];
                this.treeViewer.addFilter(existingFilter);
                ++n2;
            }
        } else {
            this.treeViewer.addFilter(filter);
        }
    }

    @Override
    public DeviceCoreDescriptor getDeviceCoreDescriptor() {
        return this.deviceCoreDescriptor;
    }

    @Override
    public DeviceDescriptor getDeviceDescriptor() {
        return this.deviceDescriptor;
    }

    @Override
    public FamilyDescriptor getFamilyDescriptor() {
        return this.familyDescriptor;
    }

    @Override
    public String getDeviceRevision() {
        return this.deviceRevision;
    }
}

