/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.example.core;

import com.nxp.s32ds.cle.ide.example.internal.core.ExampleProjectLoader;
import com.nxp.s32ds.cle.ide.example.internal.core.ExampleRegistryActivator;
import com.nxp.s32ds.cle.ide.example.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.example.registry.ExampleCategoryDescriptor;
import com.nxp.s32ds.cle.runtime.example.registry.ExampleRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.ext.ide.examples.core.ExampleObject;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.ide.examples.core.IExampleObject;
import com.nxp.s32ds.ext.ide.examples.core.IVisualComponent;
import com.nxp.s32ds.ext.ide.examples.core.VisualComponent;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ExampleProjectFacade {
    private static final String PROJECT_FILE = ".project";
    private static final DeviceDescriptor UNDEFINED_DEVICE = ExampleProjectFacade.getUndefinedDeviceDescriptor();
    private static final FamilyDescriptor UNDEFINED_FAMILY = ExampleProjectFacade.getUndefinedFamilyDescriptor();
    private Map<String, Map<String, List<IExampleComponent>>> mapCategoryToComponents = new HashMap<String, Map<String, List<IExampleComponent>>>();
    private Map<String, Map<String, List<IExampleObject>>> mapCategoryToObjectComponents = new HashMap<String, Map<String, List<IExampleObject>>>();
    private Map<String, Map<String, List<IExampleObject>>> mapCategoryToTreeObjectComponents = new HashMap<String, Map<String, List<IExampleObject>>>();
    private List<ExampleCategoryDescriptor> categoryDescriptors = new ArrayList<ExampleCategoryDescriptor>();
    private List<CategoryModel> categoryModels = new ArrayList<CategoryModel>();
    private Map<FamilyDescriptor, List<DeviceDescriptor>> familyToDevices = new TreeMap<FamilyDescriptor, List<DeviceDescriptor>>(Comparator.comparing(EntityDescriptor::getName));

    public IStatus initExampleModel(IProgressMonitor progressMonitor) {
        ExampleProjectLoader.loadFromExtension(this.mapCategoryToComponents, this.getExampleRegistry(), progressMonitor);
        this.validateCategoryDescriptors();
        this.fillCategoryDescriptors();
        this.convertToObjects(progressMonitor);
        this.convertToTreeObjects(progressMonitor);
        this.wrapIntoCategory(progressMonitor);
        this.fillFamilyToDevicesMap();
        return Status.OK_STATUS;
    }

    public ExampleRegistry getExampleRegistry() {
        return ExampleRegistryActivator.getInstance().getExampleRegistry();
    }

    private void validateCategoryDescriptors() {
        Collection descriptors = this.getExampleRegistry().getExampleCategoryDescriptors();
        List allSubcategories = descriptors.stream().filter(obj -> obj.getParentId() != null && !obj.getParentId().isEmpty()).collect(Collectors.toList());
        List<String> allCategoryIds = ExampleProjectFacade.mapCategoriesToIds(descriptors);
        for (ExampleCategoryDescriptor subcategory : allSubcategories) {
            if (allCategoryIds.contains(subcategory.getParentId())) continue;
            ExampleRegistryActivator.getInstance().logWarning(NLS.bind((String)Messages.ExampleProjectFacade_categoryHasUndefinedParent, (Object)subcategory.getId(), (Object)subcategory.getParentId()));
        }
    }

    private void fillCategoryDescriptors() {
        this.categoryDescriptors.addAll(this.getExampleRegistry().getExampleCategoryDescriptors());
    }

    private void convertToObjects(IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)this.mapCategoryToComponents.values().size());
        for (Map.Entry<String, Map<String, List<IExampleComponent>>> categoryToComponent : this.mapCategoryToComponents.entrySet()) {
            HashMap mapObjectComponents = new HashMap();
            for (Map.Entry<String, List<IExampleComponent>> components : categoryToComponent.getValue().entrySet()) {
                ArrayList<ExampleObject> listObjectComponents = new ArrayList<ExampleObject>();
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)subMonitor.split(1), (int)components.getValue().size());
                for (IExampleComponent modelComponent : components.getValue()) {
                    monitor.subTask(modelComponent.getProjectName());
                    IProjectDescription projectDescriptor = modelComponent.getProjectDescriptor();
                    ArrayList<IProjectDescription> relatedProjectDescr = new ArrayList<IProjectDescription>();
                    IProject[] iProjectArray = modelComponent.getRelatedProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject pr = iProjectArray[n2];
                        IExampleComponent relatedComponent = ExampleProjectFacade.findExampleComponent(pr, components.getValue());
                        if (relatedComponent != null) {
                            IProjectDescription relatedProjectDescriptor = relatedComponent.getProjectDescriptor();
                            relatedProjectDescr.add(relatedProjectDescriptor);
                        }
                        ++n2;
                    }
                    ExampleObject objectComponent = new ExampleObject(relatedProjectDescr, projectDescriptor, modelComponent);
                    objectComponent.setCategoryName(components.getKey());
                    listObjectComponents.add(objectComponent);
                    monitor.worked(1);
                }
                mapObjectComponents.put(components.getKey(), listObjectComponents);
            }
            this.mapCategoryToObjectComponents.put(categoryToComponent.getKey(), mapObjectComponents);
        }
    }

    private static IExampleComponent findExampleComponent(IProject project, List<IExampleComponent> componentList) {
        for (IExampleComponent example : componentList) {
            if (!example.getProjectName().equals(project.getName())) continue;
            return example;
        }
        return null;
    }

    private static IExampleObject findObjectComponent(IProjectDescription pd, List<IExampleObject> listObjectComponents) {
        for (IExampleObject parentObject : listObjectComponents) {
            if (!parentObject.getProjectDescription().getName().equals(pd.getName())) continue;
            return parentObject;
        }
        return null;
    }

    private void convertToTreeObjects(IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)this.mapCategoryToObjectComponents.size());
        for (Map.Entry<String, Map<String, List<IExampleObject>>> category : this.mapCategoryToObjectComponents.entrySet()) {
            HashMap mapTreeObjectComponents = new HashMap();
            for (Map.Entry<String, List<IExampleObject>> iter : category.getValue().entrySet()) {
                ArrayList<Object> treeObjectComponent = new ArrayList<Object>();
                ArrayList tempList = new ArrayList();
                tempList.addAll(iter.getValue());
                for (IExampleObject objectComponent : iter.getValue()) {
                    IExampleComponent modelingComponent = objectComponent.getModelingComponent();
                    if (modelingComponent.getRelatedProjects() == null || modelingComponent.getRelatedProjects().length <= 0) continue;
                    treeObjectComponent.add(objectComponent);
                    tempList.remove(objectComponent);
                    for (IProjectDescription projDescr : objectComponent.getRelatedProjectsDescriptors()) {
                        IExampleObject child = ExampleProjectFacade.findObjectComponent(projDescr, iter.getValue());
                        objectComponent.addChildObject(child);
                        tempList.remove(child);
                    }
                }
                treeObjectComponent.addAll(tempList);
                mapTreeObjectComponents.put(iter.getKey(), treeObjectComponent);
            }
            this.mapCategoryToTreeObjectComponents.put(category.getKey(), mapTreeObjectComponents);
            subMonitor.worked(1);
        }
    }

    private void wrapIntoCategory(IProgressMonitor progressMonitor) {
        List<ExampleCategoryDescriptor> rootCategories = ExampleProjectFacade.extractRootCategories(this.getAllCategories());
        this.convertCategoriesToModels(rootCategories, this.categoryModels, progressMonitor);
        Map<String, List<IExampleObject>> categoryToExamples = this.mapCategoryToTreeObjectComponents.get("");
        this.categoryModels.add(new CategoryModel(this.convertToExampleGroups(categoryToExamples)));
        this.categoryModels.sort(Comparator.comparing(CategoryModel::getName, String::compareToIgnoreCase));
    }

    private void convertCategoriesToModels(List<ExampleCategoryDescriptor> categories, List<CategoryModel> models, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)this.mapCategoryToObjectComponents.size());
        for (ExampleCategoryDescriptor rootCategory : categories) {
            List<ExampleCategoryDescriptor> subcategories = ExampleProjectFacade.findSubcategories(this.getAllCategories(), rootCategory.getId());
            List<String> subcategoryIds = ExampleProjectFacade.mapCategoriesToIds(subcategories);
            Map<String, List<IExampleObject>> categoryToExamples = this.mapCategoryToTreeObjectComponents.get(rootCategory.getId());
            models.add(new CategoryModel(rootCategory.getId(), rootCategory.getName(), this.convertToExampleGroups(categoryToExamples), subcategoryIds));
            this.convertCategoriesToModels(subcategories, models, (IProgressMonitor)subMonitor);
            subMonitor.worked(1);
        }
    }

    private Collection<ExampleCategoryDescriptor> getAllCategories() {
        return this.categoryDescriptors;
    }

    private static List<ExampleCategoryDescriptor> extractRootCategories(Collection<ExampleCategoryDescriptor> categories) {
        return categories.stream().filter(item -> item.getParentId() == null || item.getParentId().isEmpty()).collect(Collectors.toList());
    }

    private static List<ExampleCategoryDescriptor> findSubcategories(Collection<ExampleCategoryDescriptor> categories, String id) {
        return categories.stream().filter(item -> item.getParentId() != null && item.getParentId().equals(id)).collect(Collectors.toList());
    }

    private static List<String> mapCategoriesToIds(Collection<ExampleCategoryDescriptor> categories) {
        return categories.stream().map(EntityDescriptor::getId).collect(Collectors.toList());
    }

    public List<IVisualComponent> convertToTreeVisualComponents() {
        ArrayList<IVisualComponent> treeNodes = new ArrayList<IVisualComponent>();
        List<ExampleCategoryDescriptor> rootCategories = ExampleProjectFacade.extractRootCategories(this.getAllCategories());
        List<String> rootCategoryIds = ExampleProjectFacade.mapCategoriesToIds(rootCategories);
        List<IVisualComponent> categorizedRoots = this.categoryModels.stream().filter(item -> rootCategoryIds.contains(item.getId())).map(item -> new VisualComponent(item.getName())).collect(Collectors.toList());
        treeNodes.addAll(categorizedRoots);
        this.fillVisualComponentsTree(treeNodes, categorizedRoots);
        this.fillVisualComponentsTreeWithUncategorized(treeNodes);
        return treeNodes.stream().filter(item -> !item.getGroups().isEmpty() || !item.getChildObjects().isEmpty()).sorted(Comparator.comparing(IVisualComponent::getVisualComponentName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    private void fillVisualComponentsTree(List<IVisualComponent> treeNodes, List<IVisualComponent> visualRoots) {
        for (IVisualComponent visualRoot : visualRoots) {
            CategoryModel model = this.extractCategoryModelByName(visualRoot.getVisualComponentName());
            if (!model.getSubcategoryIds().isEmpty()) {
                List<CategoryModel> listModels = this.findModelSubcategories(model);
                for (CategoryModel m : listModels) {
                    if (!this.anyChildHasExample(m)) continue;
                    VisualComponent visualChild = new VisualComponent(m.getName());
                    visualRoot.addGroup(visualChild);
                }
                this.fillVisualComponentsTree(treeNodes, visualRoot.getGroups());
            }
            ExampleProjectFacade.fillVisualRoot(visualRoot, model);
        }
    }

    private List<CategoryModel> findModelSubcategories(CategoryModel model) {
        return this.categoryModels.stream().filter(item -> model.getSubcategoryIds().contains(item.getId())).collect(Collectors.toList());
    }

    private boolean anyChildHasExample(CategoryModel model) {
        if (!model.getExampleGroups().isEmpty()) {
            return true;
        }
        List<CategoryModel> children = this.findModelSubcategories(model);
        for (CategoryModel child : children) {
            if (!this.anyChildHasExample(child)) continue;
            return true;
        }
        return false;
    }

    private void fillVisualComponentsTreeWithUncategorized(List<IVisualComponent> treeNodes) {
        VisualComponent root = new VisualComponent();
        CategoryModel model = this.extractCategoryModelByName("");
        ExampleProjectFacade.fillVisualRoot((IVisualComponent)root, model);
        treeNodes.addAll(root.getGroups());
    }

    private static void fillVisualRoot(IVisualComponent visualRoot, CategoryModel model) {
        List<ExampleGroup> exampleGroups = model.getExampleGroups();
        for (ExampleGroup group : exampleGroups) {
            VisualComponent visualChild = new VisualComponent(group.getGroupName());
            for (IExampleObject iter : group.getExamples()) {
                visualChild.addNewItems(iter.getModelingComponent().getGroup(), iter);
            }
            if (!group.getExamples().isEmpty()) {
                visualRoot.addGroup(visualChild);
            }
            visualRoot.getGroups().sort(Comparator.comparing(IVisualComponent::getVisualComponentName, String.CASE_INSENSITIVE_ORDER));
        }
    }

    private List<ExampleGroup> convertToExampleGroups(Map<String, List<IExampleObject>> mapNameToExamples) {
        if (mapNameToExamples == null) {
            return Collections.emptyList();
        }
        ArrayList<ExampleGroup> exampleGroups = new ArrayList<ExampleGroup>();
        for (Map.Entry<String, List<IExampleObject>> rootCategory : mapNameToExamples.entrySet()) {
            String groupName = rootCategory.getKey();
            List<IExampleObject> examples = rootCategory.getValue();
            ExampleGroup exampleGroup = new ExampleGroup(groupName, examples);
            exampleGroups.add(exampleGroup);
        }
        return exampleGroups;
    }

    private CategoryModel extractCategoryModelByName(String name) {
        return this.categoryModels.stream().filter(item -> item.getName().equals(name)).findFirst().orElseThrow(NoSuchElementException::new);
    }

    public IPath findProjectFilePath(File fileParent) {
        if (!fileParent.exists()) {
            return null;
        }
        if (fileParent.isFile()) {
            if (fileParent.getName().equals(PROJECT_FILE)) {
                return new Path(fileParent.getAbsolutePath());
            }
        } else {
            File[] fileArray = fileParent.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().equals(PROJECT_FILE)) {
                    return new Path(file.getAbsolutePath());
                }
                ++n2;
            }
        }
        return null;
    }

    public Map<String, Map<String, List<IExampleComponent>>> getMapCategoryToComponents() {
        return this.mapCategoryToComponents;
    }

    private void fillFamilyToDevicesMap() {
        Stream<DeviceDescriptor> deviceDescriptors = this.categoryModels.stream().flatMap(model -> model.getExampleGroups().stream()).flatMap(group -> group.getExamples().stream()).map(example -> example.getModelingComponent().getDeviceId()).map(this::resolveDeviceDescriptor).distinct();
        deviceDescriptors.forEach(deviceDescriptor -> {
            List familyDescriptors = DeviceDescriptors.getFamilyDescriptors((String)deviceDescriptor.getId());
            if (familyDescriptors.isEmpty()) {
                familyDescriptors.add(UNDEFINED_FAMILY);
            }
            if (familyDescriptors.size() == 1) {
                FamilyDescriptor familyDescriptor = (FamilyDescriptor)familyDescriptors.get(0);
                this.familyToDevices.putIfAbsent(familyDescriptor, new ArrayList());
                this.familyToDevices.compute(familyDescriptor, (key, value) -> {
                    value.add(deviceDescriptor);
                    return value;
                });
            } else {
                ExampleRegistryActivator.getInstance().logWarning(NLS.bind((String)"Unexpected number of family descriptors for device id={0}. ", (Object)deviceDescriptor.getId()));
            }
        });
        this.familyToDevices.forEach((key, value) -> value.sort(Comparator.comparing(EntityDescriptor::getName)));
    }

    public Map<FamilyDescriptor, List<DeviceDescriptor>> getHardwareData() {
        return this.familyToDevices;
    }

    public List<DeviceDescriptor> getHardwareDevicesData() {
        return this.getHardwareData().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private DeviceDescriptor resolveDeviceDescriptor(String deviceId) {
        DeviceDescriptor deviceDescriptor = DeviceDescriptors.getDeviceDescriptor((String)deviceId);
        if (deviceDescriptor == null) {
            return UNDEFINED_DEVICE;
        }
        return deviceDescriptor;
    }

    private static DeviceDescriptor getUndefinedDeviceDescriptor() {
        return new DeviceDescriptor(){

            public String getName() {
                return Messages.ExampleProjectFacade_undefinedDevice;
            }

            public String getId() {
                return "";
            }

            public String getDescription() {
                return Messages.ExampleProjectFacade_undefinedDevice;
            }

            public String getRevision() {
                return Messages.ExampleProjectFacade_undefinedDevice;
            }
        };
    }

    private static FamilyDescriptor getUndefinedFamilyDescriptor() {
        return new FamilyDescriptor(){

            public String getName() {
                return Messages.ExampleProjectFacade_undefinedFamily;
            }

            public String getId() {
                return "";
            }

            public String getDescription() {
                return Messages.ExampleProjectFacade_undefinedFamily;
            }
        };
    }

    private class CategoryModel {
        private String id;
        private String name;
        private List<ExampleGroup> exampleGroups;
        private List<String> subcategoryIds;

        CategoryModel(String id, String name, List<ExampleGroup> exampleGroups, List<String> subcategoryIds) {
            this.id = id;
            this.name = name;
            this.exampleGroups = exampleGroups;
            this.subcategoryIds = subcategoryIds;
        }

        CategoryModel(List<ExampleGroup> exampleGroups) {
            this("", "", exampleGroups, Collections.emptyList());
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<ExampleGroup> getExampleGroups() {
            return this.exampleGroups;
        }

        public List<String> getSubcategoryIds() {
            return this.subcategoryIds;
        }
    }

    private class ExampleGroup {
        private String groupName;
        private List<IExampleObject> examples;

        ExampleGroup(String groupName, List<IExampleObject> examples) {
            this.groupName = groupName;
            this.examples = examples;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public List<IExampleObject> getExamples() {
            return this.examples;
        }
    }
}

