/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.ui.imports;

import com.nxp.s32ds.cle.cdt.core.imports.ImportExportConfigurationUtil;
import com.nxp.s32ds.cle.cdt.ui.internal.CdtUiActivator;
import com.nxp.s32ds.cle.cdt.ui.internal.imports.ImportExecMessages;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.DebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.ext.rcp.databinding.ValidationDescriptors;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.ui.importexecutable.AbstractImportExecutableWizard;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ImportExecConfigurationPage
extends WizardPage {
    private AbstractImportExecutableWizard wizard;
    private static final int ROW_WIDTH = 250;
    private static final int ROW_BTN_WIDTH = 100;
    private Text txtProjectNameExs;
    private Text txtProjectNameNew;
    private Button btnNewProject;
    private Button btnExsProject;
    private Button btnSearchProject;
    private Button btnLConfig;
    private CCombo cmbLConfig;
    private CCombo cmbToolchain;
    private Label lblLConfigName;
    private Label lblLToolchainName;
    private Text txtLConfigName;
    private Label lblSourcePath;
    private Text txtSourcePath;
    private Button btnSourceBrowse;
    private Button btnSourceClear;
    private List<IToolChain> toolChains;
    private DeviceCoreDescriptor deviceCoreDescriptor;
    private String deviceRevision;
    private List<DebuggerLaunchConfigurationDescriptor> launchConfigurationTypes = new ArrayList<DebuggerLaunchConfigurationDescriptor>();
    Collection<IValidator<String>> nameValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.name.validators");
    Collection<IValidator<String>> pathValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.path.validators");
    Collection<IValidator<String>> nameLacunchConfigurationValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"launch.configuration.name.validators");
    private final CompositeValidator compositeNameValidator = new CompositeValidator(new ArrayList<IValidator<String>>(this.nameValidators));
    private final CompositeValidator compositePathValidator = new CompositeValidator(new ArrayList<IValidator<String>>(this.pathValidators));
    private final CompositeValidator compositeLaunchConfigurationNameValidator = new CompositeValidator(new ArrayList<IValidator<String>>(this.nameLacunchConfigurationValidators));

    public ImportExecConfigurationPage(AbstractImportExecutableWizard wizard) {
        super(Messages.AbstractImportExecutableWizard_windowTitle);
        this.wizard = wizard;
        this.setTitle(ImportExecMessages.ImportExeWizard_import_exe_page_two_title);
        this.setDescription(Messages.ImportExecutablePageTwo_ChooseExisting);
        this.toolChains = new ArrayList<IToolChain>();
    }

    public void createControl(Composite parent) {
        GridData lblGridDataLft = new GridData(4, 4, false, false);
        lblGridDataLft.widthHint = 250;
        GridData btnGridData = new GridData(4, 4, false, false);
        btnGridData.widthHint = 100;
        GridData txtGridData = new GridData(4, 4, false, false, 3, 1);
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(4, false));
        this.btnNewProject = new Button(base, 16);
        this.btnNewProject.setText(ImportExecMessages.ImportExePage2_new_project_name);
        this.btnNewProject.setLayoutData((Object)lblGridDataLft);
        this.btnNewProject.setSelection(true);
        this.btnNewProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecConfigurationPage.this.setupProjectControls(ImportExecConfigurationPage.this.btnNewProject.getSelection());
            }
        });
        this.txtProjectNameNew = new Text(base, 2048);
        this.txtProjectNameNew.setText("");
        this.txtProjectNameNew.setLayoutData((Object)txtGridData);
        this.txtProjectNameNew.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evn) {
                ImportExecConfigurationPage.this.updatePageState();
            }
        });
        this.btnExsProject = new Button(base, 16);
        this.btnExsProject.setText(ImportExecMessages.ImportExePage2_existing_project);
        this.btnExsProject.setLayoutData((Object)lblGridDataLft);
        this.btnExsProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecConfigurationPage.this.setupProjectControls(ImportExecConfigurationPage.this.btnNewProject.getSelection());
                ImportExecConfigurationPage.this.updatePageState();
            }
        });
        this.txtProjectNameExs = new Text(base, 2056);
        this.txtProjectNameExs.setText("");
        this.txtProjectNameExs.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.txtProjectNameExs.setEnabled(this.btnExsProject.getSelection());
        this.btnSearchProject = new Button(base, 8);
        this.btnSearchProject.setText(ImportExecMessages.ImportExePage2_search);
        this.btnSearchProject.setLayoutData((Object)btnGridData);
        this.btnSearchProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICProject cProject = ImportExecConfigurationPage.this.getCProjectFromDialog();
                if (cProject != null) {
                    ImportExecConfigurationPage.this.txtProjectNameExs.setText(cProject.getElementName());
                    ImportExecConfigurationPage.this.updatePageState();
                }
            }
        });
        Label lblSeparator = new Label(base, 258);
        lblSeparator.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.btnLConfig = new Button(base, 32);
        this.btnLConfig.setText(ImportExecMessages.ImportExePage2_create_launch_configuration);
        this.btnLConfig.setLayoutData((Object)lblGridDataLft);
        this.btnLConfig.setSelection(true);
        this.btnLConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecConfigurationPage.this.setEnabledLaunchContols(ImportExecConfigurationPage.this.btnLConfig.getSelection());
                if (ImportExecConfigurationPage.this.toolChains.isEmpty()) {
                    ImportExecConfigurationPage.this.cmbToolchain.setEnabled(false);
                } else {
                    ImportExecConfigurationPage.this.cmbToolchain.setEnabled(ImportExecConfigurationPage.this.btnLConfig.getSelection());
                }
            }
        });
        this.cmbLConfig = new CCombo(base, 2056);
        this.cmbLConfig.setLayoutData((Object)txtGridData);
        this.cmbLConfig.setEnabled(false);
        this.cmbLConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecConfigurationPage.this.configureToolchainCombo();
                ImportExecConfigurationPage.this.updatePageState();
            }
        });
        this.lblLConfigName = new Label(base, 0);
        this.lblLConfigName.setLayoutData((Object)lblGridDataLft);
        this.lblLConfigName.setText(ImportExecMessages.ImportExePage2_launch_configuration_name);
        this.txtLConfigName = new Text(base, 2048);
        this.txtLConfigName.setLayoutData((Object)txtGridData);
        this.txtLConfigName.setEnabled(this.btnLConfig.getSelection());
        this.txtLConfigName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ImportExecConfigurationPage.this.updatePageState();
            }
        });
        this.lblLToolchainName = new Label(base, 0);
        this.lblLToolchainName.setLayoutData((Object)lblGridDataLft);
        this.lblLToolchainName.setText(ImportExecMessages.ImportExePage2_tool_chain_name);
        this.cmbToolchain = new CCombo(base, 2056);
        this.cmbToolchain.setLayoutData((Object)txtGridData);
        this.cmbToolchain.setEnabled(false);
        this.cmbToolchain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecConfigurationPage.this.updatePageState();
            }
        });
        this.lblSourcePath = new Label(base, 0);
        this.lblSourcePath.setText(ImportExecMessages.ImportExePage2_source_path);
        this.lblSourcePath.setLayoutData((Object)lblGridDataLft);
        this.txtSourcePath = new Text(base, 2060);
        this.txtSourcePath.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnSourceBrowse = new Button(base, 8);
        this.btnSourceBrowse.setText(ImportExecMessages.ImportExePage2_browse);
        this.btnSourceBrowse.setLayoutData((Object)btnGridData);
        this.btnSourceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ImportExecConfigurationPage.this.getShell(), 0x10000000);
                dialog.setText(ImportExecMessages.ImportExePage2_folder_select);
                dialog.setMessage(ImportExecMessages.ImportExePage2_specify_src_folder);
                dialog.setFilterPath(Platform.getInstanceLocation().toString());
                String res = dialog.open();
                if (res != null) {
                    String sourcePath = new Path(res).makeAbsolute().toOSString();
                    ImportExecConfigurationPage.this.txtSourcePath.setText(sourcePath);
                }
            }
        });
        this.btnSourceClear = new Button(base, 8);
        this.btnSourceClear.setText(ImportExecMessages.ImportExePage2_clear);
        this.btnSourceClear.setLayoutData((Object)btnGridData);
        this.btnSourceClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecConfigurationPage.this.txtSourcePath.setText("");
            }
        });
        this.setupProjectControls(this.btnNewProject.getSelection());
        this.setControl((Control)base);
    }

    private void setEnabledLaunchContols(boolean selection) {
        this.cmbLConfig.setEnabled(selection);
        this.txtLConfigName.setEnabled(selection);
        this.txtLConfigName.setText(this.getNewProjectName());
    }

    protected void setupProjectControls(boolean isUseNewProject) {
        this.txtProjectNameNew.setEnabled(isUseNewProject);
        this.txtProjectNameExs.setEnabled(!isUseNewProject);
        this.btnSearchProject.setEnabled(!isUseNewProject);
    }

    public String getSource() {
        return this.txtSourcePath.getText();
    }

    private void configureToolchainCombo() {
        this.toolChains.clear();
        this.cmbToolchain.removeAll();
        int selectionIndex = this.cmbLConfig.getSelectionIndex();
        if (!this.launchConfigurationTypes.isEmpty() && this.launchConfigurationTypes.size() >= selectionIndex) {
            DebuggerLaunchConfigurationDescriptor descriptor = this.launchConfigurationTypes.get(this.cmbLConfig.getSelectionIndex());
            this.toolChains = ImportExportConfigurationUtil.getSupportedToolChainsByCondition((String)this.deviceCoreDescriptor.getDeviceId(), (String)this.deviceRevision, (String)descriptor.getDebuggerId(), (String)this.deviceCoreDescriptor.getCoreId());
            if (this.toolChains == null || this.toolChains.isEmpty()) {
                this.toolChains = this.getSupportedToolchains(descriptor);
            }
        }
        if (this.toolChains == null || this.toolChains.isEmpty()) {
            this.cmbToolchain.setEnabled(false);
        } else {
            this.toolChains.stream().forEach(tch -> this.cmbToolchain.add(tch.getName()));
            this.cmbToolchain.select(0);
            this.cmbToolchain.setEnabled(this.btnLConfig.getSelection());
        }
    }

    @Deprecated
    private List<IToolChain> getSupportedToolchains(DebuggerLaunchConfigurationDescriptor descriptor) {
        List deviceDebuggerDescriptors = DeviceDebuggerDescriptors.getDeviceDebuggerDescriptors((String)this.deviceCoreDescriptor.getDeviceId());
        List collectionOfCoreDebuggerDescriptors = CoreDebuggerDescriptors.getCoreDescriptors((String)this.deviceCoreDescriptor.getCoreId()).stream().filter(d -> descriptor.getDebuggerId().contains(d.getDebuggerId())).map(m -> m.getToolchainId()).collect(Collectors.toList());
        List collect = deviceDebuggerDescriptors.stream().filter(d -> descriptor.getDebuggerId().contains(d.getDebuggerId())).collect(Collectors.toList());
        collect.removeIf(debugger -> !collectionOfCoreDebuggerDescriptors.contains(debugger.getToolchainId()));
        return collect.stream().map(coreDebuggerDescriptor -> coreDebuggerDescriptor.getToolchainId()).filter(Objects::nonNull).map(toolchainId -> ManagedBuildManager.getExtensionToolChain((String)toolchainId)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPageComplete() {
        this.setErrorMessage(null);
        this.setMessage(null);
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (this.isCreateNewProjectSelected()) {
            IStatus status = this.compositeNameValidator.validate(this.getNewProjectName());
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            String projectPath = String.valueOf(workspaceLocation.toOSString()) + File.separator + this.getNewProjectName() + File.separator;
            status = this.compositePathValidator.validate(projectPath);
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
        } else {
            IProject project;
            IProject iProject = project = this.getExistingCProject() == null ? null : this.getExistingCProject().getProject();
            if (project == null || !project.exists()) {
                this.setErrorMessage(ImportExecMessages.ImportWizard_ProjectDoesNotExist_Error);
                return false;
            }
        }
        if (!this.isCreateLaunchConfigurationSelected()) return true;
        if (this.cmbLConfig.getSelectionIndex() < 0) {
            this.setErrorMessage(ImportExecMessages.ImportExecConfigurationPage_launch_type_not_specified);
            return false;
        }
        if (!this.toolChains.isEmpty() && this.cmbToolchain.getSelectionIndex() < 0) {
            this.setErrorMessage(ImportExecMessages.ImportExePage2_tool_chain_must_be_set);
            return false;
        }
        IValidator validator = ValidationDescriptors.getValidatorByValidatorId((String)"launch.name.validator");
        String launchConfigurationName = this.txtLConfigName.getText().trim();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            launchManager.isValidLaunchConfigurationName(launchConfigurationName);
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        IStatus validationStatus = this.compositeLaunchConfigurationNameValidator.validate(launchConfigurationName);
        if (!validationStatus.isOK()) {
            this.setErrorMessage(validationStatus.getMessage());
            return false;
        }
        IProject project = this.getExistingCProject() == null ? null : this.getExistingCProject().getProject();
        String projectPath = "";
        projectPath = project == null || !project.exists() ? String.valueOf(workspaceLocation.toOSString()) + File.separator + this.getNewProjectName() : project.getLocation().toOSString();
        Path path = new Path(String.valueOf(projectPath) + File.separator + launchConfigurationName);
        validationStatus = validator.validate((Object)path.toOSString());
        if (!validationStatus.isOK()) {
            this.setErrorMessage(validationStatus.getMessage());
            return false;
        }
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                ILaunchConfiguration existConfiguration = iLaunchConfigurationArray[n2];
                if (launchConfigurationName.equals(existConfiguration.getName())) {
                    this.setErrorMessage(String.format(ImportExecMessages.ImportExePage2_launch_cfg_exists, launchConfigurationName));
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CdtUiActivator.getInstance().logError("An exception was thrown during launch configurations extraction", e);
        }
        return true;
    }

    private void updatePageState() {
        this.setPageComplete(this.isPageComplete());
    }

    boolean isCreateNewProjectSelected() {
        return this.btnNewProject.getSelection();
    }

    public String getNewProjectName() {
        return this.txtProjectNameNew.getText().trim();
    }

    public void setSettings(DeviceCoreDescriptor deviceCoreDescriptor, String deviceRevision) {
        this.deviceCoreDescriptor = deviceCoreDescriptor;
        this.deviceRevision = deviceRevision;
        this.txtProjectNameNew.setText(this.wizard.getDefaultProjectName());
        this.cmbLConfig.removeAll();
        this.cmbToolchain.removeAll();
        this.toolChains.clear();
        this.launchConfigurationTypes.clear();
        List lcDescriptors = ImportExportConfigurationUtil.getDebuggerLaunchConfigurationDescriptorsByDeviceCore((DeviceCoreDescriptor)deviceCoreDescriptor, (String)deviceRevision);
        if (lcDescriptors.isEmpty()) {
            lcDescriptors = ImportExportConfigurationUtil.getDebuggerLaunchConfigurationDescriptors((DeviceCoreDescriptor)deviceCoreDescriptor);
        }
        this.launchConfigurationTypes.addAll(lcDescriptors);
        for (DebuggerLaunchConfigurationDescriptor configuration : this.launchConfigurationTypes) {
            this.cmbLConfig.add(DebuggerDescriptors.getDebuggerRegistry().getDebuggerDescriptor(configuration.getDebuggerId()).getName());
        }
        this.setEnabledLaunchContols(this.btnLConfig.getSelection());
        this.updatePageState();
    }

    public boolean isCreateLaunchConfigurationSelected() {
        return this.btnLConfig.getSelection();
    }

    protected ICProject getCProjectFromDialog() {
        try {
            Object[] cprojects = CoreModel.getDefault().getCModel().getCProjects();
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(ImportExecMessages.ImportWizard_ElementListSelectionDialog_Title);
            dialog.setMessage(ImportExecMessages.ImportWizard_ElementListSelectionDialog_Message);
            dialog.setElements(cprojects);
            ICProject cProject = this.getExistingCProject();
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                return (ICProject)dialog.getFirstResult();
            }
        }
        catch (CModelException e) {
            CdtUiActivator.getInstance().logError("An exception was thrown during extracting projects from the core model", e);
        }
        return null;
    }

    public ILaunchConfigurationType getLaunchConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(this.launchConfigurationTypes.get(this.cmbLConfig.getSelectionIndex()).getLaunchConfigurationTypeIdentifier());
    }

    public DebuggerLaunchConfigurationDescriptor getDebuggerLaunchConfigurationDescriptor() {
        return this.launchConfigurationTypes.get(this.cmbLConfig.getSelectionIndex());
    }

    public String getLaunchConfigurationName() {
        return this.txtLConfigName.getText();
    }

    public String getToolChainId() {
        if (this.toolChains.isEmpty()) {
            return "";
        }
        return this.toolChains.get(this.cmbToolchain.getSelectionIndex()).getId();
    }

    public ICProject getExistingCProject() {
        String projectName = this.txtProjectNameExs.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        ICProject cProject = CoreModel.getDefault().getCModel().getCProject(projectName);
        if (!cProject.exists()) {
            return null;
        }
        return cProject;
    }
}

