/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.updateprojectcode;

import com.nxp.swtools.common.ui.utils.GcUtils;
import com.nxp.swtools.common.ui.utils.editors.EditorHelper;
import com.nxp.swtools.common.ui.utils.swt.CompareContentProvider;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.HardReferenceNonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ErrorLevels;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContext;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.storage.GeneratedProjectFile;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectInfo;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.Activator;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.sdkproject.ToolSourceFileProvider;
import com.nxp.swtools.sdkproject.ToolchainProjectDestinationPathProvider;
import com.nxp.swtools.sdkproject.swt.StyledLabelProviderAdapter;
import com.nxp.swtools.sdkproject.updateprojectcode.SourceGenerateBlocker;
import com.nxp.swtools.sdkproject.updateprojectcode.TreeItemData;
import com.nxp.swtools.sdkproject.updateprojectcode.TreeItemDataContentProvider;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.swt.appearance.DefaultColorSchemeSetter;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.validation.engine.FilteredProblems;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.jface.gridviewer.GridTreeViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.widgets.grid.DefaultCellRenderer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class UpdateCodeDialog
extends Dialog {
    static final long serialVersionUID = 1L;
    private static final int HINT_DIFF_WIDHT = 800;
    private static final int HINT_DIFF_HEIGHT = 600;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(UpdateCodeDialog.class);
    private static final String SETTING_SECTION_NAME = UpdateCodeDialog.class.getSimpleName();
    private static final String SETTING_SECTION_DIFF_MODE_NAME = String.valueOf(SETTING_SECTION_NAME) + "_DIFF_MODE";
    private static final String SETTING_SPLITTER_LEFT_LAYOUT = "SPLITTER_LEFT_LAYOUT";
    boolean diffMode = false;
    protected final boolean showOpenDialogOption;
    @Nullable
    protected Boolean showOpenDialogOptionValue = null;
    @Nullable
    protected Boolean returnToDevelop = null;
    @Nullable
    protected Boolean updateCdtIncludePaths = null;
    @Nullable
    protected Composite diffContainer;
    @Nullable
    protected Composite scrollContent;
    @NonNull
    protected @NonNull List<@NonNull TreeItemData> treeItems = new ArrayList<TreeItemData>();
    @Nullable
    protected Grid filesTree;
    @Nullable
    protected Sash splitter;
    @Nullable
    protected Font treeBoldFont;
    @Nullable
    protected Cursor treeHandCursor;
    @NonNull
    protected @NonNull Map<@NonNull Path, TreeItemData> folders = new HashMap<Path, TreeItemData>();

    public UpdateCodeDialog(@NonNull Shell parent, boolean showOpenDialogOption) {
        super(parent);
        this.showOpenDialogOption = showOpenDialogOption;
    }

    /*
     * Unable to fully structure code
     */
    void showFileDiff(@NonNull Path cmpPrjFilePath, @NonNull String newFileContent) {
        block7: {
            shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
            projectProvider = shrdConfig.getToolchainProjectProvider();
            v0 = toolchainProject = projectProvider != null ? projectProvider.getToolchainProject() : null;
            if (!UpdateCodeDialog.$assertionsDisabled && toolchainProject == null) {
                throw new AssertionError();
            }
            prjContent = toolchainProject.getSourceFileAsCachedString(cmpPrjFilePath);
            container = this.diffContainer;
            curScrollContent = this.scrollContent;
            tree = this.filesTree;
            theSplitter = this.splitter;
            if (prjContent == null || container == null || curScrollContent == null || tree == null || theSplitter == null) {
                return;
            }
            theSplitter.setVisible(true);
            this.diffMode = true;
            fdata = (FormData)tree.getLayoutData();
            if (fdata != null) {
                fdata.right = new FormAttachment((Control)theSplitter, 0);
            }
            newContArr = newFileContent.getBytes(StandardCharsets.UTF_8);
            prjContArr = prjContent.getBytes(StandardCharsets.UTF_8);
            contProvider = new CompareContentProvider(cmpPrjFilePath.toString(), newContArr, prjContArr);
            shell = this.getShell();
            v1 = resizeDlg = shell == null || shell.getMaximized() == false;
            if (container.getChildren().length != 0) ** GOTO lbl27
            this.restoreSplitterLayout(theSplitter);
            break block7;
lbl-1000:
            // 1 sources

            {
                container.getChildren()[0].dispose();
lbl27:
                // 2 sources

                ** while (container.getChildren().length > 0)
            }
lbl28:
            // 1 sources

            resizeDlg = false;
        }
        diffCtrl = EditorHelper.createCompareControl((Composite)container, (CompareContentProvider)contProvider, (IProgressMonitor)new NullProgressMonitor());
        if (diffCtrl == null) {
            return;
        }
        diffCtrl.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setSize(container.computeSize(750, 300));
        minWdt = Integer.max(800, container.getSize().x);
        minHigh = Integer.max(600, container.getSize().y);
        dispRect = container.getDisplay().getClientArea();
        par = (ScrolledComposite)curScrollContent.getParent();
        if (par != null) {
            par.setMinSize(minWdt, minHigh);
        }
        container.layout();
        curScrollContent.setSize(curScrollContent.computeSize(dispRect.width * 2 / 3, dispRect.height * 2 / 3));
        curScrollContent.layout(true, true);
        if (resizeDlg && (dlgShell = (dlg = this).getShell()) != null) {
            size = this.getInitialSize();
            dlgShell.setSize(size);
            dlgShell.setLocation(this.getInitialLocation(size));
        }
    }

    void setLayoutDefferedRecursively(@Nullable Composite composite, boolean layoutDeffered) {
        if (composite != null) {
            composite.setLayoutDeferred(layoutDeffered);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Composite) {
                    this.setLayoutDefferedRecursively((Composite)control, layoutDeffered);
                }
                ++n2;
            }
        }
    }

    @NonNull TreeItemData findTreeItemFolder(@NonNull TreeItemData treeParent, @NonNull Path relPath) {
        TreeItemData result = treeParent;
        Path curPath = Paths.get("", new String[0]);
        int index = -1;
        while (++index < relPath.getNameCount()) {
            curPath = curPath.resolve(relPath.getName(index));
            TreeItemData newFolder = this.folders.get(relPath);
            if (newFolder == null) {
                String folderText = String.valueOf(relPath.getName(index).toString()) + File.separator;
                newFolder = TreeItemData.newItem(result, TreeItemData.ItemType.FOLDER, folderText, Messages.get().UpdPrjCode_Tooltip_ProjectSubFolder);
                this.folders.put(curPath, newFolder);
            }
            result = newFolder;
        }
        return result;
    }

    public static @NonNull Path getDefaultDestPathForGeneratedFile(@NonNull Path relFilePath, @NonNull IToolchainProjectInfo toolchainProject) {
        if (relFilePath.startsWith(toolchainProject.getProjectRoot())) {
            relFilePath = toolchainProject.getProjectRoot().relativize(relFilePath);
        }
        return relFilePath;
    }

    protected void createTreeItemDataForFile(@NonNull String toolId, @NonNull Path relFilePath, @Nullable String fileRawContent, @NonNull TreeItemData treeParent, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IGeneratedFilesStatusProvider.GeneratedFileStatus status, boolean derivedSource, @Nullable String additionalInformation) {
        String icon;
        String fileTooltip;
        String fileStatus;
        IGeneratedFilesStatusProvider genStatusProvider;
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        IToolchainProjectProvider projectProvider = shrdConfig.getToolchainProjectProvider();
        IToolchainProjectWithSdk toolchainProject = projectProvider != null ? projectProvider.getToolchainProject() : null;
        IGeneratedFilesStatusProvider iGeneratedFilesStatusProvider = genStatusProvider = projectProvider != null ? projectProvider.getGeneratedFilesStatusProvider() : null;
        assert (toolchainProject != null && genStatusProvider != null);
        int statusDecorator = -1;
        String statusTooltip = null;
        String statusSuffix = "";
        Path relPath = toolchainProject.findSourceFileRelPath(relFilePath);
        if (relPath == null) {
            relPath = UpdateCodeDialog.getDefaultDestPathForGeneratedFile(relFilePath, (IToolchainProjectInfo)toolchainProject);
            if (toolchainProject.wasProjectDetected() && !SWToolsPlatform.isRunningInEclipseIde()) {
                statusDecorator = 1;
                statusTooltip = String.valueOf(ErrorLevels.levelToText((int)statusDecorator)) + ": " + Messages.get().UpdPrjCode_ErrTheSourceFileNotInProject;
                statusSuffix = Messages.get().UpdPrjCode_FileStatus_NotInProject;
            }
        }
        if (additionalInformation != null) {
            statusTooltip = UtilsText.isEmpty(statusTooltip) ? additionalInformation : String.valueOf(statusTooltip) + "\r\n" + additionalInformation;
            if (statusDecorator < 0) {
                statusDecorator = 0;
            }
        }
        Runnable showDiff = null;
        if (status == null) {
            assert (false);
            fileStatus = "???";
            fileTooltip = "";
            icon = "icons/updateProjectCode_Disabled.png";
        } else {
            switch (status.statusInfo) {
                default: {
                    assert (false);
                }
                case NOT_EXIST: {
                    fileStatus = String.valueOf(Messages.get().UpdPrjCode_FileStatus_Create) + statusSuffix;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_Create_Tooltip;
                    icon = "icons/updateProjectCode_Dirty.png";
                    break;
                }
                case USER_TEMPLATE: {
                    fileStatus = String.valueOf(Messages.get().UpdPrjCode_FileStatus_UserFile) + statusSuffix;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_UserFile_Tooltip;
                    icon = "icons/userTemplateProjectCode.png";
                    break;
                }
                case DELETE: {
                    fileStatus = Messages.get().UpdPrjCode_FileStatus_Delete;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_Delete_Tooltip;
                    icon = "icons/updateProjectCode_Delete.png";
                    break;
                }
                case MODIFIED: {
                    fileStatus = String.valueOf(Messages.get().UpdPrjCode_FileStatus_Changed) + statusSuffix;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_Changed_Tooltip;
                    icon = "icons/updateProjectCode_Dirty.png";
                    String fileContent = UtilsText.convertLineEndings((String)Objects.requireNonNull(fileRawContent), (String)"\r\n");
                    Path cmpPrjFilePath = relPath;
                    showDiff = () -> this.showFileDiff(cmpPrjFilePath, fileContent);
                    break;
                }
                case UP_TO_DATE: {
                    assert (!genStatusProvider.isNeededUpdateProjectCode(status));
                    fileStatus = String.valueOf(Messages.get().UpdPrjCode_FileStatus_Same) + statusSuffix;
                    fileTooltip = Messages.get().UpdPrjCode_FileStatus_Same_Tooltip;
                    icon = "icons/updateProjectCode_Updated.png";
                }
            }
        }
        Path relPathWithoutFileName = relPath.getParent();
        if (relPathWithoutFileName == null) {
            assert (false) : "Is this really needed?? Might be a bug";
            relPathWithoutFileName = Paths.get("", new String[0]);
        }
        TreeItemData fldr = this.findTreeItemFolder(treeParent, relPathWithoutFileName);
        if (statusTooltip != null) {
            fileTooltip = String.valueOf(statusTooltip) + "\r\n" + fileTooltip;
        }
        StorageTool storageTool = shrdConfig.getTools().getTool(toolId);
        assert (storageTool != null);
        TreeItemData fileItem = TreeItemData.newItem(fldr, TreeItemData.ItemType.FILE, Objects.requireNonNull(relPath.getFileName()).toString(), fileTooltip);
        fileItem.setDerived(derivedSource);
        if (icon.contentEquals("icons/userTemplateProjectCode.png")) {
            fileItem.setSelection(TreeItemData.Selection.CANNOT_SELECT);
        } else if (!storageTool.isProjectFileUpdateEnabled(fileItem.getText())) {
            fileItem.setSelection(TreeItemData.Selection.UNSELECTED);
        }
        if (icon.contentEquals("icons/updateProjectCode_Delete.png")) {
            fileItem.setForRemoval(true);
        }
        if (!fileStatus.isEmpty()) {
            Image decoratedIcon = statusDecorator < 0 ? ToolsImages.getLocalImage((String)icon) : ToolsImages.getImageWithProblemDecorator((String)icon, (int)statusDecorator, (int)0);
            fileItem.setFileStatus(decoratedIcon, fileStatus, showDiff);
        }
    }

    protected void createFileControlsForTheFiles(@NonNull String toolId, Collection<@NonNull ISourceFile> generatedFiles, ISourceFileProviderWrapper.ISourceGenerateResult genResult, @NonNull TreeItemData treeParent) {
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        IToolchainProjectProvider projectProvider = shrdConfig.getToolchainProjectProvider();
        assert (projectProvider != null);
        IToolchainProjectWithSdk toolchainProject = projectProvider.getToolchainProject();
        assert (toolchainProject != null);
        IGeneratedFilesStatusProvider genStatusProvider = projectProvider.getGeneratedFilesStatusProvider();
        assert (genStatusProvider != null);
        ITool tool = Tools.getTool((String)toolId);
        assert (tool != null);
        ToolchainProjectDestinationPathProvider pathProvider = new ToolchainProjectDestinationPathProvider(toolchainProject, "board", shrdConfig.getPreferences().getOutputPathOverrides());
        Path prjRoot = toolchainProject.getProjectRoot();
        HashMap<@NonNull K, @NonNull V> generatedFilePaths = new HashMap();
        generatedFiles.forEach(source -> {
            Path path2 = UpdateCodeDialog.relativizePath(prjRoot, pathProvider.getDestinationPath(source.getRelFileName()));
            generatedFilePaths.put(path2, source.getAsString());
        });
        List<@NonNull T> overridenPaths = pathProvider.getOverridenPath().stream().map(p -> UpdateCodeDialog.relativizePath(prjRoot, p)).collect(Collectors.toList());
        genStatusProvider.getGeneratedRelPathsToDelete(false, toolId).forEach(relFilePath -> {
            String string = generatedFilePaths.put(relFilePath, "");
        });
        if (generatedFilePaths.isEmpty()) {
            genResult = genResult.getStatus() == ISourceFileGenerationStatus.GenerationStatus.OK ? new SourceGenerateBlocker(ISourceFileGenerationStatus.GenerationStatus.WARNING, Messages.get().UpdPrjCode_ErrNoFileGenerated) : new SourceGenerateBlocker(genResult.getStatus(), genResult.getMessage());
        } else {
            ISourceFileProviderWrapper.ISourceGenerateResult result = genResult;
            generatedFilePaths.entrySet().stream().sorted((a, b) -> Objects.requireNonNull((Path)a.getKey()).compareTo((Path)b.getKey())).forEach(k -> {
                Path relFilePath = Objects.requireNonNull((Path)k.getKey());
                IGeneratedFilesStatusProvider.GeneratedFileStatus status = genStatusProvider.getGeneratedFileProjectStatus(relFilePath, true);
                boolean derivedSource = false;
                if (status == null) {
                    ISourceFile sourceFile;
                    derivedSource = result.isDerivedSource(relFilePath.toString());
                    ISourceFile iSourceFile = sourceFile = derivedSource ? result.findSourceByName(relFilePath.toString()) : null;
                    if (sourceFile != null) {
                        HardReferenceNonNull foundPath = new HardReferenceNonNull((Object)sourceFile.getRelFilePath());
                        status = genStatusProvider.getProjectFileStatus(toolId, foundPath, sourceFile.getAsString());
                    }
                }
                this.createTreeItemDataForFile(toolId, relFilePath, (String)k.getValue(), treeParent, status, derivedSource, overridenPaths.contains(relFilePath) ? Messages.get().UpdateCodeDialog_FileStatus_PathOverriden_infoDecorator : null);
            });
        }
    }

    protected ISourceFileProviderWrapper.ISourceGenerateResult createFileControlsForTheTool(@NonNull String toolId, @NonNull ISourceFileProviderWrapper srcFileProvider, @NonNull TreeItemData treeParent) {
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        ProcessorCore selCore = shrdConfig.getCommonConfig().getSelectedCore();
        IToolchainProjectProvider projectProvider = shrdConfig.getToolchainProjectProvider();
        IToolchainProjectWithSdk toolchainProject = projectProvider != null ? projectProvider.getToolchainProject() : null;
        IGeneratedFilesStatusProvider genStatusProvider = projectProvider != null ? projectProvider.getGeneratedFilesStatusProvider() : null;
        ITool tool = Tools.getTool((String)toolId);
        assert (tool != null);
        if (toolchainProject == null || genStatusProvider == null || selCore == null) {
            LOGGER.severe("toolchainProject or genStatusProvider or selCore is null");
            assert (false) : "toolchainProject or genStatusProvider or selCore is null";
            return new SourceGenerateBlocker(ISourceFileGenerationStatus.GenerationStatus.FATAL, "Unexpected failure");
        }
        if (!tool.isProcessorSupported(shrdConfig)) {
            return new SourceGenerateBlocker(ISourceFileGenerationStatus.GenerationStatus.WARNING, Messages.get().UpdPrjCode_ErrProcessorNotSupported);
        }
        StorageTool storageTool = shrdConfig.getTools().getTool(toolId);
        if (storageTool == null || !storageTool.isEnabled()) {
            String toolName = tool.getToolId();
            SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)toolName);
            if (product != null) {
                toolName = product.getProductName();
            }
            return new SourceGenerateBlocker(ISourceFileGenerationStatus.GenerationStatus.WARNING, String.format(Messages.get().UpdPrjCode_ToolIsDisabledTooltip, toolName));
        }
        ArrayList<@NonNull ISourceFile> generatedFiles = new ArrayList<ISourceFile>();
        genStatusProvider.getGeneratedRelFiles(true, toolId);
        ISourceFileProviderWrapper.ISourceGenerateResult genResult = srcFileProvider.generate(selCore.getID(), true);
        generatedFiles.addAll(genResult.getAllGeneratedFiles());
        if (genResult.getStatus() != ISourceFileGenerationStatus.GenerationStatus.FATAL) {
            this.createFileControlsForTheFiles(toolId, generatedFiles, genResult, treeParent);
        } else {
            genResult = new SourceGenerateBlocker(ISourceFileGenerationStatus.GenerationStatus.FATAL, genResult.getMessage());
        }
        this.folders.clear();
        return genResult;
    }

    protected @NonNull Point getNewLocation() {
        Shell shell = this.getShell();
        if (shell == null) {
            return new Point(0, 0);
        }
        Point result = this.getInitialLocation(Objects.requireNonNull(shell.getSize()));
        assert (result != null);
        return result;
    }

    protected boolean createControlsForTheTool(@NonNull ToolSourceFileProvider toolSrcFileProvider, boolean withoutProblems) {
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        IToolchainProjectWithSdk toolchainProject = shrdConfig.getToolchainProject();
        assert (toolchainProject != null);
        ProcessorCore selCore = shrdConfig.getCommonConfig().getSelectedCore();
        ISourceFileProviderWrapper srcFileProvider = toolSrcFileProvider.getSourceFileProvider();
        assert (selCore != null);
        ITool tool = Tools.getTool((String)toolSrcFileProvider.getToolId());
        assert (tool != null);
        TreeItemData toolItem = TreeItemData.newRootItem(toolSrcFileProvider.getTool().getProductName(), toolSrcFileProvider, Messages.get().UpdPrjCode_ToolCheckboxTooltip);
        ISourceFileProviderWrapper.ISourceGenerateResult srcGenResult = this.createFileControlsForTheTool(toolSrcFileProvider.getToolId(), srcFileProvider, toolItem);
        if (withoutProblems && srcGenResult.hasBlockingIssue()) {
            return false;
        }
        this.treeItems.add(toolItem);
        StorageTool storageTool = toolSrcFileProvider.getStorageTool();
        if (storageTool != null && !storageTool.getUpdateCode()) {
            toolItem.setSelection(TreeItemData.Selection.UNSELECTED);
        }
        FilteredProblems guiProblems = FilteredProblems.countNumberOfProblemsForTool((ITool)Objects.requireNonNull(Tools.getTool((String)toolSrcFileProvider.getToolId())));
        if (srcGenResult.getStatus() != ISourceFileGenerationStatus.GenerationStatus.OK || guiProblems.getHighestLevel() > 0) {
            if (srcGenResult.getStatus() == ISourceFileGenerationStatus.GenerationStatus.FATAL || srcGenResult.hasBlockingIssue()) {
                toolItem.setSelection(TreeItemData.Selection.NEVER_SELECTED);
            }
            StringBuilder tooltip = new StringBuilder();
            if (srcGenResult.getStatus() != ISourceFileGenerationStatus.GenerationStatus.OK) {
                tooltip.append(Messages.get().UpdPrjCode_Tooltip_ToolPrblmInCodeGen);
                tooltip.append(": ");
                tooltip.append(srcGenResult.getMessage());
            }
            if (guiProblems.getHighestLevel() > 0) {
                if (tooltip.length() > 0) {
                    tooltip.append("\r\n");
                }
                tooltip.append(Messages.get().UpdPrjCode_Tooltip_ToolPrblmInConfig);
                tooltip.append(": ");
                tooltip.append(Objects.requireNonNull(guiProblems.getProblemsCount(1)));
            }
            toolItem.setTooltip(tooltip.toString());
            boolean error = srcGenResult.getStatus() == ISourceFileGenerationStatus.GenerationStatus.FATAL || srcGenResult.getStatus() == ISourceFileGenerationStatus.GenerationStatus.ERRORS || guiProblems.getHighestLevel() >= 2;
            Image icon = PlatformUI.getWorkbench().getSharedImages().getImage(error ? "IMG_OBJS_ERROR_TSK" : "IMG_OBJS_WARN_TSK");
            assert (icon != null);
            if (error) {
                toolItem.setFileStatus(icon, UtilsText.safeString((String)Messages.get().UpdPrjCode_FileStatus_Error), null);
            } else {
                toolItem.setFileStatus(icon, UtilsText.safeString((String)Messages.get().UpdPrjCode_FileStatus_Warn), null);
            }
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        String mexStatus;
        Composite newScrollContent;
        Composite mainContainer = (Composite)super.createDialogArea(parent);
        ScrolledComposite scrollContainer = new ScrolledComposite(mainContainer, 768);
        scrollContainer.setExpandHorizontal(true);
        scrollContainer.setExpandVertical(true);
        scrollContainer.setAlwaysShowScrollBars(false);
        this.scrollContent = newScrollContent = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)newScrollContent);
        newScrollContent.setLayout((Layout)new FormLayout());
        scrollContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        newScrollContent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                newScrollContent.layout(true, true);
            }
        });
        final CheckboxTreeViewerWithRows filesTreeViewer = new CheckboxTreeViewerWithRows(newScrollContent);
        filesTreeViewer.setAutoExpandLevel(4);
        Grid tree = filesTreeViewer.getGrid();
        tree.setLinesVisible(false);
        this.filesTree = tree;
        tree.setHeaderVisible(true);
        FormData fd = new FormData(100, 300);
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        tree.setLayoutData((Object)fd);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)tree, "UpdateProjectFilesWindowTree");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)filesTreeViewer, (int)2);
        filesTreeViewer.setContentProvider((IContentProvider)new TreeItemDataContentProvider());
        GridColumn firstColumn = this.createNameColumn(filesTreeViewer);
        GridColumn statusColumn = this.createStatusColumn(filesTreeViewer);
        tree.addListener(13, event -> {
            GridItem treeItem;
            Object itmObj;
            if (event.detail == 32 && event.item instanceof GridItem && (itmObj = (treeItem = (GridItem)event.item).getData()) instanceof TreeItemData) {
                TreeItemData item = (TreeItemData)itmObj;
                item.toggleSelection();
                filesTreeViewer.refresh();
            }
        });
        this.treeHandCursor = new Cursor((Device)tree.getDisplay(), 21);
        tree.addMouseMoveListener(event -> {
            ViewerCell cell = filesTreeViewer.getCell(new Point(event.x, event.y));
            if (cell != null && cell.getColumnIndex() == 1) {
                TreeItemData itemData = filesTreeViewer.getItemData(cell);
                if (itemData != null && itemData.getFileStatusAction() != null) {
                    tree.setCursor(this.treeHandCursor);
                } else {
                    tree.setCursor(null);
                }
            } else {
                tree.setCursor(null);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                ViewerCell cell = filesTreeViewer.getCell(new Point(event.x, event.y));
                if (cell != null && cell.getColumnIndex() == 1) {
                    Runnable runnable;
                    TreeItemData itemData = filesTreeViewer.getItemData(cell);
                    Runnable runnable2 = runnable = itemData != null ? itemData.getFileStatusAction() : null;
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            }
        });
        ArrayList<@NonNull ToolSourceFileProvider> disabledToolProviers = new ArrayList<ToolSourceFileProvider>();
        for (ToolSourceFileProvider toolSrcFileProvider : ToolSourceFileProvider.getToolSourceFileProviders()) {
            if (this.createControlsForTheTool(toolSrcFileProvider, true)) continue;
            disabledToolProviers.add(toolSrcFileProvider);
        }
        for (ToolSourceFileProvider toolSrcFileProvider : disabledToolProviers) {
            boolean result = this.createControlsForTheTool(toolSrcFileProvider, false);
            assert (result);
        }
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        TreeItemData confCheckBox = TreeItemData.newRootItem(UtilsText.safeString((String)Messages.get().UpdPrjCode_Configuration), null, Messages.get().UpdPrjCode_ConfigurationTooltip);
        this.treeItems.add(confCheckBox);
        String string = mexStatus = shrdConfig.isDirty() ? Messages.get().UpdPrjCode_MexModified : Messages.get().UpdPrjCode_MexSaved;
        assert (mexStatus != null);
        TreeItemData mexFile = TreeItemData.newItem(confCheckBox, TreeItemData.ItemType.FILE, UtilsFile.getFileNameWithExtension((String)UtilsText.safeString((String)shrdConfig.getLocationOnDisk())), Messages.get().UpdPrjCode_ConfigurationTooltip);
        Image mexIcon = ToolsImages.getLocalImage((String)(shrdConfig.isDirty() ? "icons/updateProjectCode_Dirty.png" : "icons/updateProjectCode_Updated.png"));
        mexFile.setFileStatus(mexIcon, mexStatus, () -> this.showMexDiff(shrdConfig));
        confCheckBox.setSelection(TreeItemData.Selection.ALWAYS_SELECTED);
        Sash theSplitter = new Sash(newScrollContent, 2560);
        theSplitter.addListener(13, e -> {
            Rectangle parentRect = newScrollContent.getClientArea();
            int left = e.x;
            if (left < 150) {
                left = 150;
            } else if (left > parentRect.width - 300) {
                left = parentRect.width - 300;
            }
            FormData fdata = (FormData)theSplitter.getLayoutData();
            if (fdata != null) {
                fdata.left = new FormAttachment(0, left);
                newScrollContent.layout();
            }
        });
        theSplitter.setVisible(false);
        this.splitter = theSplitter;
        Composite newDiffContainer = new Composite(newScrollContent, 0);
        newDiffContainer.setLayout((Layout)new GridLayout(1, false));
        fd = new FormData(0, 100);
        fd.left = new FormAttachment((Control)theSplitter, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        newDiffContainer.setLayoutData((Object)fd);
        this.diffContainer = newDiffContainer;
        fd = new FormData(2, 2);
        fd.left = new FormAttachment(40, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        theSplitter.setLayoutData((Object)fd);
        scrollContainer.layout();
        newScrollContent.setSize(newScrollContent.computeSize(-1, -1));
        newScrollContent.addDisposeListener(e -> {
            if (this.treeBoldFont != null) {
                this.treeBoldFont.dispose();
            }
            if (this.treeHandCursor != null) {
                this.treeHandCursor.dispose();
            }
        });
        filesTreeViewer.setInput(this.treeItems);
        DefaultColorSchemeSetter.setDefaultColorScheme((Grid)tree);
        firstColumn.pack();
        firstColumn.setWidth(firstColumn.getWidth() + 10);
        statusColumn.pack();
        statusColumn.setWidth(statusColumn.getWidth() + 10);
        return mainContainer;
    }

    private void showMexDiff(ISharedConfiguration sharedConfig) {
        IToolchainProjectWithSdk toolchainProject = sharedConfig.getToolchainProject();
        if (toolchainProject != null) {
            ToolchainProjectDestinationPathProvider pathProvider = new ToolchainProjectDestinationPathProvider(toolchainProject, "", sharedConfig.getPreferences().getOutputPathOverrides());
            Path prjRoot = toolchainProject.getProjectRoot();
            String mexLocation = sharedConfig.getLocationOnDisk();
            if (mexLocation != null) {
                Path path = UpdateCodeDialog.relativizePath(prjRoot, pathProvider.getDestinationPath(mexLocation));
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                        SharedConfigurationFactory.saveSharedConfigurationToXml((ISharedConfiguration)sharedConfig, (OutputStream)out);
                        String content = out.toString(StandardCharsets.UTF_8);
                        if (content != null) {
                            String newlyGenerated = UtilsText.convertLineEndings((String)content, (String)"\r\n").concat("\r\n");
                            this.showFileDiff(path, newlyGenerated);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "The newly generated configuration to compare cannot be serialized", e);
                }
            }
        }
    }

    @NonNull GridColumn createNameColumn(final @NonNull CheckboxTreeViewerWithRows treeViewer) {
        GridViewerColumn firstColumnViewer = new GridViewerColumn((GridTreeViewer)treeViewer, 32, 0);
        GridColumn firstColumn = firstColumnViewer.getColumn();
        firstColumn.setWidth(300);
        firstColumn.setText(UtilsText.safeString((String)Messages.get().UpdPrjCode_ColumnTitle_GeneratedFile));
        SWTFactoryProxy.INSTANCE.setTree(firstColumn, true);
        firstColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getText();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getIcon();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getTooltip();
                }
                return null;
            }

            public Font getFont(Object element) {
                TreeItemData item;
                if (element instanceof TreeItemData && (item = (TreeItemData)element).getItemType().equals((Object)TreeItemData.ItemType.TOOL)) {
                    return UpdateCodeDialog.this.getTreeBoldFont(treeViewer.getGrid());
                }
                return null;
            }

            public Color getForeground(Object element) {
                if (element instanceof TreeItemData) {
                    TreeItemData item = (TreeItemData)element;
                    if (item.getSelection().isReadOnly()) {
                        return treeViewer.getGrid().getDisplay().getSystemColor(17);
                    }
                    if (item.isForRemoval()) {
                        return treeViewer.getGrid().getDisplay().getSystemColor(3);
                    }
                }
                return super.getForeground(element);
            }

            public void update(@NonNull ViewerCell cell) {
                super.update(cell);
                Object element = cell.getElement();
                if (element instanceof TreeItemData) {
                    TreeItemData data = (TreeItemData)element;
                    Widget item = cell.getViewerRow().getItem();
                    if (item instanceof GridItem) {
                        GridItem gridItem = (GridItem)item;
                        gridItem.setGrayed(data.getSelection().isGrayed());
                        gridItem.setChecked(data.getSelection().isChecked());
                        gridItem.setCheckable(0, !data.getSelection().isReadOnly());
                    }
                }
            }
        });
        return firstColumn;
    }

    public GridColumn createStatusColumn(@NonNull CheckboxTreeViewerWithRows treeViewer) {
        GridViewerColumn statusColumnViewer = new GridViewerColumn((GridTreeViewer)treeViewer, 0, 1);
        final GridColumn statusColumn = statusColumnViewer.getColumn();
        statusColumn.setWidth(100);
        statusColumn.setMoveable(false);
        statusColumn.setText(UtilsText.safeString((String)Messages.get().UpdPrjCode_ColumnTitle_Status));
        statusColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable Color getForeground(@NonNull Object element) {
                if (this.isClickable(element)) {
                    return statusColumn.getDisplay().getSystemColor(36);
                }
                return super.getForeground(element);
            }

            public @Nullable Image getImage(@NonNull Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getFileStatusIcon();
                }
                return null;
            }

            public @Nullable String getToolTipText(@NonNull Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getTooltip();
                }
                return null;
            }

            public @Nullable String getText(@NonNull Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getFileStatusLabel();
                }
                return "";
            }

            private boolean isClickable(@Nullable Object element) {
                if (element instanceof TreeItemData) {
                    return ((TreeItemData)element).getFileStatusAction() != null;
                }
                return false;
            }
        });
        statusColumn.setCellRenderer((GridCellRenderer)new DefaultCellRenderer(){

            public void paint(GC gc, Object value) {
                super.paint(gc, value);
                GridItem item = (GridItem)value;
                Object data = item.getData();
                if (data instanceof TreeItemData && ((TreeItemData)data).getFileStatusAction() != null) {
                    Rectangle cellBounds = this.getBounds();
                    String text = item.getText(this.getColumn());
                    if (cellBounds != null && text != null) {
                        Rectangle textOffset = this.getTextBounds(item, true);
                        Rectangle textBounds = GcUtils.move((Rectangle)cellBounds, (int)textOffset.x, (int)textOffset.y);
                        Point textExtent = gc.textExtent(text);
                        int lineStartX = textBounds.x;
                        int lineEndX = textBounds.x + textExtent.x;
                        int lineY = textBounds.y + textExtent.y - 1;
                        gc.drawLine(lineStartX, lineY, lineEndX, lineY);
                    }
                }
            }
        });
        return statusColumn;
    }

    @NonNull Font getTreeBoldFont(@Nullable Grid tree) {
        if (this.treeBoldFont != null) {
            return this.treeBoldFont;
        }
        assert (tree != null);
        Font font = tree.getFont();
        assert (font != null);
        this.treeBoldFont = font = FontFactory.changeStyle((Font)font, (int)1);
        return font;
    }

    private void createOptions(@NonNull Composite bottomGrp) {
        Button opt;
        if (!this.showOpenDialogOption && !SWToolsPlatform.isRunningInMCUXpressoIde()) {
            return;
        }
        Group optionsGrp = new Group(bottomGrp, 4);
        optionsGrp.setText(Messages.get().UpdPrjCode_OptionsGrpTitle);
        GridLayout layout = new GridLayout(1, false);
        optionsGrp.setLayout((Layout)layout);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        optionsGrp.setLayoutData((Object)gridData);
        if (this.showOpenDialogOption) {
            opt = new Button((Composite)optionsGrp, 32);
            opt.setText(com.nxp.swtools.utils.Messages.get().KEPreferenceHelper_ShowUpdProjectDialog);
            opt.setSelection(KEPreferences.showUpdateCodeDialog());
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)opt, com.nxp.swtools.utils.Messages.get().KEPreferenceHelper_ShowUpdProjectDialogTooltip);
            SWTFactoryProxy.INSTANCE.setTestId((Widget)opt, "PreferenceShowUpdateProjectDialog");
            opt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UpdateCodeDialog.this.showOpenDialogOptionValue = opt.getSelection();
                }
            });
        }
        if (SWToolsPlatform.isRunningInMCUXpressoIde()) {
            opt = new Button((Composite)optionsGrp, 32);
            opt.setText(com.nxp.swtools.utils.Messages.get().KEPreferenceHelper_ReturnToDevelopAfterUpdateProject);
            opt.setSelection(KEPreferences.returnToDevelopAfterUpdateProject());
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)opt, com.nxp.swtools.utils.Messages.get().KEPreferenceHelper_ReturnToDevelopAfterUpdateProjectTooltip);
            opt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UpdateCodeDialog.this.returnToDevelop = opt.getSelection();
                }
            });
            ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
            Button cbUpdateCdt = new Button((Composite)optionsGrp, 32);
            cbUpdateCdt.setText(com.nxp.swtools.utils.Messages.get().UpdateCodeDialog_UpdateCdtIncludePaths);
            cbUpdateCdt.setSelection(shrdConfig.getPreferences().isUpdateCDTIncludePaths());
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)opt, com.nxp.swtools.utils.Messages.get().UpdateCodeDialog_UpdateCdtIncludePathsTooltip);
            cbUpdateCdt.addListener(13, event -> {
                Boolean bl = this.updateCdtIncludePaths = Boolean.valueOf(cbUpdateCdt.getSelection());
            });
        }
    }

    protected Control createButtonBar(Composite parent) {
        assert (parent != null);
        Composite bottomGrp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        bottomGrp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        bottomGrp.setLayoutData((Object)gridData);
        bottomGrp.setFont(parent.getFont());
        this.createOptions(bottomGrp);
        return super.createButtonBar(bottomGrp);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().UpdPrjCode_DlgTitle);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)newShell, "UpdateProjectCodeDialog");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String name = this.diffMode ? SETTING_SECTION_DIFF_MODE_NAME : SETTING_SECTION_NAME;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(name);
        if (section == null) {
            section = settings.addNewSection(name);
        }
        return section;
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        Shell shell = this.getShell();
        if (shell != null) {
            Point computeSize = shell.computeSize(-1, -1, true);
            shell.setMinimumSize(Math.min(size.x, computeSize.x), Math.min(size.y, computeSize.y));
        }
        return size;
    }

    public boolean close() {
        if (this.diffMode) {
            this.storeSplitterLayout(this.splitter);
        }
        return super.close();
    }

    void storeSplitterLayout(@Nullable Sash theSplitter) {
        IDialogSettings setting = this.getDialogBoundsSettings();
        if (setting != null && theSplitter != null && theSplitter.getLayoutData() instanceof FormData) {
            FormData data = (FormData)theSplitter.getLayoutData();
            assert (data != null);
            FormAttachment left = data.left;
            assert (left != null);
            String[] layout = new String[]{Integer.toString(left.numerator), Integer.toString(left.denominator), Integer.toString(left.offset)};
            setting.put(SETTING_SPLITTER_LEFT_LAYOUT, layout);
            assert (left.control == null) : MessageFormat.format("Control({0}) is can't be saved in settings!", left.control);
        }
    }

    public void restoreSplitterLayout(@NonNull Sash theSplitter) {
        IDialogSettings setting = this.getDialogBoundsSettings();
        FormData data = (FormData)theSplitter.getLayoutData();
        if (setting != null && data != null) {
            try {
                String[] arr = setting.getArray(SETTING_SPLITTER_LEFT_LAYOUT);
                if (arr != null) {
                    data.left = new FormAttachment(Integer.parseInt(arr[0]), Integer.parseInt(arr[1]), Integer.parseInt(arr[2]));
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private static void retrieveFiles(@NonNull Collection<@NonNull TreeItemData> tree, @NonNull Collection<@NonNull TreeItemData> files) {
        for (TreeItemData item : tree) {
            if (TreeItemData.ItemType.FILE.equals((Object)item.getItemType())) {
                files.add(item);
            }
            UpdateCodeDialog.retrieveFiles(item.getChildren(), files);
        }
    }

    private static @NonNull Path relativizePath(@NonNull Path projectRoot, @NonNull Path path) {
        if (path.startsWith(projectRoot)) {
            path = projectRoot.relativize(path);
        } else {
            Path prjRootParent = projectRoot.getParent();
            while (prjRootParent != null) {
                if (path.startsWith(prjRootParent)) {
                    path = projectRoot.relativize(path);
                    break;
                }
                prjRootParent = prjRootParent.getParent();
            }
        }
        return path;
    }

    private static void updateTool(TreeItemData tool) {
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        ToolSourceFileProvider toolSrcProvider = tool.getToolSourceFileProvider();
        assert (toolSrcProvider != null);
        StorageTool storageTool = shrdConfig.getTools().getTool(toolSrcProvider.getToolId());
        if (storageTool != null) {
            boolean toolUpdated;
            boolean strgToolChanged = false;
            boolean bl = toolUpdated = !tool.getSelection().equals((Object)TreeItemData.Selection.UNSELECTED);
            if (toolUpdated != storageTool.getUpdateCode()) {
                StorageTool.setToolUpdateCode((StorageTool)storageTool, (boolean)toolUpdated);
                strgToolChanged = true;
            }
            ArrayList<@NonNull TreeItemData> files = new ArrayList<TreeItemData>();
            UpdateCodeDialog.retrieveFiles(tool.getChildren(), files);
            ArrayList<@NonNull GeneratedProjectFile> genFiles = new ArrayList<GeneratedProjectFile>();
            for (TreeItemData file : files) {
                genFiles.add(file.toGeneratedProjectFile());
            }
            if (storageTool.setGeneratedProjectFiles(genFiles)) {
                strgToolChanged = true;
            }
            if (strgToolChanged) {
                shrdConfig.setDirty((IConfigChangeContext)new DefaultConfigChangeContext(IConfigChangeContext.ConfigChangeType.UNKNOWN, toolSrcProvider.getToolId(), (Object)storageTool, Messages.get().UpdPrjCode_SetDirty_UpdPrjGenFiles));
            }
        } else {
            LOGGER.warning("Failed to update code for " + toolSrcProvider.getToolId() + ". This tool is null for the current configuration.");
        }
    }

    public int open() {
        int result = super.open();
        if (result == 0) {
            for (TreeItemData tool : this.treeItems) {
                ToolSourceFileProvider toolSrcProvider = tool.getToolSourceFileProvider();
                if (!TreeItemData.ItemType.TOOL.equals((Object)tool.getItemType()) || toolSrcProvider == null) continue;
                UpdateCodeDialog.updateTool(tool);
            }
            if (this.showOpenDialogOptionValue != null) {
                KEPreferences.setShowUpdateCodeDialog((boolean)this.showOpenDialogOptionValue);
            }
            if (this.returnToDevelop != null) {
                KEPreferences.setReturnToDevelopAfterUpdateProject((boolean)this.returnToDevelop);
            }
            if (this.updateCdtIncludePaths != null) {
                ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
                shrdConfig.getPreferences().setUpdateCDTIncludePaths(Objects.requireNonNull(this.updateCdtIncludePaths).booleanValue());
            }
        }
        return result;
    }

    static class CheckboxTreeViewerWithRows
    extends GridTreeViewer {
        public CheckboxTreeViewerWithRows(@NonNull Composite parent) {
            super(parent);
        }

        protected ViewerRow getViewerRow(Point point) {
            ViewerRow result;
            GridColumn[] treeCols = this.getGrid().getColumns();
            if (treeCols == null || treeCols.length == 0) {
                assert (false);
                return null;
            }
            int wasPointX = point.x;
            point.x = treeCols[0].getWidth() - 2;
            do {
                result = super.getViewerRow(point);
                point.x -= 8;
            } while (result == null && point.x > 0);
            point.x = wasPointX;
            return result;
        }

        @Nullable TreeItemData getItemData(@NonNull ViewerCell cell) {
            Object data = cell.getViewerRow().getItem().getData();
            return data instanceof TreeItemData ? (TreeItemData)data : null;
        }
    }

    static abstract class StyledLabelProviderAdapterWithTooltip
    extends StyledLabelProviderAdapter
    implements IToolTipProvider {
        StyledLabelProviderAdapterWithTooltip() {
        }
    }
}

