/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsXmlDom;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithCmsisParser;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Element;

public class MdkUVisionPrjAdapter
extends GenericPrjAdapterWithCmsisParser {
    @NonNull
    static final String UVISION_PRJ_FILE_EXT = ".uvprojx";
    @NonNull
    public static final String UVISION_PRJ_SUBDIR = "mdk";

    MdkUVisionPrjAdapter(@NonNull File file, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(file, prjDir, existingProcessorDetector);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void findCmsisSdkComponentsInUVisionProject(@NonNull Element root, @NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile) {
        Element rteElem = UtilsXmlDom.getChildElement((Element)root, (String)"RTE");
        if (rteElem == null) {
            LOGGER.info("`RTE` element not found in MDK uVision project file: " + this.getToolchainPrjFilePathStr());
            return;
        }
        Element componentsElem = UtilsXmlDom.getChildElement((Element)rteElem, (String)"components");
        if (componentsElem == null) {
            LOGGER.severe("`components` element not found in MDK uVision project file: " + this.getToolchainPrjFilePathStr());
            return;
        }
        @NonNull List componentElems = UtilsXmlDom.getChildrenElements((Element)componentsElem, (String)"component");
        for (Element compElem : componentElems) {
            SdkComponentInProject comp = this.createSdkComponentInPrjFromCmsisAttrs(compElem);
            if (comp == null) continue;
            componentsInPrjFile.add(comp);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void retrieveProjectSourcesFiles(@NonNull Element groupsElem, @NonNull Set<@NonNull Path> prjSources) {
        @NonNull List groupElems = UtilsXmlDom.getChildrenElements((Element)groupsElem, (String)"Group");
        for (Element groupElem : groupElems) {
            Element filesElem = UtilsXmlDom.getChildElement((Element)groupElem, (String)"Files");
            if (filesElem == null) continue;
            @NonNull List fileElems = UtilsXmlDom.getChildrenElements((Element)filesElem, (String)"File");
            for (Element fileElem : fileElems) {
                Element filePathElem = UtilsXmlDom.getChildElement((Element)fileElem, (String)"FilePath");
                if (filePathElem == null) {
                    LOGGER.severe("'FilePath' element not foun in MDK project file: " + this.getToolchainPrjFilePathStr());
                    continue;
                }
                String srcFilePath = UtilsFile.toEclipsePath((String)UtilsText.safeString((String)filePathElem.getTextContent()));
                if (srcFilePath.isEmpty()) continue;
                prjSources.add(Paths.get(srcFilePath, new String[0]));
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void retrieveProjectSourcesRTE(@NonNull Element rootElem, @NonNull Set<@NonNull Path> prjSources) {
        Element filesElem;
        Element rteElem = UtilsXmlDom.getChildElement((Element)rootElem, (String)"RTE");
        if (rteElem != null && (filesElem = UtilsXmlDom.getChildElement((Element)rteElem, (String)"files")) != null) {
            @NonNull List fileElems = UtilsXmlDom.getChildrenElements((Element)filesElem, (String)"file");
            for (Element fileElem : fileElems) {
                String srcFilePath;
                Element instElem = UtilsXmlDom.getChildElement((Element)fileElem, (String)"instance");
                if (instElem == null || (srcFilePath = UtilsFile.toEclipsePath((String)UtilsText.safeString((String)instElem.getTextContent()))).isEmpty()) continue;
                prjSources.add(Paths.get(srcFilePath, new String[0]));
            }
        }
    }

    private void retrieveProjectSources(@NonNull Element rootElem, @NonNull Element groupsElem, @NonNull Set<@NonNull Path> prjSources) {
        this.retrieveProjectSourcesFiles(groupsElem, prjSources);
        MdkUVisionPrjAdapter.retrieveProjectSourcesRTE(rootElem, prjSources);
    }

    private void retrieveIncludePathsAndProcessor(@NonNull Element targetOptElem, @NonNull List<@NonNull Path> inclPaths) {
        String[] pathsArr;
        int n;
        Element tgtArmAds = UtilsXmlDom.getChildElement((Element)targetOptElem, (String)"TargetArmAds");
        if (tgtArmAds == null) {
            LOGGER.severe("`TargetArmAds` element not found in uVision project file: " + this.getToolchainPrjFilePathStr());
            return;
        }
        Element cadsElem = UtilsXmlDom.getChildElement((Element)tgtArmAds, (String)"Cads");
        if (cadsElem == null) {
            LOGGER.severe("`Cads` element not found in uVision project file: " + this.getToolchainPrjFilePathStr());
            return;
        }
        Element variousCtrlsElem = UtilsXmlDom.getChildElement((Element)cadsElem, (String)"VariousControls");
        if (variousCtrlsElem == null) {
            LOGGER.severe("`VariousControls` element not found in uVision project file: " + this.getToolchainPrjFilePathStr());
            return;
        }
        Element inclPathElem = UtilsXmlDom.getChildElement((Element)variousCtrlsElem, (String)"IncludePath");
        if (inclPathElem == null) {
            LOGGER.severe("`IncludePath` element not found in uVision project file: " + this.getToolchainPrjFilePathStr());
            return;
        }
        Element defineElem = UtilsXmlDom.getChildElement((Element)variousCtrlsElem, (String)"Define");
        if (defineElem != null) {
            String[] definesArr;
            String defines = Objects.requireNonNull(defineElem.getTextContent()).trim();
            String[] stringArray = definesArr = defines.split(",");
            int n2 = definesArr.length;
            n = 0;
            while (n < n2) {
                String define = stringArray[n];
                String trimDefine = define.trim();
                if (trimDefine.startsWith("CPU_")) {
                    this.setDetectedPartNumberFromSymbol(trimDefine.substring(4));
                }
                ++n;
            }
        }
        String[] stringArray = pathsArr = Objects.requireNonNull(inclPathElem.getTextContent()).trim().split(";");
        n = pathsArr.length;
        int n3 = 0;
        while (n3 < n) {
            String path = stringArray[n3];
            inclPaths.add(Paths.get(path, new String[0]));
            ++n3;
        }
    }

    private String parseProcessorAndCore(@NonNull String deviceText, @NonNull Element targetOptElem, @NonNull List<@NonNull Path> inclPaths) {
        String coreStr;
        String processor;
        int pos = deviceText.indexOf(58);
        String partNumber = "";
        if (pos < 0) {
            processor = deviceText;
            coreStr = "";
        } else {
            processor = deviceText.substring(0, pos);
            coreStr = deviceText.substring(pos + 1);
        }
        if (!this.existingProcessorDetector.existsProcessor(processor)) {
            partNumber = processor;
        }
        this.retrieveIncludePathsAndProcessor(targetOptElem, inclPaths);
        if ((partNumber.isEmpty() || !this.setDetectedPartNumber(partNumber)) && this.detectedPartNumber == null) {
            this.autoselectPartNumber(this.getProcessorInfo(partNumber));
        }
        return coreStr;
    }

    private void parseCore(String coreStr) {
        String selCoreId;
        AtomicBoolean isMulticore = new AtomicBoolean(false);
        if (!this.detectProcessorCore(UtilsText.safeString((String)coreStr), isMulticore)) {
            if ("M0plus".equals(coreStr)) {
                coreStr = "cm0plus";
                isMulticore.set(false);
                this.detectProcessorCore(coreStr, isMulticore);
            } else if ("M4".equals(coreStr)) {
                coreStr = "cm4";
                isMulticore.set(false);
                this.detectProcessorCore(coreStr, isMulticore);
            }
        }
        String string = selCoreId = this.detectedCore != null ? this.detectedCore.getID() : "";
        if (this.detectedCore == null || isMulticore.get() && !coreStr.isEmpty() && !coreStr.equals(selCoreId)) {
            LOGGER.severe(() -> String.format("[SDK] Core was not detected from the MDK uVision project file '%s'", this.getToolchainPrjFilePathStr()));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean parse(@NonNull Element root, @NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull Set<@NonNull Path> prjSources, @NonNull List<@NonNull Path> inclPaths, @NonNull IProgressMonitor monitor) {
        Element targetElem;
        Element targetsElem = UtilsXmlDom.getChildElement((Element)root, (String)"Targets");
        if (targetsElem == null) {
            LOGGER.severe("`Targets` element not found in MDK uVision project file: " + this.getToolchainPrjFilePathStr());
            return false;
        }
        @NonNull List targetElems = UtilsXmlDom.getChildrenElements((Element)targetsElem, (String)"Target");
        Element element = targetElem = targetElems.isEmpty() ? null : (Element)targetElems.get(0);
        if (targetElem == null) {
            LOGGER.severe("`Target` element not found in MDK uVision project file: " + this.getToolchainPrjFilePathStr());
            return false;
        }
        Element groupsElem = UtilsXmlDom.getChildElement((Element)targetElem, (String)"Groups");
        if (groupsElem == null) {
            LOGGER.severe("`Groups` element not found in MDK uVision project file: " + this.getToolchainPrjFilePathStr());
            return false;
        }
        Element targetOptElem = UtilsXmlDom.getChildElement((Element)targetElem, (String)"TargetOption");
        if (targetOptElem == null) {
            LOGGER.severe("`TargetOption` element not found in MDK uVision project file: " + this.getToolchainPrjFilePathStr());
            return false;
        }
        Element targetCommonOptElem = UtilsXmlDom.getChildElement((Element)targetOptElem, (String)"TargetCommonOption");
        if (targetCommonOptElem == null) {
            LOGGER.severe("`TargetCommonOption` element not found in MDK uVision project file: " + this.getToolchainPrjFilePathStr());
            return false;
        }
        Element deviceElem = UtilsXmlDom.getChildElement((Element)targetCommonOptElem, (String)"Device");
        if (deviceElem == null) {
            LOGGER.severe("`Device` element not found in MDK uVision project file: " + this.getToolchainPrjFilePathStr());
            return false;
        }
        Element outputElem = UtilsXmlDom.getChildElement((Element)targetCommonOptElem, (String)"OutputName");
        if (outputElem != null) {
            this.detectedProjectName = UtilsFile.getFileNameWithoutExtension((String)Objects.requireNonNull(outputElem.getTextContent()).trim());
        }
        monitor.worked(20);
        String deviceText = Objects.requireNonNull(deviceElem.getTextContent()).trim();
        String coreStr = this.parseProcessorAndCore(deviceText, targetOptElem, inclPaths);
        monitor.worked(20);
        this.findCmsisSdkComponentsInUVisionProject(root, componentsInPrjFile);
        this.parseCore(coreStr);
        this.retrieveProjectSources(root, groupsElem, prjSources);
        monitor.worked(20);
        return true;
    }

    @Override
    public @Nullable String getToolchainId() {
        return UVISION_PRJ_SUBDIR;
    }

    @Override
    public @Nullable String getToolchainName() {
        return "MDK uVision";
    }
}

