/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.ArmGccPrjAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;

@NonNullByDefault
public class ArmGccLegacyPrjAdapter
extends ArmGccPrjAdapter {
    private static final String PRJ_DIR_MACRO = "${ProjDirPath}/";

    ArmGccLegacyPrjAdapter(File file, File prjDir, IToolchainProjectWithSdk existingProcessorDetector) {
        super(file, prjDir, existingProcessorDetector);
    }

    @Override
    public boolean parse(@NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull Set<@NonNull Path> prjSources, @NonNull List<@NonNull Path> inclPaths, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.prjFile), StandardCharsets.US_ASCII));){
                String line;
                boolean insideFileList = false;
                block20: while ((line = reader.readLine()) != null) {
                    String coreType;
                    int corePos;
                    line = line.trim();
                    if (insideFileList) {
                        if (line.startsWith(")") || line.endsWith(")")) {
                            insideFileList = false;
                            break;
                        }
                        String srcFilePath = UtilsFile.toEclipsePath((String)line);
                        if (srcFilePath.startsWith("\"") && srcFilePath.endsWith("\"")) {
                            srcFilePath = srcFilePath.substring(1, srcFilePath.length() - 1);
                        }
                        if (srcFilePath.startsWith(PRJ_DIR_MACRO)) {
                            srcFilePath = srcFilePath.substring(PRJ_DIR_MACRO.length());
                        }
                        prjSources.add(Paths.get(srcFilePath, new String[0]));
                        continue;
                    }
                    String lineUppercase = line.toUpperCase(Locale.ENGLISH);
                    if (lineUppercase.startsWith("ADD_EXECUTABLE(")) {
                        this.detectedProjectName = UtilsFile.getFileNameWithoutExtension((String)line.substring(15));
                        insideFileList = true;
                        continue;
                    }
                    if (lineUppercase.startsWith("ADD_LIBRARY(")) {
                        this.detectedProjectName = UtilsFile.getFileNameWithoutExtension((String)line.substring(12));
                        insideFileList = true;
                        continue;
                    }
                    if (lineUppercase.startsWith("INCLUDE_DIRECTORIES(") && line.endsWith(")")) {
                        String path = UtilsFile.toEclipsePath((String)line.substring(20, line.length() - 1));
                        if (path.startsWith(PRJ_DIR_MACRO)) {
                            path = path.substring(PRJ_DIR_MACRO.length());
                        }
                        inclPaths.add(Paths.get(path, new String[0]));
                        continue;
                    }
                    if (!lineUppercase.startsWith("SET(CMAKE_C_FLAGS_") || !line.endsWith("\")")) continue;
                    int cpuPos = line.lastIndexOf(" -DCPU_");
                    if (cpuPos > 0) {
                        String symbol = line.substring(cpuPos + 7, line.length() - 2);
                        if (symbol.endsWith("=1")) {
                            symbol = symbol.substring(0, symbol.length() - 2);
                        }
                        this.setDetectedPartNumberFromSymbol(symbol);
                    }
                    if ((corePos = line.lastIndexOf(" -mcpu=")) <= 0) continue;
                    switch (coreType = line.substring(corePos + 7, line.length() - 2)) {
                        case "cortex-m33": 
                        case "cortex-m0plus": 
                        case "cortex-m33+nodsp": {
                            continue block20;
                        }
                        case "cortex-m4": {
                            if (this.detectProcessorCore("cm4", new AtomicBoolean(false))) continue block20;
                            this.detectProcessorCore("m4", new AtomicBoolean(false));
                            continue block20;
                        }
                        case "cortex-m7": {
                            if (this.detectProcessorCore("cm7", new AtomicBoolean(false))) continue block20;
                            this.detectProcessorCore("m7", new AtomicBoolean(false));
                            continue block20;
                        }
                    }
                    LOGGER.severe(String.format("[TOOL] Unsupported ARMCC core type: %s", coreType));
                }
                monitor.worked(1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            assert (false);
            return false;
        }
        catch (IOException iOException) {}
        this.handleUndetectedCore();
        return this.detectedProcessor != null;
    }
}

