/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ToolSourceFileProvider {
    @NonNull
    final SwToolsProduct tool;
    @NonNull
    final ISourceFileProviderWrapper sourceFileProvider;

    public ToolSourceFileProvider(@NonNull SwToolsProduct tool, @NonNull ISourceFileProviderWrapper sourceFileProvider) {
        this.tool = tool;
        this.sourceFileProvider = sourceFileProvider;
    }

    public @Nullable StorageTool getStorageTool() {
        ISharedConfiguration shrdConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        return shrdConfig.getTools().getTool(this.getToolId());
    }

    public @NonNull SwToolsProduct getTool() {
        return this.tool;
    }

    public @NonNull String getToolId() {
        return this.tool.getProductId();
    }

    public @NonNull ISourceFileProviderWrapper getSourceFileProvider() {
        return this.sourceFileProvider;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Collection<@NonNull ToolSourceFileProvider> getToolSourceFileProviders() {
        ArrayList<@NonNull ToolSourceFileProvider> result = new ArrayList<ToolSourceFileProvider>();
        @NonNull List products = SwToolsProductConfiguration.getRegisteredProductsSorted();
        for (SwToolsProduct product : products) {
            @Nullable ISourceFileProviderWrapper srcFileProvider = SourceFileProviderFactory.getSourceFileProvidersWrapper((String)product.getProductId());
            if (srcFileProvider == null) continue;
            result.add(new ToolSourceFileProvider(product, srcFileProvider));
        }
        return result;
    }

    public String toString() {
        return "ToolSourceFileProvider [toolId=" + this.tool.getProductId() + "]";
    }
}

