/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.internal.refactoring.text;

import com.nxp.s32ds.ext.ide.internal.refactoring.Messages;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextEdit;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextMatch;
import java.util.Objects;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class IdeTextReplaceEdit
extends IdeTextEdit {
    protected final String replacementString;

    public IdeTextReplaceEdit(IdeTextMatch match, String replacementString) {
        super(match);
        this.replacementString = replacementString;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    @Override
    public TextEdit createTextEdit(IDocument document) {
        return new ReplaceEdit(this.match.getOffset(), this.match.getLength(), this.replacementString);
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)Messages.IdeTextReplaceEdit_replace_match_0_to_1, (Object)this.match.getSearchString(), (Object)this.replacementString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.replacementString);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IdeTextReplaceEdit)) {
            return false;
        }
        IdeTextReplaceEdit other = (IdeTextReplaceEdit)obj;
        return Objects.equals(this.replacementString, other.replacementString);
    }
}

