/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.table;

import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.table.ISettingNode;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ViewerCell;

public abstract class ASettingEditingSupport
extends EditingSupport {
    @Nullable
    private CellEditor lastCellEditor;

    public ASettingEditingSupport(@NonNull ColumnViewer viewer) {
        super(viewer);
    }

    protected CellEditor getCellEditor(Object element) {
        if (this.lastCellEditor != null) {
            this.lastCellEditor.dispose();
        }
        if (element instanceof ISettingNode) {
            final CellEditor editor = this.getCellEditor((ISettingNode)element);
            if (editor != null) {
                editor.addListener(new ICellEditorListener(){

                    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    }

                    public void cancelEditor() {
                        if (!editor.getControl().isDisposed()) {
                            editor.getControl().getDisplay().asyncExec(() -> editor.dispose());
                        }
                    }

                    public void applyEditorValue() {
                        if (!editor.getControl().isDisposed()) {
                            editor.getControl().getDisplay().asyncExec(() -> editor.dispose());
                        }
                    }
                });
                this.lastCellEditor = editor;
            }
            return editor;
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        if (element instanceof ISettingNode) {
            return this.canEdit((ISettingNode)element);
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (element instanceof ISettingNode) {
            return this.getValue((ISettingNode)element);
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof ISettingNode) {
            UiController.getInstance().runTransaction(() -> this.setValue((ISettingNode)element, value));
        }
    }

    protected void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        if (cellEditor.isDirty() || Rap.isActive()) {
            super.saveCellEditorValue(cellEditor, cell);
        }
    }

    protected abstract @Nullable CellEditor getCellEditor(@NonNull ISettingNode var1);

    protected abstract boolean canEdit(@NonNull ISettingNode var1);

    protected abstract @Nullable Object getValue(@NonNull ISettingNode var1);

    protected abstract void setValue(@NonNull ISettingNode var1, @Nullable Object var2);
}

