/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagram;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.utils.ToolTipBuilder;
import com.nxp.swtools.common.ui.utils.swt.ITooltipProvider;
import com.nxp.swtools.common.ui.utils.swt.TooltipProviderCacheDecorator;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;

@NonNullByDefault
public class DiagramSymbolToolTipProviderFactory {
    public static @Nullable ITooltipProvider create(DiagramSymbol symbol, IClocksConfig config) {
        ITooltipProvider provider = DiagramSymbolToolTipProviderFactory.createToolTipProvider(symbol, config);
        if (provider != null && Rap.isActive()) {
            return new TooltipProviderCacheDecorator(provider);
        }
        return provider;
    }

    private static @Nullable ITooltipProvider createToolTipProvider(DiagramSymbol symbol, IClocksConfig config) {
        String parentId;
        String id = symbol.getId();
        IMcu mcu = config.getMcu();
        IClockElement clockElement = mcu.getClockElement(id);
        if (clockElement != null) {
            return new ElementToolTipProvider(clockElement, config);
        }
        DiagramSymbol parent = symbol.getParent();
        String string = parentId = parent == null ? null : parent.getId();
        if (mcu.isElementNotAvailable(id)) {
            return new UnavailableElementToolTipProvider(id, parentId);
        }
        Pin pin = mcu.getAllPins().get(id);
        if (pin != null) {
            return new PinToolTipProvider(parentId, pin, config);
        }
        return null;
    }

    private DiagramSymbolToolTipProviderFactory() {
    }

    private static class ElementToolTipProvider
    implements ITooltipProvider {
        private final IClockElement element;
        private final IClocksConfig config;

        public ElementToolTipProvider(IClockElement element, IClocksConfig config) {
            this.config = config;
            this.element = element;
        }

        public String getToolTipText() {
            return ToolTipBuilder.create(this.element, this.config);
        }
    }

    private static class PinToolTipProvider
    implements ITooltipProvider {
        @Nullable
        private final String componentId;
        private final Pin pin;
        private final IClocksConfig config;

        public PinToolTipProvider(@Nullable String componentId, Pin pin, IClocksConfig config) {
            this.componentId = componentId;
            this.pin = pin;
            this.config = config;
        }

        public String getToolTipText() {
            return ToolTipBuilder.create(this.pin, this.componentId, this.config);
        }
    }

    private static class UnavailableElementToolTipProvider
    implements ITooltipProvider {
        private final String elementId;
        @Nullable
        private final String componentId;

        public UnavailableElementToolTipProvider(String elementId, @Nullable String componentId) {
            this.elementId = elementId;
            this.componentId = componentId;
        }

        public String getToolTipText() {
            return ToolTipBuilder.createForNonavailable(this.elementId, this.componentId);
        }
    }
}

