/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.ClockOutputSetting;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.Connection;
import com.nxp.swtools.clocks.ui.WidgetFactory;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.ISettingNode;
import com.nxp.swtools.clocks.ui.table.SettingNode;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.clocks.ui.table.SettingsInput;
import com.nxp.swtools.clocks.ui.table.SettingsTable;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.storage.StorageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public class ClockInputOutputWindow {
    @NonNull
    private static final String PREFERENCE_SASH_WEIGHTS = "sources_outputs_ratio";
    private static final int CONNECTION_WIDTH = 30;
    @NonNull
    private final String TITLE_CLOCK_SOURCES;
    @NonNull
    private final String TITLE_CLOCK_OUTPUTS;
    @NonNull
    SettingsTable sourcesTable;
    @NonNull
    SettingsTable outputsTable;
    @NonNull
    Connection connection;
    @NonNull
    final GuiController guiController;
    @NonNull
    @NonNull Set<@NonNull IEventListener> listeners;
    @NonNull
    private final StorageHelper storageHelper;

    public ClockInputOutputWindow(@NonNull Composite parent) {
        this.TITLE_CLOCK_SOURCES = Messages.get().ClockInputOutputWindow_ClockSources;
        this.TITLE_CLOCK_OUTPUTS = Messages.get().ClockInputOutputWindow_ClockOutputs;
        this.guiController = GuiController.getInstance();
        this.listeners = new HashSet<IEventListener>();
        this.storageHelper = new StorageHelper(3);
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        Composite sourcesComposite = ClockInputOutputWindow.createTableComposite((Composite)sashForm, false);
        Composite connectionOutputsComposite = new Composite((Composite)sashForm, 0);
        GridLayout layout = new GridLayout(2, false);
        WidgetFactory.setMarginAndSpacing(layout, 0);
        connectionOutputsComposite.setLayout((Layout)layout);
        Composite connectionComposite = ClockInputOutputWindow.createConnectionComposite(connectionOutputsComposite);
        Composite outputsComposite = ClockInputOutputWindow.createTableComposite(connectionOutputsComposite, true);
        ClockInputOutputWindow.createTitle(sourcesComposite, this.TITLE_CLOCK_SOURCES, 1);
        this.sourcesTable = new SettingsTable(sourcesComposite, "sources", false, true);
        this.sourcesTable.setLooseSelection(true);
        this.sourcesTable.setSortRootNodes(false);
        ClockInputOutputWindow.createTitle(connectionComposite, " ", 1);
        this.connection = ClockInputOutputWindow.createConnection(connectionComposite);
        ClockInputOutputWindow.createTitle(outputsComposite, this.TITLE_CLOCK_OUTPUTS, 1);
        this.outputsTable = new SettingsTable(outputsComposite, "outputs", true, false);
        this.outputsTable.setSortRootNodes(false);
        this.outputsTable.setNamesColumnSorting(1024);
        this.setInputs();
        this.connection.setTables(this.sourcesTable, this.outputsTable);
        this.registerProfileListener();
        this.registerValueChangeListeners();
        this.registerSelectionListeners();
        this.registerConnectionListeners();
        this.attachLockChangeListener();
        this.attachResizeListener();
        SWTFactoryProxy.INSTANCE.setTestId((Widget)parent, "nebulaGridInputOutput");
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.sourcesTable.getGrid(), "nebulaGridSourcesWindow");
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.outputsTable.getGrid(), "nebulaGridOutputWindow");
        sourcesComposite.addDisposeListener(e -> this.listeners.forEach(x -> this.guiController.removeModelListener((IEventListener)x)));
        int[] weights = this.storageHelper.loadIntArray(PREFERENCE_SASH_WEIGHTS, sashForm.getWeights());
        sashForm.setWeights(weights);
        Listener listener = e -> this.storageHelper.saveIntArray(PREFERENCE_SASH_WEIGHTS, sashForm.getWeights());
        sourcesComposite.addListener(11, listener);
        connectionOutputsComposite.addListener(11, listener);
    }

    private void attachResizeListener() {
        this.sourcesTable.getGrid().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ClockInputOutputWindow.this.connection.redrawAsync();
            }
        });
    }

    private void attachLockChangeListener() {
        IEventListener listener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                Object object;
                if (event.originator != ClockInputOutputWindow.this.sourcesTable.getGrid()) {
                    object = event.object;
                    if (object instanceof ISetting) {
                        ClockInputOutputWindow.this.sourcesTable.refreshSetting((ISetting)object);
                    } else {
                        ClockInputOutputWindow.this.sourcesTable.refresh();
                    }
                }
                if (event.originator != ClockInputOutputWindow.this.outputsTable.getGrid()) {
                    object = event.object;
                    if (object instanceof ISetting) {
                        ClockInputOutputWindow.this.outputsTable.refreshSetting((ISetting)object);
                    } else {
                        ClockInputOutputWindow.this.outputsTable.refresh();
                    }
                }
            }
        };
        this.guiController.addListener(16, listener);
        this.listeners.add(listener);
    }

    private void registerConnectionListeners() {
        SelectionAdapter scrollListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClockInputOutputWindow.this.connection.redraw();
            }
        };
        ScrollBar verticalBar = this.sourcesTable.getGrid().getVerticalBar();
        verticalBar.addSelectionListener((SelectionListener)scrollListener);
        verticalBar = this.outputsTable.getGrid().getVerticalBar();
        verticalBar.addSelectionListener((SelectionListener)scrollListener);
        Listener collapseListener = new Listener(){

            public void handleEvent(Event event) {
                ClockInputOutputWindow.this.connection.redraw();
            }
        };
        this.sourcesTable.getGrid().addListener(17, collapseListener);
        this.sourcesTable.getGrid().addListener(18, collapseListener);
        this.outputsTable.getGrid().addListener(17, collapseListener);
        this.outputsTable.getGrid().addListener(18, collapseListener);
        SettingsTable.ISortChangeListener sortChangeListener = () -> this.connection.redraw();
        this.sourcesTable.setSortChangeListener(sortChangeListener);
        this.outputsTable.setSortChangeListener(sortChangeListener);
    }

    private void registerSelectionListeners() {
        this.outputsTable.getGridViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISetting selectedSetting;
                ISettingNode selectedSettingNode = ClockInputOutputWindow.this.outputsTable.getSelectedSetting();
                if (selectedSettingNode != null && (selectedSetting = selectedSettingNode.getSetting()) != null) {
                    ClockInputOutputWindow.this.outputsTable.clearHighlight();
                    ClockInputOutputWindow.this.outputsTable.addHighlight(selectedSetting.getId());
                    if (selectedSetting instanceof ClockOutputSetting) {
                        ClockOutputSetting clockOutput = (ClockOutputSetting)selectedSetting;
                        String clockOutputId = clockOutput.getClockOutput().getID();
                        ClockInputOutputWindow.this.guiController.setSelectedElement(clockOutputId, ClockInputOutputWindow.this.outputsTable.getGrid());
                    }
                    if (!ClockInputOutputWindow.this.outputsTable.getGridViewer().isCellEditorActive()) {
                        ClockInputOutputWindow.this.outputsTable.refresh();
                    }
                }
            }
        });
        this.sourcesTable.getGridViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IClockElement selectedElement;
                ISettingNode selectedSettingNode = ClockInputOutputWindow.this.sourcesTable.getSelectedSetting();
                if (selectedSettingNode != null && (selectedElement = selectedSettingNode.getClockElement()) != null) {
                    ClockInputOutputWindow.this.guiController.setSelectedElement(selectedElement.getID(), ClockInputOutputWindow.this.sourcesTable.getGrid());
                }
            }
        });
        this.registerPathSelectionChangeListener();
    }

    private void registerPathSelectionChangeListener() {
        IEventListener listener = new IEventListener(){

            public void handle(ToolEvent event) {
                if (event.originator != ClockInputOutputWindow.this.sourcesTable.getGrid()) {
                    ClockInputOutputWindow.this.sourcesTable.clearHighlight();
                    IClockElement activeSource = ClockInputOutputWindow.this.guiController.getSourceForActiveOutput();
                    if (activeSource != null) {
                        ClockInputOutputWindow.this.sourcesTable.addHighlight(activeSource.getOutputFrequencySetting().getId());
                    }
                    ClockInputOutputWindow.this.setSourcesInput(ClockInputOutputWindow.this.guiController.getProfile().getMcu().getSettings());
                }
                if (event.originator != ClockInputOutputWindow.this.outputsTable.getGrid()) {
                    IMcu mcu;
                    IClockElement selectedOutput;
                    ClockInputOutputWindow.this.outputsTable.clearHighlight();
                    ClockInputOutputWindow.this.outputsTable.getGrid().deselectAll();
                    String selectedOutputId = ClockInputOutputWindow.this.guiController.getActiveOutput();
                    if (selectedOutputId != null && (selectedOutput = (mcu = ClockInputOutputWindow.this.guiController.getProfile().getMcu()).getClockElement(selectedOutputId)) != null) {
                        ISetting outFreqSetting = selectedOutput.getOutputFrequencySetting();
                        ClockInputOutputWindow.this.outputsTable.addHighlight(outFreqSetting.getId());
                        ClockInputOutputWindow.this.outputsTable.selectSetting(outFreqSetting);
                    }
                    ClockInputOutputWindow.this.setOutputsInput(ClockInputOutputWindow.this.guiController.getProfile().getMcu().getSettings());
                    if (event.isType(4)) {
                        ClockInputOutputWindow.this.outputsTable.showSelection();
                    }
                }
                ClockInputOutputWindow.this.connection.redraw();
            }
        };
        this.guiController.addListener(38, listener);
        this.listeners.add(listener);
    }

    private void registerValueChangeListeners() {
        ClockInputOutputWindow.addValueChangeListener(this.outputsTable);
        ClockInputOutputWindow.addValueChangeListener(this.sourcesTable);
    }

    private void registerProfileListener() {
        IEventListener listener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                ClockInputOutputWindow.this.setInputs();
                ClockInputOutputWindow.this.connection.redrawAsync();
            }
        };
        this.guiController.addListener(64, listener);
        this.listeners.add(listener);
    }

    private static void addValueChangeListener(@NonNull SettingsTable table) {
        table.setValueChangeListener(new SettingValueChangeListener(table.getGrid()));
    }

    void setInputs() {
        SettingsDB settingsDB = this.guiController.getProfile().getMcu().getSettings();
        this.setSourcesInput(settingsDB);
        this.setOutputsInput(settingsDB);
    }

    private void setSourcesInput(@NonNull SettingsDB settingsDB) {
        Collection<@NonNull ClockSourceSetting> clockSources = settingsDB.getClockSources();
        ArrayList<@NonNull ISettingNode> rootNodes = new ArrayList<ISettingNode>();
        String internalSourceGroup = UtilsText.safeString((String)Messages.get().ClockInputOutputWindow_InternalClockSources);
        String externallSourceGroup = UtilsText.safeString((String)Messages.get().ClockInputOutputWindow_ExternalClockSources);
        SettingNode.Builder internalBuilder = new SettingNode.Builder(internalSourceGroup);
        SettingNode.Builder externalBuilder = new SettingNode.Builder(externallSourceGroup);
        IClocksConfig activeConfig = this.guiController.getProfile().getActiveConfig();
        if (activeConfig != null) {
            for (ClockSourceSetting source : clockSources) {
                SettingNode.Builder sourceBuilder = new SettingNode.Builder(source);
                for (ISetting setting : source.getElement().getSettings()) {
                    if (setting == source || !setting.isVisible(activeConfig)) continue;
                    sourceBuilder.addChild(new SettingNode(setting, null));
                }
                if (source.isInternal()) {
                    internalBuilder.addChild(sourceBuilder.build());
                    continue;
                }
                externalBuilder.addChild(sourceBuilder.build());
            }
        }
        rootNodes.add(internalBuilder.build());
        rootNodes.add(externalBuilder.build());
        this.sourcesTable.setInput(new SettingsInput(rootNodes));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void setOutputsInput(@NonNull SettingsDB settingsDB) {
        Collection<@NonNull ClockOutputSetting> clockOutputs = settingsDB.getClockOutputs();
        ArrayList<@NonNull ISettingNode> rootNodes = new ArrayList<ISettingNode>();
        IClocksConfig activeConfig = this.guiController.getProfile().getActiveConfig();
        if (activeConfig != null) {
            Map<String, List<@NonNull ClockOutputSetting>> groupedOutputs = clockOutputs.stream().collect(Collectors.groupingBy(ClockOutputSetting::getGroup));
            groupedOutputs.forEach((k, v) -> {
                if (k != null) {
                    @NonNull SettingNode.Builder builder = new SettingNode.Builder(UtilsText.toSentenceCase((String)k));
                    v.forEach(x -> {
                        SettingNode.Builder builder2 = builder.addChild(new SettingNode.Builder((ISetting)x).build());
                    });
                    SettingNode build = builder.build();
                    if (k.equalsIgnoreCase("system")) {
                        rootNodes.add(0, build);
                    } else {
                        rootNodes.add(build);
                    }
                }
            });
        }
        this.outputsTable.setInput(new SettingsInput(rootNodes));
    }

    private static @NonNull Connection createConnection(@NonNull Composite composite) {
        Connection connection = new Connection(composite, 0x20040000);
        connection.setLayoutData(new GridData(1808));
        return connection;
    }

    private static @NonNull Composite createConnectionComposite(@NonNull Composite parent) {
        Composite sourcesComposite = new Composite(parent, 0);
        GridData layoutData = new GridData();
        layoutData.widthHint = 30;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.verticalAlignment = 4;
        sourcesComposite.setLayoutData((Object)layoutData);
        sourcesComposite.setLayout((Layout)ClockInputOutputWindow.createSubLayout());
        return sourcesComposite;
    }

    private static @NonNull Composite createTableComposite(@NonNull Composite parent, boolean setLayoutData) {
        Composite sourcesComposite = new Composite(parent, 0);
        if (setLayoutData) {
            sourcesComposite.setLayoutData((Object)new GridData(1808));
        }
        sourcesComposite.setLayout((Layout)ClockInputOutputWindow.createSubLayout());
        return sourcesComposite;
    }

    private static @NonNull Label createTitle(@NonNull Composite composite, @NonNull String text, int hSpan) {
        Label title = WidgetFactory.createTitle(composite, text);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)title, "nebulaGridLabel_" + text);
        title.setLayoutData((Object)new GridData(4, 4, true, false, hSpan, 1));
        return title;
    }

    private static @NonNull GridLayout createSubLayout() {
        GridLayout layout = new GridLayout(1, false);
        WidgetFactory.setMarginAndSpacing(layout, 0);
        return layout;
    }
}

