/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.valueMaps.EntryValueMap;
import com.nxp.swtools.clocks.data.valueMaps.IValueMap;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ICalculus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public abstract class AValueMapInternal
implements IValueMap {
    @NonNull
    protected Expression expression;
    @NonNull
    protected @NonNull BitFieldElement @NonNull [] bitFields;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(EntryValueMap.class);
    protected int fractionalBits;

    public AValueMapInternal(@NonNull Expression expression, @NonNull BitFieldElement @NonNull [] bitFields, int fractionalBits) {
        this.expression = expression;
        this.bitFields = bitFields;
        this.fractionalBits = fractionalBits;
    }

    @Override
    public @NonNull Expression getExpression() {
        return this.expression;
    }

    @Override
    public @NonNull BitFieldElement @NonNull [] getBitFields() {
        return this.bitFields;
    }

    @Override
    public int getFractionalBits() {
        return this.fractionalBits;
    }

    static boolean sortRationalList(@NonNull List<@NonNull String> input) {
        try {
            Collections.sort(input, (o1, o2) -> new BigRational(o1).compareTo(new BigRational(o2)));
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    static boolean sortIntegerList(@NonNull List<@NonNull String> input) {
        try {
            Collections.sort(input, (o1, o2) -> Integer.compare(Integer.parseInt(o1), Integer.parseInt(o2)));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static boolean sortDecimalList(@NonNull List<@NonNull String> input) {
        try {
            Collections.sort(input, (o1, o2) -> new BigDecimal((String)o1).compareTo(new BigDecimal((String)o2)));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static void sortStringList(@NonNull List<@NonNull String> input) {
        Collections.sort(input);
    }

    protected @NonNull String createFractionalUiValue(@NonNull String uiValue) {
        BigDecimal defaultDecimal = new BigDecimal(uiValue);
        BigDecimal fractionDecimal = new BigDecimal(BigInteger.ONE.shiftLeft(this.fractionalBits));
        return UtilsText.safeString((String)defaultDecimal.divide(fractionDecimal).toPlainString());
    }

    @Override
    public List<@NonNull String> getSortedUiValues() {
        ArrayList<@NonNull String> uiValuesList = new ArrayList<String>(this.getUiValues());
        if (!(AValueMapInternal.sortRationalList(uiValuesList) || AValueMapInternal.sortIntegerList(uiValuesList) || AValueMapInternal.sortDecimalList(uiValuesList))) {
            AValueMapInternal.sortStringList(uiValuesList);
        }
        return uiValuesList;
    }

    @Override
    public @Nullable ICalculus getCalculus() {
        return null;
    }
}

