/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.PowerModeSpecificElement;
import com.nxp.swtools.clocks.data.elements.Splitter;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.ClockSelectSetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.OutputFrequencySetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClockSelect
extends AClockElement {
    @NonNull
    @NonNull ArrayList<@NonNull String> branches = new ArrayList();

    public ClockSelect(@NonNull ClockElementData elementData, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values) {
        super(elementData.getRegisters(), elementData.getId(), elementData.getName(), elementData.getDescription(), elementData.getConstraints(), elementData.getConfigElements(), elementData.isPrioritized());
        super.setPowerModeSpecific(elementData.isPowerModeSpecific);
        this.addNestedSetting(new EnableSetting(this.id, (IElement)this, elementData.getEnableDisableConditions()));
        this.modelDevice = new ClockSelectModel(this.id, ENodeType.Multiplexer);
        ClockSelectSetting clockSelectSetting = new ClockSelectSetting(this);
        this.settings.put(clockSelectSetting.getId(), clockSelectSetting);
        this.values = values;
    }

    @Override
    protected @NonNull ISetting createOutputFrequencySetting() {
        return new OutputFrequencySetting(this, false, false);
    }

    @Override
    public String getType() {
        return ElementType.CLOCK_SELECT.toString();
    }

    public @NonNull ArrayList<@NonNull String> getBranches() {
        return this.branches;
    }

    public boolean replaceBranch(@NonNull String old, @NonNull String replacement) {
        return Collections.replaceAll(this.branches, old, replacement);
    }

    public void setBranches(@NonNull ArrayList<@NonNull String> branches) {
        this.branches = branches;
    }

    public @NonNull Collection<@NonNull Object> getInputs() {
        HashSet<@NonNull Object> inputs = new HashSet<Object>();
        this.values.values().forEach(x -> {
            boolean bl = inputs.addAll(x.getControlValues());
        });
        return inputs;
    }

    public @NonNull Collection<@NonNull String> getOptions(@NonNull IClocksConfig clocksConfig) {
        ValueMap activeValueMap = this.getActiveValueMap(clocksConfig);
        assert (activeValueMap != null);
        return activeValueMap.getSortedUiValues();
    }

    public @Nullable String getDefaultUiInputSignal(@Nullable IClocksConfig clocksConfig) {
        ValueMap activeValueMap = this.getActiveValueMap(clocksConfig);
        assert (activeValueMap != null);
        return activeValueMap.getDefaultUiValue();
    }

    public @Nullable String getActivatedSignal(@NonNull String value, @Nullable IClocksConfig clocksConfig) {
        ValueMap activeValueMap = this.getActiveValueMap(clocksConfig);
        assert (activeValueMap != null);
        Object activatedSignal = activeValueMap.getControlValueByUiValue(value);
        if (activatedSignal != null) {
            return activatedSignal.toString();
        }
        return null;
    }

    @Override
    public String getInputSignal() {
        if (this.inputSignal != null) {
            return this.inputSignal;
        }
        String defaultInputSignal = this.getDefaultUiInputSignal(null);
        if (defaultInputSignal != null) {
            return this.getActivatedSignal(defaultInputSignal, null);
        }
        return null;
    }

    @Override
    protected @NonNull PowerModeSpecificElement createPowerModeSpecific() {
        return new PowerModeSpecificElement(() -> new ClockSelectSetting(this), () -> this.configElements);
    }

    @Override
    protected void saveToModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            SettingsConfig settingsConfig = config.getSettingsConfig();
            ISetting muxSetting = this.getFrequencyModifierSetting();
            assert (muxSetting != null);
            IMcu mcu = config.getMcu();
            String selectedElementID = this.getActivePredecessor(config);
            if (selectedElementID != null) {
                IClockElement activePredElement = mcu.getClockElement(selectedElementID);
                Node predNode = null;
                if (activePredElement != null) {
                    Splitter outSplitter = activePredElement.getSplitter();
                    Node node = predNode = outSplitter == null ? activePredElement.getComputationNode(config) : outSplitter.getComputationNode();
                    assert (predNode != null);
                    if (this.branches.contains(predNode.getID()) && (!lockedOnly || settingsConfig.isLocked(muxSetting))) {
                        predNode = config.getClocksModel().getNode(predNode.getID());
                        compNode.setSelected(predNode);
                    } else {
                        compNode.setSelected(null);
                    }
                } else if (this.branches.isEmpty()) {
                    compNode.setSelected(null);
                } else {
                    compNode.setSelected(config.getClocksModel().getNode(this.branches.get(0)));
                }
            } else {
                compNode.setSelected(null);
            }
        }
    }

    public @Nullable String getActivePredecessor(@NonNull IClocksConfig config) {
        SettingValue muxSettingValue;
        SettingsConfig settingsConfig = config.getSettingsConfig();
        ISetting muxSetting = this.getFrequencyModifierSetting();
        if (muxSetting != null && (muxSettingValue = settingsConfig.getSettingValue(muxSetting)) != SettingValue.N_A) {
            return muxSettingValue.getValue().toString();
        }
        return null;
    }

    @Override
    protected void loadFromModel(@NonNull IClocksConfig config) {
    }

    private class ClockSelectModel
    extends AClockModelCreationElement {
        public ClockSelectModel(@NonNull String id, ENodeType type) {
            super(id, type);
        }

        @Override
        public String getDefaultBranch() {
            if (!ClockSelect.this.branches.isEmpty()) {
                ArrayList<@NonNull String> branchesLoc = ClockSelect.this.branches;
                String defaultInputSignal = ClockSelect.this.getDefaultUiInputSignal(null);
                assert (defaultInputSignal != null);
                String selectedElementID = ClockSelect.this.getActivatedSignal(defaultInputSignal, null);
                if (branchesLoc.contains(selectedElementID)) {
                    return selectedElementID;
                }
                String splitterID = String.valueOf(selectedElementID) + "_SPLIT";
                if (branchesLoc.contains(splitterID)) {
                    return splitterID;
                }
                return branchesLoc.get(0);
            }
            return null;
        }

        @Override
        public List<String> getPredList() {
            return ClockSelect.this.getBranches();
        }
    }
}

