/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.dependencies;

import com.nxp.swtools.clocks.data.dependencies.PriorityComparator;
import com.nxp.swtools.clocks.data.dependencies.SettingDependencyGraph;
import com.nxp.swtools.clocks.data.dependencies.SettingResolverResult;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.ClocksProfile;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.settings.ClockSelectSetting;
import com.nxp.swtools.clocks.data.settings.DFSPrescalerSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.PrescalerSetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.graphs.IDirectedGraph;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.stream.StreamsUtils;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksIdValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class OrderedSettingValuesResolver {
    private static final boolean BUILD_RESOLUTION_GRAPH = false;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(OrderedSettingValuesResolver.class);
    @NonNull
    private final IClocksConfig config;
    @NonNull
    private DependencyGraphCrawler crawler;
    @NonNull
    private @NonNull Map<@NonNull ISetting, @NonNull Set<@NonNull ISetting>> conflicts = new HashMap<ISetting, Set<ISetting>>();
    @NonNull
    private @NonNull Map<@NonNull ISetting, @NonNull ISetting> writers = new HashMap<ISetting, ISetting>();
    @NonNull
    private @NonNull Set<@NonNull ISetting> invisibles = new HashSet<ISetting>();
    @NonNull
    private @NonNull Map<@NonNull ISetting, @NonNull Set<@NonNull ISetting>> nonEditables = new HashMap<ISetting, Set<ISetting>>();
    @NonNull
    private SettingDependencyGraph resolutionGraph;
    private boolean modifiersModify;
    @NonNull
    private @NonNull Map<ISetting, @NonNull StorageClocksIdValue> storageVals = new HashMap<ISetting, StorageClocksIdValue>();
    @Nullable
    private ISetting prioritySetting;

    public OrderedSettingValuesResolver(@NonNull IClocksConfig config) {
        this.config = config;
        this.resolutionGraph = new SettingDependencyGraph(config.getMcu().getSettings());
        IDirectedGraph dependencyGraph = config.getMcu().getSettingDependencies();
        this.crawler = new DependencyGraphCrawler(dependencyGraph, config);
    }

    public @NonNull SettingResolverResult resolve(@Nullable ISetting prioritizedSetting, boolean modifiersModificationAllowed) {
        return this.resolve(prioritizedSetting, modifiersModificationAllowed, null);
    }

    public @NonNull SettingResolverResult resolve(@Nullable ISetting prioritizedSetting, boolean modifiersModificationAllowed, @Nullable Map<ISetting, @NonNull StorageClocksIdValue> storageValues) {
        boolean wasSomeResolved;
        long startTime = System.currentTimeMillis();
        this.init(prioritizedSetting, modifiersModificationAllowed, storageValues);
        if (storageValues != null) {
            storageValues.forEach((x, y) -> ClocksProfile.restoreUserEnabled(this.config, y));
        }
        do {
            String id;
            wasSomeResolved = false;
            while ((id = this.crawler.nextEasyNode()) != null) {
                if (this.resolve(id, false, false)) {
                    wasSomeResolved = true;
                    continue;
                }
                this.crawler.removeFromEasy(id);
            }
            ArrayList<@NonNull String> potentialWritersCopy = new ArrayList<String>(this.crawler.getPotentialWriters());
            if (wasSomeResolved |= this.resolve(potentialWritersCopy, false, true, false)) continue;
            ArrayList<@NonNull String> unresolvedIds = new ArrayList<String>(this.crawler.getUnresolvedNodes());
            Collections.sort(unresolvedIds, new PriorityComparator(this.config, prioritizedSetting, this.crawler.getUnprioritizeds()).reversed());
            wasSomeResolved = this.resolve(unresolvedIds, true, true, false);
            if (wasSomeResolved) continue;
            LOGGER.severe(() -> "Any of the settings can not be resolved: " + unresolvedIds);
            wasSomeResolved = this.resolve(unresolvedIds, true, false, true);
        } while (wasSomeResolved && !this.crawler.getUnresolvedNodes().isEmpty());
        if (!this.crawler.getUnresolvedNodes().isEmpty()) {
            LOGGER.severe("Not possible to restore settings: " + this.crawler.getUnresolvedNodes());
        }
        SettingResolverResult result = new SettingResolverResult(this.conflicts, this.invisibles, this.nonEditables);
        Level level = SWToolsProperties.isVerificationOn() ? Level.INFO : Level.FINE;
        LOGGER.log(level, () -> "Setting dependencies resolution took: " + (System.currentTimeMillis() - startTime) + " ms");
        return result;
    }

    private boolean resolve(@NonNull Collection<@NonNull String> ids, boolean firstOnly, boolean checkPriority, boolean setUnknown) {
        boolean wasSomeResolved = false;
        for (String unresolvedId : ids) {
            if (!firstOnly || !(wasSomeResolved |= this.resolve(unresolvedId, setUnknown, checkPriority))) continue;
            return true;
        }
        return wasSomeResolved;
    }

    private boolean resolve(@NonNull String id, boolean setUnknown, boolean checkPriority) {
        ISetting setting = this.config.getMcu().getSettings().findSettingWithId(id);
        if (setting == null) {
            LOGGER.severe(() -> "Setting not found: " + id);
            this.crawler.setResolved(id);
            return true;
        }
        return this.resolveSettingAndBitFields(setting, setUnknown, checkPriority);
    }

    private boolean hasHighestPriority(@NonNull String settingId, @NonNull Collection<@NonNull ISetting> succeedingBfs) {
        PriorityComparator priorityComparator = new PriorityComparator(this.config, this.prioritySetting, this.crawler.getUnprioritizeds());
        for (ISetting succeedingBitFieldSetting : succeedingBfs) {
            String highestPriorityPred = this.predcessorHighestPriority(succeedingBitFieldSetting, this.prioritySetting);
            if (highestPriorityPred == null || priorityComparator.compare(settingId, highestPriorityPred) >= 0) continue;
            return false;
        }
        return true;
    }

    boolean hasBfSuccessor(@NonNull String id) {
        return StreamsUtils.safeStream((Collection)this.config.getMcu().getSettingDependencies().getSuccessors(id)).anyMatch(x -> {
            ISetting setting = SettingProvider.getSettingById(x, this.config.getMcu());
            return setting != null && setting.getType() == SettingType.BIT_FIELD;
        });
    }

    private @Nullable String predcessorHighestPriority(@NonNull ISetting settingId, @Nullable ISetting prioritizedSetting) {
        Optional<@NonNull String> findFirst = this.config.getMcu().getSettingDependencies().getPredecessors(settingId.getId()).stream().filter(x -> !this.crawler.isResolved((String)x)).sorted(new PriorityComparator(this.config, prioritizedSetting, this.crawler.getUnprioritizeds()).reversed()).findFirst();
        return findFirst.orElse(null);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    Collection<@NonNull ISetting> succeedingBfs(@NonNull String id) {
        Collection result;
        @NonNull Collection nonNullResult = result = (Collection)StreamsUtils.safeStream((Collection)this.config.getMcu().getSettingDependencies().getSuccessors(id)).map(x -> SettingProvider.getSettingById(x, this.config.getMcu())).filter(x -> x != null && x.getType() == SettingType.BIT_FIELD).collect(Collectors.toList());
        ISetting setting = SettingProvider.getSettingById(id, this.config.getMcu());
        if (setting != null && setting.getType() == SettingType.BIT_FIELD) {
            nonNullResult.add(setting);
        }
        return nonNullResult;
    }

    private void init(@Nullable ISetting prioritizedSetting, boolean modifiersModificationAllowed, @Nullable Map<ISetting, @NonNull StorageClocksIdValue> storageValues) {
        this.modifiersModify = modifiersModificationAllowed;
        this.storageVals = storageValues == null ? new HashMap() : storageValues;
        this.prioritySetting = prioritizedSetting;
        this.crawler.init(prioritizedSetting);
        this.writers.clear();
        this.conflicts.clear();
        this.invisibles.clear();
        this.nonEditables.clear();
        this.resolutionGraph.clear();
    }

    private boolean canRead(ISetting setting) {
        Collection<@NonNull String> resolvedNodes = this.crawler.getResolvedNodes();
        if (resolvedNodes.containsAll(this.config.getMcu().getSettingDependencies().getPredecessors(setting.getId()))) {
            return true;
        }
        return setting.canRead(this.config, resolvedNodes);
    }

    private boolean canWrite(ISetting setting) {
        Collection<@NonNull String> resolvedNodes = this.crawler.getResolvedNodes();
        if (resolvedNodes.containsAll(this.config.getMcu().getSettingDependencies().getPredecessors(setting.getId()))) {
            return true;
        }
        return setting.canWrite(this.config, resolvedNodes);
    }

    private void addDependenciesToGraph(@NonNull ISetting setting, @NonNull Collection<@NonNull ISetting> dependencies) {
        if (dependencies.isEmpty()) {
            this.resolutionGraph.addRoot(setting.getId());
        } else {
            dependencies.forEach(x -> {
                boolean bl = this.resolutionGraph.addEdge(x.getId(), setting.getId());
            });
        }
    }

    private boolean resolveSettingAndBitFields(@NonNull ISetting setting, boolean setUnknownBitFields, boolean checkPriority) {
        boolean writable = setting.isWritable();
        if (this.canRead(setting)) {
            return this.readSetting(setting, writable);
        }
        try {
            if (writable && this.canWrite(setting)) {
                return this.writeSetting(setting, setUnknownBitFields, checkPriority);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        return false;
    }

    private void checkLockConflicts(@NonNull ISetting setting, @NonNull SettingValue value) {
        SettingValue lockedValue;
        LockState lockState;
        if (setting.isUserLockable() && (lockState = this.config.getSettingsConfig().getLockState(setting)) != null && !(lockedValue = lockState.getValue()).equals(value)) {
            this.getBitFieldsToWriteSafe(setting, value, true).keySet().forEach(x -> this.addConflict(setting, Objects.requireNonNull(this.writers.get(x))));
        }
    }

    private @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWriteSafe(@NonNull ISetting setting, @NonNull SettingValue value, boolean writable) {
        if (writable) {
            try {
                return setting.getBitFieldsToWrite(this.config, value);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return Collections.emptyMap();
    }

    private boolean readSetting(@NonNull ISetting setting, boolean writable) {
        SettingValue value = this.createSettingValue(setting, this.storageVals, () -> setting.createCurrentValue(this.config));
        if (value == null) {
            LOGGER.severe(() -> String.format("No setting value can be created for setting:%s", setting.getId()));
            return false;
        }
        boolean lock = false;
        if (writable) {
            SettingValue currentValue;
            this.checkLockConflicts(setting, value);
            if (!this.modifiersModify && !(currentValue = this.config.getSettingsConfig().getSettingValue(setting)).equals(value)) {
                LOGGER.info(() -> "Necessary to update value of a setting even if a modification is not allowed. Probably value of a setting: " + setting + " is dependent on another setting. Detected dependencies: " + this.config.getMcu().getSettingDependencies().getPredecessors(setting.getId()));
            }
            lock = !value.isN_A() && this.config.isLocked(setting) && !setting.isUserLockable();
        }
        this.config.setSettingValue(setting, value, false, lock);
        this.crawler.setResolved(setting.getId());
        if (setting.getType() == SettingType.BIT_FIELD) {
            this.writers.put(setting, setting);
        }
        return true;
    }

    private boolean writeSetting(@NonNull ISetting setting, boolean setUnknownBitFields, boolean checkPriority) {
        SettingValue settingValue = this.createSettingValue(setting, this.storageVals, () -> SettingProvider.getValueBySettingId(setting.getId(), this.config.getMcu(), this.config.getSettingsConfig()));
        if (settingValue != null && !settingValue.isN_A()) {
            Map<@NonNull ISetting, @NonNull SettingValue> bitFieldsToWrite = setting.getBitFieldsToWrite(this.config, settingValue);
            if (checkPriority && !this.hasHighestPriority(setting.getId(), bitFieldsToWrite.keySet())) {
                return false;
            }
            if (this.isSomeResolved(bitFieldsToWrite.keySet())) {
                if (setUnknownBitFields) {
                    LOGGER.severe("NOT IMPLEMENTED YET, SOME OF THE BIT-FIELDS ARE RESOLVED AND SOME OF THEM ARE NOT");
                    LOGGER.severe(() -> String.format("Setting: %s, resolved bit-fields: %s, unresolved bit-fields: %s", setting, bitFieldsToWrite.keySet().stream().filter(x -> this.crawler.isResolved(x.getId())).collect(CollectorsUtils.toList()), bitFieldsToWrite.keySet().stream().filter(x -> !this.crawler.isResolved(x.getId())).collect(CollectorsUtils.toList())));
                } else {
                    this.crawler.addUnprioritizedSetting(setting.getId());
                    return false;
                }
            }
            bitFieldsToWrite.forEach((x, y) -> {
                this.config.setSettingValue((ISetting)x, (SettingValue)y, false, false);
                this.crawler.setResolved(x.getId());
                this.writers.put((ISetting)x, setting);
                this.invisibles.add((ISetting)x);
            });
            this.crawler.setResolved(setting.getId());
            return true;
        }
        this.crawler.addUnprioritizedSetting(setting.getId());
        return false;
    }

    private boolean isSomeResolved(@NonNull Collection<@NonNull ISetting> settings) {
        for (ISetting setting : settings) {
            if (!this.crawler.isResolved(setting.getId())) continue;
            return true;
        }
        return false;
    }

    private @Nullable SettingValue createSettingValue(ISetting setting, Map<ISetting, @NonNull StorageClocksIdValue> storageValues, Supplier<@Nullable SettingValue> valueCreator) {
        SettingValue value = null;
        if (this.config.isImporting() && setting.getElement() instanceof IConfigElement && ((IConfigElement)setting.getElement()).isSharingRegisters(this.config)) {
            IConfigElement elem = (IConfigElement)setting.getElement();
            Collection<@NonNull IConfigElementItem> items = elem.getItems();
            if (items != null && !this.setSettingItems(items, elem.getSharedList(), 0)) {
                String message = String.format("No setting value can be created for setting: %s and settings with shared registers. Incompatible or corrupt import.", setting.getId());
                LOGGER.severe(message);
                this.config.addError(setting.getId(), message, ClocksProblem.Type.LOCAL);
            }
            value = this.config.getSettingsConfig().getSettingValue(setting);
        } else if (storageValues.containsKey(setting)) {
            StorageClocksIdValue storageClocksIdValue = Objects.requireNonNull(storageValues.get(setting));
            value = ClocksProfile.restoreSetting(this.config, storageClocksIdValue);
        } else {
            value = valueCreator.get();
        }
        if (setting instanceof ClockSelectSetting) {
            value = this.createSettingValueForSelector(setting, value, valueCreator);
        } else if (setting instanceof PrescalerSetting || setting instanceof DFSPrescalerSetting) {
            value = this.createSettingValueForPrescaler(setting, value);
        }
        return value;
    }

    private @Nullable SettingValue createSettingValueForSelector(@NonNull ISetting setting, @Nullable SettingValue value, Supplier<@Nullable SettingValue> valueCreator) {
        Collection<Object> controlValues;
        ValueMap activeValueMap;
        SettingValue result = value;
        ClockSelect selector = (ClockSelect)setting.getElement();
        Map<@NonNull Object, @NonNull Object> bitFieldsToWrite = new HashMap();
        if (result != null) {
            bitFieldsToWrite = this.getBitFieldsToWriteSafe(setting, result, setting.isWritable());
        }
        if (!(!bitFieldsToWrite.isEmpty() || setting.getUsedBitFields().isEmpty() || result != null && result != SettingValue.N_A || (result = valueCreator.get()) != null && result != SettingValue.N_A || (activeValueMap = selector.getActiveValueMap(this.config)) == null || !(controlValues = activeValueMap.getControlValues()).iterator().hasNext() || (result = setting.parseValue(controlValues.iterator().next(), this.config)) == null)) {
            this.config.getSettingsConfig().setSettingValue(setting, result);
        }
        return result;
    }

    private @Nullable SettingValue createSettingValueForPrescaler(@NonNull ISetting setting, @Nullable SettingValue value) {
        SettingValue lockParsedValue;
        SettingValue result = value;
        LockState lockState = this.config.getSettingsConfig().getLockState(setting);
        if (lockState != null && (lockParsedValue = setting.parseUiValue(lockState.getUiValue(), this.config)) != null && !lockState.getValue().equals(lockParsedValue)) {
            LockState newLockState = new LockState(lockState, lockParsedValue);
            this.config.getSettingsConfig().setLockState(setting, newLockState);
            if (lockState.getValue().equals(value)) {
                result = lockParsedValue;
            }
        }
        return result;
    }

    private void addConflict(@NonNull ISetting cause, @NonNull ISetting erroneous) {
        if (this.conflicts.containsKey(cause)) {
            Objects.requireNonNull(this.conflicts.get(cause)).add(erroneous);
        } else {
            HashSet<@NonNull ISetting> erroneousCollection = new HashSet<ISetting>();
            erroneousCollection.add(erroneous);
            this.conflicts.put(cause, erroneousCollection);
        }
    }

    private boolean setSettingItems(@NonNull Collection<@NonNull IConfigElementItem> items, @NonNull List<@NonNull ISetting> settingList, int index) {
        Collection<IConfigElementItem> itemsList;
        IElement elem;
        for (IConfigElementItem item : items) {
            if (!this.isMatchItem(item)) continue;
            return true;
        }
        if (index < settingList.size() && (elem = settingList.get(index).getElement()) instanceof IConfigElement && (itemsList = ((IConfigElement)elem).getItems()) != null) {
            for (IConfigElementItem item : itemsList) {
                this.config.setSettingValue(settingList.get(index), new SettingValue(item.getID(), item.getName()), false, false);
                if (!this.setSettingItems(items, settingList, index + 1)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMatchItem(@NonNull IConfigElementItem item) {
        Map<@NonNull String, @NonNull Long> bitFieldsToAssign = item.getBitFieldsToAssignForConfig(this.config);
        for (Map.Entry<String, Long> assignEntry : bitFieldsToAssign.entrySet()) {
            BitFieldElement bitField = ClocksBitFieldProvider.getBitFieldById(assignEntry.getKey(), this.config.getMcu().getBitFieldsCache());
            Long value = assignEntry.getValue();
            if (bitField == null || value == null) continue;
            IRegBitFieldValueAPI bfValue = ClocksBitFieldProvider.getBitFieldValueOrResetValueNullable(bitField, this.config);
            long assignValue = value;
            if (bfValue != null && bfValue.getValue() == assignValue) continue;
            return false;
        }
        return true;
    }

    private static class DependencyGraphCrawler {
        @NonNull
        private final IClocksConfig config;
        @Nullable
        private ISetting prioritizedSetting;
        @NonNull
        private final @NonNull Collection<@NonNull String> unprioritizedSettings = new HashSet<String>();
        @NonNull
        private IDirectedGraph graph;
        @NonNull
        private @NonNull Set<@NonNull String> resolvedNodes = new HashSet<String>();
        @NonNull
        private @NonNull Set<@NonNull String> unresolvedNodes = new HashSet<String>();
        @NonNull
        private @NonNull Set<@NonNull String> easyNodes = new HashSet<String>();
        @NonNull
        private @NonNull Set<@NonNull String> potentionalWriters = new HashSet<String>();

        DependencyGraphCrawler(@NonNull IDirectedGraph graph, @NonNull IClocksConfig config) {
            this.graph = graph;
            this.config = config;
        }

        boolean isResolved(@NonNull String node) {
            return this.resolvedNodes.contains(node);
        }

        void init(@Nullable ISetting prioritized) {
            this.prioritizedSetting = prioritized;
            this.resolvedNodes.clear();
            this.unresolvedNodes = this.findUnresolvedNodes();
            this.easyNodes.clear();
            this.graph.getRoots().stream().filter(this::isEasy).forEach(easyNode -> {
                boolean bl = this.easyNodes.add((String)easyNode);
            });
            this.unprioritizedSettings.clear();
            this.potentionalWriters.clear();
            this.addPotentialWriters();
        }

        private void addPotentialWriters() {
            for (String node : this.unresolvedNodes) {
                this.addPotentialWritersOf(node);
            }
        }

        private void addPotentialWritersOf(@NonNull String node) {
            ISetting setting = SettingProvider.getSettingById(node, this.config.getMcu());
            if (setting != null && setting.getType() == SettingType.BIT_FIELD) {
                Collection<@NonNull String> predecessorsHighestPriority = this.predcessorsHighestPriority(node);
                PriorityComparator priorityComparator = new PriorityComparator(this.config, this.prioritizedSetting, this.unprioritizedSettings);
                if (predecessorsHighestPriority.isEmpty() || priorityComparator.compare(node, predecessorsHighestPriority.iterator().next()) > 0) {
                    this.potentionalWriters.add(node);
                } else {
                    this.potentionalWriters.addAll(predecessorsHighestPriority);
                }
            }
        }

        @Nullable String nextEasyNode() {
            return (String)CollectionsUtils.firstOrNull(this.easyNodes);
        }

        void setResolved(@NonNull String node) {
            this.resolvedNodes.add(node);
            this.unresolvedNodes.remove(node);
            this.easyNodes.remove(node);
            this.potentionalWriters.remove(node);
            for (String successorOfResolved : this.graph.getSuccessors(node)) {
                if (this.resolvedNodes.contains(successorOfResolved) || !this.isEasy(successorOfResolved)) continue;
                this.easyNodes.add(successorOfResolved);
            }
        }

        @NonNull Set<@NonNull String> getUnresolvedNodes() {
            return this.unresolvedNodes;
        }

        @NonNull Set<@NonNull String> findUnresolvedNodes() {
            HashSet<@NonNull String> unresolved = new HashSet<String>();
            for (String node : this.graph.getRoots()) {
                this.addUnresolvedRecursively(node, unresolved);
            }
            return unresolved;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void addUnresolvedRecursively(@NonNull String node, @NonNull Set<@NonNull String> unresolved) {
            if (!this.resolvedNodes.contains(node)) {
                unresolved.add(node);
            }
            @NonNull Collection successors = this.graph.getSuccessors(node);
            for (String successor : successors) {
                if (unresolved.contains(successor)) continue;
                this.addUnresolvedRecursively(successor, unresolved);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        boolean isEasy(@NonNull String node) {
            @NonNull Collection predcessors = this.graph.getPredecessors(node);
            for (String predecessor : predcessors) {
                if (this.resolvedNodes.contains(predecessor)) continue;
                return false;
            }
            return true;
        }

        @NonNull Collection<@NonNull String> getResolvedNodes() {
            return CollectionsUtils.unmodifiableSet(this.resolvedNodes);
        }

        void addUnprioritizedSetting(@NonNull String settingId) {
            this.unprioritizedSettings.add(settingId);
            if (this.potentionalWriters.contains(settingId)) {
                this.potentionalWriters.remove(settingId);
                for (String successor : this.graph.getSuccessors(settingId)) {
                    if (this.resolvedNodes.contains(successor)) continue;
                    this.addPotentialWritersOf(successor);
                }
            }
        }

        private @NonNull Collection<@NonNull String> predcessorsHighestPriority(@NonNull String setting) {
            PriorityComparator priorityComparator = new PriorityComparator(this.config, this.prioritizedSetting, this.unprioritizedSettings);
            int highestPriority = Integer.MIN_VALUE;
            for (String predecessor : this.graph.getPredecessors(setting)) {
                if (this.resolvedNodes.contains(predecessor)) continue;
                highestPriority = Math.max(highestPriority, priorityComparator.getPriority(predecessor));
            }
            ArrayList<@NonNull String> result = new ArrayList<String>();
            for (String predecessor : this.graph.getPredecessors(setting)) {
                if (this.resolvedNodes.contains(predecessor) || highestPriority != priorityComparator.getPriority(predecessor)) continue;
                result.add(predecessor);
            }
            return result;
        }

        @NonNull Collection<@NonNull String> getUnprioritizeds() {
            return CollectionsUtils.unmodifiableCollection(this.unprioritizedSettings);
        }

        @NonNull Collection<@NonNull String> getPotentialWriters() {
            return CollectionsUtils.unmodifiableCollection(this.potentionalWriters);
        }

        void removeFromEasy(@NonNull String node) {
            this.easyNodes.remove(node);
        }
    }
}

