/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.ClockSlice;
import com.nxp.swtools.clocks.data.ClockSliceUtils;
import com.nxp.swtools.clocks.data.DiagramData;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.clocks.data.dependencies.SettingDependencyGraph;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.ComponentOutput;
import com.nxp.swtools.clocks.data.elements.ComputationalModel;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.NoClock;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.elements.Root;
import com.nxp.swtools.clocks.data.elements.Splitter;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.ClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.AGeneralSetting;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.ClockOutputSetting;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.PowerModeSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.model.ModelDataComI;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.clocks.verification.ExpressionVerificator;
import com.nxp.swtools.clocks.verification.ModelVerificator;
import com.nxp.swtools.clocks.verification.NameVerificator;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IResolvable;
import com.nxp.swtools.common.utils.graphs.IDirectedGraph;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.features.Feature;
import com.nxp.swtools.provider.features.SdkFeatures;
import com.nxp.swtools.resourcetables.model.data.McuResourceTables;
import com.nxp.swtools.resourcetables.model.mcu.ACommonMcu;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.script.CompiledScript;

public class Mcu
extends ACommonMcu
implements IMcu {
    @NonNull
    public static final String SPLITTER_SUFFIX = "_SPLIT";
    @NonNull
    private Map<String, IClockComponent> components;
    @NonNull
    private IMcuDescriptor descriptor;
    @NonNull
    private final SettingsDB settings;
    @NonNull
    private final IRegistersDatabaseAPI registers;
    @NonNull
    private @NonNull Map<@NonNull String, IClockElement> mcuElements;
    @NonNull
    private @NonNull List<@NonNull IConfigElement> mcuConfigElements;
    private AGlobalSetting powerModeSetting;
    @NonNull
    private @NonNull Map<@NonNull String, String> outputSignals;
    @NonNull
    private final CompiledScript script;
    @NonNull
    private SettingsConfig defaultSettingsConfig;
    @NonNull
    private ClocksConfig defaultClocksConfig;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(Mcu.class);
    @NonNull
    private @NonNull List<@NonNull PowerMode> powerModes;
    @Nullable
    String customPowerModesDescription;
    @NonNull
    private @NonNull Map<@NonNull String, String> notAvailableElements;
    @NonNull
    private NoClock noClockElement = new NoClock();
    @NonNull
    private IDirectedGraph settingDependencyGraph;
    @NonNull
    private @NonNull Set<@NonNull BitFieldSetting> bitFieldSettings = new HashSet<BitFieldSetting>();
    @NonNull
    private @NonNull Map<@NonNull String, Set<@NonNull String>> controlledSettings = new HashMap<String, Set<String>>();
    @NonNull
    private @NonNull Collection<@NonNull DiagramSymbol> diagramSymbols;
    @NonNull
    private final PeripheralComponentFile peripheralComponentFile;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull Pin> pins;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull IClockElement> allElements;
    @NonNull
    private BitFieldsCache bitFieldsCache;
    @NonNull
    private DiagramData mcuDiagramData;
    @Nullable
    private SdkFeatures sdkFeatures;

    public Mcu(@NonNull CompiledScript script, @NonNull BitFieldsCache bitFieldsCache, @NonNull IMcuDescriptor descriptor, @NonNull Map<@NonNull String, IClockComponent> components, @NonNull Map<@NonNull String, IClockElement> mcuElements, @NonNull List<@NonNull IConfigElement> configElements, @NonNull Map<@NonNull String, String> outputSignals, @NonNull List<@NonNull PowerMode> powerModes, @Nullable String customPowerModesDescription, @NonNull Map<@NonNull String, String> notAvailableElements, @NonNull Collection<@NonNull DiagramSymbol> diagramSymbols, @NonNull PeripheralComponentFile peripheralComponentFile, @Nullable McuResourceTables mcuResourceTables, @NonNull IMcuIdentification mcuIdentification, @NonNull IProcessorMasterToolInfo masterToolInfo, @NonNull Collection<@NonNull ProcessorCore> cores, @Nullable SdkFeatures sdkFeatures) {
        super(bitFieldsCache.getRegistersDb(), mcuResourceTables, mcuIdentification, masterToolInfo, cores);
        this.descriptor = descriptor;
        this.components = components;
        this.mcuElements = mcuElements;
        this.allElements = this.findAllEmenets();
        this.mcuConfigElements = configElements;
        this.outputSignals = outputSignals;
        this.powerModes = powerModes;
        this.customPowerModesDescription = customPowerModesDescription;
        this.script = script;
        this.bitFieldsCache = bitFieldsCache;
        this.registers = bitFieldsCache.getRegistersDb();
        this.notAvailableElements = notAvailableElements;
        this.settings = this.loadSettingsDB();
        assert (this.settings != null);
        this.defaultSettingsConfig = this.createDefaultSettingsConfig();
        this.defaultClocksConfig = this.createDefaultClocksConfig();
        this.diagramSymbols = diagramSymbols;
        this.peripheralComponentFile = peripheralComponentFile;
        this.pins = this.findAllPins();
        this.sdkFeatures = sdkFeatures;
        this.fillElementConnections(this.defaultClocksConfig);
        this.settingDependencyGraph = this.createSettingDependencyGraph();
        this.createControlledSettingsRelation();
        this.defaultClocksConfig.setModel(ComputationalModel.createFor(this));
        this.defaultClocksConfig.recompute(false, null);
        this.defaultClocksConfig.getSettingsConfig().clearChanges();
        this.defaultClocksConfig.setModel(ComputationalModel.createEmptyFor(this));
        this.mcuDiagramData = this.initDiagramData();
        if (SWToolsProperties.isVerificationOn()) {
            NameVerificator.verifyMcuNames(this);
            ModelVerificator.verify(this, this.getDiagramDataCopy());
            ModelVerificator.verifyDependencies(this);
            LOGGER.fine("Setting dependency graph: \n" + this.settingDependencyGraph);
            ExpressionVerificator verificator = ExpressionVerificator.getInstance();
            verificator.verifyExpressions(this.defaultClocksConfig);
            verificator.verifyBitFields();
            verificator.clear();
            LOGGER.finest("Diagram input: \n" + this.generateDiagramInput());
        }
    }

    private final @NonNull DiagramData initDiagramData() {
        ArrayList<@NonNull DiagramSymbol> copy = new ArrayList<DiagramSymbol>();
        this.diagramSymbols.forEach(x -> {
            boolean bl = copy.add(x.makeCopy());
        });
        this.mcuDiagramData = new DiagramData(copy, this, false);
        List<@NonNull ClockSlice> mcuClockSlices = ClockSliceUtils.getAllClockSlices(this);
        mcuClockSlices.forEach(x -> x.applySignalMapping(this));
        mcuClockSlices.forEach(x -> {
            DiagramData diagramData = x.getDiagramData(this);
        });
        DiagramData.checkDiagramIntegrity(this);
        return this.mcuDiagramData;
    }

    private final @NonNull String generateDiagramInput() {
        StringBuilder input = new StringBuilder();
        Map<@NonNull String, IClockElement> elements = this.getAllElements();
        input.append("{\n    Nodes: [");
        input.append(String.join((CharSequence)", ", (Iterable)this.mcuElements.keySet().stream().map(id -> Mcu.quoteIfNeeded(Mcu.prepareIDforDiagramInput(id))).collect(CollectorsUtils.toList())));
        ArrayList<String> subgraphs = new ArrayList<String>();
        for (Map.Entry<String, IClockComponent> entry : this.getClockComponents().entrySet()) {
            Set<@NonNull String> elementIDs = entry.getValue().getElementsMap().keySet();
            if (elementIDs.isEmpty()) continue;
            StringBuilder component = new StringBuilder();
            component.append("{" + Mcu.quoteIfNeeded(entry.getKey()) + ": [");
            component.append(String.join((CharSequence)", ", (Iterable)elementIDs.stream().map(id -> Mcu.quoteIfNeeded(Mcu.prepareIDforDiagramInput(id))).collect(CollectorsUtils.toList())));
            component.append("]}");
            subgraphs.add(component.toString());
        }
        if (!subgraphs.isEmpty()) {
            input.append(", ");
            input.append(String.join((CharSequence)", ", subgraphs));
        }
        input.append("],\n    Edges: [");
        ArrayList<String> edges = new ArrayList<String>();
        for (IClockElement element : elements.values()) {
            for (IClockElement successor : element.getSuccessors()) {
                String id2 = String.valueOf(element.getID()) + "->" + successor.getID();
                edges.add(Mcu.quoteIfNeeded(id2));
            }
        }
        input.append(String.join((CharSequence)", ", edges));
        input.append("],\n    Left: [");
        input.append(String.join((CharSequence)", ", (Iterable)elements.values().stream().filter(x -> x instanceof ClockSource).map(IElement::getID).map(id -> Mcu.quoteIfNeeded(Mcu.prepareIDforDiagramInput(id))).collect(CollectorsUtils.toList())));
        input.append("],\n    Right: [");
        input.append(String.join((CharSequence)", ", (Iterable)elements.values().stream().filter(x -> x instanceof ClockOutput).map(IElement::getID).map(id -> Mcu.quoteIfNeeded(Mcu.prepareIDforDiagramInput(id))).collect(CollectorsUtils.toList())));
        input.append("]\n}\n");
        return input.toString();
    }

    private static final @NonNull String prepareIDforDiagramInput(String id) {
        if (id.contains(".")) {
            id = id.substring(id.indexOf(".") + 1);
        }
        return id;
    }

    private static final @NonNull String quoteIfNeeded(String id) {
        if (id.contains(" ")) {
            id = "\"" + id + "\"";
        }
        return id;
    }

    @Override
    public IRegistersDatabaseAPI getRegisters() {
        return this.registers;
    }

    private @NonNull SettingsDB loadSettingsDB() {
        this.powerModeSetting = new PowerModeSetting(this.powerModes, this.customPowerModesDescription);
        SettingsDB.Builder builder = new SettingsDB.Builder().addGlobalSetting(this.powerModeSetting);
        for (IConfigElement element : this.getAllGlobalConfigElements()) {
            builder.addGlobalSetting((AGlobalSetting)element.getSetting());
            if (!element.isPowerModeSpecific()) continue;
            for (ISetting iSetting : element.createPowerModeSpecificSettings(this.powerModes).values()) {
                builder.addPowerModeSpecificSetting(iSetting);
            }
        }
        Collection<@NonNull IClockElement> elements = this.getAllElements().values();
        for (IClockElement element : elements) {
            this.extractSettingsFromElement(element, builder, true);
            List<@NonNull IClockElement> internalElements = element.getInternalElements();
            if (internalElements == null) continue;
            internalElements.forEach(x -> this.extractSettingsFromElement((IClockElement)x, builder, false));
        }
        for (IClockComponent component : this.getClockComponents().values()) {
            EnableSetting enableSetting = component.getEnableSetting();
            if (enableSetting == null) continue;
            builder.addGeneralSetting(enableSetting);
        }
        for (Pin pin : this.findAllPins().values()) {
            EnableSetting pinEnable = pin.getEnableSetting();
            if (pinEnable == null) continue;
            builder.addGeneralSetting(pinEnable);
        }
        EnableSetting enableSetting = this.noClockElement.getEnableSetting();
        if (enableSetting != null) {
            builder.addGeneralSetting(enableSetting);
        }
        for (ISetting iSetting : builder.getAllSettings()) {
            for (String bitFieldID : iSetting.getUsedBitFields()) {
                BitFieldElement bitField = ClocksBitFieldProvider.getBitFieldById(bitFieldID, this.getBitFieldsCache());
                if (bitField == null) continue;
                BitFieldSetting bfSetting = null;
                for (BitFieldSetting bitFieldSetting : this.bitFieldSettings) {
                    if (!bitFieldSetting.getBitField().equals(bitField)) continue;
                    bfSetting = bitFieldSetting;
                }
                if (bfSetting != null) continue;
                bfSetting = new BitFieldSetting(bitField);
                this.bitFieldSettings.add(bfSetting);
            }
        }
        this.bitFieldSettings.forEach(x -> {
            SettingsDB.Builder builder2 = builder.addGeneralSetting((AGeneralSetting)x);
        });
        @NonNull SettingsDB settingsDB = builder.build();
        return settingsDB;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void extractSettingsFromElement(@NonNull IClockElement element, @NonNull SettingsDB.Builder builder, boolean extractPowerModeSpecific) {
        List<ISetting> elementSettings = element.getSettings();
        for (ISetting setting : elementSettings) {
            if (setting instanceof ClockSourceSetting) {
                builder.addClockSource((ClockSourceSetting)setting);
                continue;
            }
            if (setting instanceof ClockOutputSetting) {
                builder.addClockOutput((ClockOutputSetting)setting);
                continue;
            }
            if (!(setting instanceof AGeneralSetting)) continue;
            builder.addGeneralSetting((AGeneralSetting)setting);
        }
        if (extractPowerModeSpecific) {
            @NonNull @NonNull Map powerModeSpecificSettings = element.createPowerModeSpecificSettings(this.powerModes);
            for (ISetting setting : powerModeSpecificSettings.values()) {
                if (setting instanceof ClockSourceSetting) {
                    builder.addPowerModeSpecificClockSource((ClockSourceSetting)setting);
                    continue;
                }
                builder.addPowerModeSpecificSetting(setting);
            }
        }
    }

    @Override
    public IMcuDescriptor getMcuDescriptor() {
        return this.descriptor;
    }

    @Override
    public Map<String, IClockComponent> getClockComponents() {
        return this.components;
    }

    @Override
    public IClockComponent getClockComponent(String id) {
        return this.components.get(id);
    }

    public Map<@NonNull String, @NonNull IClockElement> findAllEmenets() {
        LinkedHashMap<@NonNull String, @NonNull IClockElement> elements = new LinkedHashMap<String, IClockElement>(this.mcuElements);
        for (IClockComponent component : this.components.values()) {
            elements.putAll(component.getElementsMap());
            for (ClockSlice slice : component.getSlices()) {
                elements.putAll(slice.getElements());
            }
        }
        return elements;
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull IClockElement> getAllElements() {
        return this.allElements;
    }

    public @NonNull Map<@NonNull String, @NonNull Splitter> getSplitterElements() {
        HashMap<@NonNull String, @NonNull Splitter> splitters = new HashMap<String, Splitter>();
        for (IClockElement element : this.getAllElements().values()) {
            Splitter splitter = element.getSplitter();
            if (splitter == null) continue;
            splitters.put(splitter.getID(), splitter);
        }
        return splitters;
    }

    @Override
    public @Nullable IClockElement getClockElement(@NonNull String id) {
        if (id.equals(this.noClockElement.getID())) {
            return this.noClockElement;
        }
        int dotIdx = id.indexOf(46);
        IClockElement clockElement = null;
        if (dotIdx >= 0 && id.indexOf(46, dotIdx + 1) < 0) {
            clockElement = this.getClockElement(id.substring(0, dotIdx), id);
        }
        if (clockElement == null) {
            clockElement = this.getAllElements().get(id);
        }
        return clockElement;
    }

    public @Nullable IClockElement getClockElement(@NonNull String componentID, @NonNull String id) {
        IClockComponent clockComponent = this.getClockComponent(componentID);
        if (clockComponent != null) {
            return clockComponent.getClockElement(id);
        }
        return this.mcuElements.get(componentID);
    }

    @Override
    public @NonNull Collection<@NonNull ModelDataComI> getAllModelElements() {
        boolean addNoClockElement;
        Collection<IClockElement> elementValues = this.getAllElements().values();
        if (CollectionsUtils.containsNullValue(elementValues)) {
            LOGGER.severe("Elements contains null value(s)!");
        }
        HashSet<@NonNull ModelDataComI> modelElements = new HashSet<ModelDataComI>();
        boolean bl = addNoClockElement = !this.noClockElement.getSuccessors().isEmpty();
        if (addNoClockElement) {
            modelElements.add(this.noClockElement);
            Splitter splitter = this.noClockElement.getSplitter();
            if (splitter != null) {
                modelElements.add(splitter);
            }
        }
        for (IClockElement element : elementValues) {
            if (element == null) continue;
            modelElements.add(element);
        }
        Root root = new Root(this.bitFieldsCache);
        ArrayList<@NonNull String> clockSourceIDs = new ArrayList<String>();
        if (addNoClockElement) {
            clockSourceIDs.add(this.noClockElement.getID());
        }
        for (ModelDataComI element : modelElements) {
            if (!(element instanceof ClockSource)) continue;
            clockSourceIDs.add(((ClockSource)element).getID());
        }
        root.getDevice().setSuccessors(clockSourceIDs);
        modelElements.add(root);
        modelElements.addAll(this.getSplitterElements().values());
        return modelElements;
    }

    private void fillElementConnections(@NonNull IClocksConfig config) {
        HashMap<@NonNull String, @NonNull String> notPairedElements = new HashMap<String, String>();
        Map<@NonNull String, IClockElement> elements = this.getAllElements();
        for (IClockElement element : elements.values()) {
            String predecessorID;
            String inputSignal = element.getInputSignal();
            String string = predecessorID = UtilsText.isEmpty((String)inputSignal) ? "" : this.getPredecessorID(UtilsText.safeString((String)inputSignal));
            if (element instanceof ClockSelect) {
                this.connectClockSelect(element);
                continue;
            }
            if (inputSignal == null || "".equals(inputSignal) || predecessorID == null) continue;
            IClockElement predecessor = this.getClockElement(predecessorID);
            element.getDevice().setPredecessorID(predecessorID);
            if (predecessor != null) {
                this.connect(element, predecessor);
                continue;
            }
            if (this.isElementNotAvailable(predecessorID)) {
                notPairedElements.put(predecessorID, element.getID());
                config.setDisabledByDefault(element);
                element.getDevice().setPredecessorID(this.noClockElement.getID());
                this.connect(element, this.noClockElement);
                continue;
            }
            LOGGER.warning("No predeccessor found for element: " + element.getID());
        }
        this.reconnect(notPairedElements, elements);
        this.verifyConnections();
    }

    private void connectClockSelect(@NonNull IClockElement element) {
        ClockSelect clockSelect = (ClockSelect)element;
        Collection<@NonNull Object> inputs = clockSelect.getInputs();
        ArrayList<@NonNull String> branches = new ArrayList<String>();
        for (Object input : inputs) {
            String pred = UtilsText.safeString((String)input.toString());
            IClockElement predecessor = null;
            predecessor = this.noClockElement.getID().equals(pred) ? this.noClockElement : this.getClockElement(pred);
            if (predecessor != null) {
                this.connect(element, predecessor, branches);
                continue;
            }
            if (this.isElementNotAvailable(pred)) continue;
            LOGGER.warning(MessageFormat.format("No element has been found for clock selector {0} input branch named: {1}", element.getID(), pred));
        }
        clockSelect.setBranches(branches);
    }

    private void reconnect(@NonNull Map<@NonNull String, String> notPairedElements, @NonNull Map<@NonNull String, IClockElement> elements) {
        for (IClockElement element : elements.values()) {
            if (element.getDevice().getSuccessor() != null) continue;
            String outputSignal = "";
            for (Map.Entry<String, String> entry : this.notAvailableElements.entrySet()) {
                if (!entry.getValue().replaceAll("\\.clk", "").equals(element.getID())) continue;
                outputSignal = entry.getKey();
            }
            if (!notPairedElements.containsKey(outputSignal)) continue;
            String successor = notPairedElements.get(outputSignal);
            if (successor != null) {
                IClockElement successorElement = this.getClockElement(successor);
                if (successorElement == null) continue;
                this.connect(successorElement, element);
                continue;
            }
            LOGGER.severe("No succesor durring connection reconstruction for output signal: " + outputSignal);
        }
    }

    private void verifyConnections() {
        if (SWToolsProperties.isVerificationOn()) {
            for (IClockElement element : this.getAllElements().values()) {
                ModelCreationI device = element.getDevice();
                if (device.getSuccessor() == null && device.getSuccList() == null && !(element instanceof ClockOutput)) {
                    LOGGER.severe("Successor missing: " + element.getID());
                }
                if (device.getPredecessor() != null || device.getPredList() != null) continue;
                LOGGER.severe("Predecessor missing: " + element.getID());
            }
        }
    }

    private @NonNull String connect(@NonNull IClockElement element, @NonNull IClockElement predecessor, @Nullable List<@NonNull String> branches) {
        String predID = predecessor.getID();
        String successor = predecessor.getDevice().getSuccessor();
        predecessor.addSuccessor(element);
        element.addPredecessor(predecessor);
        if (successor == null) {
            predecessor.getDevice().setSuccessorID(element.getID());
        } else {
            Splitter splitter = predecessor.getSplitter();
            if (splitter == null) {
                String splitterID = String.valueOf(predID) + SPLITTER_SUFFIX;
                splitter = new Splitter(splitterID, predID);
                splitter.addSuccessor(successor);
                IClockElement clockElement = this.getClockElement(successor);
                if (clockElement instanceof ClockSelect) {
                    ((ClockSelect)clockElement).replaceBranch(predID, splitterID);
                }
                if (branches != null) {
                    Collections.replaceAll(branches, predID, splitterID);
                }
                predecessor.setSplitter(splitter);
            }
            predID = splitter.getID();
            splitter.addSuccessor(element.getID());
            element.getDevice().setPredecessorID(splitter.getID());
            predecessor.getDevice().setSuccessorID(splitter.getID());
        }
        if (branches != null) {
            branches.add(predID);
        }
        return predID;
    }

    private @NonNull String connect(@NonNull IClockElement element, @NonNull IClockElement predecessor) {
        return this.connect(element, predecessor, null);
    }

    @Override
    public String getPredecessorID(@NonNull String inputSignal) {
        String parsedSignal = inputSignal;
        while (parsedSignal != null && !UtilsText.isEmpty((String)parsedSignal)) {
            if (parsedSignal.endsWith(".clk")) {
                return parsedSignal.substring(0, parsedSignal.length() - ".clk".length());
            }
            int dotIndex = parsedSignal.indexOf(46);
            if (dotIndex >= 0) {
                IClockComponent clockComponent = this.getClockComponent(parsedSignal.substring(0, dotIndex));
                if (clockComponent != null) {
                    parsedSignal = clockComponent.getOutputMapping().get(parsedSignal);
                    continue;
                }
                return parsedSignal;
            }
            return null;
        }
        return parsedSignal;
    }

    @Override
    public SettingsDB getSettings() {
        return this.settings;
    }

    @Override
    public @NonNull Map<@NonNull String, String> getOutputMapping() {
        return this.outputSignals;
    }

    @Override
    public @NonNull CompiledScript getCodeGeneratingScript() {
        return this.script;
    }

    @Override
    public @NonNull IClocksConfig getDefaultConfig() {
        return this.defaultClocksConfig;
    }

    private @NonNull ClocksConfig createDefaultClocksConfig() {
        ClocksConfig clocksConfig = new ClocksConfig(this.defaultSettingsConfig, this);
        return clocksConfig;
    }

    private @NonNull SettingsConfig createDefaultSettingsConfig() {
        SettingsConfig settingsConfig = new SettingsConfig();
        ClocksConfig config = new ClocksConfig(settingsConfig, this);
        for (AGlobalSetting setting : this.settings.getGlobalSettings()) {
            SettingValue defaultValue = setting.getDefaultValue(config);
            if (defaultValue != null) {
                settingsConfig.setSettingValue(setting, defaultValue);
            } else {
                settingsConfig.setSettingValue(setting, SettingValue.N_A);
            }
            if (!setting.isLockedByDefault()) continue;
            settingsConfig.lockSettingIfNotLocked(setting);
        }
        ArrayList<@NonNull ClockSourceSetting> clockSources = new ArrayList<ClockSourceSetting>(this.settings.getClockSources());
        clockSources.addAll(this.settings.getPowerModeSpecificClockSources());
        for (ClockSourceSetting setting : clockSources) {
            List<SettingValue> values = setting.getValues(config);
            SettingValue value = SettingValue.FREQ_N_A;
            if (values == null) {
                if (setting.getDefaultValue(config) != null) {
                    value = setting.getDefaultValue(config);
                } else {
                    LOGGER.warning("No default value found for setting: " + setting.getId());
                }
            } else {
                value = !values.isEmpty() ? values.get(0) : SettingValue.FREQ_N_A;
            }
            assert (value != null);
            settingsConfig.setSettingValue(setting, value);
            if (setting.isLockedByDefault()) {
                settingsConfig.lockSettingIfNotLocked(setting);
            }
            if (!setting.isUserEnableable()) continue;
            settingsConfig.setUserEnabled(setting, setting.isConnectedByDefault());
        }
        ArrayList<@NonNull AGeneralSetting> generalSettings = new ArrayList<AGeneralSetting>(this.settings.getGeneralSettings());
        Collections.sort(generalSettings, (s1, s2) -> s1.getType().name().compareTo(s2.getType().name()));
        Mcu.createDefaultValues(config, generalSettings, settingsConfig);
        Mcu.createDefaultValues(config, this.settings.getPowerModeSpecificSettings(), settingsConfig);
        Mcu.createDefaultValues(config, this.settings.getClockOutputs(), settingsConfig);
        return settingsConfig;
    }

    private static void createDefaultValues(@NonNull IClocksConfig clocksConfig, @NonNull Collection<? extends @NonNull ISetting> settings, @NonNull SettingsConfig settingsConfig) {
        for (ISetting iSetting : settings) {
            SettingValue defaultValue = iSetting.getDefaultValue(clocksConfig);
            if (defaultValue != null) {
                settingsConfig.setSettingValue(iSetting, defaultValue);
            } else {
                List<@NonNull SettingValue> values = iSetting.getValues(clocksConfig);
                if (values != null && !values.isEmpty()) {
                    settingsConfig.setSettingValue(iSetting, values.get(0));
                } else {
                    LOGGER.warning("No default value found for setting: " + iSetting.getId());
                }
            }
            if (!iSetting.isLockedByDefault()) continue;
            settingsConfig.lockSettingIfNotLocked(iSetting);
        }
    }

    @Override
    public @NonNull PeripheralComponentFile getPeripheralComponentFile() {
        return this.peripheralComponentFile;
    }

    @Override
    public @NonNull String getVersion() {
        return this.descriptor.getVersion();
    }

    @Override
    public @NonNull Collection<@NonNull String> getNotAvailableElements() {
        return CollectionsUtils.unmodifiableSet(this.notAvailableElements.keySet());
    }

    @Override
    public boolean isElementNotAvailable(@NonNull String elementID) {
        return this.getNotAvailableElements().contains(elementID) || this.getNotAvailableElements().contains(Text.getComponentID(elementID));
    }

    @Override
    public @Nullable IClockElement getClockElementFromSplitter(@NonNull String splitterId) {
        String componentID = UtilsText.safeString((String)splitterId.replaceAll("\\..*", ""));
        IClockComponent parentComponent = this.getClockComponent(componentID);
        if (parentComponent != null) {
            for (IClockElement element : parentComponent.getElements()) {
                Splitter elemSplitter = element.getSplitter();
                if (elemSplitter == null || !splitterId.equals(elemSplitter.getID())) continue;
                return element;
            }
        } else {
            for (IClockElement element : this.mcuElements.values()) {
                Splitter elemSplitter = element.getSplitter();
                if (elemSplitter == null || !splitterId.equals(elemSplitter.getID())) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public @NonNull Collection<@NonNull IConfigElement> getGlobalConfigElements() {
        return this.mcuConfigElements;
    }

    @Override
    public @NonNull Collection<@NonNull IConfigElement> getAllGlobalConfigElements() {
        ArrayList<@NonNull IConfigElement> allConfigElements = new ArrayList<IConfigElement>(this.mcuConfigElements);
        for (IClockComponent component : this.components.values()) {
            allConfigElements.addAll(component.getGlobalConfigElements());
        }
        return allConfigElements;
    }

    @Override
    public @NonNull IClockElement getNoClockElement() {
        return this.noClockElement;
    }

    @Override
    public @Nullable AGlobalSetting getPowerModeSetting() {
        return this.powerModeSetting;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull String, @NonNull Pin> findAllPins() {
        LinkedHashMap<@NonNull String, @NonNull Pin> result = new LinkedHashMap<String, Pin>();
        @NonNull Stream cs = CollectionsUtils.getInstancesOf(this.getAllElements().values(), ClockSource.class);
        cs.flatMap(source -> source.getPins().stream()).forEach(pin -> {
            Pin pin2 = result.put(pin.getID(), (Pin)pin);
        });
        @NonNull Stream clockOuts = CollectionsUtils.getInstancesOf(this.getAllElements().values(), ClockOutput.class);
        clockOuts.flatMap(output -> output.getPins().stream()).forEach(pin -> {
            Pin pin2 = result.put(pin.getID(), (Pin)pin);
        });
        @NonNull Stream componentOuts = CollectionsUtils.getInstancesOf(this.getAllElements().values(), ComponentOutput.class);
        componentOuts.flatMap(output -> output.getPins().stream()).forEach(pin -> {
            Pin pin2 = result.put(pin.getID(), (Pin)pin);
        });
        return result;
    }

    private @NonNull IDirectedGraph createSettingDependencyGraph() {
        this.createSoftDisableConditions();
        SettingDependencyGraph dependencyGraph = new SettingDependencyGraph(this.settings);
        this.settings.getAllSettings().forEach(x -> {
            boolean bl = dependencyGraph.addNode(x.getId());
        });
        for (ISetting setting : this.settings.getAllSettings()) {
            setting.getDependencies(this).forEach(x -> {
                boolean bl = dependencyGraph.addEdge((String)x, setting.getId());
            });
            setting.getInfluencedSettings(this).forEach(x -> {
                boolean bl = dependencyGraph.addEdge(setting.getId(), (String)x);
            });
        }
        dependencyGraph.refreshRoots();
        if (SWToolsProperties.isVerificationOn()) {
            dependencyGraph.verifyBitFieldSettings();
        }
        return dependencyGraph;
    }

    private void createSoftDisableConditions() {
        for (ISetting setting : this.settings.getAllEnableSettings()) {
            EnableSetting enableSetting;
            if (!(setting instanceof EnableSetting) || !((enableSetting = (EnableSetting)setting).getElement() instanceof IClockElement)) continue;
            IClockElement element = (IClockElement)enableSetting.getElement();
            if (element instanceof ClockSelect) {
                Mcu.createSoftDisableConditionForSelector(element, enableSetting);
                continue;
            }
            for (IClockElement predecessorElement : element.getPredecessors()) {
                EnableSetting predecessorEnableSetting = predecessorElement.getEnableSetting();
                if (predecessorEnableSetting == null) continue;
                enableSetting.setSoftEnableCondition(Expression.create(predecessorEnableSetting.getId()));
            }
        }
    }

    private static void createSoftDisableConditionForSelector(@NonNull IClockElement element, @NonNull EnableSetting enableSetting) {
        HashMap<@NonNull String, @NonNull IResolvable> predecessorEnableSettings = new HashMap<String, IResolvable>();
        block0: for (IClockElement predecessorElement : element.getPredecessors()) {
            EnableSetting predecessorEnableSetting = predecessorElement.getEnableSetting();
            if (predecessorEnableSetting == null) continue;
            Collection<@NonNull Object> values = ((ClockSelect)element).getInputs();
            for (Object inputObject : values) {
                String input = UtilsText.safeToString((Object)inputObject);
                if (!input.equals(predecessorElement.getID())) continue;
                predecessorEnableSettings.put(input, Expression.create(predecessorEnableSetting.getId()).getMainResolvable());
                continue block0;
            }
        }
        Expression exp = Expression.EXPRESSION_TRUE;
        ISetting selectorSetting = element.getFrequencyModifierSetting();
        if (selectorSetting != null) {
            exp = Expression.createSwitch(predecessorEnableSettings, exp.getMainResolvable(), Expression.create(selectorSetting.getId()).getMainResolvable());
        }
        enableSetting.setSoftEnableCondition(exp);
    }

    @Override
    public @NonNull IDirectedGraph getSettingDependencies() {
        return this.settingDependencyGraph;
    }

    private void addControlSetting(@NonNull String setting, @NonNull String controlSetting) {
        if (!setting.equals(controlSetting)) {
            Set<@NonNull String> controlSettings = new HashSet<String>();
            if (this.controlledSettings.containsKey(setting)) {
                controlSettings = Objects.requireNonNull(this.controlledSettings.get(setting));
            }
            controlSettings.add(controlSetting);
            this.controlledSettings.put(setting, controlSettings);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createControlledSettingsRelation() {
        for (ISetting setting : this.settings.getAllBitFieldSettings()) {
            @NonNull Collection predecessors = this.settingDependencyGraph.getPredecessors(setting.getId());
            @NonNull Collection successors = this.settingDependencyGraph.getSuccessors(setting.getId());
            @NonNull List bitFieldModifiers = (List)predecessors.stream().filter(successors::contains).collect(CollectorsUtils.toList());
            for (String modifier : bitFieldModifiers) {
                successors.forEach(x -> this.addControlSetting((String)x, modifier));
            }
        }
    }

    @Override
    public @Nullable Set<@NonNull String> getControlSettings(@NonNull String setting) {
        return this.controlledSettings.get(setting);
    }

    @Override
    public DiagramData getDiagramDataCopy() {
        return this.mcuDiagramData;
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull Pin> getAllPins() {
        return this.pins;
    }

    @Override
    public @NonNull BitFieldsCache getBitFieldsCache() {
        return this.bitFieldsCache;
    }

    public @NonNull PeripheralComponentFile getClockConsumers() {
        return this.peripheralComponentFile;
    }

    public boolean hasFeature(@NonNull String feature, @Nullable String core, @Nullable String peripheral) {
        if (this.sdkFeatures != null) {
            return this.sdkFeatures.hasFeature(this.sdkFeatures.removePrefix(feature), this.getMcuIdentification().getPackage(), core, peripheral);
        }
        return false;
    }

    public @Nullable String getFeature(@NonNull String feature, @Nullable String core, @Nullable String peripheral) {
        Feature featureFound;
        if (this.sdkFeatures != null && (featureFound = this.sdkFeatures.getFeatureByName(this.sdkFeatures.removePrefix(feature), this.getMcuIdentification().getPackage(), core, peripheral)) != null) {
            return featureFound.getValue();
        }
        return null;
    }
}

