/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.application;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.wizards.exportWizard.ExportClocksHtmlReport;
import com.nxp.swtools.clocks.wizards.exportWizard.ExportClocksSourcesWizard;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.cmd.CmdSection;
import com.nxp.swtools.common.utils.cmd.ICmdApplication;
import com.nxp.swtools.common.utils.files.FileAccessFactory;
import com.nxp.swtools.common.utils.lang.MethodAndInstance;
import com.nxp.swtools.common.utils.lang.ReflectionUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.IDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.OverriddenDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.SourceDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.utils.registers.BitField;
import com.nxp.swtools.utils.registers.BitFieldInfo;
import com.nxp.swtools.utils.registers.RegisterCsvStorage;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import com.nxp.swtools.utils.wizards.exportWizard.ExportUtils;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class CmdApplication
implements ICmdApplication {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(CmdApplication.class);
    @NonNull
    private static final String INTERNAL_BUNDLE_NAME = "com.nxp.swtools.clocks.internal_development";
    @NonNull
    private static final String TEST_DATA_GENERATOR_CLASS = "TestConfigGenerator";
    @NonNull
    private static final String HANDLER_PACKAGE_NAME = "handlers";
    @NonNull
    private static final String TEST_DATA_GENERATOR_METHOD = "generateTestConfigurations";

    public boolean run(@NonNull CmdSection cmdSection) {
        boolean result = true;
        Set keys = cmdSection.cmdMap.keySet();
        for (String key : keys) {
            String path;
            if (key.equals("-ExportAll") && !(path = cmdSection.getOptionValue("-ExportAll")).isEmpty()) {
                result &= CmdApplication.exportSources(path, false);
                result &= CmdApplication.exportHTML(path);
            }
            if (key.equals("-ExportSrc") && !(path = cmdSection.getOptionValue("-ExportSrc")).isEmpty()) {
                result &= CmdApplication.exportSources(path, false);
            }
            if (key.equals("-ExportMcuTemplate") && !(path = cmdSection.getOptionValue("-ExportMcuTemplate")).isEmpty()) {
                result &= CmdApplication.exportSources(path, true);
            }
            if (key.equals("-ExportHTML") && !(path = cmdSection.getOptionValue("-ExportHTML")).isEmpty()) {
                result &= CmdApplication.exportHTML(path);
            }
            if (key.equals("-ExportRegisters") && !(path = cmdSection.getOptionValue("-ExportRegisters")).isEmpty()) {
                result &= CmdApplication.exportRegisters(path);
            }
            if (!key.equals("-GenerateTestConfigs") || (path = cmdSection.getOptionValue("-GenerateTestConfigs")).isEmpty()) continue;
            Bundle bundle = Platform.getBundle((String)INTERNAL_BUNDLE_NAME);
            if (bundle == null) {
                result = true;
                LOGGER.log(Level.SEVERE, "Unable to get bundle: com.nxp.swtools.clocks.internal_development");
                result = false;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(INTERNAL_BUNDLE_NAME);
            stringBuilder.append(".");
            stringBuilder.append(HANDLER_PACKAGE_NAME);
            stringBuilder.append(".");
            stringBuilder.append(TEST_DATA_GENERATOR_CLASS);
            MethodAndInstance methodAndInstance = ReflectionUtils.getMethodAndInstance((Bundle)bundle, (String)stringBuilder.toString(), (String)TEST_DATA_GENERATOR_METHOD, (Class[])new Class[]{String.class});
            if (methodAndInstance == null) {
                result = false;
                continue;
            }
            try {
                methodAndInstance.getMethod().invoke(methodAndInstance.getInstance(), path);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "Unable to invoke instance of " + methodAndInstance.getMethod().getName(), e.getMessage());
                result = false;
            }
        }
        return result;
    }

    private static boolean exportRegisters(@NonNull String path) {
        IClocksProfile profile = UiController.getInstance().getProfile();
        IClocksConfig config = profile.getActiveConfig();
        ArrayList<@NonNull E> bitFieldInfos = new ArrayList();
        if (config != null) {
            config.getSettingsConfig().getSettingValues().entrySet().stream().filter(e -> e.getKey() instanceof BitFieldSetting).forEach(x -> {
                BitFieldSetting setting = (BitFieldSetting)x.getKey();
                BigInteger value = BigInteger.valueOf(-1L);
                if (((SettingValue)x.getValue()).getValue() instanceof Long) {
                    Long settingValue = (Long)((SettingValue)x.getValue()).getValue();
                    value = BigInteger.valueOf(settingValue);
                    bitFieldInfos.add(new BitFieldInfo((BitField)setting.getBitField(), value, true));
                }
            });
            ArrayList<ISourceFile> report = new ArrayList<ISourceFile>();
            report.add(SourceFileProviderFactory.createSourceFileFromString((String)(String.valueOf(config.getName()) + ".csv"), (String)RegisterCsvStorage.export(bitFieldInfos), null));
            return ExportUtils.exportToFolder((IDestinationPathProvider)new OverriddenDestinationPathProvider(Paths.get(path, new String[0]), SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getOutputPathOverrides()), report, (boolean)false);
        }
        return false;
    }

    private static boolean exportSources(@NonNull String path, boolean template) {
        return ExportClocksSourcesWizard.generateSourcesToFolder((IDestinationPathProvider)new SourceDestinationPathProvider(Paths.get(path, new String[0]), SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getOutputPathOverrides()), FileAccessFactory.getFileSystemAccess(), template) != null;
    }

    private static boolean exportHTML(@NonNull String path) {
        AExportWizard.GenerationResult result = ExportClocksHtmlReport.generateReport();
        if (result.wasSuccessful) {
            Collection report = result.getGeneratedSourceFiles();
            assert (report != null);
            return ExportUtils.exportToFolder((IDestinationPathProvider)new OverriddenDestinationPathProvider(Paths.get(path, new String[0]), SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getOutputPathOverrides()), (Collection)report, (boolean)false);
        }
        return false;
    }
}

