/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.table.params;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.DiagsEyeResultHandler;
import com.nxp.swtools.mem.validation.model.JitterEyeResultHandler;
import com.nxp.swtools.mem.validation.model.TestResultsParser;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.VParam;
import com.nxp.swtools.mem.validation.table.params.VParamValue;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Point;

public class VParamVariation {
    private static final Logger LOGGER = LogManager.getLogger(VParamVariation.class);
    private VTable parent;
    private Point pos;
    private VParamValue[] hValues;
    private VParamValue[] vValues;
    private boolean selected;
    private boolean validated;
    private VState state;
    @Nullable
    private List<VRunResult> resultList = new ArrayList<VRunResult>();
    @Nullable
    private Object customData = null;
    private long lastUIRefreshTime;
    @Nullable
    private ArrayList<DiagsEyeResultHandler.EyeTable> dqTables;
    @Nullable
    private ArrayList<JitterEyeResultHandler.EyeTable> jitterTables;
    @Nullable
    private ArrayList<JitterEyeResultHandler.EyeTable> patternIndepTables;
    private int currentRun = 0;

    public VParamVariation(VParamVariation proto, VTable _parent) {
        VParam param;
        String paramName;
        this.parent = _parent;
        this.pos = proto.pos;
        this.hValues = new VParamValue[proto.hValues.length];
        int i = 0;
        while (i < this.hValues.length) {
            paramName = proto.hValues[i].getParam().getName();
            param = _parent.getParam(paramName);
            this.hValues[i] = new VParamValue(Objects.requireNonNull(proto.hValues[i]), Objects.requireNonNull(param));
            ++i;
        }
        this.vValues = new VParamValue[proto.vValues.length];
        i = 0;
        while (i < this.vValues.length) {
            paramName = proto.vValues[i].getParam().getName();
            param = _parent.getParam(paramName);
            this.vValues[i] = new VParamValue(Objects.requireNonNull(proto.vValues[i]), Objects.requireNonNull(param));
            ++i;
        }
        this.selected = proto.selected;
        this.validated = proto.validated;
        this.state = proto.state;
        List<VScriptConfig> scriptConfigList = this.parent.getScriptsConfig();
        List<VRunResult> resultListLoc = this.resultList;
        for (VScriptConfig scriptConfig : scriptConfigList) {
            if (scriptConfig == null || !scriptConfig.isSelected()) continue;
            int i2 = 0;
            while (i2 < scriptConfig.getNumRuns()) {
                if (resultListLoc == null) {
                    this.resultList = resultListLoc = new ArrayList<VRunResult>();
                }
                resultListLoc.add(new VRunResult(this, scriptConfig, i2));
                ++i2;
            }
        }
    }

    public VParamVariation(VTable _parent, Point _pos, VParamValue[] _hValues, VParamValue[] _vValues) {
        this.parent = _parent;
        this.pos = _pos;
        this.hValues = (VParamValue[])_hValues.clone();
        this.vValues = (VParamValue[])_vValues.clone();
        this.selected = true;
        this.validated = false;
        this.state = VState.DEFAULT;
        List<VRunResult> resultListLoc = this.resultList;
        List<VScriptConfig> scriptConfigList = this.parent.getScriptsConfig();
        for (VScriptConfig scriptConfig : scriptConfigList) {
            if (scriptConfig == null || !scriptConfig.isSelected()) continue;
            int i = 0;
            while (i < scriptConfig.getNumRuns()) {
                if (resultListLoc == null) {
                    this.resultList = resultListLoc = new ArrayList<VRunResult>();
                }
                resultListLoc.add(new VRunResult(this, scriptConfig, i));
                ++i;
            }
        }
    }

    public void addResults(@NonNull VRunResult[] resultsToAdd) {
        List<VRunResult> resultListLoc = this.resultList;
        if (resultListLoc == null) {
            this.resultList = resultListLoc = new ArrayList<VRunResult>();
        }
        resultListLoc.addAll(Arrays.asList(resultsToAdd));
    }

    public boolean allTestsPassed() {
        if (!this.selected) {
            return false;
        }
        if (this.resultList != null) {
            for (VRunResult result : this.resultList) {
                if (result.getType() == VRunResult.ResultType.PASSED) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void applyConfiguration(boolean handleChanges, boolean genCode) {
        this.applyConfiguration(true, handleChanges, genCode);
    }

    public void applyConfiguration(boolean newTransaction, boolean handleChanges, boolean genCode) {
        VParamValue[] vParamValueArray = this.hValues;
        int n = this.hValues.length;
        int n2 = 0;
        while (n2 < n) {
            VParamValue hValue = vParamValueArray[n2];
            hValue.applyConfiguration(this.parent.getOptions().useDefaultParamValues(), this.customData, hValue.equals(this.hValues[this.hValues.length - 1]) && this.vValues.length == 0 & handleChanges, genCode);
            ++n2;
        }
        vParamValueArray = this.vValues;
        n = this.vValues.length;
        n2 = 0;
        while (n2 < n) {
            VParamValue vValue = vParamValueArray[n2];
            vValue.applyConfiguration(this.parent.getOptions().useDefaultParamValues(), this.customData, vValue.equals(this.vValues[this.vValues.length - 1]) && handleChanges, genCode);
            ++n2;
        }
    }

    private String getCodegenErrorText() {
        if (this.parent.isReadMargins()) {
            return "X";
        }
        return VState.ERR_CODEGEN.message();
    }

    public String getConfErrorText() {
        if (this.parent.isReadMargins() || this.parent.isWriteMargins()) {
            return "X";
        }
        return VState.ERR_CONFIG.message();
    }

    public @Nullable Object getCustomData() {
        return this.customData;
    }

    public VParamValue[] getHValues() {
        return (VParamValue[])this.hValues.clone();
    }

    public long getLastRefreshTime() {
        return this.lastUIRefreshTime;
    }

    public int getNumFails() {
        if (!this.selected) {
            return 0;
        }
        int numFails = 0;
        if (this.resultList != null) {
            for (VRunResult result : this.resultList) {
                if (result.getType() != VRunResult.ResultType.FAILED) continue;
                ++numFails;
            }
        }
        return numFails;
    }

    public int getNumPasses() {
        if (!this.selected) {
            return 0;
        }
        int numPasses = 0;
        if (this.resultList != null) {
            for (VRunResult result : this.resultList) {
                if (result.getType() != VRunResult.ResultType.PASSED) continue;
                ++numPasses;
            }
        }
        return numPasses;
    }

    public int getNumSkips() {
        if (!this.selected) {
            return 0;
        }
        int numSkips = 0;
        if (this.resultList != null) {
            for (VRunResult result : this.resultList) {
                if (result.getType() != VRunResult.ResultType.SKIPPED) continue;
                ++numSkips;
            }
        }
        return numSkips;
    }

    public @Nullable VScriptConfig getOperationalScriptConfig() {
        VScript script = null;
        VParamValue[] vParamValueArray = this.hValues;
        int n = this.hValues.length;
        int n2 = 0;
        while (n2 < n) {
            VParamValue hValue = vParamValueArray[n2];
            if (hValue.getValue() instanceof VScript) {
                script = (VScript)hValue.getValue();
                break;
            }
            ++n2;
        }
        if (script == null) {
            vParamValueArray = this.vValues;
            n = this.vValues.length;
            n2 = 0;
            while (n2 < n) {
                VParamValue vValue = vParamValueArray[n2];
                if (vValue.getValue() instanceof VScript) {
                    script = (VScript)vValue.getValue();
                    break;
                }
                ++n2;
            }
        }
        if (script == null) {
            return null;
        }
        for (VScriptConfig sc : this.parent.getScriptsConfig()) {
            if (!sc.getScript().getId().equalsIgnoreCase(script.getId())) continue;
            return sc;
        }
        return null;
    }

    public String[][] getParamNameValuePairs() {
        int numH = this.hValues.length;
        int numV = this.vValues.length;
        String[][] nvPairs = new String[numH + numV][2];
        int i = 0;
        while (i < numH) {
            nvPairs[i][0] = this.hValues[i].getParam().getName();
            nvPairs[i][1] = this.hValues[i].getValue().toString();
            ++i;
        }
        int startIdx = numH;
        int i2 = 0;
        while (i2 < numV) {
            nvPairs[startIdx + i2][0] = this.vValues[i2].getParam().getName();
            nvPairs[startIdx + i2][1] = this.vValues[i2].getValue().toString();
            ++i2;
        }
        return nvPairs;
    }

    public VTable getParent() {
        return this.parent;
    }

    private String getPassedText() {
        int numExecuted = 0;
        int numPassed = 0;
        int total = 0;
        if (this.resultList != null) {
            total = this.resultList.size();
            assert (this.resultList != null);
            for (VRunResult result : this.resultList) {
                switch (result.getType()) {
                    case FAILED: {
                        ++numExecuted;
                        break;
                    }
                    case PASSED: {
                        ++numExecuted;
                        ++numPassed;
                        break;
                    }
                    case SKIPPED: {
                        break;
                    }
                    case QUEUED: {
                        break;
                    }
                }
            }
        }
        String text = "";
        if (numExecuted > 0 || this.state == VState.PAUSED) {
            text = this.parent.isReadMargins() ? "" + numPassed : numPassed + "/" + total;
        }
        return text;
    }

    public Point getPos() {
        return new Point(this.pos.x, this.pos.y);
    }

    public @Nullable VRunResult getResult(int resultIdx) {
        return this.resultList != null ? this.resultList.get(resultIdx) : null;
    }

    public VRunResult @Nullable [] getResults() {
        List<VRunResult> resultListLoc = this.resultList;
        return resultListLoc != null ? resultListLoc.toArray(new VRunResult[resultListLoc.size()]) : null;
    }

    public VRunResult @Nullable [] getResults(int startIdx, int endIdx) {
        return this.resultList != null ? this.resultList.subList(startIdx, endIdx).toArray(new VRunResult[endIdx - startIdx]) : null;
    }

    public HashMap<Integer, VRunResult[]> getResultsByScript(VScriptConfig scriptConfig) {
        HashMap<Integer, VRunResult[]> res = new HashMap<Integer, VRunResult[]>();
        if (this.resultList != null) {
            for (VRunResult result : this.resultList) {
                if (!result.getScriptConfig().equals(scriptConfig)) continue;
                if (res.containsKey(new Integer(result.getNumRun()))) {
                    ArrayList<VRunResult> rList = new ArrayList<VRunResult>(Arrays.asList(res.get(new Integer(result.getNumRun()))));
                    rList.add(result);
                    res.put(new Integer(result.getNumRun()), rList.toArray(new VRunResult[rList.size()]));
                    continue;
                }
                res.put(new Integer(result.getNumRun()), new VRunResult[]{result});
            }
        }
        return res;
    }

    public String getSkippText() {
        if (this.parent.isReadMargins() || this.parent.isWriteMargins()) {
            return "XX";
        }
        return VState.SKIPPED.message();
    }

    public VState getState() {
        return this.state;
    }

    public String getText() {
        String text = "";
        if (VTable.TableResultsType.DEFAULT == this.parent.getOptions().getDisplayResultsType()) {
            switch (this.state) {
                case DEFAULT: 
                case PAUSED: 
                case PASSED: 
                case PARTIALY_PASSED: 
                case FAILED: {
                    text = this.getPassedText();
                    break;
                }
                case SKIPPED: {
                    text = this.getSkippText();
                    break;
                }
                case ERR_CODEGEN: {
                    text = this.getCodegenErrorText();
                    break;
                }
                case ERR_CONFIG: {
                    text = this.getConfErrorText();
                    break;
                }
            }
        } else {
            text = TestResultsParser.getCustomResultFromLog(this.parent, this);
        }
        return text;
    }

    public int getTotalRuns() {
        return this.resultList != null ? this.resultList.size() : 0;
    }

    public VParamValue[] getVValues() {
        return (VParamValue[])this.vValues.clone();
    }

    public boolean hasPassingRuns() {
        if (!this.selected) {
            return false;
        }
        if (this.resultList != null) {
            for (VRunResult result : this.resultList) {
                if (result.getType() != VRunResult.ResultType.PASSED) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSkips() {
        if (!this.selected) {
            return false;
        }
        if (this.resultList != null) {
            for (VRunResult result : this.resultList) {
                if (result.getType() != VRunResult.ResultType.SKIPPED) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public VRunResult @Nullable [] removeResults(int startIdx, int endIdx) {
        List<VRunResult> resultListLoc = this.resultList;
        if (resultListLoc != null) {
            ArrayList<VRunResult> resultsToRemove = new ArrayList<VRunResult>(resultListLoc.subList(startIdx, endIdx));
            resultListLoc.subList(startIdx, endIdx).clear();
            return resultsToRemove.toArray(new VRunResult[resultsToRemove.size()]);
        }
        return null;
    }

    public void reset() {
        this.state = VState.DEFAULT;
        this.validated = false;
        this.resetRunResults();
    }

    public void resetRunResults() {
        this.currentRun = 0;
        List<VRunResult> resultListLoc = this.resultList;
        if (resultListLoc != null) {
            resultListLoc.clear();
            if (this.parent.hasScriptParam()) {
                VScriptConfig sc = this.getOperationalScriptConfig();
                if (sc != null && sc.isSelected()) {
                    int i = 0;
                    while (i < sc.getNumRuns()) {
                        resultListLoc.add(new VRunResult(this, sc, i));
                        ++i;
                    }
                }
            } else {
                List<VScriptConfig> scriptConfigList = this.parent.getScriptsConfig();
                for (VScriptConfig scriptConfig : scriptConfigList) {
                    if (scriptConfig == null || !scriptConfig.isSelected()) continue;
                    int i = 0;
                    while (i < scriptConfig.getNumRuns()) {
                        resultListLoc.add(new VRunResult(this, scriptConfig, i));
                        ++i;
                    }
                }
            }
            for (VRunResult runResult : resultListLoc) {
                String figureFilePath = TestResultsLogger.getFigureLogFilePath(runResult.getParamVariation());
                String phyLogFilePath = TestResultsLogger.getPhyTrainingLogFilePath(runResult.getParamVariation());
                String logFilePath = TestResultsLogger.getLogFilePath(runResult);
                try {
                    Files.deleteIfExists(Paths.get(figureFilePath, new String[0]));
                    Files.deleteIfExists(Paths.get(phyLogFilePath, new String[0]));
                    Files.deleteIfExists(Paths.get(logFilePath, new String[0]));
                }
                catch (IOException e) {
                    LOGGER.info(e.getMessage());
                }
            }
        }
    }

    public void setCustomData(Object _customData) {
        this.customData = _customData;
    }

    public void setLastRefreshTime(long lastUIRefreshTime) {
        this.lastUIRefreshTime = lastUIRefreshTime;
    }

    public void setPosition(Point point) {
        this.pos = point;
    }

    public void setSelected(boolean _selected) {
        this.selected = _selected;
    }

    public void setState(VState _state) {
        this.state = _state;
    }

    public void skipRemainingRuns() {
        if (!this.selected) {
            return;
        }
        if (this.resultList != null) {
            for (VRunResult result : this.resultList) {
                if (result.getType() != VRunResult.ResultType.QUEUED) continue;
                result.setType(VRunResult.ResultType.SKIPPED);
            }
        }
        this.updateStateFromRunResults(StateUpdatePolicy.createDefaultPolicy());
    }

    public void skipRuns(int startRunIdx, int skipSize) {
        if (!this.selected) {
            return;
        }
        List<VRunResult> resultListLoc = this.resultList;
        if (resultListLoc != null) {
            int resultListSize = resultListLoc.size();
            int i = startRunIdx;
            while (i < startRunIdx + skipSize) {
                if (i < resultListSize) {
                    resultListLoc.get(i).setType(VRunResult.ResultType.SKIPPED);
                }
                ++i;
            }
        }
        this.updateStateFromRunResults(StateUpdatePolicy.createDefaultPolicy());
    }

    public void updateStateFromRunResults(StateUpdatePolicy updatePolicy) {
        if (!this.selected || this.getTotalRuns() == 0) {
            return;
        }
        if (this.allTestsPassed()) {
            this.state = VState.PASSED;
        } else if (this.hasPassingRuns()) {
            if (updatePolicy.getMinPassThreshold() > 0) {
                if (this.getNumPasses() >= updatePolicy.getMinPassThreshold()) {
                    this.state = VState.PASSED;
                }
            } else {
                this.state = VState.PARTIALY_PASSED;
            }
        } else {
            this.state = this.getNumFails() > 0 ? VState.FAILED : (this.hasSkips() ? (updatePolicy.getIgnoreSkips() ? VState.DEFAULT : VState.SKIPPED) : VState.DEFAULT);
        }
    }

    public void setDiagsData(ArrayList<DiagsEyeResultHandler.EyeTable> dqTables) {
        this.dqTables = dqTables;
    }

    public @Nullable ArrayList<DiagsEyeResultHandler.EyeTable> getDqTables() {
        return this.dqTables;
    }

    public void setJitterData(ArrayList<JitterEyeResultHandler.EyeTable> jitterTables) {
        this.jitterTables = jitterTables;
    }

    public @Nullable ArrayList<JitterEyeResultHandler.EyeTable> getPattIndepJitterData() {
        return this.patternIndepTables;
    }

    public void setPattIndepData(ArrayList<JitterEyeResultHandler.EyeTable> patternIndepTables) {
        this.patternIndepTables = patternIndepTables;
    }

    public @Nullable ArrayList<JitterEyeResultHandler.EyeTable> getJitterData() {
        return this.jitterTables;
    }

    public void updateCurrentRunModel() {
        List<VRunResult> resultListLoc;
        if (this.resultList != null && this.currentRun < (resultListLoc = this.resultList).size()) {
            resultListLoc.get(this.currentRun).setRunning();
        }
    }

    public void nextRun() {
        ++this.currentRun;
        this.updateCurrentRunModel();
    }

    public static class StateUpdatePolicy {
        private final boolean ignoreSkips;
        private final int maxSkipThreshold;
        private final int minPassThreshold;

        public static StateUpdatePolicy createDefaultPolicy() {
            return new StateUpdatePolicy(false, 0, -1);
        }

        private StateUpdatePolicy(boolean _ignoreSkips, int _maxSkipThreshold, int _minPassThreshold) {
            this.ignoreSkips = _ignoreSkips;
            this.maxSkipThreshold = _maxSkipThreshold;
            this.minPassThreshold = _minPassThreshold;
        }

        public boolean getIgnoreSkips() {
            return this.ignoreSkips;
        }

        public int getMaxSkipThreshold() {
            return this.maxSkipThreshold;
        }

        public int getMinPassThreshold() {
            return this.minPassThreshold;
        }
    }

    public static enum VState {
        DEFAULT(""),
        ERR_CONFIG("Error"),
        ERR_CODEGEN("Error"),
        PAUSED(""),
        SKIPPED("Skipped"),
        PASSED(""),
        PARTIALY_PASSED(""),
        FAILED("");

        private final String message;

        private VState(String _message) {
            this.message = _message;
        }

        public String message() {
            return this.message;
        }
    }
}

