/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.presenter.updaters;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionView;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.presenter.updaters.AUIRunnable;
import com.nxp.swtools.mem.validation.ui.ExecutionView;
import com.nxp.swtools.mem.validation.ui.MainView;
import com.nxp.swtools.mem.validation.ui.VScenarioView;
import java.util.logging.Logger;

public class TableFigureRefreshUpdater
extends AUIRunnable {
    private static final Logger LOGGER = LogManager.getLogger(TableFigureRefreshUpdater.class);
    private VPresentationModel data;
    private boolean updateExec;
    @Nullable
    private VScenarioView scenarioView;
    @Nullable
    private ExecutionView execView;
    @Nullable
    private ConnectionView connView;

    private static void trace(String message) {
        LOGGER.warning(message);
    }

    public TableFigureRefreshUpdater(VPresentationModel _data, boolean _updateExec) {
        this.data = _data;
        this.updateExec = _updateExec;
        MainView mainView = this.data.getView();
        if (!this.data.isViewDisposed()) {
            this.scenarioView = mainView.getScenarioView();
            this.execView = mainView.getExecutionView();
            this.connView = mainView.getConnView();
        } else {
            TableFigureRefreshUpdater.trace(UtilsText.safeString((String)Messages.TableFigureRefreshUpdater_0));
        }
    }

    @Override
    public void run() {
        if (!this.data.isViewDisposed()) {
            TableFigureRefreshUpdater.trace(UtilsText.safeString((String)Messages.TableFigureRefreshUpdater_1));
            if (this.scenarioView != null) {
                this.scenarioView.redrawScenarioFigure();
            }
            ExecutionPresentationModel executionLoc = this.data.getExecution();
            if (this.updateExec && this.execView != null && executionLoc != null) {
                this.execView.setInput(executionLoc);
            }
            if (this.connView != null && executionLoc != null) {
                this.connView.setInput(executionLoc);
            }
        } else {
            TableFigureRefreshUpdater.trace(UtilsText.safeString((String)Messages.TableFigureRefreshUpdater_2));
        }
    }
}

