/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scripts;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.model.scripts.AddressRange;

public class VScriptParam {
    public static final String BYTE_LANE_ID = "diag_byte";
    public static final String BIT_LANE_ID = "diag_lane";
    public static final String USE_RANDOM_PATTERN_PARAM_NAME = "USE_RANDOM_PATTERN";
    public static final String PATTERN_PARAM_NAME = "app.test_params.params";
    public static final String FULL_MEMORY_CHECK = "app.test_params.check_full_memory";
    public static final String TEXT_INFO_TIME = "app.test_params.time";
    protected String id;
    protected VScriptParamType type;
    protected String name;
    protected String description;
    protected Object defaultValue;
    protected boolean hidden;
    protected long minSize;
    @Nullable
    protected String customSizeUnit;
    @Nullable
    protected String availableMemoryId;
    @Nullable
    protected AddressRange minStartAddress;
    @Nullable
    protected Options options;

    private static Object castDefaultValue(String _defaultValue, VScriptParamType _type) {
        switch (_type) {
            case BOOL: {
                return new Boolean(_defaultValue.equals("true"));
            }
            case BYTE_PATTERN_HEX: 
            case INT_PATTERN_HEX: {
                return _defaultValue;
            }
            case INT_HEX: {
                _defaultValue = _defaultValue.trim().replaceAll("0x|0X", "");
                return new Long(Long.parseLong(_defaultValue, 16));
            }
            case INT_DEC: 
            case INT_SIZE_DEC: 
            case MULTI_OPT: 
            case TIME: {
                return new Integer(Integer.parseInt(_defaultValue));
            }
            case INFO_TEXT: {
                return _defaultValue;
            }
        }
        return "";
    }

    public VScriptParam(String _id, VScriptParamType _type, String _name, String _description, String _defaultOption, boolean _hidden, @Nullable Options _options, long _minSize, @Nullable String _customSizeUnit, @Nullable String _availableMemoryId, @Nullable AddressRange _minStartAddress) {
        this.id = _id;
        this.type = _type;
        this.name = _name;
        this.description = _description;
        this.defaultValue = VScriptParam.castDefaultValue(_defaultOption, _type);
        this.hidden = _hidden;
        this.options = _options;
        this.minSize = _minSize;
        this.customSizeUnit = _customSizeUnit;
        this.availableMemoryId = _availableMemoryId;
        this.minStartAddress = _minStartAddress;
    }

    public VScriptParam(VScriptParam proto) {
        this.id = proto.id;
        this.type = proto.type;
        this.name = proto.name;
        this.description = proto.description;
        this.defaultValue = proto.defaultValue;
        this.hidden = proto.hidden;
        this.options = proto.options;
        this.minSize = proto.minSize;
        this.customSizeUnit = proto.customSizeUnit;
        this.availableMemoryId = proto.availableMemoryId;
        this.minStartAddress = proto.minStartAddress;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable Options getOptions() {
        return this.options;
    }

    public VScriptParamType getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public long getMinSize() {
        return this.minSize;
    }

    public @Nullable String getCustomSizeUnit() {
        return this.customSizeUnit;
    }

    public @Nullable String getAvailableMemoryId() {
        return this.availableMemoryId;
    }

    public @Nullable AddressRange getMinStartAddress() {
        return this.minStartAddress;
    }

    public static class Option {
        public final String name;
        public final String value;

        public Option(String _name, String _value) {
            this.name = _name;
            this.value = _value;
        }
    }

    public static class Options {
        public final Option[] options;

        public Options(Option[] _options) {
            this.options = (Option[])_options.clone();
        }

        public String getName(Object value) {
            Option[] optionArray = this.options;
            int n = this.options.length;
            int n2 = 0;
            while (n2 < n) {
                Option option = optionArray[n2];
                if (value.equals(option.value)) {
                    return option.name;
                }
                ++n2;
            }
            return "";
        }

        public String[] getNames() {
            String[] names = new String[this.options.length];
            int i = 0;
            while (i < this.options.length) {
                names[i] = this.options[i].name;
                ++i;
            }
            return names;
        }

        public String getValue(String name) {
            Option[] optionArray = this.options;
            int n = this.options.length;
            int n2 = 0;
            while (n2 < n) {
                Option option = optionArray[n2];
                if (name.equals(option.name)) {
                    return option.value;
                }
                ++n2;
            }
            return "";
        }
    }

    public static enum VScriptParamType {
        INT_DEC,
        INT_SIZE_DEC,
        INT_HEX,
        BYTE_PATTERN_HEX,
        INT_PATTERN_HEX,
        BOOL,
        MULTI_OPT,
        TIME,
        INFO_TEXT;

    }
}

