/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scenarios;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.TestScriptParam;
import com.nxp.swtools.mem.validation.table.params.VParam;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class VScenario
implements IScenarioElement {
    private static final Logger LOGGER = LogManager.getLogger(VScenario.class);
    @Nullable
    protected IScenarioElement parent;
    protected VTableGroup[] children = new VTableGroup[0];
    protected boolean selected;
    protected boolean visible;
    protected String id;
    protected String name;
    protected String description;
    protected List<VScriptConfig> scriptsConfig = new ArrayList<VScriptConfig>();
    @Nullable
    private CollectionsUtils.Pair<String, String> visibleCondition;

    public VScenario(String _id, String _name, @Nullable IScenarioElement _parent) {
        this.id = _id;
        this.name = _name;
        this.parent = _parent;
        this.visible = true;
        this.description = "";
        this.visibleCondition = null;
    }

    public VScenario(VScenario proto, @Nullable IScenarioElement _parent) {
        this.selected = proto.selected;
        this.id = proto.id;
        this.name = proto.name;
        this.description = proto.description;
        this.visible = proto.visible;
        this.visibleCondition = proto.getVisibleCondition();
        this.parent = _parent;
        this.children = new VTableGroup[proto.children.length];
        int i = 0;
        while (i < this.children.length) {
            this.children[i] = (VTableGroup)proto.children[i].clone(this);
            ++i;
        }
        this.resolveScriptConfigReferences();
    }

    public void addScriptConfig(VScriptConfig sc) {
        this.scriptsConfig.add(sc);
    }

    @Override
    public IScenarioElement clone(IScenarioElement parent) {
        return new VScenario(this, parent);
    }

    @Override
    public IScenarioElement[] getChildren() {
        return (IScenarioElement[])this.children.clone();
    }

    public VTable.TableState getCompoundState() {
        VTable table;
        VTable[] selectedTables = this.getSelectedTables();
        VTable.TableState scenarioState = VTable.TableState.CLEAN;
        VTable[] vTableArray = selectedTables;
        int n = selectedTables.length;
        int n2 = 0;
        while (n2 < n) {
            table = vTableArray[n2];
            if (table.isVisible() && table.getState() == VTable.TableState.RUNNING) {
                return VTable.TableState.RUNNING;
            }
            ++n2;
        }
        vTableArray = selectedTables;
        n = selectedTables.length;
        n2 = 0;
        while (n2 < n) {
            table = vTableArray[n2];
            if (table != null && table.isVisible()) {
                VTable.TableState tableState = table.getState();
                switch (table.getState()) {
                    case CLEAN: {
                        if (scenarioState != VTable.TableState.PASSED) break;
                        scenarioState = VTable.TableState.RUNNING;
                        break;
                    }
                    case NOT_QUEUED: {
                        break;
                    }
                    case RUNNING: 
                    case CANCELLED: 
                    case PAUSED: {
                        return tableState;
                    }
                    case FAILED: {
                        scenarioState = tableState;
                        break;
                    }
                    case PASSED: {
                        if (scenarioState == VTable.TableState.FAILED) break;
                        scenarioState = tableState;
                    }
                }
            }
            ++n2;
        }
        return scenarioState;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getNumRuns() {
        int numRuns = 0;
        for (VScriptConfig sc : this.scriptsConfig) {
            if (!sc.isSelected()) continue;
            numRuns += sc.getNumRuns();
        }
        return numRuns;
    }

    public int getNumTables() {
        int numTables = 0;
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTable[] tables;
            VTableGroup group = vTableGroupArray[n2];
            VTable[] vTableArray = tables = group.getTables();
            int n3 = tables.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                if (table != null && table.isVisible() && table.isSelected()) {
                    ++numTables;
                }
                ++n4;
            }
            ++n2;
        }
        return numTables;
    }

    @Override
    public @Nullable IScenarioElement getParent() {
        return this.parent;
    }

    @Override
    public String getQualifiedName() {
        if (this.parent != null) {
            return String.valueOf(this.parent.getQualifiedName()) + ", " + this.name;
        }
        return this.name;
    }

    public @Nullable VTable getScriptParamTable() {
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTable[] tables;
            VTableGroup group = vTableGroupArray[n2];
            VTable[] vTableArray = tables = group.getTables();
            int n3 = tables.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                if (table != null && table.isVisible()) {
                    VParam[] vParamArray = table.getHParams();
                    int n5 = vParamArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        VParam hParam = vParamArray[n6];
                        if (hParam instanceof TestScriptParam) {
                            return table;
                        }
                        ++n6;
                    }
                    vParamArray = table.getVParams();
                    n5 = vParamArray.length;
                    n6 = 0;
                    while (n6 < n5) {
                        VParam vParam = vParamArray[n6];
                        if (vParam instanceof TestScriptParam) {
                            return table;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public List<VScriptConfig> getScriptsConfig() {
        return this.scriptsConfig;
    }

    public VScriptConfig[] getSelectedScriptConfigs() {
        ArrayList<VScriptConfig> selectedConfigs = new ArrayList<VScriptConfig>();
        for (VScriptConfig config : this.scriptsConfig) {
            if (!config.isSelected()) continue;
            selectedConfigs.add(config);
        }
        return selectedConfigs.toArray(new VScriptConfig[selectedConfigs.size()]);
    }

    public VTable[] getSelectedTables() {
        ArrayList<VTable> tableList = new ArrayList<VTable>();
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTable[] tables;
            VTableGroup tableGroup = vTableGroupArray[n2];
            VTable[] vTableArray = tables = tableGroup.getTables();
            int n3 = tables.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                if (table != null && table.isVisible() && table.isSelected()) {
                    tableList.add(table);
                }
                ++n4;
            }
            ++n2;
        }
        return tableList.toArray(new VTable[tableList.size()]);
    }

    public VTableGroup @Nullable [] getTableGroups() {
        return (VTableGroup[])this.children.clone();
    }

    public boolean hasScriptParams() {
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTableGroup group = vTableGroupArray[n2];
            if (group != null) {
                VTable[] tables;
                VTable[] vTableArray = tables = group.getTables();
                int n3 = tables.length;
                int n4 = 0;
                while (n4 < n3) {
                    VTable table = vTableArray[n4];
                    if (table != null && table.isVisible()) {
                        VParam[] vParamArray = table.getHParams();
                        int n5 = vParamArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            VParam hParam = vParamArray[n6];
                            if (hParam instanceof TestScriptParam) {
                                return true;
                            }
                            ++n6;
                        }
                        vParamArray = table.getVParams();
                        n5 = vParamArray.length;
                        n6 = 0;
                        while (n6 < n5) {
                            VParam vParam = vParamArray[n6];
                            if (vParam instanceof TestScriptParam) {
                                return true;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean hasSelections() {
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTableGroup group = vTableGroupArray[n2];
            if (group != null) {
                VTable[] tables;
                VTable[] vTableArray = tables = group.getTables();
                int n3 = tables.length;
                int n4 = 0;
                while (n4 < n3) {
                    VTable table = vTableArray[n4];
                    if (table != null && table.isVisible() && table.getFirstQueuedCell() != null) {
                        VParamVariation cell = table.getFirstQueuedCell();
                        while (cell != null) {
                            VScriptConfig[] scriptConfigs = table.getSelectedScriptConfigs(cell);
                            if (scriptConfigs != null && scriptConfigs.length > 0) {
                                return true;
                            }
                            cell = table.getNextQueuedCell(cell);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    public void invertCellSelection() {
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTableGroup tableGroup = vTableGroupArray[n2];
            VTable[] vTableArray = tableGroup.getTables();
            int n3 = vTableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                if (table.isVisible() && (table.getOptions().allowCellSkip() || table.getOptions().allowTableSkip())) {
                    table.invertCellSelection();
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public boolean isReadMargins() {
        return this.name != null && this.name.equals(ScenarioType.READ_MARGINS.name);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public boolean isSingleTableScenario() {
        return this.children.length == 1 && this.children[0].getTables().length == 1;
    }

    public boolean isSingleTableScenario(boolean onlyVisibleTables) {
        int numTables = 0;
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTableGroup tableGroup = vTableGroupArray[n2];
            VTable[] vTableArray = tableGroup.getTables();
            int n3 = vTableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                if (!onlyVisibleTables || onlyVisibleTables && table.isVisible()) {
                    ++numTables;
                }
                ++n4;
            }
            ++n2;
        }
        return numTables == 1;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isWriteMargins() {
        return this.name.equals(ScenarioType.WRITE_MARGINS.name);
    }

    public boolean isDiagsEye() {
        return this.name.equals(ScenarioType.DIAG_TX_EYE.name) || this.name.equals(ScenarioType.DIAG_RX_EYE.name);
    }

    public boolean isDiagsReadMargins() {
        return this.name.equals(ScenarioType.DIAG_RX_EYE.name);
    }

    public boolean isJitterEye() {
        for (VScriptConfig sc : this.getScriptsConfig()) {
            if (!sc.getName().contains(ScenarioType.JITTER_SCOPE.name)) continue;
            return sc.isSelected();
        }
        return false;
    }

    public boolean isCAEye() {
        return this.name.equals(ScenarioType.CA_BUS.name);
    }

    public boolean logsEnabled() {
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTableGroup group = vTableGroupArray[n2];
            VTable[] vTableArray = group.getTables();
            int n3 = vTableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                if (table.isVisible()) {
                    return table.getOptions().showLogs();
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public void removeScriptConfig(VScript script) {
        for (VScriptConfig sc : this.scriptsConfig) {
            if (sc.getScript() != script) continue;
            this.scriptsConfig.remove(sc);
            break;
        }
    }

    public void reset() {
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTableGroup tableGroup = vTableGroupArray[n2];
            VTable[] vTableArray = tableGroup.getTables();
            int n3 = vTableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                table.reset();
                ++n4;
            }
            ++n2;
        }
    }

    public void resolveScriptConfigReferences() {
        VTable table;
        int n;
        int n2;
        VTable[] vTableArray;
        VTableGroup tableGroup;
        int useTableIdx = 0;
        if (ScenarioType.CLOCK_CENTERING.name.equals(this.name)) {
            useTableIdx = 2;
        }
        VTable scriptsTable = null;
        int crtTableIdx = 0;
        VTableGroup[] vTableGroupArray = this.children;
        int n3 = this.children.length;
        int n4 = 0;
        block0: while (n4 < n3) {
            tableGroup = vTableGroupArray[n4];
            vTableArray = tableGroup.getTables();
            n2 = vTableArray.length;
            n = 0;
            while (n < n2) {
                table = vTableArray[n];
                if (crtTableIdx == useTableIdx) {
                    scriptsTable = table;
                    break block0;
                }
                ++crtTableIdx;
                ++n;
            }
            ++n4;
        }
        if (scriptsTable != null) {
            this.scriptsConfig = scriptsTable.getScriptsConfig();
            vTableGroupArray = this.children;
            n3 = this.children.length;
            n4 = 0;
            while (n4 < n3) {
                tableGroup = vTableGroupArray[n4];
                vTableArray = tableGroup.getTables();
                n2 = vTableArray.length;
                n = 0;
                while (n < n2) {
                    table = vTableArray[n];
                    if (!table.hasCustomDefaultScripts()) {
                        table.scriptsConfig = this.scriptsConfig;
                    }
                    ++n;
                }
                ++n4;
            }
            for (VScriptConfig scriptConfig : this.scriptsConfig) {
                scriptConfig.setOwner(this);
            }
        }
    }

    public boolean scriptsEnabled() {
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTableGroup group = vTableGroupArray[n2];
            VTable[] vTableArray = group.getTables();
            int n3 = vTableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                if (table.isVisible()) {
                    return table.getOptions().showScripts();
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public void selectAllCells() {
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTableGroup tableGroup = vTableGroupArray[n2];
            VTable[] vTableArray = tableGroup.getTables();
            int n3 = vTableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                if (table.isVisible() && (table.getOptions().allowCellSkip() || table.getOptions().allowTableSkip())) {
                    table.selectAllCells();
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void setChildren(IScenarioElement[] _children) {
        this.children = new VTableGroup[_children.length];
        int i = 0;
        VTableGroup tableGroup = null;
        IScenarioElement[] iScenarioElementArray = _children;
        int n = _children.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement _child = iScenarioElementArray[n2];
            if (_child instanceof VTableGroup) {
                tableGroup = (VTableGroup)_child;
                tableGroup.parent = this;
                this.children[i++] = tableGroup;
            }
            if (_child instanceof VTable) {
                VTable table = (VTable)_child;
                this.children[i++] = new VTableGroup(table.getId(), table.getName(), this, new VTable[]{table});
            }
            ++n2;
        }
        this.resolveScriptConfigReferences();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean testOptionsEnabled() {
        VTableGroup[] vTableGroupArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            VTableGroup group = vTableGroupArray[n2];
            VTable[] vTableArray = group.getTables();
            int n3 = vTableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VTable table = vTableArray[n4];
                if (table.isVisible()) {
                    return table.getOptions().showConfig();
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public void updateScriptConfig(VScriptConfig model) {
        for (VScriptConfig sc : this.scriptsConfig) {
            if (sc.getScript() != model.getScript()) continue;
            sc.setSelected(model.isSelected());
            sc.setNumRuns(model.getNumRuns());
        }
    }

    public boolean isShmooedTest() {
        return false;
    }

    public boolean isStressTest() {
        return this.name.equals(ScenarioType.STRESS_TEST.name);
    }

    public boolean isVREFTest() {
        return this.name.equals(ScenarioType.VREF_TEST.name);
    }

    public void setVisibleCondition(String visibleCond) {
        String[] visibleCondArray = visibleCond.split("=");
        if (visibleCondArray == null || visibleCondArray.length != 2) {
            return;
        }
        this.visibleCondition = new CollectionsUtils.Pair((Object)visibleCondArray[0], (Object)visibleCondArray[1]);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CollectionsUtils.Pair<String, String> getVisibleCondition() {
        return this.visibleCondition;
    }

    public void applyCellCustomData() {
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController != null) {
            configController.customPostValidationApplySelection();
        } else {
            LOGGER.severe(Messages.VScenario_CustomCellOperationError);
        }
    }

    public static enum ScenarioType {
        CLOCK_CENTERING("Centering the clock"),
        READ_ODT("Read ODT and driver"),
        WRITE_ODT("Write ODT and driver"),
        OPERATIONAL("Operational DDR tests"),
        READ_MARGINS("Read Margin"),
        WRITE_MARGINS("Write Margin"),
        DIAG_TX_EYE("Diag Write Margin"),
        DIAG_RX_EYE("Diag Read Margin"),
        STRESS_TEST("Stress tests"),
        JITTER_SCOPE("jitter_scope"),
        PATTERN_INDEP_JITTER_SCOPE("pattern_independent_jitter_scope"),
        VREF_TEST("Vref for 1D optimization"),
        CA_BUS("CA Bus Signals Margin");

        public final String name;

        private ScenarioType(String _name) {
            this.name = _name;
        }
    }
}

