/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ConfigManager;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.cproviders.ScriptConfigContentProvider;
import com.nxp.swtools.mem.validation.cproviders.StageTreeContentProvider;
import com.nxp.swtools.mem.validation.cproviders.TestRunResultContentLazyProvider;
import com.nxp.swtools.mem.validation.cproviders.TestRunResultContentProvider;
import com.nxp.swtools.mem.validation.jobs.JobName;
import com.nxp.swtools.mem.validation.listeners.AutoReportSelectionListener;
import com.nxp.swtools.mem.validation.listeners.BoolParamSelectionListener;
import com.nxp.swtools.mem.validation.listeners.BytePatternParamModifyListener;
import com.nxp.swtools.mem.validation.listeners.DecIntegerParamKeyListener;
import com.nxp.swtools.mem.validation.listeners.DecSizeIntegerParamKeyListener;
import com.nxp.swtools.mem.validation.listeners.HexIntegerParamKeyListener;
import com.nxp.swtools.mem.validation.listeners.InvertCellSelectionListener;
import com.nxp.swtools.mem.validation.listeners.MultiOptParamSelectionListener;
import com.nxp.swtools.mem.validation.listeners.ReportSelectionListener;
import com.nxp.swtools.mem.validation.listeners.RestoreComponentPropertiesListener;
import com.nxp.swtools.mem.validation.listeners.ScenarioCanvasApplyConfigListener;
import com.nxp.swtools.mem.validation.listeners.ScenarioCanvasMenuDetectListener;
import com.nxp.swtools.mem.validation.listeners.ScenarioCanvasMouseListener;
import com.nxp.swtools.mem.validation.listeners.ScenarioCanvasMouseMoveListener;
import com.nxp.swtools.mem.validation.listeners.ScenarioCanvasOnMenuShowListener;
import com.nxp.swtools.mem.validation.listeners.ScenarioPaintListener;
import com.nxp.swtools.mem.validation.listeners.ScenarioSelectionListener;
import com.nxp.swtools.mem.validation.listeners.ScriptConfigCountEditingSupport;
import com.nxp.swtools.mem.validation.listeners.ScriptConfigDoubleClickListener;
import com.nxp.swtools.mem.validation.listeners.ScriptConfigSelectionListener;
import com.nxp.swtools.mem.validation.listeners.ScriptConfigSyncOptionListener;
import com.nxp.swtools.mem.validation.listeners.SelectAllCellsListener;
import com.nxp.swtools.mem.validation.listeners.SelectCellRegionListener;
import com.nxp.swtools.mem.validation.listeners.StageSelectionListener;
import com.nxp.swtools.mem.validation.listeners.TestLogsComboSelectionListener;
import com.nxp.swtools.mem.validation.listeners.TestRunResultsSelectionListener;
import com.nxp.swtools.mem.validation.listeners.TimeParamListener;
import com.nxp.swtools.mem.validation.listeners.ToggleCellErrorColoringListener;
import com.nxp.swtools.mem.validation.listeners.ValidationButtonListener;
import com.nxp.swtools.mem.validation.lproviders.HintColumnLabelProvider;
import com.nxp.swtools.mem.validation.lproviders.ScriptConfigColumnLabelProvider;
import com.nxp.swtools.mem.validation.lproviders.StageTreeLabelProvider;
import com.nxp.swtools.mem.validation.lproviders.TestRunResultsComboLabelProvider;
import com.nxp.swtools.mem.validation.lproviders.TestRunResultsLabelProvider;
import com.nxp.swtools.mem.validation.model.ARunResultsUpdaterListener;
import com.nxp.swtools.mem.validation.model.CABusEyeResultHandler;
import com.nxp.swtools.mem.validation.model.DiagsEyeResultHandler;
import com.nxp.swtools.mem.validation.model.IProgressIndicator;
import com.nxp.swtools.mem.validation.model.JitterEyeResultHandler;
import com.nxp.swtools.mem.validation.model.RunResultsUpdaterListener;
import com.nxp.swtools.mem.validation.model.TablePassedVerifier;
import com.nxp.swtools.mem.validation.model.TableSelector;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.IConditionChangeListener;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.SelectCellRegionDrawTool;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.AddressRange;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.presenter.updaters.AUIRunnable;
import com.nxp.swtools.mem.validation.presenter.updaters.ConnectionLostUIUpdater;
import com.nxp.swtools.mem.validation.presenter.updaters.ErrorStateChangeUIUpdater;
import com.nxp.swtools.mem.validation.presenter.updaters.ExecutionStageDisabler;
import com.nxp.swtools.mem.validation.presenter.updaters.LogViewUpdater;
import com.nxp.swtools.mem.validation.presenter.updaters.RealTimeUpdater;
import com.nxp.swtools.mem.validation.presenter.updaters.RefreshRestoreTool;
import com.nxp.swtools.mem.validation.presenter.updaters.RefreshUIRunnable;
import com.nxp.swtools.mem.validation.presenter.updaters.RunResultsUiUpdater;
import com.nxp.swtools.mem.validation.presenter.updaters.ScenarioFinishUiUpdater;
import com.nxp.swtools.mem.validation.presenter.updaters.TableFigureRefreshUpdater;
import com.nxp.swtools.mem.validation.presenter.updaters.TableFinishUiUpdater;
import com.nxp.swtools.mem.validation.presenter.updaters.TimeoutReachedUiUpdater;
import com.nxp.swtools.mem.validation.presenter.updaters.ValidationStartUiUpdater;
import com.nxp.swtools.mem.validation.reports.CsvReportGenerator;
import com.nxp.swtools.mem.validation.reports.HtmlReportGenerator;
import com.nxp.swtools.mem.validation.reports.IReportGenerator;
import com.nxp.swtools.mem.validation.reports.ImageReportGenerator;
import com.nxp.swtools.mem.validation.reports.LogReportGenerator;
import com.nxp.swtools.mem.validation.reports.XlsReportGenerator;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.CellLogsView;
import com.nxp.swtools.mem.validation.ui.CellResultsMainView;
import com.nxp.swtools.mem.validation.ui.CellSummaryView;
import com.nxp.swtools.mem.validation.ui.CustomText;
import com.nxp.swtools.mem.validation.ui.MainView;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import com.nxp.swtools.mem.validation.ui.VScriptParamsView;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IGenericProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.progress.UIJob;

public class VPresentationModel {
    private static final Logger LOGGER = LogManager.getLogger(VPresentationModel.class);
    private static final String LOCK_TARGET_FAIL_MSG = Messages.ddrv_presentation_model_target_fail;
    private static final String UNLOCK_TARGET_FAIL_MSG = Messages.ddrv_presentation_model_unable_to_unlock;
    private static final String CONFIG_ERRORS_MSG = Messages.ddrv_presentation_model_config_errors;
    private static final String CODEGEN_ERRORS_MSG = Messages.ddrv_presentation_model_err_code_generation;
    private static final String SERVER_TIMEOUT_ERROR_MSG = Messages.ddrv_presentation_model_connection_timed_out;
    @Nullable
    private VModel model;
    @Nullable
    private String id;
    @Nullable
    protected ValidationPresentationModel validation;
    @Nullable
    protected ExecutionPresentationModel execution;
    @Nullable
    private VSessionModel session;
    protected TableSelector standardSelector = new TableSelector();
    private IReportGenerator.AutoReportData autoReportData = new IReportGenerator.AutoReportData();
    private IReportGenerator.ReportData reportData = new IReportGenerator.ReportData();
    private Map<IReportGenerator.ReportType, IReportGenerator> repGenMap = new EnumMap<IReportGenerator.ReportType, IReportGenerator>(IReportGenerator.ReportType.class);
    private StageTreeLabelProvider stageTreeLabelProvider;
    private MainView view;
    private boolean skipSync;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean componentHasErrors() {
        @NonNull Collection collection = ValidationEngineFactory.getProblemsCollection();
        if (collection.isEmpty()) {
            return false;
        }
        String componentId = "";
        IConfigProvider configProvider = ValidationContext.getInstance().getConfigController();
        if (configProvider != null) {
            componentId = configProvider.getCurrentInstanceName();
        }
        if (componentId.isEmpty()) {
            LOGGER.severe("Error retrieving component instance name");
            return true;
        }
        for (IBaseProblem problem : collection) {
            if (!(problem instanceof IGenericProblem) || problem.getProblemLevel() != 2 || !componentId.equalsIgnoreCase(((IGenericProblem)problem).getResource())) continue;
            return true;
        }
        return false;
    }

    private static String getComponentErrors() {
        if (!VPresentationModel.componentHasErrors()) {
            return "";
        }
        return Messages.ERR_CONFIG_MSG;
    }

    public static VPresentationModel newInstance(Composite parentView) throws Exception {
        if (!Activator.getDefault().getConfigManager().createValidationSpecificFolders()) {
            throw new Exception("Validation specific folders could not be created in location: ");
        }
        return new VPresentationModel(parentView);
    }

    static void trace(String message) {
        LOGGER.info(message);
    }

    static void trace(Level logLevel, String message) {
        if (!Level.OFF.equals(logLevel)) {
            LOGGER.log(logLevel, message);
        }
    }

    private VPresentationModel(Composite parentView) {
        this.view = new MainView(parentView);
        this.stageTreeLabelProvider = new StageTreeLabelProvider();
        this.attachUIListeners();
        this.updateUI(new RefreshUIRunnable(this), JobName.REFRESH_UI_ON_MODEL_CREATION.name);
    }

    private void attachContentProviders() {
        VScenarioOptionsView scenarioOptionsViewLoc;
        CellLogsView logsViewLoc;
        this.view.getStagesView().setStageTreeContentProvider(new StageTreeContentProvider());
        CellSummaryView summaryViewLoc = this.view.getCellSummaryView();
        if (summaryViewLoc != null) {
            summaryViewLoc.setTestResultsContentProvider(new TestRunResultContentLazyProvider());
            summaryViewLoc.setHintContentProvider(new ArrayContentProvider());
        }
        if ((logsViewLoc = this.view.getCellLogsView()) != null) {
            logsViewLoc.setCellTestContentProvider(new TestRunResultContentProvider());
        }
        if ((scenarioOptionsViewLoc = this.view.getScenarioOptionsView()) != null) {
            scenarioOptionsViewLoc.setScriptConfigContentProvider(new ScriptConfigContentProvider());
        }
    }

    private void attachLabelProviders() {
        VScenarioOptionsView scenarioOptionsViewLoc;
        CellSummaryView summaryViewLoc;
        this.view.getStagesView().setStageTreeLabelProvider(this.stageTreeLabelProvider);
        CellLogsView logsViewLoc = this.view.getCellLogsView();
        if (logsViewLoc != null) {
            logsViewLoc.setCellTestLabelProvider(new TestRunResultsComboLabelProvider());
        }
        if ((summaryViewLoc = this.view.getCellSummaryView()) != null) {
            summaryViewLoc.setTestResultsScriptLabelProvider(new TestRunResultsLabelProvider(0));
            summaryViewLoc.setTestResultsRunLabelProvider(new TestRunResultsLabelProvider(1));
            summaryViewLoc.setTestResultsElapsedLabelProvider(new TestRunResultsLabelProvider(2));
            summaryViewLoc.setTestResultsStatusLabelProvider(new TestRunResultsLabelProvider(3));
            summaryViewLoc.setTestResultsFailReasonProvider(new TestRunResultsLabelProvider(4));
            summaryViewLoc.setHintSymptomLabelProvider(new HintColumnLabelProvider(0));
            summaryViewLoc.setHintCauseLabelProvider(new HintColumnLabelProvider(1));
        }
        if ((scenarioOptionsViewLoc = this.view.getScenarioOptionsView()) != null) {
            scenarioOptionsViewLoc.setScriptNameLabelProvider(new ScriptConfigColumnLabelProvider(this, 0));
            scenarioOptionsViewLoc.setScriptCountLabelProvider(new ScriptConfigColumnLabelProvider(this, 1));
        }
    }

    private void attachMouseListeners() {
        this.view.getScenarioView().setScenarioCanvasMouseListener(new ScenarioCanvasMouseListener(this));
        this.view.getScenarioView().setScenarioCanvasMouseMoveListener(new ScenarioCanvasMouseMoveListener(this));
    }

    private void attachMenuListeners() {
        this.view.getScenarioView().setScenarioCanvasMenuDetectListener(new ScenarioCanvasMenuDetectListener(this));
        this.view.getScenarioView().setScenarioCanvasApplyConfigListener(new ScenarioCanvasApplyConfigListener(this));
        this.view.getScenarioView().setScenarioCanvasMenuShowListener(new ScenarioCanvasOnMenuShowListener(this));
    }

    private void attachPaintListeners() {
        this.view.getScenarioView().setScenarioPaintListener(new ScenarioPaintListener(this));
    }

    private void attachSelectionListeners() {
        VScenarioOptionsView scenarioOptionsViewLoc;
        CellSummaryView summaryViewLoc;
        this.view.getStagesView().setScenarioSelectionListener(new ScenarioSelectionListener(this));
        this.view.getStagesView().setStageSelectionListener((SelectionListener)new StageSelectionListener(this));
        CellLogsView logsViewLoc = this.view.getCellLogsView();
        if (logsViewLoc != null) {
            logsViewLoc.setLogsSelectionListener(new TestLogsComboSelectionListener(this));
        }
        if ((summaryViewLoc = this.view.getCellSummaryView()) != null) {
            summaryViewLoc.setTestResultsSelectionListener(new TestRunResultsSelectionListener(this));
        }
        if ((scenarioOptionsViewLoc = this.view.getScenarioOptionsView()) != null) {
            if (!SwToolsProduct.isUctProduct()) {
                scenarioOptionsViewLoc.setDoubleClickListener(new ScriptConfigDoubleClickListener(this));
            }
            scenarioOptionsViewLoc.setSelectionListener((SelectionListener)new ScriptConfigSelectionListener(this));
            scenarioOptionsViewLoc.setSyncOptionListener((SelectionListener)new ScriptConfigSyncOptionListener(this));
            scenarioOptionsViewLoc.addScriptParamListener(VScriptParam.VScriptParamType.BOOL, (EventListener)((Object)new BoolParamSelectionListener(this)));
            scenarioOptionsViewLoc.addScriptParamListener(VScriptParam.VScriptParamType.BYTE_PATTERN_HEX, (EventListener)((Object)new BytePatternParamModifyListener(this)));
            scenarioOptionsViewLoc.addScriptParamListener(VScriptParam.VScriptParamType.INT_DEC, (EventListener)((Object)new DecIntegerParamKeyListener(this)));
            scenarioOptionsViewLoc.addScriptParamListener(VScriptParam.VScriptParamType.INT_HEX, (EventListener)((Object)new HexIntegerParamKeyListener(this)));
            scenarioOptionsViewLoc.addScriptParamListener(VScriptParam.VScriptParamType.INT_SIZE_DEC, (EventListener)((Object)new DecSizeIntegerParamKeyListener(this)));
            scenarioOptionsViewLoc.addScriptParamListener(VScriptParam.VScriptParamType.MULTI_OPT, (EventListener)((Object)new MultiOptParamSelectionListener(this)));
            scenarioOptionsViewLoc.addScriptParamListener(VScriptParam.VScriptParamType.TIME, (EventListener)((Object)new TimeParamListener(this)));
            scenarioOptionsViewLoc.setScriptCountEditingSupport(new ScriptConfigCountEditingSupport(this, (ColumnViewer)scenarioOptionsViewLoc.getScriptsTableViewer()));
        }
        this.view.getExecutionView().setVButtonSelectionListener((SelectionListener)new ValidationButtonListener(this));
        this.view.getScenarioView().setRestoreComponentListener((SelectionListener)new RestoreComponentPropertiesListener(this));
        this.view.getScenarioView().setAutoReportSelectionListener((SelectionListener)new AutoReportSelectionListener(this));
        this.view.getScenarioView().setReportSelectionListener((SelectionListener)new ReportSelectionListener(this, IReportGenerator.ReportType.JPG));
        this.view.getScenarioView().setExportLogSelectionListener((SelectionListener)new ReportSelectionListener(this, IReportGenerator.ReportType.LOG));
        this.view.getScenarioView().setSelectAllCellsListener((SelectionListener)new SelectAllCellsListener(this));
        this.view.getScenarioView().setSelectCellRegionListener((SelectionListener)new SelectCellRegionListener(this));
        this.view.getScenarioView().setInvertCellSelectionListener((SelectionListener)new InvertCellSelectionListener(this));
        this.view.getScenarioView().setToggleCellErrorColoringListener((SelectionListener)new ToggleCellErrorColoringListener(this));
    }

    private void attachUIListeners() {
        this.attachContentProviders();
        this.attachLabelProviders();
        this.attachSelectionListeners();
        this.attachPaintListeners();
        this.attachMouseListeners();
        this.attachMenuListeners();
    }

    private void createExecutionPresentation() {
        boolean enableV;
        this.execution = new ExecutionPresentationModel(this);
        VStagePresentation selectedStage = this.getSelectedStage();
        boolean bl = enableV = selectedStage != null && selectedStage.hasSelections() && !VPresentationModel.componentHasErrors();
        if (this.execution != null) {
            this.execution.resetUiData(enableV);
        }
        this.updateExecutionPresentationModel(true);
    }

    private void createValidationPresentation() {
        if (this.model != null) {
            VStage[] modelStages = this.model.getValidationModel().getValidationStages();
            ValidationPresentationModel validationLoc = this.validation = new ValidationPresentationModel(this);
            VStagePresentation[] stages = new VStagePresentation[modelStages.length];
            int i = 0;
            while (i < modelStages.length) {
                stages[i] = new VStagePresentation(validationLoc, Objects.requireNonNull(modelStages[i]));
                ++i;
            }
            validationLoc.setStages(stages);
            validationLoc.setConfigErrors(VPresentationModel.componentHasErrors());
            VStagePresentation[] vStagePresentationArray = stages;
            int n = stages.length;
            int n2 = 0;
            while (n2 < n) {
                VStagePresentation stage = vStagePresentationArray[n2];
                stage.cleanupAllScenarios();
                ++n2;
            }
        }
    }

    public void disposeView() {
        if (!this.view.isDisposed()) {
            this.view.dispose();
        }
    }

    public boolean generateAutoReport(long numExecTests, long startTime, long endTime, boolean forceGenerate) {
        if (!this.autoReportData.enabled) {
            return false;
        }
        boolean shouldGenerate = false;
        if (forceGenerate) {
            shouldGenerate = true;
        } else {
            switch (this.autoReportData.autoReportMode) {
                case SCRIPT: {
                    if (numExecTests <= 0L || numExecTests % (long)this.autoReportData.autoReportRepetition != 0L) break;
                    shouldGenerate = true;
                    break;
                }
                case SECOND: {
                    long numSeconds = (endTime - startTime) / 1000L;
                    if (numSeconds < (long)this.autoReportData.autoReportRepetition) break;
                    shouldGenerate = true;
                    break;
                }
                case MINUTE: {
                    long numMinutes = (endTime - startTime) / 1000L / 60L;
                    if (numMinutes < (long)this.autoReportData.autoReportRepetition) break;
                    shouldGenerate = true;
                    break;
                }
                case HOUR: {
                    long numHours = (endTime - startTime) / 1000L / 60L / 60L;
                    if (numHours < (long)this.autoReportData.autoReportRepetition) break;
                    shouldGenerate = true;
                }
            }
        }
        if (!shouldGenerate) {
            return false;
        }
        try {
            VStage stageLoc;
            if (this.session != null && (stageLoc = this.session.getStage()) != null) {
                VScenario[] scenarios = stageLoc.getVisibleScenarios();
                ArrayList<VTable> reportTableList = new ArrayList<VTable>();
                VScenario[] vScenarioArray = scenarios;
                int n = scenarios.length;
                int n2 = 0;
                while (n2 < n) {
                    VTable[] allTables;
                    VScenario scenario = vScenarioArray[n2];
                    VTable[] vTableArray = allTables = scenario.getSelectedTables();
                    int n3 = allTables.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        VTable.TableState state;
                        VTable table = vTableArray[n4];
                        if (table != null && ((state = table.getState()) == VTable.TableState.CANCELLED || state == VTable.TableState.FAILED || state == VTable.TableState.PASSED || state == VTable.TableState.RUNNING)) {
                            reportTableList.add(table);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (reportTableList.size() > 0) {
                    VTable[] reportTables = reportTableList.toArray(new VTable[reportTableList.size()]);
                    return Objects.requireNonNull(this.repGenMap.get((Object)this.autoReportData.getReportType())).generateReport(reportTables, this.autoReportData);
                }
            }
            return false;
        }
        catch (SecurityException se) {
            LOGGER.severe(se.getMessage());
            return false;
        }
    }

    public boolean generateReport(VTable[] tables) {
        if (tables.length > 0) {
            return Objects.requireNonNull(this.repGenMap.get((Object)this.reportData.getReportType())).generateReport(tables, this.reportData);
        }
        return false;
    }

    public IReportGenerator.AutoReportData getAutoReportData() {
        return this.autoReportData;
    }

    public @Nullable ExecutionPresentationModel getExecution() {
        return this.execution;
    }

    public String getId() {
        return UtilsText.safeString((String)this.id);
    }

    public @Nullable VModel getModel() {
        return this.model;
    }

    public IReportGenerator.ReportData getReportData() {
        return this.reportData;
    }

    public boolean getSkipSync() {
        return this.skipSync;
    }

    public void setSkipSync(boolean prevSync) {
        this.skipSync = prevSync;
    }

    public Scripts getScripts() {
        return Objects.requireNonNull(this.validation).getModel().getScripts();
    }

    public @Nullable VParamVariation getSelectedCell() {
        VScenarioPresentation selScenario = this.getSelectedScenario();
        if (selScenario != null) {
            return selScenario.getSelectedCell();
        }
        return null;
    }

    public @Nullable VScenarioPresentation getSelectedScenario() {
        VStagePresentation selStage;
        if (this.validation != null && (selStage = this.validation.getSelectedStage()) != null) {
            return selStage.getSelectedScenario();
        }
        return null;
    }

    public @Nullable VScenarioPresentation getScenarioPresentation(VScenario stageScenario) {
        VStagePresentation selStage;
        if (this.validation != null && (selStage = this.validation.getSelectedStage()) != null) {
            return selStage.getScenarioPresentation(stageScenario.getName());
        }
        return null;
    }

    public @Nullable VScenario getSelectedScenarioModel() {
        VScenarioPresentation selScenario = this.getSelectedScenario();
        return selScenario == null ? null : selScenario.getModel();
    }

    public VTable[] getSelectedScenarioTerminatedTables(boolean filterUnfinished) {
        VScenario scenarioModel = this.getSelectedScenarioModel();
        if (scenarioModel == null) {
            return new VTable[0];
        }
        VTable[] allTables = scenarioModel.getSelectedTables();
        ArrayList<VTable> tableList = new ArrayList<VTable>();
        VTable[] vTableArray = allTables;
        int n = allTables.length;
        int n2 = 0;
        while (n2 < n) {
            VTable table = vTableArray[n2];
            if (table != null) {
                VTable.TableState state = table.getState();
                if (state == VTable.TableState.CANCELLED || state == VTable.TableState.FAILED || state == VTable.TableState.PASSED) {
                    tableList.add(table);
                } else if (!filterUnfinished && state == VTable.TableState.PAUSED) {
                    tableList.add(table);
                }
            }
            ++n2;
        }
        return tableList.toArray(new VTable[tableList.size()]);
    }

    public @Nullable VScriptConfig getSelectedScriptConfigSnapshot() {
        VScenarioPresentation selScenario = this.getSelectedScenario();
        if (selScenario != null) {
            return selScenario.getSelectedScriptConfigSnapshot();
        }
        return null;
    }

    public @Nullable VStagePresentation getSelectedStage() {
        return this.validation != null ? this.validation.getSelectedStage() : null;
    }

    public @Nullable IDisplayFigure getSelectedTable() {
        VScenarioPresentation selScenario = this.getSelectedScenario();
        if (selScenario != null) {
            return selScenario.getSelectedTable();
        }
        return null;
    }

    public @Nullable VRunResult getSelectedTestRun() {
        VScenarioPresentation selScenario = this.getSelectedScenario();
        if (selScenario != null) {
            return selScenario.getSelectedRunResult();
        }
        return null;
    }

    public @Nullable VSessionModel getSession() {
        return this.session;
    }

    public @Nullable ValidationPresentationModel getValidationModel() {
        return this.validation;
    }

    public MainView getView() {
        return this.view;
    }

    public boolean isValidationInProgress() {
        ValidationPresentationModel validationLoc = this.validation;
        return validationLoc != null && validationLoc.isAnyJobRunning();
    }

    public boolean isViewDisposed() {
        return this.view == null || this.view.isDisposed();
    }

    public void onChangeSelectedTarget() {
    }

    public void onCleanup() {
    }

    public void onConditionChange(IConditionChangeListener.ChangeType type, Object data) {
        if (IConditionChangeListener.ChangeType.ACCESS_TYPE == type) {
            return;
        }
        ValidationContext vContext = ValidationContext.getInstance();
        vContext.setModel(this);
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            if (validationLoc.isAnyJobRunning()) {
                validationLoc.cancelJob(0);
            }
            boolean repopulateRegisters = false;
            Objects.requireNonNull(this.model).update(vContext, repopulateRegisters);
            validationLoc.onUpdateTableVisibility();
            String jobName = null;
            switch (type) {
                case PEX_PROPERTY: {
                    jobName = JobName.REFRESH_UI_ON_PEX_PROPERTY_CHANGE.name;
                    break;
                }
                case ACCESS_TYPE: {
                    jobName = JobName.REFRESH_UI_ON_ACCESS_TYPE_CHANGE.name;
                    break;
                }
                case ACTIVE_CPU: {
                    jobName = JobName.REFRESH_UI_ON_ACTIVE_CPU_CHANGE.name;
                    break;
                }
                case PROBE_TYPE: {
                    jobName = JobName.REFRESH_UI_ON_PROBE_CHANGE.name;
                }
            }
            this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.ALL, false), UtilsText.safeString((String)jobName));
        }
    }

    public void onConnectionLost() {
        ValidationPresentationModel validationLoc;
        ExecutionPresentationModel executionLoc = this.execution;
        if (executionLoc != null) {
            executionLoc.resetUiData(false);
            executionLoc.updateStartDecorator(ExecutionPresentationModel.DecoratorType.WARNING, Messages.WARN_DISCONNECTED);
        }
        if ((validationLoc = this.validation) != null) {
            if (validationLoc.isAnyJobRunning()) {
                validationLoc.cancelJob(0);
            }
            validationLoc.stopHighlight();
            this.updateUI(new ConnectionLostUIUpdater(this), JobName.REFRESH_UI_ON_VALIDATION_SERVICE_CONNECTION_LOST.name);
        }
    }

    public void onErrorStateChange(boolean hasErrors) {
        Objects.requireNonNull(this.validation).setConfigErrors(hasErrors);
        this.updateExecutionPresentationModel(true);
        String jobName = hasErrors ? JobName.REFRESH_UI_ON_COMPONENT_ERRORS_APPEAR.name : JobName.REFRESH_UI_ON_COMPONENT_ERRORS_DISAPPEAR.name;
        this.updateUI(new ErrorStateChangeUIUpdater(this), jobName);
    }

    public void onInvertCellSelection() {
        VScenarioPresentation scenario = this.getSelectedScenario();
        if (scenario != null) {
            scenario.getModel().invertCellSelection();
            scenario.updateTableContents();
            this.updateExecutionPresentationModel(true);
            this.updateUI(new TableFigureRefreshUpdater(this, true), JobName.REFRESH_UI_ON_INVERT_CELL_SELECTIONS.name);
        }
    }

    public void onRestoreComponentProperties() {
        this.updateUI(new RefreshRestoreTool(this, false), JobName.REFRESH_UI_ON_RESTORE_COMPONENT_PROPERTIES.name);
    }

    public void onScenarioCanvasMouseDown(@Nullable MouseEvent e) {
        if (this.getSelectedScenario() == null || e == null) {
            return;
        }
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            ValidationPresentationModel.SelectionToolType selType = validationLoc.getActiveToolType();
            SelectCellRegionDrawTool cellRegionTool = validationLoc.getSelectCellRegionTool();
            if (cellRegionTool != null && selType == ValidationPresentationModel.SelectionToolType.SELECT_REGION) {
                if (e.button == 1) {
                    cellRegionTool.setStart(new Point(e.x, e.y));
                    cellRegionTool.setEnd(new Point(e.x, e.y));
                    cellRegionTool.setActive(true);
                } else {
                    validationLoc.setActiveToolType(ValidationPresentationModel.SelectionToolType.SELECT_CELL);
                    cellRegionTool.setActive(false);
                }
                this.updateUI(new TableFigureRefreshUpdater(this, true), JobName.REFRESH_UI_ON_SCENARIO_CANVAS_MOUSE_DOWN.name);
            }
        }
    }

    public void onScenarioCanvasMouseMove(@Nullable MouseEvent e) {
        ValidationPresentationModel.SelectionToolType selType;
        if (this.getSelectedScenario() == null || e == null) {
            return;
        }
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null && (selType = validationLoc.getActiveToolType()) == ValidationPresentationModel.SelectionToolType.SELECT_REGION) {
            SelectCellRegionDrawTool tool = validationLoc.getSelectCellRegionTool();
            if (tool != null) {
                tool.setEnd(new Point(e.x, e.y));
            }
            this.updateUI(new TableFigureRefreshUpdater(this, false), JobName.REFRESH_UI_ON_SCENARIO_CANVAS_MOUSE_MOVE.name);
        }
    }

    public void onScenarioCanvasMouseUp(@Nullable MouseEvent e) {
        if (this.getSelectedScenario() == null) {
            return;
        }
        ValidationPresentationModel.SelectionToolType activeTool = Objects.requireNonNull(this.validation).getActiveToolType();
        if (e != null) {
            switch (activeTool) {
                case SELECT_CELL: {
                    this.onSelectCell(new Point(e.x, e.y), false);
                    break;
                }
                case SELECT_REGION: {
                    boolean ctrlPressed = (e.stateMask & 0x40000) != 0;
                    this.onSelectCellRegionEnd(new Point(e.x, e.y), ctrlPressed);
                }
            }
        }
    }

    public void onSelectAllCells() {
        VScenarioPresentation scenario = this.getSelectedScenario();
        if (scenario != null) {
            scenario.getModel().selectAllCells();
            this.updateExecutionPresentationModel(true);
            scenario.updateTableContents();
            this.updateUI(new TableFigureRefreshUpdater(this, true), JobName.REFRESH_UI_ON_SELECT_ALL_CELL.name);
        }
    }

    public void onSelectCell(Point clickPoint, boolean applyConfiguration) {
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            boolean selectionOk = validationLoc.onSelectCell(clickPoint);
            if (!selectionOk) {
                return;
            }
            if (validationLoc.isAnyJobRunning()) {
                this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.SELECT_CELL, false), JobName.REFRESH_UI_ON_CELL_SELECTION_DURING_VALIDATION.name);
                return;
            }
            VParamVariation selCell = this.getSelectedCell();
            if (selCell == null) {
                return;
            }
            VTable selTable = selCell.getParent();
            if (selTable.getOptions().allowUserVariation() && (selTable.getState() == VTable.TableState.PASSED || selTable.getState() == VTable.TableState.CANCELLED) && selCell.getState() == VParamVariation.VState.PASSED && !selTable.hasScriptParam()) {
                VParamVariation userCell = selCell != selTable.getGoldenVariation() ? selCell : null;
                VParamVariation applyCell = userCell == null ? selTable.getGoldenVariation() : userCell;
                selTable.setUserVariation(userCell);
                if (applyCell != null && applyConfiguration) {
                    applyCell.applyConfiguration(true, false);
                }
            }
            this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.SELECT_CELL, false), JobName.REFRESH_UI_ON_CELL_SELECTION_DURING_VALIDATION.name);
        }
    }

    public void onSelectCellRegion() {
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            if (validationLoc.isAnyJobRunning()) {
                return;
            }
            validationLoc.setActiveToolType(ValidationPresentationModel.SelectionToolType.SELECT_REGION);
        }
    }

    public void onSelectCellRegionEnd(Point p, boolean ctrlPressed) {
        Objects.requireNonNull(this.validation).onSelectCellRegionEnd(p, ctrlPressed);
        this.updateExecutionPresentationModel(true);
        this.updateUI(new TableFigureRefreshUpdater(this, true), JobName.REFRESH_UI_ON_SCENARIO_CANVAS_MOUSE_UP.name);
    }

    public void onSelectedTargetVerificationComplete() {
        this.updateExecutionPresentationModel(false);
        if (!this.isViewDisposed()) {
            this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.SELECT_STAGE, false), JobName.REFRESH_UI_ON_TARGET_CONNECTIVITY_CHECK_FINISHED.name);
        }
    }

    public void onSelectedTargetVerificationInit() {
        this.updateExecutionPresentationModel(false);
        if (!this.isViewDisposed()) {
            this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.ALL, false), JobName.REFRESH_UI_ON_TARGET_CONNECTIVITY_CHECK_STARTED.name);
        }
    }

    public void onTablesRuntimeUpdate(VTable[] tables) {
        if (tables.length == 0) {
            return;
        }
        VTable firstTable = tables[0];
        IScenarioElement parent = firstTable.getParent();
        if (parent != null) {
            VStagePresentation[] stages;
            IScenarioElement firstTableScenario = parent.getParent();
            VScenarioPresentation scenData = null;
            ValidationPresentationModel validationLoc = this.validation;
            if (validationLoc != null && (stages = validationLoc.getStages()) != null) {
                Object[] objectArray = stages;
                int n = stages.length;
                int n2 = 0;
                while (n2 < n) {
                    VStagePresentation stage = objectArray[n2];
                    scenData = stage.getFigure(firstTableScenario);
                    if (scenData != null) break;
                    ++n2;
                }
                if (scenData != null) {
                    objectArray = tables;
                    n = tables.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object table = objectArray[n2];
                        if (table != null) {
                            scenData.refreshTableFigure((VTable)table);
                        }
                        ++n2;
                    }
                    scenData.setComputed(false);
                }
            }
        }
        this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.ALL, false), JobName.REFRESH_UI_ON_WRITE_MARGIN_DYNAMIC_TABLE_UPDATES.name);
    }

    public void onToggleCellErrorColoring() {
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            boolean enabled = !validationLoc.isCellErrorColoringEnabled();
            validationLoc.enableCellErrorColoring(enabled);
            this.view.getScenarioView().updateLegend();
        }
        this.updateUI(new TableFigureRefreshUpdater(this, false), JobName.REFRESH_UI_ON_TOGGLE_CELL_ERROR_COLOURING.name);
    }

    public void onValidationCancel() {
        this.updateUI(new ExecutionStageDisabler(this), JobName.DISABLE_EXECUTION_VIEW_ON_VALIDATION_CANCEL.name);
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null && validationLoc.isAnyJobRunning()) {
            validationLoc.cancelJob(0);
        }
    }

    public void onValidationCancelled(VStage stage, VScenario scenario, VTable[] tables, int tableIdx, @Nullable VParamVariation cell, boolean unlockSuccess) {
        if (cell == null) {
            cell = tables[0].getParamVariation(new Point(0, 0));
        }
        VParamVariation firstCellSkip = cell;
        int i = tableIdx;
        while (i < tables.length) {
            tables[i].skipFrom(firstCellSkip);
            tables[i].setState(VTable.TableState.CANCELLED);
            if (tables[i].getOptions().restoreConfigEn()) {
                tables[i].restoreInitialComponentConfig();
            }
            firstCellSkip = null;
            ++i;
        }
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            ExecutionPresentationModel executionLoc;
            validationLoc.setChangedEnabled(true);
            firstCellSkip = cell;
            int i2 = tableIdx;
            while (i2 < tables.length) {
                validationLoc.onValidationTableFinish(stage, scenario, tables[i2], true, firstCellSkip);
                firstCellSkip = null;
                ++i2;
            }
            VSessionModel sessionLoc = this.session;
            if (sessionLoc != null && (executionLoc = this.execution) != null) {
                executionLoc.setStartMode(ExecutionPresentationModel.StartValidationMode.VALIDATE);
            }
            validationLoc.waitForAnyJobToFinish();
            if (!this.isViewDisposed()) {
                if (!unlockSuccess) {
                    this.updateUI(new ScenarioFinishUiUpdater(this, true, UNLOCK_TARGET_FAIL_MSG), JobName.REFRESH_UI_ON_VALIDATION_CANCELLED.name);
                } else {
                    this.updateUI(new ScenarioFinishUiUpdater(this), JobName.REFRESH_UI_ON_VALIDATION_CANCELLED.name);
                }
            }
            validationLoc.stopHighlight();
        }
    }

    public void onValidationCellFinish(VSessionModel.VEvent event, boolean updateUI) {
        VParamVariation cel;
        VParamVariation.StateUpdatePolicy updatePolicy = VParamVariation.StateUpdatePolicy.createDefaultPolicy();
        VScenario scenario = event.getScenario();
        @Nullable VParamVariation[] cells = event.getCells();
        int primaryCellIndex = event.getPrimaryCellIndex();
        if (primaryCellIndex != -1 && cells != null && (cel = cells[primaryCellIndex]) != null) {
            cells = new VParamVariation[]{cel};
        }
        if (cells != null) {
            VParamVariation[] vParamVariationArray = cells;
            int n = cells.length;
            int n2 = 0;
            while (n2 < n) {
                VParamVariation cell = vParamVariationArray[n2];
                if (cell != null) {
                    this.onValidationCellFinish(Objects.requireNonNull(this.session).getStage(), scenario, cell, updatePolicy, updateUI);
                }
                ++n2;
            }
        }
    }

    public void onLogUpdate(String log, boolean append) {
        this.updateUI(new LogViewUpdater(this, log, append), JobName.REFRESH_UI_ON_NEW_LOG.name);
    }

    public void onPeriodicUpdate() {
        this.updateUI(new RealTimeUpdater(this), JobName.REFRESH_UI_PERIODICALLY.name);
    }

    public void onValidationCellFinish(VStage stage, VScenario scenario, VParamVariation cell, VParamVariation.StateUpdatePolicy updatePolicy) {
        this.onValidationCellFinish(stage, scenario, cell, updatePolicy, true);
    }

    public void onValidationCellFinish(@Nullable VStage stage, VScenario scenario, VParamVariation cell, VParamVariation.StateUpdatePolicy updatePolicy, boolean updateUI) {
        cell.updateStateFromRunResults(updatePolicy);
        if (stage != null) {
            Objects.requireNonNull(this.validation).onValidationCellFinished(stage, scenario, cell);
        }
        this.updateUI(new TimeoutReachedUiUpdater(this, Messages.CloseExecTimeoutMsg), JobName.REFRESH_UI_ON_NEW_CELL_VALIDATION_FINISH.name);
        if (updateUI && scenario == this.getSelectedScenarioModel()) {
            this.updateUI(new RunResultsUiUpdater(this, cell), JobName.REFRESH_UI_ON_NEW_CELL_VALIDATION_FINISH.name);
        }
    }

    public void onValidationCellSkip(VStagePresentation stage, VScenario scenario, VTable table, VParamVariation cell, VParamVariation.StateUpdatePolicy cellStatePolicy) {
        cell.skipRemainingRuns();
        cell.updateStateFromRunResults(cellStatePolicy);
        Objects.requireNonNull(this.validation).onValidationCellSkip(stage, scenario, table, cell);
        if (scenario == this.getSelectedScenarioModel()) {
            this.updateUI(new RunResultsUiUpdater(this, cell), JobName.REFRESH_UI_ON_NEW_CELL_SKIPPED.name);
        }
    }

    public void onValidationCellStart(VSessionModel.VEvent event, boolean updateUI) {
        VTable[] tables = event.getTables();
        VStage stageLoc = Objects.requireNonNull(this.session).getStage();
        @Nullable VParamVariation[] cells = event.getCells();
        if (stageLoc != null && cells != null) {
            int tablesLength = tables.length;
            int i = 0;
            while (i < tablesLength) {
                VTable ti = tables[i];
                VParamVariation ci = cells[i];
                if (ci != null) {
                    Objects.requireNonNull(this.validation).onUpdateRunningCell(stageLoc, event.getScenario(), ti, ci);
                }
                ++i;
            }
        }
        if (updateUI && event.getScenario() == this.getSelectedScenarioModel()) {
            this.updateUI(new TableFigureRefreshUpdater(this, false), JobName.REFRESH_UI_ON_NEW_CELL_VALIDATION.name);
        }
    }

    public void onValidationCellStart(VStage stage, VScenario scenario, VTable table, VParamVariation cell, boolean updateUI) {
        Objects.requireNonNull(this.validation).onUpdateRunningCell(stage, scenario, table, cell);
        if (updateUI && scenario == this.getSelectedScenarioModel()) {
            this.updateUI(new TableFigureRefreshUpdater(this, false), JobName.REFRESH_UI_ON_NEW_CELL_VALIDATION.name);
        }
    }

    public void onValidationCodegenError(VStage stage, VScenario scenario, VTable[] tables, int tableIdx, VParamVariation cell, boolean targetUnlockSuccess) {
        VParamVariation firstCellSkip = cell;
        int i = tableIdx;
        while (i < tables.length) {
            tables[i].skipFrom(firstCellSkip);
            tables[i].setState(VTable.TableState.CANCELLED);
            firstCellSkip = null;
            ++i;
        }
        cell.setState(VParamVariation.VState.ERR_CODEGEN);
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            int i2 = tableIdx;
            while (i2 < tables.length) {
                validationLoc.onValidationTableFinish(stage, scenario, tables[tableIdx]);
                ++i2;
            }
            ExecutionPresentationModel executionLoc = this.execution;
            if (executionLoc != null && Objects.requireNonNull(this.session).isFirstScenario()) {
                executionLoc.resetUiData(false);
            }
            this.updateUI(new ExecutionStageDisabler(this), JobName.DISABLE_UI_ON_CGEN_EXCEPTION.name);
            validationLoc.waitForAnyJobToFinish();
        }
        this.updateUI(new ScenarioFinishUiUpdater(this, true, targetUnlockSuccess ? CODEGEN_ERRORS_MSG : UNLOCK_TARGET_FAIL_MSG), JobName.REFRESH_UI_ON_VALIDATION_CGEN_EXCEPTION.name);
    }

    public void onValidationConfigError(VStage stage, VScenario scenario, VTable[] tables, int tableIdx, VParamVariation cell, boolean unlockTargetSuccess) {
        VParamVariation firstCellSkip = cell;
        int i = tableIdx;
        while (i < tables.length) {
            tables[i].skipFrom(firstCellSkip);
            tables[i].setState(VTable.TableState.CANCELLED);
            firstCellSkip = null;
            ++i;
        }
        cell.setState(VParamVariation.VState.ERR_CONFIG);
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            int i2 = tableIdx;
            while (i2 < tables.length) {
                validationLoc.onValidationTableFinish(stage, scenario, tables[tableIdx]);
                ++i2;
            }
            ExecutionPresentationModel executionLoc = this.execution;
            if (executionLoc != null && Objects.requireNonNull(this.session).isFirstScenario()) {
                executionLoc.resetUiData(false);
            }
            this.updateUI(new ExecutionStageDisabler(this), JobName.DISABLE_EXECUTION_VIEW_ON_CONFIG_ERRORS.name);
            validationLoc.waitForAnyJobToFinish();
        }
        this.updateUI(new ScenarioFinishUiUpdater(this, true, unlockTargetSuccess ? CONFIG_ERRORS_MSG : UNLOCK_TARGET_FAIL_MSG), JobName.REFRESH_UI_ON_CONFIG_ERRORS_DURING_VALIDATION.name);
    }

    public void onValidationEnd(VStage stage, VScenario scenario, boolean targetUnlockSuccess) {
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            VStagePresentation stagePres = validationLoc.getStage(stage.getName());
            VPresentationModel.trace(String.format("DDRVPresentationModel.onValidationEnd(stage=%s, scenario=%s, targetUnlockSuccess=%b)", stage.getName(), scenario.getName(), new Boolean(targetUnlockSuccess)));
            if (stagePres != null || Objects.requireNonNull(this.session).isLastScenario()) {
                validationLoc.setChangedEnabled(true);
                VStagePresentation stagePresentation = validationLoc.getStage(stage.getName());
                if (stagePresentation != null) {
                    stagePresentation.setScenarioAutoSelected(false);
                }
                if (Objects.requireNonNull(this.session).isLastScenario()) {
                    this.updateExecutionPresentationModel(true);
                } else {
                    ExecutionPresentationModel executionLoc = this.execution;
                    if (executionLoc != null) {
                        executionLoc.resetUiData(true);
                        if (scenario.getCompoundState() == VTable.TableState.PASSED) {
                            executionLoc.setStartMode(ExecutionPresentationModel.StartValidationMode.NEXT_STEP);
                        }
                    }
                    this.updateExecutionPresentationModel(false);
                }
                validationLoc.waitForAnyJobToFinish();
                this.updateUI(new ScenarioFinishUiUpdater(this, !targetUnlockSuccess, targetUnlockSuccess ? null : UNLOCK_TARGET_FAIL_MSG), JobName.REFRESH_UI_ON_VALIDATION_END.name);
                validationLoc.stopHighlight();
            } else {
                this.updateUI(new ExecutionStageDisabler(this), JobName.DISABLE_EXECUTION_VIEW_ON_VALIDATION_END.name);
                validationLoc.waitForAnyJobToFinish();
                validationLoc.stopHighlight();
                this.onValidationNextStep();
            }
        }
    }

    public void onValidationLockTargetFail(VStage stage) {
        ExecutionPresentationModel executionLoc = this.execution;
        if (executionLoc != null && Objects.requireNonNull(this.session).isFirstScenario()) {
            executionLoc.resetUiData(true);
        }
        this.updateUI(new ScenarioFinishUiUpdater(this, true, LOCK_TARGET_FAIL_MSG), JobName.REFRESH_UI_ON_VALIDATION_LOCK_FAILS.name);
    }

    public void onValidationNextStep() {
        VStagePresentation stagePresentation;
        VStage stage = Objects.requireNonNull(this.session).getStage();
        if (stage != null && (stagePresentation = Objects.requireNonNull(this.validation).getStage(stage.getName())) != null) {
            this.scheduleValidationJob(stagePresentation, true);
        }
        this.updateUI(new ValidationStartUiUpdater(this), JobName.REFRESH_UI_ON_VALIDATION_NEXT_STEP.name);
        this.updateCellHighlighting();
    }

    public void onValidationResume() {
        VSessionModel.VEvent event;
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null && (event = validationLoc.getResumeEvent()) != null) {
            VStagePresentation stagePresentation;
            VTable[] tables;
            VTable[] vTableArray = tables = event.getTables();
            int n = tables.length;
            int n2 = 0;
            while (n2 < n) {
                VTable table = vTableArray[n2];
                if (table != null) {
                    table.setState(VTable.TableState.RUNNING);
                }
                ++n2;
            }
            VStage stage = Objects.requireNonNull(this.session).getStage();
            if (stage != null && (stagePresentation = validationLoc.getStage(stage.getName())) != null) {
                this.setSelectedStage(stagePresentation, false);
                stagePresentation.setSelectedScenarioElement(event.getScenario());
                stagePresentation.setScenarioAutoSelected(true);
                this.scheduleValidationJob(stagePresentation, true);
            }
        }
        this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.RESUMED, false), JobName.REFRESH_UI_ON_VALIDATION_RESUME.name);
        this.updateCellHighlighting();
    }

    public void onValidationRunResults(VStage stage, VScenario scenario, VRunResult result) {
        this.onValidationRunResults(stage, scenario, result, true);
    }

    public void onValidationRunResults(VStage stage, VScenario scenario, VRunResult result, boolean refreshUI) {
        Objects.requireNonNull(this.validation).onValidationRunResults(stage, scenario, result);
        VStagePresentation stageLoc = this.getSelectedStage();
        if (stageLoc != null && refreshUI && stage == stageLoc.getModel()) {
            this.updateUI(new RunResultsUiUpdater(this, result.getParamVariation()), JobName.REFRESH_UI_ON_NEW_TEST_RESULTS.name);
        }
    }

    public void onValidationRunResults(VStage stage, VScenario scenario, VRunResult[] results) {
        this.onValidationRunResults(stage, scenario, results, true);
    }

    public void onValidationRunResults(VStage stage, VScenario scenario, VRunResult[] results, boolean refreshUI) {
        VRunResult[] vRunResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            VRunResult result = vRunResultArray[n2];
            Objects.requireNonNull(this.validation).onValidationRunResults(stage, scenario, result);
            ++n2;
        }
        VStagePresentation stageLoc = this.getSelectedStage();
        if (stageLoc != null && stage == stageLoc.getModel()) {
            VParamVariation[] cells = new VParamVariation[results.length];
            int i = 0;
            while (i < results.length) {
                cells[i] = results[i].getParamVariation();
                ++i;
            }
            if (refreshUI) {
                this.updateUI(new RunResultsUiUpdater(this, cells), JobName.REFRESH_UI_ON_NEW_TEST_RESULTS.name);
            }
        }
    }

    public void onValidationServerTimeout(VStage stage, VScenario scenario, VTable[] tables, int tableIdx, @Nullable VParamVariation cell, boolean unlockTargetSuccess) {
        VParamVariation firstCellSkip = cell;
        int i = tableIdx;
        while (i < tables.length) {
            tables[i].skipFrom(firstCellSkip);
            tables[i].setState(VTable.TableState.CANCELLED);
            firstCellSkip = null;
            ++i;
        }
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            validationLoc.setChangedEnabled(true);
            int i2 = tableIdx;
            while (i2 < tables.length) {
                validationLoc.onValidationTableFinish(stage, scenario, tables[tableIdx]);
                ++i2;
            }
            VSessionModel sessionLoc = this.session;
            ExecutionPresentationModel executionLoc = this.execution;
            if (sessionLoc != null && executionLoc != null && sessionLoc.isLastScenario()) {
                executionLoc.resetUiData(true);
            }
            this.updateUI(new ExecutionStageDisabler(this), JobName.DISABLE_UI_ON_VSERVER_TIMEOUT.name);
            validationLoc.waitForAnyJobToFinish();
            if (unlockTargetSuccess) {
                if (scenario == this.getSelectedScenarioModel()) {
                    this.updateUI(new ScenarioFinishUiUpdater(this, false, SERVER_TIMEOUT_ERROR_MSG), JobName.REFRESH_UI_ON_VSERVER_TIMEOUT.name);
                }
            } else {
                this.updateUI(new ScenarioFinishUiUpdater(this, false, UNLOCK_TARGET_FAIL_MSG), JobName.REFRESH_UI_ON_VSERVER_TIMEOUT.name);
            }
        }
    }

    public void onValidationStart() {
        VStagePresentation stage;
        ValidationPresentationModel validationLoc = this.validation;
        ExecutionPresentationModel executionLoc = this.execution;
        if (validationLoc != null && executionLoc != null && (stage = validationLoc.getSelectedStage()) != null) {
            stage.cleanupSelectedScenarios();
            stage.resetSelectedScenarios();
            stage.selectFirstRunningCell();
            validationLoc.setChangedEnabled(false);
            executionLoc.setStartMode(ExecutionPresentationModel.StartValidationMode.CANCEL);
            this.scheduleValidationJob(stage, false);
            this.updateUI(new ValidationStartUiUpdater(this), JobName.REFRESH_UI_ON_VALIDATION_START.name);
            validationLoc.startHighlight();
        }
    }

    public void onValidationTableFinish(VSessionModel.VEvent event) {
        VScenario scenario = event.getScenario();
        VTable[] tables = event.getTables();
        @Nullable VParamVariation[] cells = event.getCells();
        VStage stageLoc = Objects.requireNonNull(this.session).getStage();
        if (stageLoc != null && cells != null) {
            int tablesLength = tables.length;
            int i = 0;
            while (i < tablesLength) {
                VTable table = tables[i];
                VParamVariation cell = cells[i];
                if (cell != null) {
                    this.onValidationTableFinish(stageLoc, scenario, table, cell);
                }
                ++i;
            }
        }
    }

    public void onValidationTableFinish(VStage stage, VScenario scenario, VTable table, boolean passed) {
        table.setState(passed ? VTable.TableState.PASSED : VTable.TableState.FAILED);
        if (!table.hasScriptParam() && table.getOptions().precomputeGoldenVariation()) {
            this.selectGoldenCell(table, false);
        }
        Objects.requireNonNull(this.validation).onValidationTableFinish(stage, scenario, table);
        if (scenario == this.getSelectedScenarioModel()) {
            this.updateUI(new TableFinishUiUpdater(this, table), JobName.REFRESH_UI_ON_VTABLE_CUSTOM_FINISHED.name);
        }
    }

    public void onValidationTableFinish(VStage stage, VScenario scenario, VTable table, VParamVariation cell) {
        this.onValidationCellFinish(stage, scenario, cell, VParamVariation.StateUpdatePolicy.createDefaultPolicy());
        boolean passed = TablePassedVerifier.verify(table);
        table.setState(passed ? VTable.TableState.PASSED : VTable.TableState.FAILED);
        if (!table.hasScriptParam() && table.getOptions().precomputeGoldenVariation()) {
            this.selectGoldenCell(table, false);
        }
        Objects.requireNonNull(this.validation).onValidationTableFinish(stage, scenario, table);
        if (scenario == this.getSelectedScenarioModel()) {
            this.updateUI(new TableFinishUiUpdater(this, table), JobName.REFRESH_UI_ON_VTABLE_FINISHED.name);
        }
    }

    public void onValidationTableSkip(VStage stage, VScenario scenario, VTable table, VParamVariation cell) {
        table.skipFrom(cell);
        Objects.requireNonNull(this.validation).onValidationTableSkip(stage, scenario, table, cell);
        if (scenario == this.getSelectedScenarioModel()) {
            this.updateUI(new RunResultsUiUpdater(this, cell), JobName.REFRESH_UI_ON_VTABLE_SKIP.name);
        }
    }

    public void onValidationTargetError(VStage stage) {
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            VPresentationModel.trace(String.format("DDRVPresentationModel.onValidationEnd(stage=%s)", stage.getName()));
            validationLoc.setChangedEnabled(true);
            this.updateExecutionPresentationModel(true);
            this.updateUI(new ScenarioFinishUiUpdater(this, true, Messages.TargetConnectionFailed_0), JobName.REFRESH_UI_ON_VALIDATION_END.name);
            validationLoc.stopHighlight();
        }
    }

    public void onValidationUnlockTargetFail(VStagePresentation stage) {
        Objects.requireNonNull(this.execution).resetUiData(true);
        this.updateUI(new ScenarioFinishUiUpdater(this, true, UNLOCK_TARGET_FAIL_MSG), JobName.REFRESH_UI_ON_VALIDATION_UNLOCK_FAILS.name);
    }

    public void onViewDispose() {
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            validationLoc.stopHighlight();
            this.disposeView();
            validationLoc.cancelJob(5000);
        }
    }

    public void openFileInEditor(@Nullable File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return;
        }
        IFileStore fileOnLocalDisk = EFS.getLocalFileSystem().getStore(file.toURI());
        FileStoreEditorInput editorInput = new FileStoreEditorInput(fileOnLocalDisk);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            try {
                if (page != null) {
                    page.openEditor((IEditorInput)editorInput, "org.eclipse.ui.DefaultTextEditor");
                }
            }
            catch (PartInitException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    public void openScriptInEditor(VScript script) {
        VScript.VScriptTemplate[] templates = script.getTemplates();
        ValidationContext vContext = ValidationContext.getInstance();
        vContext.setModel(this);
        VScript.VScriptTemplate activeTemplate = null;
        VScript.VScriptTemplate[] vScriptTemplateArray = templates;
        if (templates.length != 0) {
            VScript.VScriptTemplate template;
            activeTemplate = template = vScriptTemplateArray[0];
        }
        if (activeTemplate != null) {
            this.openFileInEditor(new File(activeTemplate.getFilePath()));
        }
    }

    public void resetView(Composite parentView) {
        Control[] controlArray = parentView.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control contr = controlArray[n2];
            if (!contr.isDisposed()) {
                contr.dispose();
            }
            ++n2;
        }
        this.view = new MainView(parentView);
        CellResultsMainView cellView = this.view.getCellResultsMainView();
        if (cellView != null) {
            cellView.createPhyDebugView();
        }
        parentView.pack();
        Composite parentComposite = parentView.getParent();
        if (parentComposite != null) {
            parentComposite.layout(true);
        }
        this.attachUIListeners();
        if (this.validation != null) {
            this.validation.resetView();
        }
        this.updateUI(new RefreshUIRunnable(this), JobName.REFRESH_UI_ON_RESET_VIEW.name);
    }

    private void scheduleValidationJob(VStagePresentation stage, boolean resume) {
        ARunResultsUpdaterListener handler;
        VScenario diagsTxEye = stage.getModel().getScenario(VScenario.ScenarioType.DIAG_TX_EYE);
        VScenario diagsRxEye = stage.getModel().getScenario(VScenario.ScenarioType.DIAG_RX_EYE);
        VScenario caBusEye = stage.getModel().getScenario(VScenario.ScenarioType.CA_BUS);
        VScenarioPresentation scen = stage.getSelectedScenario();
        String script = null;
        if (scen != null) {
            script = scen.getCheckedScript();
        }
        if (diagsRxEye != null && diagsRxEye.isSelected() && diagsRxEye.getCompoundState() == VTable.TableState.CLEAN || diagsTxEye != null && diagsTxEye.isSelected() && diagsTxEye.getCompoundState() == VTable.TableState.CLEAN) {
            this.session = new VSessionModel(stage.getModel(), true);
            handler = new DiagsEyeResultHandler(this);
            this.setProgressIndicator(handler);
        } else if (caBusEye != null && caBusEye.isSelected() && caBusEye.getCompoundState() == VTable.TableState.CLEAN) {
            this.session = new VSessionModel(stage.getModel(), true);
            handler = new CABusEyeResultHandler(this);
            this.setProgressIndicator(handler);
        } else if (script != null && scen != null && scen.getModel().getName().contains("Lane") && (script.equals(VScenario.ScenarioType.JITTER_SCOPE.name) || script.equals(VScenario.ScenarioType.PATTERN_INDEP_JITTER_SCOPE.name))) {
            this.session = new VSessionModel(stage.getModel(), true);
            handler = new JitterEyeResultHandler(this);
            this.setProgressIndicator(handler);
        } else {
            if (!resume) {
                this.session = new VSessionModel(stage.getModel(), false);
                this.setProgressIndicator(this.session);
            }
            handler = new RunResultsUpdaterListener(this);
        }
        Objects.requireNonNull(this.validation).scheduleJob(stage, handler, resume);
    }

    public void selectGoldenCell(VTable table, boolean applyCell) {
        if (table.getState() != VTable.TableState.PASSED || table.isWriteMargins() || table.isReadMargins()) {
            return;
        }
        String tableId = table.getId();
        VParamVariation[][] cells = table.getParamVariations();
        VParamVariation goldCell = null;
        goldCell = this.standardSelector.selectBestOption(cells, tableId);
        if (goldCell != null) {
            table.setGoldenVariation(goldCell);
            if (applyCell) {
                goldCell.applyConfiguration(true, false);
            }
        }
    }

    public void setInput(@Nullable ConfigManager configManager, ValidationContext vContext) {
        if (configManager != null) {
            this.model = VModel.newInstance(vContext, configManager);
            if (this.model != null) {
                this.createValidationPresentation();
                this.createExecutionPresentation();
                this.repGenMap.put(IReportGenerator.ReportType.HTML, new HtmlReportGenerator());
                this.repGenMap.put(IReportGenerator.ReportType.CSV, new CsvReportGenerator());
                this.repGenMap.put(IReportGenerator.ReportType.EXCEL, new XlsReportGenerator());
                this.repGenMap.put(IReportGenerator.ReportType.JPG, new ImageReportGenerator(this, IReportGenerator.ReportType.JPG));
                this.repGenMap.put(IReportGenerator.ReportType.PNG, new ImageReportGenerator(this, IReportGenerator.ReportType.PNG));
                this.repGenMap.put(IReportGenerator.ReportType.LOG, new LogReportGenerator(this, IReportGenerator.ReportType.LOG));
            }
        } else {
            this.model = null;
        }
        this.updateUI(new RefreshUIRunnable(this), JobName.REFRESH_UI_ON_MODEL_CREATION.name);
    }

    public void setProgressIndicator(IProgressIndicator progressIndicator) {
        this.stageTreeLabelProvider.setProgressIndicator(progressIndicator);
    }

    public void setSelectedScenario(IScenarioElement elem, boolean updateChecked, boolean isChecked) {
        ValidationPresentationModel validationLoc = this.validation;
        ExecutionPresentationModel executionLoc = this.execution;
        if (validationLoc != null && executionLoc != null) {
            if (!validationLoc.setSelectedScenario(elem, updateChecked, isChecked)) {
                return;
            }
            validationLoc.setActiveToolType(ValidationPresentationModel.SelectionToolType.SELECT_CELL);
            if (updateChecked && executionLoc.hasStageInProgress()) {
                this.updateExecutionPresentationModel(true);
            }
            if (!validationLoc.isAnyJobRunning() && !executionLoc.hasStageInProgress()) {
                this.updateExecutionPresentationModel(true);
            }
            this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.SELECT_SCENARIO, updateChecked), JobName.REFRESH_UI_ON_VSCENARIO_SELECTION.name);
            if (!updateChecked) {
                this.updateCellHighlighting();
            }
        }
    }

    public void setSelectedStage(VStagePresentation selectedStage, boolean refreshBlink) {
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            validationLoc.setSelectedStage(selectedStage);
            validationLoc.setActiveToolType(ValidationPresentationModel.SelectionToolType.SELECT_CELL);
            boolean resetData = !validationLoc.isAnyJobRunning() && !Objects.requireNonNull(this.execution).hasStageInProgress();
            this.updateExecutionPresentationModel(resetData);
            this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.SELECT_STAGE, false), JobName.REFRESH_UI_ON_VSTAGE_SELECTION.name);
            if (refreshBlink) {
                this.updateCellHighlighting();
            }
        }
    }

    public void updateCellHighlighting() {
        VScenario scenarioLoc = this.getSelectedScenarioModel();
        ValidationPresentationModel validationLoc = this.validation;
        if (validationLoc != null) {
            if (scenarioLoc != null && scenarioLoc.getCompoundState() == VTable.TableState.RUNNING) {
                validationLoc.startHighlight();
            } else {
                validationLoc.stopHighlight();
            }
        }
    }

    public void updateExecutionPresentationModel(boolean resetData) {
        ValidationPresentationModel validationLoc = this.validation;
        ExecutionPresentationModel executionLoc = this.execution;
        VStagePresentation selectedStage = this.getSelectedStage();
        VScenarioPresentation selectedScenario = this.getSelectedScenario();
        if (validationLoc != null && executionLoc != null && selectedStage != null && selectedScenario != null) {
            VStage stage;
            boolean enableStartButton;
            boolean hasSelections = selectedStage.hasSelections();
            boolean configErrors = VPresentationModel.componentHasErrors();
            boolean connectionErrors = executionLoc.hasConnectionErrors();
            boolean checkedScriptConfigErrors = false;
            boolean isTestRunning = false;
            VScenarioPresentation scenarioPresentation = null;
            VScenario[] vScenarioArray = selectedStage.getModel().getScenarios();
            int n = vScenarioArray.length;
            int n2 = 0;
            while (n2 < n) {
                VScenario stageScenario = vScenarioArray[n2];
                if (stageScenario.isSelected()) {
                    scenarioPresentation = this.getScenarioPresentation(stageScenario);
                    if (scenarioPresentation != null) {
                        checkedScriptConfigErrors = validationLoc.hasScriptConfigErrors(scenarioPresentation);
                    }
                    if (checkedScriptConfigErrors) break;
                }
                ++n2;
            }
            boolean bl = enableStartButton = hasSelections && !configErrors && !connectionErrors && !checkedScriptConfigErrors;
            if (resetData) {
                executionLoc.resetUiData(enableStartButton);
            }
            if (this.session != null && (stage = this.session.getStage()) != null && executionLoc.hasStageInProgress()) {
                isTestRunning = true;
                if (!selectedStage.getModel().getName().equals(stage.getName())) {
                    executionLoc.setStartEnabled(false);
                    executionLoc.updateStartDecorator(ExecutionPresentationModel.DecoratorType.ERROR, UtilsText.safeString((String)Messages.WARN_ANOTHER_JOB_RUNNING_MSG));
                } else {
                    executionLoc.setStartEnabled(true);
                    executionLoc.updateStartDecorator(ExecutionPresentationModel.DecoratorType.NONE, "");
                }
            }
            if (!isTestRunning) {
                if (enableStartButton) {
                    executionLoc.setStartEnabled(true);
                    executionLoc.updateStartDecorator(ExecutionPresentationModel.DecoratorType.NONE, "");
                } else {
                    executionLoc.setStartEnabled(false);
                    if (!hasSelections) {
                        executionLoc.updateStartDecorator(ExecutionPresentationModel.DecoratorType.WARNING, UtilsText.safeString((String)Messages.WARN_SELECT_SCENARIO_MSG));
                    } else if (configErrors) {
                        executionLoc.updateStartDecorator(ExecutionPresentationModel.DecoratorType.ERROR, VPresentationModel.getComponentErrors());
                    } else if (connectionErrors) {
                        executionLoc.updateStartDecorator(ExecutionPresentationModel.DecoratorType.ERROR, executionLoc.getConnectionErrors());
                    } else {
                        String invalidScriptConfigsStr = Arrays.toString(validationLoc.getInvalidScriptConfigs());
                        executionLoc.updateStartDecorator(ExecutionPresentationModel.DecoratorType.ERROR, UtilsText.safeString((String)NLS.bind((String)Messages.ERR_SCRIPT_CONFIG_MSG, (Object)invalidScriptConfigsStr)));
                    }
                }
            }
        }
    }

    public void updateSelectedCell() {
        VScenarioPresentation selScenario = this.getSelectedScenario();
        if (selScenario != null) {
            selScenario.updateSelectedCell();
        }
    }

    public void updateUI(final AUIRunnable uiUpdater, String jobName) {
        final MainView _view = this.view;
        if (_view == null || _view.isDisposed()) {
            return;
        }
        UIJob wjob = new UIJob(jobName){

            public IStatus runInUIThread(@Nullable IProgressMonitor monitor) {
                VPresentationModel.trace(uiUpdater.getLogLevel(), String.format("Running DDRv UI updater: %s", uiUpdater.toString()));
                if (!_view.isDisposed()) {
                    uiUpdater.run();
                }
                return Status.OK_STATUS;
            }
        };
        wjob.setSystem(true);
        wjob.schedule();
    }

    public void validateSelectedScriptConfig() {
        final MainView _view = this.view;
        final VScenarioPresentation scenario = Objects.requireNonNull(Objects.requireNonNull(this.validation).getSelectedStage()).getSelectedScenario();
        UIJob wjob = new UIJob("Update DDRv presentation model - validate scripts"){

            public IStatus runInUIThread(@Nullable IProgressMonitor monitor) {
                ExecutionPresentationModel executionLoc;
                VPresentationModel.trace("Running DDRv UI updater: Validate selected script config");
                ValidationPresentationModel validationLoc = VPresentationModel.this.validation;
                VScenarioOptionsView scenOptView = VPresentationModel.this.getView().getScenarioOptionsView();
                if (validationLoc != null && !_view.isDisposed() && scenario != null && scenOptView != null && (executionLoc = VPresentationModel.this.execution) != null && executionLoc.getStartMode().equals((Object)ExecutionPresentationModel.StartValidationMode.VALIDATE)) {
                    VPresentationModel.this.updateExecutionPresentationModel(false);
                    VPresentationModel.this.getView().getExecutionView().setInput(executionLoc);
                    VPresentationModel.this.getView().getConnView().setInput(executionLoc);
                    scenOptView.setInput(scenario, false);
                }
                return Status.OK_STATUS;
            }
        };
        wjob.setSystem(true);
        wjob.schedule();
    }

    public void updatePresentation(ValidationContext vContext) {
        Objects.requireNonNull(this.model).update(vContext, false);
        this.updateUI(new RefreshUIRunnable(this, RefreshUIRunnable.RefreshMode.ALL, false), JobName.REFRESH_UI_ON_PEX_PROPERTY_CHANGE.name);
    }

    public void validateScript(VScriptConfig script) {
        ValidationPresentationModel validationLoc = this.validation;
        VScriptParamsView paramView = this.getParamView();
        VScriptParamValue sizeParamValue = null;
        VScriptParamValue addressParamValue = null;
        if (validationLoc != null && paramView != null) {
            Control addressText;
            Control sizeText = paramView.getControlByParamId("app.test_params.size");
            if (sizeText != null && (sizeParamValue = (VScriptParamValue)sizeText.getData("qcs.validation.ddr.model")) != null) {
                String sizeParamName = sizeParamValue.getParam().getName();
                boolean isValidSize = this.validateSize(script);
                if (isValidSize) {
                    validationLoc.removeInvalidScriptConfig(script, sizeParamName);
                } else {
                    validationLoc.addInvalidScriptConfig(script, sizeParamName);
                }
            }
            if ((addressText = paramView.getControlByParamId("app.test_params.start_addr")) != null && (addressParamValue = (VScriptParamValue)addressText.getData("qcs.validation.ddr.model")) != null && sizeParamValue != null) {
                String addressParamName = addressParamValue.getParam().getName();
                boolean isValidAddress = this.validateAddress(script);
                if (isValidAddress) {
                    validationLoc.removeInvalidScriptConfig(script, addressParamName);
                } else {
                    validationLoc.addInvalidScriptConfig(script, addressParamName);
                }
            }
        }
    }

    public boolean validateSize(VScriptConfig script) {
        Control sizeText;
        VScriptParamValue[] scriptParamValues;
        VScriptParamsView paramView = this.getParamView();
        VScriptConfig selectedScriptConfig = this.getSelectedScriptConfig();
        boolean isValidValue = true;
        boolean overFlowMemory = false;
        long sizeValue = 0L;
        long minSize = 1L;
        long availableMemory = 0L;
        VScriptParamValue[] vScriptParamValueArray = scriptParamValues = script.getParamValues();
        int n = scriptParamValues.length;
        int n2 = 0;
        while (n2 < n) {
            VScriptParamValue scriptParamValue = vScriptParamValueArray[n2];
            if (scriptParamValue.getParam().getId().equals("app.test_params.size")) {
                availableMemory = this.getAvailableMemory(scriptParamValue);
                minSize = this.getMinSize(scriptParamValue);
                sizeValue = Long.valueOf(scriptParamValue.getValue().toString());
                if (availableMemory > 0L && sizeValue > availableMemory) {
                    overFlowMemory = true;
                }
                if (sizeValue < minSize || overFlowMemory) {
                    isValidValue = false;
                }
            }
            ++n2;
        }
        if (paramView != null && selectedScriptConfig != null && script.getName().equals(selectedScriptConfig.getName()) && (sizeText = paramView.getControlByParamId("app.test_params.size")) instanceof CustomText) {
            Text text = ((CustomText)sizeText).getText();
            if (!isValidValue) {
                if (overFlowMemory) {
                    this.setErrorDecoration((Control)text, MessageFormat.format(Messages.SizeTooBig, availableMemory));
                } else {
                    this.setErrorDecoration((Control)text, MessageFormat.format(Messages.SizeTooSmall, minSize));
                }
            } else {
                this.resetDecoration((Control)text);
            }
        }
        return isValidValue;
    }

    public boolean validateAddress(VScriptConfig script) {
        VScriptConfig selectedScriptConfig = this.getSelectedScriptConfig();
        VScriptParamValue sizeParamValue = script.getParamValue("app.test_params.size");
        VScriptParamsView paramView = this.getParamView();
        if (selectedScriptConfig != null && paramView != null && sizeParamValue != null) {
            long availableMemory = this.getAvailableMemory(sizeParamValue);
            long sizeValue = Long.valueOf(sizeParamValue.getValue().toString());
            Control addressText = paramView.getControlByParamId("app.test_params.start_addr");
            VScriptParamValue startAddress = selectedScriptConfig.getParamValue("app.test_params.start_addr");
            if (startAddress != null && addressText != null) {
                long startAddrValue = Long.valueOf(startAddress.getValue().toString());
                AddressRange minStartAddress = startAddress.getParam().getMinStartAddress();
                if (minStartAddress != null) {
                    long minRange = minStartAddress.getMin();
                    long maxRange32bits = minStartAddress.getMax(availableMemory);
                    long extendedMinRange = minStartAddress.getExtendedMin();
                    long extendedMaxRange = minStartAddress.getExtendedMax(availableMemory);
                    if (startAddrValue >= minRange && startAddrValue <= maxRange32bits) {
                        if (startAddrValue + sizeValue - 1L > maxRange32bits) {
                            this.setErrorDecoration(addressText, Messages.ParamsOutOf32BitRange);
                            return false;
                        }
                        if (script.equals(selectedScriptConfig)) {
                            this.resetDecoration(addressText);
                        }
                    } else if (extendedMinRange > 0L && startAddrValue >= extendedMinRange && startAddrValue <= extendedMaxRange) {
                        if (startAddrValue + sizeValue - 1L > extendedMaxRange) {
                            this.setErrorDecoration(addressText, Messages.ParamsOutOfMemory);
                            return false;
                        }
                        if (script.equals(selectedScriptConfig)) {
                            this.resetDecoration(addressText);
                        }
                    } else {
                        this.setErrorDecoration(addressText, Messages.AddressOutOfRange);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void setErrorDecoration(Control text, String message) {
        text.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
        text.setToolTipText(message);
    }

    public void resetDecoration(Control text) {
        text.setBackground(null);
        text.setToolTipText(null);
    }

    public long getMinSize(VScriptParamValue scriptParamValue) {
        IDisplayFigure selectedTable;
        VScenarioPresentation vsp = this.getSelectedScenario();
        if (vsp != null && (selectedTable = vsp.getSelectedTable()) != null) {
            List<VScriptConfig> scriptConfigs = selectedTable.getModel().getScriptsConfig();
            long minSize = scriptConfigs.stream().filter(sc -> Arrays.asList(sc.getParamValues()).contains(scriptParamValue)).map(sc -> sc.getParamValues()).flatMap(Arrays::stream).filter(pv -> VScriptParam.VScriptParamType.BOOL.equals((Object)pv.getParam().getType())).filter(pv -> Boolean.valueOf(pv.getValue().toString())).map(pv -> pv.getParam().getMinSize()).max(Long::compare).orElse(new Long(1L));
            return minSize;
        }
        return 1L;
    }

    public long getAvailableMemory(VScriptParamValue sizeParamValue) {
        String instanceName;
        String memoryValue;
        long availableMemmory = 0L;
        VScriptParam param = sizeParamValue.getParam();
        String availableMemoryId = param.getAvailableMemoryId();
        IConfigProvider controllerLoc = ValidationContext.getInstance().getConfigController();
        if (controllerLoc != null && availableMemoryId != null && (memoryValue = controllerLoc.getPropertyValue(instanceName = controllerLoc.getCurrentInstanceName(), availableMemoryId)) != null) {
            availableMemmory = Long.parseLong(memoryValue.replaceAll("\"", ""));
        }
        return availableMemmory;
    }

    public @Nullable VScriptParamsView getParamView() {
        VScriptParamsView paramView = null;
        VScriptConfig selectedScriptConfig = this.getSelectedScriptConfig();
        if (selectedScriptConfig != null) {
            String scriptId = selectedScriptConfig.getScript().getId();
            VScenarioOptionsView scenarioView = this.getView().getScenarioOptionsView();
            if (scenarioView != null) {
                paramView = scenarioView.getParamViews().get(scriptId);
            }
        }
        return paramView;
    }

    public @Nullable VScriptConfig getSelectedScriptConfig() {
        VScenarioPresentation selectedScenario;
        VStagePresentation selectedStage;
        ValidationPresentationModel validationLoc = this.validation;
        VScriptConfig selectedScriptConfig = null;
        if (validationLoc != null && (selectedStage = validationLoc.getSelectedStage()) != null && (selectedScenario = selectedStage.getSelectedScenario()) != null) {
            selectedScriptConfig = selectedScenario.getSelectedScriptConfig();
        }
        return selectedScriptConfig;
    }
}

