/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.jobs.JobName;
import com.nxp.swtools.mem.validation.listeners.IValidationSessionEventListener;
import com.nxp.swtools.mem.validation.model.ARunResultsUpdaterListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.presenter.updaters.RefreshUIRunnable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.graphics.Point;

public class JitterEyeResultHandler
extends ARunResultsUpdaterListener {
    private static final String[] EYE_STAGE_NAMES = new String[]{"Tests"};
    private VPresentationModel model;
    @Nullable
    private String output;
    private ArrayList<EyeTable> jitterTables;
    private ArrayList<EyeTable> pattIndJitterTables;
    @Nullable
    private VStage stage;
    @Nullable
    private VScenario scenario;
    private String extraData = "";
    private VLoggingUtils.ScriptResultType resultType = VLoggingUtils.ScriptResultType.PASSED;
    private static final String STEPS_PER_BIT = "steps_per_bit";
    private static final String RX_RATE = "rx_rate";
    private static final String COUNT_WINDOW_BITS = "count_window_bits";
    private static final String EXTRA_DATA_START_TAG = "<extra_data>";
    private static final String EXTRA_DATA_END_TAG = "</extra_data>";

    public JitterEyeResultHandler(VPresentationModel presentationModel) {
        this.model = presentationModel;
        ValidationPresentationModel validationModel = this.model.getValidationModel();
        if (validationModel != null) {
            String[] stringArray = EYE_STAGE_NAMES;
            int n = EYE_STAGE_NAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String eyeStage = stringArray[n2];
                VStagePresentation stagePresentation = validationModel.getStage(Objects.requireNonNull(eyeStage));
                if (stagePresentation != null) {
                    this.stage = stagePresentation.getModel();
                    break;
                }
                ++n2;
            }
        }
        this.jitterTables = new ArrayList();
        this.pattIndJitterTables = new ArrayList();
    }

    @Override
    public IValidationSessionEventListener.VEventListenerResult onEvent(VSessionModel session, VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        if (phase == VSessionModel.VEventPhase.VSCENARIO_END) {
            return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
        }
        if (phase == VSessionModel.VEventPhase.SCRIPT_END) {
            this.scenario = event.scenario;
            if (this.resultType == VLoggingUtils.ScriptResultType.PASSED) {
                this.parseResult();
            }
            this.updateModel();
            this.model.updateUI(new RefreshUIRunnable(this.model, RefreshUIRunnable.RefreshMode.SELECT_SCENARIO, true), JobName.REFRESH_UI_ON_NEW_TEST_RESULTS.name);
        } else if (phase == VSessionModel.VEventPhase.SCRIPT_START) {
            this.jitterTables = new ArrayList();
            this.pattIndJitterTables = new ArrayList();
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    private void updateModel() {
        VRunResult[] results;
        VTableGroup tableGrp;
        VTable[] allTables;
        VTable crtTable;
        VParamVariation crtCell;
        VTableGroup[] tableGroup;
        if (this.stage != null && this.scenario != null && (tableGroup = this.scenario.getTableGroups()) != null && (crtCell = (crtTable = (allTables = (tableGrp = tableGroup[0]).getTables())[0]).getParamVariation(new Point(0, 0))) != null && (results = crtCell.getResults()) != null) {
            VRunResult[] vRunResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                VRunResult runResult = vRunResultArray[n2];
                runResult.setType(this.resultType.equals((Object)VLoggingUtils.ScriptResultType.PASSED) ? VRunResult.ResultType.PASSED : VRunResult.ResultType.FAILED);
                runResult.setFailureType(this.resultType);
                runResult.setExtraData(this.extraData);
                runResult.setErrorMessage(this.resultType.equals((Object)VLoggingUtils.ScriptResultType.PASSED) ? "" : VLoggingUtils.extractErrorMessage(UtilsText.safeString((String)this.output)));
                VParamVariation cell = runResult.getParamVariation();
                cell.setJitterData(this.jitterTables);
                cell.setPattIndepData(this.pattIndJitterTables);
                this.model.onValidationRunResults(Objects.requireNonNull(this.stage), Objects.requireNonNull(this.scenario), runResult);
                ++n2;
            }
        }
    }

    private static String extractExtraData(String rawOutput) {
        if (rawOutput.contains(EXTRA_DATA_START_TAG)) {
            int exstraStart = rawOutput.indexOf(EXTRA_DATA_START_TAG) + EXTRA_DATA_START_TAG.length();
            int extraEnd = rawOutput.indexOf(EXTRA_DATA_END_TAG);
            return rawOutput.substring(exstraStart, extraEnd);
        }
        return "";
    }

    private void parseResult() {
        String[] lines = Objects.requireNonNull(this.output).split("\\r?\\n");
        ArrayList<JSTestData> dataList = new ArrayList<JSTestData>();
        if (this.output != null && !this.output.contains(STEPS_PER_BIT)) {
            return;
        }
        if (this.output != null) {
            this.extraData = JitterEyeResultHandler.extractExtraData(this.output);
        }
        int index = 0;
        int rxRateIndex = -1;
        int countWindowBits = -1;
        boolean isJitter = true;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].contains(STEPS_PER_BIT)) {
                index = i;
            }
            if (lines[i].contains(RX_RATE)) {
                rxRateIndex = i;
            }
            if (lines[i].contains(COUNT_WINDOW_BITS)) {
                countWindowBits = i;
                isJitter = false;
            }
            String[] values = lines[i].split("[,]");
            try {
                JSTestData data;
                double normMisMatch;
                double numMisMatch;
                if (isJitter) {
                    numMisMatch = Double.parseDouble(values[1]);
                    normMisMatch = Double.parseDouble(values[2]);
                    data = new JSTestData(i, numMisMatch, normMisMatch);
                    dataList.add(data);
                } else {
                    numMisMatch = Double.parseDouble(values[0]);
                    normMisMatch = Double.parseDouble(values[1]);
                    data = new JSTestData(i, numMisMatch, normMisMatch);
                    dataList.add(data);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        EyeTable currentTable = new EyeTable();
        currentTable.dataList = dataList;
        int beginIndex = lines[index].indexOf("=");
        currentTable.stepsPerBit = Double.parseDouble(lines[index].substring(beginIndex + 1));
        beginIndex = lines[index + 1].indexOf("=");
        currentTable.patternLength = Integer.parseInt(lines[index + 1].substring(beginIndex + 1));
        if (!isJitter) {
            beginIndex = lines[rxRateIndex].indexOf("=");
            currentTable.rx_rate = Integer.parseInt(lines[rxRateIndex].substring(beginIndex + 1));
            beginIndex = lines[countWindowBits].indexOf("=");
            currentTable.count_window_bits = Integer.parseInt(lines[countWindowBits].substring(beginIndex + 1));
            this.pattIndJitterTables.add(currentTable);
        } else {
            this.jitterTables.add(currentTable);
        }
        currentTable.setJitter(isJitter);
    }

    @Override
    public double getProgress() {
        return 0.0;
    }

    @Override
    public @Nullable VStage getStage() {
        return this.stage;
    }

    @Override
    public @Nullable VScenario getScenario() {
        return this.scenario;
    }

    @Override
    public VTable[] getTables() {
        VScenario currentScenario = Objects.requireNonNull(this.scenario);
        VTableGroup[] tableGroups = currentScenario.getTableGroups();
        if (tableGroups != null) {
            return tableGroups[0].getTables();
        }
        return new VTable[0];
    }

    @Override
    public @Nullable VTable getTable() {
        return this.getTables()[0];
    }

    @Override
    public void setRawOutput(String line) {
        this.output = line;
    }

    @Override
    public @Nullable VSessionModel.VEvent getNextEvent() {
        return null;
    }

    @Override
    public void setFailureType(VLoggingUtils.ScriptResultType resultType) {
        this.resultType = resultType;
    }

    @Override
    public void setResultText(String resultText) {
    }

    public static class EyeTable {
        Range yAxis;
        Range xAxis;
        int[][] data;
        List<JSTestData> dataList = new ArrayList<JSTestData>();
        double stepsPerBit = -1.0;
        int patternLength = 10;
        int rx_rate = 0;
        int count_window_bits = -1;
        boolean isJitter = false;

        public EyeTable() {
            this.xAxis = new Range(0.0, 1000.0);
            this.yAxis = new Range(-1.5, 1.5);
            this.data = new int[0][0];
        }

        public @Nullable Range xAxis() {
            return this.xAxis;
        }

        public @Nullable Range yAxis() {
            return this.yAxis;
        }

        public int @Nullable [][] data() {
            return this.data;
        }

        public List<JSTestData> getTestData() {
            return this.dataList;
        }

        public double getStepsPerBit() {
            return this.stepsPerBit;
        }

        public int getPatternLegth() {
            return this.patternLength;
        }

        public int getRxRate() {
            return this.rx_rate;
        }

        public int getCountWindowBits() {
            return this.count_window_bits;
        }

        public void setJitter(boolean isJitter) {
            this.isJitter = isJitter;
        }

        public boolean isJitter() {
            return this.isJitter;
        }
    }

    public static class JSTestData {
        public double step;
        public double numMismatch;
        public double normMismatch;

        public JSTestData(double step, double numMismatch, double normMismatch) {
            this.step = step;
            this.numMismatch = numMismatch;
            this.normMismatch = normMismatch;
        }
    }
}

