/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import com.nxp.swtools.mem.validation.ui.VScriptParamsView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MultiOptParamSelectionListener
extends SelectionAdapter {
    private VPresentationModel data;
    public static final String DATA_SOURCE_PARAM_NAME = "app.test_params.loopback";
    public static final String DATA_COUNTWINDOW_PARAM = "app.test_params.countwindow";
    public static final String PATTERN_PARAM_NAME = "app.test_params.pattern";
    public static final String TOTAL_TIME_INFO_PARAM_NAME = "app.test_params.time";
    public static final String EXTERNAL = "External";

    public MultiOptParamSelectionListener(VPresentationModel data) {
        this.data = data;
    }

    private @Nullable VScriptConfig getValidationScript() {
        VStagePresentation stage = this.data.getSelectedStage();
        if (stage == null) {
            return null;
        }
        VScenarioPresentation scenario = stage.getSelectedScenario();
        if (scenario != null) {
            return scenario.getSelectedScriptConfig();
        }
        return null;
    }

    private @Nullable Control getControlById(String id) {
        VScriptConfig sc = this.getValidationScript();
        if (sc != null) {
            String scriptId = sc.getScript().getId();
            VScenarioOptionsView scenarioView = this.data.getView().getScenarioOptionsView();
            if (scenarioView == null) {
                return null;
            }
            VScriptParamsView paramView = scenarioView.getParamViews().get(scriptId);
            if (paramView == null) {
                return null;
            }
            return paramView.getControlByParamId(id);
        }
        return null;
    }

    private @Nullable String getSelScenario() {
        VStagePresentation stage = this.data.getSelectedStage();
        if (stage == null) {
            return null;
        }
        VScenarioPresentation scen = stage.getSelectedScenario();
        if (scen != null) {
            VScenario scenModel = scen.getModel();
            return scenModel.getName();
        }
        return null;
    }

    public void widgetSelected(SelectionEvent event) {
        Combo combo = (Combo)event.widget;
        VScriptParamValue model = (VScriptParamValue)combo.getData("qcs.validation.ddr.model");
        String optName = combo.getText();
        if (model != null) {
            Control timeToWait;
            VScriptParam.Options options = model.getParam().getOptions();
            if (model.getParam().getId().equals(DATA_SOURCE_PARAM_NAME)) {
                Control pattern = this.getControlById(PATTERN_PARAM_NAME);
                VScriptConfig sc = this.getValidationScript();
                if (pattern != null && sc != null) {
                    pattern.setEnabled(!combo.getText().equals(EXTERNAL) || !sc.getName().contains(VScenario.ScenarioType.PATTERN_INDEP_JITTER_SCOPE.name));
                }
            } else if (model.getParam().getId().equals(DATA_COUNTWINDOW_PARAM) && (timeToWait = this.getControlById(TOTAL_TIME_INFO_PARAM_NAME)) instanceof Text) {
                Text tx = (Text)timeToWait;
                IConfigProvider configCtrl = ValidationContext.getInstance().getConfigController();
                String selScen = this.getSelScenario();
                if (configCtrl != null && selScen != null && options != null) {
                    tx.setText(configCtrl.getRelatedParam(options.getValue(optName), selScen));
                }
            }
            if (options != null) {
                String optValue = options.getValue(optName);
                model.setValue(optValue);
            }
        }
        this.data.validateSelectedScriptConfig();
    }
}

