/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.codgen.CgenManager;
import com.nxp.swtools.mem.validation.codgen.RunScriptRequest;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.listeners.IValidationSessionEventListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import java.util.Arrays;

public class CGenVEventListener
implements IValidationSessionEventListener {
    public static final long SCRIPT_TIMEOUT = 180000L;
    private CgenManager cgenManag = Activator.getDefault().getCgenManager();
    private ValidationContext vContext = ValidationContext.getInstance();
    @Nullable
    private RunScriptRequest runRequest;

    private IValidationSessionEventListener.VEventListenerResult onCellStart(VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        VStage selectedStage;
        ExecutionPresentationModel execution = this.vContext.getData().getExecution();
        VSessionModel sessionModel = this.vContext.getData().getSession();
        if (execution != null && execution.getSkipDownload() && sessionModel != null && (selectedStage = sessionModel.getStage()) != null && selectedStage.isShmooType()) {
            execution.setSkipDownload(false);
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    private static IValidationSessionEventListener.VEventListenerResult onScriptUnitStart(VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    private IValidationSessionEventListener.VEventListenerResult onTableStart(VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        VStage selectedStage;
        VSessionModel sessionModel = this.vContext.getData().getSession();
        if (sessionModel != null && (selectedStage = sessionModel.getStage()) != null) {
            Arrays.asList(event.getTables()).stream().filter(table -> table.getOptions().restoreConfigEn()).forEach(t -> {
                t.storeInitialComponentConfig();
                t.applyPrerequisites();
            });
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    private IValidationSessionEventListener.VEventListenerResult onTableEnd(VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        VStage selectedStage;
        VSessionModel sessionModel = this.vContext.getData().getSession();
        if (sessionModel != null && (selectedStage = sessionModel.getStage()) != null) {
            Arrays.asList(event.getTables()).stream().filter(table -> table.getOptions().restoreConfigEn()).forEach(VTable::restoreInitialComponentConfig);
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    public CGenVEventListener(VPresentationModel data) {
        this.vContext.setModel(data);
    }

    public @Nullable RunScriptRequest getRunRequest() {
        return this.runRequest;
    }

    @Override
    public IValidationSessionEventListener.VEventListenerResult onEvent(VSessionModel session, VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        this.vContext.setEvent(event);
        this.vContext.setEventPhase(phase);
        try {
            if (phase == VSessionModel.VEventPhase.VTABLE_START) {
                IValidationSessionEventListener.VEventListenerResult vEventListenerResult = this.onTableStart(event, phase);
                return vEventListenerResult;
            }
            if (phase == VSessionModel.VEventPhase.CELL_START) {
                IValidationSessionEventListener.VEventListenerResult vEventListenerResult = this.onCellStart(event, phase);
                return vEventListenerResult;
            }
            if (phase == VSessionModel.VEventPhase.SCRIPT_UNIT_START) {
                IValidationSessionEventListener.VEventListenerResult vEventListenerResult = CGenVEventListener.onScriptUnitStart(event, phase);
                return vEventListenerResult;
            }
            if (phase == VSessionModel.VEventPhase.SCRIPT_START) {
                IValidationSessionEventListener.VEventListenerResult vEventListenerResult = this.onScriptStart(event, phase);
                return vEventListenerResult;
            }
            if (phase == VSessionModel.VEventPhase.VALIDATION_END) {
                IValidationSessionEventListener.VEventListenerResult vEventListenerResult = this.onScriptEnd(event, phase);
                return vEventListenerResult;
            }
            if (phase == VSessionModel.VEventPhase.VTABLE_END) {
                IValidationSessionEventListener.VEventListenerResult vEventListenerResult = this.onTableEnd(event, phase);
                return vEventListenerResult;
            }
        }
        finally {
            this.vContext.setEvent(null);
            this.vContext.setEventPhase(null);
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    private IValidationSessionEventListener.VEventListenerResult onScriptStart(VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        VScriptConfig scriptConfig = event.getScriptConfig();
        if (scriptConfig != null) {
            String scriptId = scriptConfig.getScript().getId();
            String cgenScenarioId = this.cgenManag.getValidScriptScenarioId(scriptId);
            this.vContext.setScenarioId(cgenScenarioId);
            long timeout = 1800000L;
            this.runRequest = this.cgenManag.generateRunScriptParams(this.vContext, timeout, true, false, this.vContext.getScriptEnvVars());
            this.cgenManag.generateCode(this.vContext);
            ExecutionPresentationModel execution = this.vContext.getData().getExecution();
            if (execution != null && !execution.getSkipDownload()) {
                execution.setSkipDownload(true);
            }
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    private IValidationSessionEventListener.VEventListenerResult onScriptEnd(VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        IGeneratedFilesStatusProvider genFilesStatusProvider;
        ISharedConfiguration sharedConfig;
        ValidationPresentationModel modelLoc;
        ExecutionPresentationModel execution = this.vContext.getData().getExecution();
        VSessionModel sessionModel = this.vContext.getData().getSession();
        if (execution != null && sessionModel != null && (modelLoc = execution.getParent().getValidationModel()) != null) {
            VParamVariation runningCell = modelLoc.getRunningCell();
            VStage selectedStage = sessionModel.getStage();
            if (runningCell != null && (!runningCell.getState().equals((Object)VParamVariation.VState.FAILED) || selectedStage != null && selectedStage.isShmooType())) {
                execution.setSkipDownload(false);
                this.cgenManag.regenerate(true);
            }
        }
        IToolchainProjectProvider toolchainProvider = (sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton()) != null ? sharedConfig.getToolchainProjectProvider() : null;
        IGeneratedFilesStatusProvider iGeneratedFilesStatusProvider = genFilesStatusProvider = toolchainProvider != null ? toolchainProvider.getGeneratedFilesStatusProvider() : null;
        if (genFilesStatusProvider != null) {
            genFilesStatusProvider.requestUpdate();
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }
}

