/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.config;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.IDiagsProvider;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.JTAGConnection;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import com.nxp.swtools.utils.events.IEventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.swt.graphics.Point;

public class ValidationContext {
    public static final String PY_TRUE = "True";
    public static final String PY_FALSE = "False";
    public static final String LOG_FILE_PREFIX = "test_";
    public static final String PHY_TRAINING_FILE_PREFIX = "phy_training_";
    public static final String FIGURE_FILE_PREFIX = "figure_";
    public static final String LOG_FILE_POSTFIX = ".log";
    public static final String TEMP_LOG = "temp.log";
    public static final String FIGURE_FILE_POSTFIX = ".png";
    private String output = "";
    private IEventListener settingChangeListener = event -> this.updatePresentation();
    @Nullable
    protected String cgenScenarioId;
    protected String cpuVariant = "";
    protected String cpuFamily = "";
    @Nullable
    private VSessionModel.VEvent event;
    @Nullable
    private VSessionModel.VEventPhase phase = VSessionModel.VEventPhase.VALIDATION_START;
    @Nullable
    private VPresentationModel presentationModel;
    @Nullable
    private IConfigProvider configController;
    @Nullable
    private IDiagsProvider diagsProvider;
    @Nullable
    private Connection currentConnection;

    public static ValidationContext getInstance() {
        try {
            return (ValidationContext)SWTFactoryProxy.INSTANCE.getSingletonInstance(ValidationContext.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain user-singleton instance of: " + ValidationContext.class.getSimpleName(), e);
        }
    }

    public static String getLogFileName(VRunResult runResult) {
        VParamVariation cell = runResult.getParamVariation();
        VTable table = cell.getParent();
        return ValidationContext.getLogFileName(table, cell.getPos());
    }

    private static String getLogFileName(VTable table, Point point) {
        String cellPosStr = TestResultsLogger.getPosStr(point);
        String tableId = table.getId();
        return LOG_FILE_PREFIX + tableId + cellPosStr + LOG_FILE_POSTFIX;
    }

    private ValidationContext() {
    }

    public @Nullable IConfigProvider getConfigController() {
        return this.configController;
    }

    public String getCpuFamily() {
        return this.configController != null ? this.configController.getMCUInfo().getFamily() : "";
    }

    public String getCpuSubFamily() {
        return this.configController != null ? this.configController.getMCUInfo().getFamily() : "";
    }

    public String getCpuVariant() {
        return this.configController != null ? this.configController.getMCUInfo().getMcu() : "";
    }

    public String getCrtScriptId() {
        return this.event != null ? Objects.requireNonNull(this.event.getScriptConfig()).getScript().getId() : "";
    }

    public boolean isModelSet() {
        return this.presentationModel != null;
    }

    public VPresentationModel getData() {
        return Objects.requireNonNull(this.presentationModel);
    }

    public VSessionModel.VEvent getEvent() {
        return Objects.requireNonNull(this.event);
    }

    public @Nullable VSessionModel.VEvent getNullableEvent() {
        return this.event;
    }

    public @Nullable VSessionModel.VEventPhase getEventPhase() {
        return this.phase;
    }

    public @Nullable String getScenarioId() {
        return this.cgenScenarioId;
    }

    public Map<String, String> getScriptEnvVars() {
        return new HashMap<String, String>();
    }

    public Set<String> getScriptIds() {
        HashSet<String> scriptIds = new HashSet<String>();
        if (this.event != null) {
            for (VScriptConfig sconf : Objects.requireNonNull(Objects.requireNonNull(this.event.getTables())[0]).getScriptsConfig()) {
                if (!sconf.isSelected() || sconf.getNumRuns() <= 0) continue;
                scriptIds.add(sconf.getScript().getId());
            }
        }
        return scriptIds;
    }

    public void reset() {
    }

    public void setConfigController(@Nullable IConfigProvider controller) {
        this.configController = controller;
    }

    public void setDiagsProvider(@Nullable IDiagsProvider diagsProv) {
        this.diagsProvider = diagsProv;
    }

    public @Nullable IDiagsProvider getDiagsProvider() {
        return this.diagsProvider;
    }

    public void setCpuFamily(String cpuFamily) {
        this.cpuFamily = cpuFamily;
    }

    public void setCpuVariant(String cpuVariant) {
        this.cpuVariant = cpuVariant;
    }

    public void setData(VPresentationModel _data) {
        this.presentationModel = _data;
        IConfigProvider configControllerLoc = this.configController;
        if (configControllerLoc != null) {
            if (this.allowUIValidationRefreshOnSettingChange()) {
                configControllerLoc.addSettingChangeListener(this.settingChangeListener);
            } else {
                configControllerLoc.removeSettingChangeListener();
            }
        }
    }

    public void setEvent(@Nullable VSessionModel.VEvent event) {
        this.event = event;
    }

    public void setEventPhase(@Nullable VSessionModel.VEventPhase phase) {
        this.phase = phase;
    }

    public void setModel(VPresentationModel _presentationModel) {
        this.setData(_presentationModel);
        this.reset();
    }

    public void setScenarioId(@Nullable String scenarioId) {
        this.cgenScenarioId = scenarioId;
    }

    private boolean allowUIValidationRefreshOnSettingChange() {
        String optionStr;
        VModel vModel = this.getData().getModel();
        if (vModel != null && (optionStr = vModel.getCustomOption("updateValidationUIOnSettingChange")) != null) {
            return Boolean.parseBoolean(optionStr);
        }
        return false;
    }

    private void updatePresentation() {
        this.getData().updatePresentation(this);
    }

    public void setHostName(String hostname) {
        Connection connection;
        ExecutionPresentationModel executionModel;
        if (this.presentationModel != null && (executionModel = this.presentationModel.getExecution()) != null && (connection = executionModel.getConnection()) instanceof JTAGConnection && !((JTAGConnection)connection).isUsbConnection()) {
            ((JTAGConnection)connection).setHostname(hostname);
        }
    }

    public String getHostName() {
        if (this.currentConnection instanceof JTAGConnection) {
            return ((JTAGConnection)this.currentConnection).getHostname();
        }
        return "";
    }

    public boolean isUsbConnection() {
        Connection connection;
        ExecutionPresentationModel executionModel;
        if (this.presentationModel != null && (executionModel = this.presentationModel.getExecution()) != null && (connection = executionModel.getConnection()) instanceof JTAGConnection) {
            return ((JTAGConnection)connection).isUsbConnection();
        }
        return true;
    }

    public @Nullable Connection getCurrentConnection() {
        ExecutionPresentationModel executionModel;
        if (this.currentConnection != null) {
            return this.currentConnection;
        }
        if (this.presentationModel != null && (executionModel = this.presentationModel.getExecution()) != null) {
            return executionModel.getConnection();
        }
        return null;
    }

    public void setCurrentConnection(Connection connection) {
        this.currentConnection = connection;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getOutput() {
        return this.output;
    }
}

