/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.codgen;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.codgen.CgenManager;
import com.nxp.swtools.mem.validation.codgen.FileUnit;
import com.nxp.swtools.mem.validation.codgen.ScriptTemplate;
import com.nxp.swtools.mem.validation.codgen.Template;
import com.nxp.swtools.mem.validation.config.ConfigManager;
import com.nxp.swtools.mem.validation.model.ParserUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class CgenParser {
    private static final String TAG_TEMPLATES = "templates";
    private static final String TAG_INIT_TEMPLATES = "init-templates";
    private static final String TAG_INIT_TEMPLATE = "init-template";
    private static final String TAG_TEST_TEMPLATES = "test-templates";
    private static final String TAG_TEST_TEMPLATE = "test-template";
    private static final String TAG_TEMPLATE_FILE = "file";
    private static final String TAG_DEFAULT_TEMPLATE_FILE = "default-file";
    private static final String TAG_SCENARIOS = "scenarios";
    private static final String TAG_SCENARIO = "scenario";
    private static final String TAG_OUTPUT_UNIT = "output";
    private static final String TAG_DEFAULT_SCENARIO = "default";
    private static final String TAG_VARIABLES = "variables";
    private static final String TAG_VARIABLE = "variable";
    private static final String TAG_RUN_SCRIPT = "run_script";

    public static void parseCgenConfigFile(ConfigManager configManager, Map<String, Template.TemplateFile[]> scriptTemplates, CgenManager cgenManager) throws IllegalArgumentException, IOException, SAXException, ParserConfigurationException {
        @NonNull String filePath = configManager.getCgenConfigXmlPath();
        Node rootNode = ParserUtility.extractRootXmlNode(filePath);
        Node variablesNode = Objects.requireNonNull(ParserUtility.extractFirstChildNode(rootNode, TAG_VARIABLES));
        Node templatesNode = Objects.requireNonNull(ParserUtility.extractFirstChildNode(rootNode, TAG_TEMPLATES));
        Node scenariosNode = Objects.requireNonNull(ParserUtility.extractFirstChildNode(rootNode, TAG_SCENARIOS));
        Node initTemplatesNode = Objects.requireNonNull(ParserUtility.extractFirstChildNode(templatesNode, TAG_INIT_TEMPLATES));
        Node testTemplatesNode = ParserUtility.extractFirstChildNode(templatesNode, TAG_TEST_TEMPLATES);
        Map<String, String> variables = CgenParser.parseVariables(variablesNode);
        Template[] initTemplates = CgenParser.parseInitTemplates(initTemplatesNode, variables, configManager);
        ScriptTemplate[] testTemplates = new ScriptTemplate[]{};
        if (!scriptTemplates.isEmpty() && testTemplatesNode != null) {
            testTemplates = CgenParser.parseTestTemplates(testTemplatesNode, variables, configManager);
        }
        CgenManager.CgenScenario[] scenarios = CgenParser.parseCgenScenarios(scenariosNode, configManager);
        cgenManager.initCgenManager(initTemplates, testTemplates, scenarios);
    }

    private static CgenManager.CgenScenario parseCgenScenario(Node node, ConfigManager configManager) {
        String id = Objects.requireNonNull(ParserUtility.getAttribValue(node, "id"));
        ArrayList<FileUnit> cgenUnitList = new ArrayList<FileUnit>();
        boolean isDefault = false;
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNode != null && TAG_RUN_SCRIPT.equalsIgnoreCase(childNode.getNodeName())) {
                String fileName = ParserUtility.getAttribValue(childNode, TAG_TEMPLATE_FILE);
                String simFileName = ParserUtility.getAttribValue(childNode, "sim-env", false);
                fileName = String.valueOf(configManager.getMainDir()) + File.separator + fileName;
                cgenUnitList.add(new FileUnit(fileName, simFileName));
            } else if (childNode != null && TAG_OUTPUT_UNIT.equalsIgnoreCase(childNode.getNodeName())) {
                cgenUnitList.add(CgenParser.parseOutputUnit(childNode));
            } else if (childNode != null && TAG_DEFAULT_SCENARIO.equalsIgnoreCase(childNode.getNodeName())) {
                isDefault = true;
            }
            ++i;
        }
        FileUnit[] cgenUnits = cgenUnitList.toArray(new FileUnit[cgenUnitList.size()]);
        return new CgenManager.CgenScenario(id, cgenUnits, isDefault);
    }

    protected static CgenManager.CgenScenario[] parseCgenScenarios(Node node, ConfigManager configManager) {
        ArrayList<CgenManager.CgenScenario> scenarioList = new ArrayList<CgenManager.CgenScenario>();
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode != null && TAG_SCENARIO.equalsIgnoreCase(childNode.getNodeName())) {
                scenarioList.add(CgenParser.parseCgenScenario(childNode, configManager));
            }
            ++i;
        }
        return scenarioList.toArray(new CgenManager.CgenScenario[scenarioList.size()]);
    }

    protected static Template[] parseInitTemplates(Node node, Map<String, String> variables, ConfigManager configManager) {
        ArrayList<Template> templateList = new ArrayList<Template>();
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode != null && TAG_INIT_TEMPLATE.equalsIgnoreCase(childNode.getNodeName())) {
                templateList.add(CgenParser.parseTemplate(childNode, Template.TemplateType.CONFIG_INIT, variables, configManager));
            }
            ++i;
        }
        return templateList.toArray(new Template[templateList.size()]);
    }

    private static FileUnit parseOutputUnit(Node node) {
        String fileNamePattern = ParserUtility.getAttribValue(node, TAG_TEMPLATE_FILE);
        assert (fileNamePattern != null);
        String envId = ParserUtility.getAttribValue(node, "env-id", false);
        ArrayList<String> templateIdList = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode != null && TAG_INIT_TEMPLATE.equalsIgnoreCase(childNode.getNodeName())) {
                String templateId = ParserUtility.getAttribValue(childNode, "id");
                assert (templateId != null);
                templateIdList.add(templateId);
            }
            if (childNode != null && TAG_TEST_TEMPLATE.equalsIgnoreCase(childNode.getNodeName())) {
                templateIdList.add("SCRIPT_TEMPLATE");
            }
            ++i;
        }
        String[] templateIds = templateIdList.toArray(new String[templateIdList.size()]);
        return new FileUnit(fileNamePattern, templateIds, envId);
    }

    private static String[] parseScriptScenario(Node node) {
        @NonNull String scenarioId = UtilsText.safeString((String)ParserUtility.getAttribValue(node, "id"));
        return new String[]{scenarioId};
    }

    private static String[][] parseScriptScenarios(Node node) {
        ArrayList<String[]> scriptScenarioList = new ArrayList<String[]>();
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode != null && TAG_SCENARIO.equalsIgnoreCase(childNode.getNodeName())) {
                scriptScenarioList.add(CgenParser.parseScriptScenario(childNode));
            }
            ++i;
        }
        scriptScenarioList.add(new String[]{""});
        String[][] retList = new String[scriptScenarioList.size()][];
        int index = 0;
        while (index < scriptScenarioList.size()) {
            retList[index] = (String[])scriptScenarioList.get(index);
            ++index;
        }
        return retList;
    }

    private static Template parseTemplate(Node node, Template.TemplateType type, Map<String, String> variables, ConfigManager configManager) {
        String id = ParserUtility.getAttribValue(node, "id");
        assert (id != null);
        String exclusive = ParserUtility.getAttribValue(node, "exclusive", false);
        String allowEmpty = ParserUtility.getAttribValue(node, "allowEmpty", false);
        ArrayList<Template.TemplateFile> templateFileList = new ArrayList<Template.TemplateFile>();
        Template.TemplateFile defaultFile = null;
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode != null && TAG_TEMPLATE_FILE.equalsIgnoreCase(childNode.getNodeName())) {
                templateFileList.add(CgenParser.parseTemplateFile(childNode, id, variables, configManager));
            }
            if (childNode != null && TAG_DEFAULT_TEMPLATE_FILE.equalsIgnoreCase(childNode.getNodeName())) {
                defaultFile = CgenParser.parseTemplateFile(childNode, id, variables, configManager);
            }
            ++i;
        }
        Template.TemplateFile[] files = templateFileList.toArray(new Template.TemplateFile[templateFileList.size()]);
        boolean exclusiveFlag = exclusive != null && !exclusive.equals("false");
        boolean allowEmptyFlag = allowEmpty != null && !allowEmpty.equals("false");
        return new Template(id, type, defaultFile, files, exclusiveFlag, allowEmptyFlag);
    }

    private static Template.TemplateFile parseTemplateFile(Node node, String templateId, Map<String, String> variables, ConfigManager configManager) {
        String file = Objects.requireNonNull(ParserUtility.getAttribValue(node, "name"));
        String path = configManager.getTemplateDir(variables, file);
        return new Template.TemplateFile(templateId, path);
    }

    private static ScriptTemplate parseTestScriptTemplate(Node node, Map<String, String> variables, ConfigManager configManager) {
        String id = ParserUtility.getAttribValue(node, "id");
        assert (id != null);
        ArrayList<Template.TemplateFile> templateFileList = new ArrayList<Template.TemplateFile>();
        Template.TemplateFile defaultFile = null;
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode != null && TAG_TEMPLATE_FILE.equalsIgnoreCase(childNode.getNodeName())) {
                templateFileList.add(CgenParser.parseTemplateFile(childNode, id, variables, configManager));
            }
            if (childNode != null && TAG_DEFAULT_TEMPLATE_FILE.equalsIgnoreCase(childNode.getNodeName())) {
                defaultFile = CgenParser.parseTemplateFile(childNode, id, variables, configManager);
            }
            ++i;
        }
        Template.TemplateFile[] files = templateFileList.toArray(new Template.TemplateFile[templateFileList.size()]);
        Node scriptScenariosNode = ParserUtility.extractFirstChildNode(node, TAG_SCENARIOS);
        assert (scriptScenariosNode != null);
        String[][] scriptScenarios = CgenParser.parseScriptScenarios(scriptScenariosNode);
        return new ScriptTemplate(id, defaultFile, files, scriptScenarios);
    }

    private static ScriptTemplate parseTestScriptTemplate(Node node, Map<String, Template.TemplateFile[]> scriptTemplates, Set<String> parsedScriptIds) {
        String id = ParserUtility.getAttribValue(node, "id");
        assert (id != null);
        parsedScriptIds.add(id);
        Template.TemplateFile[] files = scriptTemplates.get(id);
        Template.TemplateFile defaultFile = files != null ? files[0] : null;
        Node scriptScenariosNode = ParserUtility.extractFirstChildNode(node, TAG_SCENARIOS);
        assert (scriptScenariosNode != null);
        String[][] scriptScenarios = CgenParser.parseScriptScenarios(scriptScenariosNode);
        return new ScriptTemplate(id, defaultFile, files != null ? files : new Template.TemplateFile[]{}, scriptScenarios);
    }

    protected static ScriptTemplate[] parseTestTemplates(Node node, Map<String, String> variables, ConfigManager configManager) {
        ArrayList<ScriptTemplate> templateList = new ArrayList<ScriptTemplate>();
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode != null && TAG_TEST_TEMPLATE.equalsIgnoreCase(childNode.getNodeName())) {
                templateList.add(CgenParser.parseTestScriptTemplate(childNode, variables, configManager));
            }
            ++i;
        }
        return templateList.toArray(new ScriptTemplate[templateList.size()]);
    }

    protected static ScriptTemplate[] parseTestTemplates(Node node, Map<String, Template.TemplateFile[]> scriptTemplates) {
        ArrayList<ScriptTemplate> templateList = new ArrayList<ScriptTemplate>();
        HashSet<String> parsedScriptIds = new HashSet<String>();
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode != null && TAG_TEST_TEMPLATE.equalsIgnoreCase(childNode.getNodeName())) {
                templateList.add(CgenParser.parseTestScriptTemplate(childNode, scriptTemplates, parsedScriptIds));
            }
            ++i;
        }
        for (Map.Entry<String, Template.TemplateFile[]> entry : scriptTemplates.entrySet()) {
            @NonNull String scriptId = entry.getKey();
            if (parsedScriptIds.contains(scriptId)) continue;
            Template.TemplateFile[] files = entry.getValue();
            String[][] scriptScenarios = new String[][]{{"ARMv8_GTA_run_remote_test", "core: ARMv8, access: GTA"}};
            templateList.add(new ScriptTemplate(scriptId, null, files, scriptScenarios));
        }
        return templateList.toArray(new ScriptTemplate[templateList.size()]);
    }

    private static Map<String, String> parseVariables(Node node) {
        HashMap<String, String> varMap = new HashMap<String, String>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode != null && TAG_VARIABLE.equalsIgnoreCase(childNode.getNodeName())) {
                String name = ParserUtility.getAttribValue(childNode, "name");
                String value = ParserUtility.getAttribValue(childNode, "value");
                assert (name != null && value != null);
                varMap.put(name, value);
            }
            ++i;
        }
        return varMap;
    }
}

