/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.codgen;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.FileUnit;
import com.nxp.swtools.mem.validation.codgen.RunScriptRequest;
import com.nxp.swtools.mem.validation.codgen.ScriptTemplate;
import com.nxp.swtools.mem.validation.codgen.Template;
import com.nxp.swtools.mem.validation.codgen.ValidationScriptProfile;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.CollectionUtils;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.IStorageConfigurationPreferencesRead;
import com.nxp.swtools.utils.scripting.CodeGenerator;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.scripting.api.IProfileProvider;
import com.nxp.swtools.utils.scripting.api.IScriptFileProvider;
import com.nxp.swtools.utils.scripting.api.IScriptProfile;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.CompiledScript;
import org.eclipse.osgi.util.NLS;

public class CgenManager {
    private static final Logger LOGGER = LogManager.getLogger(CgenManager.class);
    public static final int DEFAULT_CCS_LISTENING_PORT = 50000;
    public static final int DEFAULT_SCRIPT_TIMEOUT_S = 1800;
    public static final long DEFAULT_SCRIPT_TIMEOUT_MS = 1800000L;
    public static final String VARIABLE_PREFIX = "$";
    public static final String INDEPENDENT_SCRIPT_ID = "independent_script";
    @Nullable
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String CONNECT_GTA_SCENARIO_ID = "ARMv8_GDB_connect_to_target";
    public static final String SCRIPT_TEMPLATE_ID = "SCRIPT_TEMPLATE";
    public static final String USER_SCRIPT_TEMPLATE = "custom_test_script.py";
    public static final String USER_SCRIPT_INPUT_TEMPLATE = "custom_test_input.json";
    public static final String READ_BOARD_CONF = "read_board_conf";
    public static final String READ_SPD_GTA = "ARMv8_GTA_read_spd";
    public static final String IMPORT_FROM_TARGET_GTA = "ARMv8_GTA_import_from_target";
    public static final String WIZARD_IMPORT_FROM_TARGET_GTA = "ARMv8_GTA_wizard_import_from_target";
    private static final String CODE_GENERATION_SCRIPT_NAME = "generateTestParams.js";
    @Nullable
    private ScriptResult scriptResult;
    protected Map<String, Template> templateMap = new HashMap<String, Template>();
    protected Map<String, ScriptTemplate> scriptTemplateMap = new HashMap<String, ScriptTemplate>();
    protected Map<String, CgenScenario> scenarioMap = new HashMap<String, CgenScenario>();
    protected boolean initialized = false;
    private boolean needToRegenerate;
    protected final ValidationScriptProfile scriptProfile = new ValidationScriptProfile();
    protected IProfileProvider profileProvider = new IProfileProvider(){

        public IScriptProfile getProfile(Thread uiThread) {
            return CgenManager.this.scriptProfile;
        }
    };
    @Nullable
    private CompiledScript compiledScript;
    private ValidationContext vContext = ValidationContext.getInstance();

    private static List<CgenSegment> extractCgenIdentifierSegments(String str) {
        ArrayList<CgenSegment> segmentList = new ArrayList<CgenSegment>();
        CgenSegment.CgenSegmentType[] cgenSegmentTypeArray = CgenSegment.CgenSegmentType.values();
        int n = cgenSegmentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CgenSegment.CgenSegmentType type = cgenSegmentTypeArray[n2];
            if (type.isIdentifier()) {
                String patternStr = type.pattern();
                Pattern pattern = Pattern.compile(patternStr);
                Matcher matcher = pattern.matcher(str);
                while (matcher.find()) {
                    int startIdx = matcher.start();
                    String encText = matcher.group();
                    int encTextLen = encText.length();
                    String text = encText.substring(type.prefixLen(), encTextLen - type.postfixLen());
                    segmentList.add(new CgenSegment(type, startIdx, text));
                }
            }
            ++n2;
        }
        Collections.sort(segmentList, new CgenSegmentComparator());
        return segmentList;
    }

    private static List<CgenSegment> extractCgenPlainTextSegments(String str, List<CgenSegment> idSegments) {
        ArrayList<CgenSegment> plainSegments = new ArrayList<CgenSegment>();
        CgenSegment idSegm = null;
        CgenSegment idSegmNext = null;
        if (idSegments.size() == 0) {
            plainSegments.add(new CgenSegment(CgenSegment.CgenSegmentType.TEXT, 0, str));
            return plainSegments;
        }
        idSegm = idSegments.get(0);
        int startIdx = 0;
        int endIdx = idSegm.startIdx;
        if (endIdx > 0) {
            plainSegments.add(new CgenSegment(CgenSegment.CgenSegmentType.TEXT, 0, str.substring(startIdx, endIdx)));
        }
        if (idSegments.size() >= 2) {
            int i = 0;
            while (i < idSegments.size() - 1) {
                idSegm = idSegments.get(i);
                idSegmNext = idSegments.get(i + 1);
                startIdx = idSegm.startIdx + idSegm.type.prefixLen() + idSegm.value.length() + idSegm.type.postfixLen();
                if (startIdx < (endIdx = idSegmNext.startIdx)) {
                    plainSegments.add(new CgenSegment(CgenSegment.CgenSegmentType.TEXT, startIdx, str.substring(startIdx, endIdx)));
                }
                ++i;
            }
        }
        idSegm = idSegments.get(idSegments.size() - 1);
        startIdx = idSegm.startIdx + idSegm.type.prefixLen() + idSegm.value.length() + idSegm.type.postfixLen();
        if (startIdx < (endIdx = str.length())) {
            plainSegments.add(new CgenSegment(CgenSegment.CgenSegmentType.TEXT, startIdx, str.substring(startIdx, endIdx)));
        }
        return plainSegments;
    }

    public static List<@Nullable CgenSegment> extractCgenSegments(String str) {
        List<CgenSegment> idList = CgenManager.extractCgenIdentifierSegments(str);
        List<CgenSegment> plainTextList = CgenManager.extractCgenPlainTextSegments(str, idList);
        ArrayList<@Nullable CgenSegment> allSegmList = new ArrayList<CgenSegment>();
        int i = 0;
        int j = 0;
        int numIds = idList.size();
        int numPlain = plainTextList.size();
        while (i < numIds && j < numPlain) {
            if (idList.get((int)i).startIdx <= plainTextList.get((int)j).startIdx) {
                allSegmList.add(idList.get(i++));
                continue;
            }
            allSegmList.add(plainTextList.get(j++));
        }
        int k = i;
        while (k < numIds) {
            allSegmList.add(idList.get(k));
            ++k;
        }
        k = j;
        while (k < numPlain) {
            allSegmList.add(plainTextList.get(k));
            ++k;
        }
        return allSegmList;
    }

    public static boolean hasMultipleCgenSegments(String line) {
        return line.indexOf(CgenSegment.CgenSegmentType.PARAM.prefix()) != -1 && line.indexOf(CgenSegment.CgenSegmentType.PARAM.postfix()) != -1;
    }

    public synchronized void generateCode(ValidationContext validationContext) {
        this.setvContext(validationContext);
        @NonNull String scriptId = validationContext.getCrtScriptId();
        String scenarioId = this.getValidScriptScenarioId(scriptId);
        CgenScenario scenario = this.scenarioMap.get(scenarioId);
        if (scenario == null) {
            LOGGER.info(Messages.WARN_SELECT_SCENARIO_MSG);
            return;
        }
        FileUnit[] fileUnits = scenario.getUnits();
        RunScriptRequest.ScriptFile[] files = new RunScriptRequest.ScriptFile[fileUnits.length];
        int i = 0;
        while (i < fileUnits.length) {
            files[i] = new RunScriptRequest.ScriptFile(fileUnits[i].getFileName(validationContext, this), UtilsText.safeString(null), fileUnits[i].generate, fileUnits[i].envVarName);
            ++i;
        }
        this.scriptProfile.setFiles(files);
        this.regenerate(true);
        RunScriptRequest.ScriptFile[] scriptFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            RunScriptRequest.ScriptFile scriptFile = scriptFileArray[n2];
            scriptFile.writeFile(UtilsText.safeString((String)Activator.getDefault().getConfigManager().getLogsFolder()));
            ++n2;
        }
    }

    public RunScriptRequest generateRunScriptParams(ValidationContext validationContext, long timeoutMs, boolean partialResults, boolean immediate, Map<String, String> envVars) {
        String scriptId = validationContext.getCrtScriptId();
        return this.generateRunScriptParams(validationContext, scriptId, timeoutMs, partialResults, immediate, envVars);
    }

    public RunScriptRequest generateRunScriptParams(ValidationContext validationContext, long timeoutMs, Map<String, String> envVars) {
        return this.generateRunScriptParams(validationContext, timeoutMs, false, false, envVars);
    }

    public RunScriptRequest generateRunScriptParams(ValidationContext validationContext, Map<String, String> envVars) {
        long timeout = 1800000L;
        return this.generateRunScriptParams(validationContext, timeout, false, false, envVars);
    }

    public RunScriptRequest generateRunScriptParams(ValidationContext validationContext, String scriptId, long timeoutMs, boolean partialResults, boolean immediate, Map<String, String> envVars) {
        String scenarioId = this.getValidScriptScenarioId(scriptId);
        CgenScenario scenario = this.scenarioMap.get(scenarioId);
        FileUnit[] fileUnits = scenario != null ? scenario.getUnits() : new FileUnit[]{};
        @NonNull RunScriptRequest.ScriptFile[] scriptFiles = new RunScriptRequest.ScriptFile[fileUnits.length];
        int i = 0;
        while (i < fileUnits.length) {
            scriptFiles[i] = new RunScriptRequest.ScriptFile(fileUnits[i].getFileName(validationContext, this), UtilsText.safeString(null), fileUnits[i].generate, fileUnits[i].envVarName);
            String envVarName = Objects.requireNonNull(scriptFiles[i].envVarName);
            envVars.put(envVarName, scriptFiles[i].name);
            ++i;
        }
        return new RunScriptRequest(scriptFiles, scriptId, timeoutMs, partialResults, immediate, false, envVars, 50000);
    }

    protected String getFileNamePart(ValidationContext validationContext, FileUnit.DynamicNamePart namePart) {
        VSessionModel.VEvent event = validationContext.getEvent();
        VTable table = Objects.requireNonNull(Objects.requireNonNull(event.getTables())[0]);
        VParamVariation cell = Objects.requireNonNull(Objects.requireNonNull(event.getCells())[0]);
        VScriptConfig scriptConfig = Objects.requireNonNull(event.getScriptConfig());
        switch (namePart) {
            case TABLE_ID: {
                return table.getId();
            }
            case ROW_ID: {
                return Integer.toString(cell.getPos().x);
            }
            case COL_ID: {
                return Integer.toString(cell.getPos().y);
            }
            case SCRIPT_ID: {
                return scriptConfig.getScript().getId();
            }
            case ITERATION_ID: {
                return Integer.toString(event.getIteration());
            }
        }
        throw new IllegalArgumentException(Messages.IllegalFilePart);
    }

    protected Set<String> getScenarioIds(Set<String> scriptIds) {
        @NonNull HashSet<String> scenarioIds = new HashSet<String>();
        for (String scriptId : scriptIds) {
            String scenarioId = this.getValidScriptScenarioId(scriptId);
            scenarioIds.add(UtilsText.safeString((String)scenarioId));
        }
        return scenarioIds;
    }

    public String getTemplateContentsAsPlainText(String templateId) {
        Template template = this.templateMap.get(templateId);
        Template.TemplateFile[] templateFile = this.getValidTemplateFile(this.getvContext(), template);
        StringBuilder buff = new StringBuilder();
        Template.TemplateFile[] templateFileArray = templateFile;
        int n = templateFile.length;
        int n2 = 0;
        while (n2 < n) {
            Template.TemplateFile templFile = templateFileArray[n2];
            CgenSegment[] cgenSegmentArray = templFile.getSegments();
            int n3 = cgenSegmentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                CgenSegment textSegment = cgenSegmentArray[n4];
                buff.append(textSegment.getValue());
                ++n4;
            }
            ++n2;
        }
        return buff.toString();
    }

    protected Set<String> getTemplateIds(Set<String> scenarioIds) {
        HashSet<String> templateIds = new HashSet<String>();
        for (String scenarioId : scenarioIds) {
            CgenScenario scenario = this.scenarioMap.get(scenarioId);
            if (scenario == null) {
                LOGGER.info(Messages.WARN_SELECT_SCENARIO_MSG);
                continue;
            }
            FileUnit[] fileUnitArray = scenario.getUnits();
            int n = fileUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileUnit fileUnit = fileUnitArray[n2];
                String[] stringArray = fileUnit.getTemplateIds();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String templateId = stringArray[n4];
                    templateIds.add(templateId);
                    ++n4;
                }
                ++n2;
            }
        }
        return templateIds;
    }

    public @Nullable String getValidScriptScenarioId(String scriptId) {
        String[][] scenMap;
        String scenarioId = null;
        ScriptTemplate scriptTemplate = this.scriptTemplateMap.get(scriptId);
        if (scriptTemplate == null) {
            return scenarioId;
        }
        String[][] stringArray = scenMap = scriptTemplate.getScenarioMap();
        if (scenMap.length != 0) {
            String[] scenCondPair = stringArray[0];
            scenarioId = scenCondPair[0];
        }
        return scenarioId;
    }

    protected Template.TemplateFile[] getValidTemplateFile(@Nullable ValidationContext validationContext, @Nullable Template template) {
        ArrayList<@Nullable Template.TemplateFile> templateFiles = new ArrayList<Template.TemplateFile>();
        if (template == null) {
            return templateFiles.toArray(new Template.TemplateFile[0]);
        }
        if (template.getFiles().length == 1) {
            templateFiles.add(template.getFiles()[0]);
            return templateFiles.toArray(new Template.TemplateFile[0]);
        }
        boolean foundNonDefaultConditionId = false;
        boolean foundExclusiveTemplate = false;
        boolean ignoreTemplates = false;
        Template.TemplateFile[] templateFileArray = template.getFiles();
        int n = templateFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template.TemplateFile templFile = templateFileArray[n2];
            if (!ignoreTemplates && validationContext != null) {
                templateFiles.add(templFile);
                if (template.isExclusive()) {
                    foundExclusiveTemplate = true;
                    ignoreTemplates = true;
                }
            }
            ++n2;
        }
        if (!foundNonDefaultConditionId && foundExclusiveTemplate) {
            LOGGER.warning(NLS.bind((String)Messages.WarningTemplateIncorectlyDefined, (Object)template.getId()));
        }
        if (templateFiles.isEmpty()) {
            if (template.getDefaultFile() != null) {
                templateFiles.add(template.getDefaultFile());
            } else if (template.allowEmpty()) {
                Template.TemplateFile empty = new Template.TemplateFile(template.id, "");
                CgenSegment[] cgenSegm = new CgenSegment[]{new CgenSegment(CgenSegment.CgenSegmentType.TEXT, 0, "")};
                empty.setSegments(cgenSegm);
                templateFiles.add(empty);
            } else {
                templateFiles.add(template.getDefaultFile());
            }
        }
        return templateFiles.toArray(new Template.TemplateFile[templateFiles.size()]);
    }

    public ValidationContext getvContext() {
        return this.vContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCgenManager(Template[] _initTemplates, ScriptTemplate[] _testTemplates, CgenScenario[] _scenarios) {
        Object[] objectArray = _scenarios;
        int n = _scenarios.length;
        int n2 = 0;
        while (n2 < n) {
            CgenScenario scenario = objectArray[n2];
            this.scenarioMap.put(scenario.getId(), scenario);
            ++n2;
        }
        objectArray = _initTemplates;
        n = _initTemplates.length;
        n2 = 0;
        while (n2 < n) {
            Object template = objectArray[n2];
            this.templateMap.put(((Template)template).getId(), (Template)template);
            ++n2;
        }
        objectArray = _testTemplates;
        n = _testTemplates.length;
        n2 = 0;
        while (n2 < n) {
            Object testTemplate = objectArray[n2];
            this.scriptTemplateMap.put(((Template)testTemplate).getId(), (ScriptTemplate)testTemplate);
            ++n2;
        }
        this.recompile();
        CgenManager cgenManager = this;
        synchronized (cgenManager) {
            this.needToRegenerate = false;
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized boolean isNeedToRegenerate() {
        return this.needToRegenerate;
    }

    public void recompile() {
        @Nullable File file = Activator.getDefault().getConfigManager().findScriptFile(CODE_GENERATION_SCRIPT_NAME);
        if (file != null) {
            this.compiledScript = JavaScriptHelper.compile((File)file);
        } else {
            LOGGER.severe(Messages.CgenManager_0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regenerate(boolean refreshSourcesView) {
        IConfigProvider configController;
        @NonNull ISharedConfiguration sharedConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        @Nullable CompiledScript compiled = this.compiledScript;
        CgenManager cgenManager = this;
        synchronized (cgenManager) {
            if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.ddr.cache.codegenscript.disable")) {
                this.recompile();
            }
            if (compiled != null) {
                this.scriptResult = new CodeGenerator(this.profileProvider, (IScriptFileProvider)Activator.getDefault().getConfigManager(), (IStorageConfigurationPreferencesRead)sharedConfiguration.getPreferences()).generate(compiled);
            } else {
                this.recompile();
            }
        }
        if (refreshSourcesView && (configController = ValidationContext.getInstance().getConfigController()) != null) {
            configController.refreshSourcesView();
        }
    }

    public void setInitialized(boolean _initialized) {
        this.initialized = _initialized;
    }

    public void setvContext(ValidationContext vContext) {
        this.vContext = vContext;
    }

    protected void updateScriptParameterNames(String scriptName, Template.TemplateFile template) {
        CgenSegment[] cgenSegmentArray = template.getSegments();
        int n = cgenSegmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            CgenSegment segment = cgenSegmentArray[n2];
            if (segment.type == CgenSegment.CgenSegmentType.PARAM) {
                segment.setExtraValue(scriptName);
            }
            ++n2;
        }
    }

    public @Nullable ScriptResult getScriptResult() {
        return this.scriptResult;
    }

    public static class CgenScenario {
        private String id;
        private FileUnit @Nullable [] units;
        private boolean isDefault;

        public CgenScenario(String _id, FileUnit[] _units, boolean _isDefault) {
            this.id = _id;
            this.units = CollectionUtils.getSafeClone(_units);
            this.isDefault = _isDefault;
        }

        public String getId() {
            return this.id;
        }

        public FileUnit[] getUnits() {
            FileUnit[] fileUnits = CollectionUtils.getSafeClone(this.units);
            return fileUnits != null ? fileUnits : new FileUnit[]{};
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }

    public static class CgenSegment {
        public CgenSegmentType type;
        public int startIdx;
        public String value;
        public String extraValue = "";

        public CgenSegment(CgenSegmentType _type, int _startIdx, String _value) {
            this.type = _type;
            this.startIdx = _startIdx;
            this.value = _value;
        }

        public CgenSegment(CgenSegmentType _type, String _value) {
            this.type = _type;
            this.startIdx = -1;
            this.value = _value;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CgenSegment other = (CgenSegment)obj;
            if (this.type != other.type) {
                return false;
            }
            return !(this.value.isEmpty() ? other.value.isEmpty() : !this.value.equals(other.value));
        }

        public String getExtraValue() {
            return this.extraValue;
        }

        public int getStartIdx() {
            return this.startIdx;
        }

        public CgenSegmentType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.type.prefix().isEmpty() ? 0 : this.type.hashCode());
            result = 31 * result + (this.value.isEmpty() ? 0 : this.value.hashCode());
            return result;
        }

        public void setExtraValue(String extraValue) {
            this.extraValue = extraValue;
        }

        public String toString() {
            return String.format(Messages.CgenManagerStringFormat, this.type.name(), new Integer(this.startIdx), this.value);
        }

        public static enum CgenSegmentType {
            TEXT,
            LINE_SEP,
            REG_VAL("<<{reg.val.", "}>>", "<<\\{reg.val.[^<>\\n\\.\\{\\}]+\\}>>"),
            REG_VAL_BYTES("<<{reg.val.bytes.", "}>>", "<<\\{reg.val.bytes.[^<>\\n\\.\\{\\}]+\\}>>"),
            REG_ADDR("<<{reg.addr.", "}>>", "<<\\{reg.addr.[^<>\\n\\.\\{\\}]+\\}>>"),
            REG_ADDR_OFFSET("<<{reg.addr.offset.", "}>>", "<<\\{reg.addr.offset.[^<>\\n\\.\\{\\}]+\\}>>"),
            PARAM("<<{", "}>>", "<<\\{[^<>\\n\\.\\{\\}]+\\}>>"),
            TABLE_PARAM("<<{table.", "}>>", "<<\\{table.[^<>\\n\\.\\{\\}]+\\}>>"),
            CUSTOM_PARAM("<<{custom.", "}>>", "<<\\{custom.[^<>\\n\\.\\{\\}]+\\}>>"),
            NEW_PEX_PARAMS("<<{new.pex.", "}>>", "<<\\{new.pex.[^<>\\n\\.\\{\\}]+\\}>>"),
            NEW_VALIDATION_PARAMS("<<{new.validation.", "}>>", "<<\\{new.validation.[^<>\\n\\.\\{\\}]+\\}>>"),
            NEW_SCENARIO_PARAMS("<<{new.scenario.", "}>>", "<<\\{new.scenario.[^<>\\n\\.\\{\\}]+\\}>>"),
            NEW_TEST_PARAMS("<<{new.test.", "}>>", "<<\\{new.test.[^<>\\n\\.\\{\\}]+\\}>>"),
            WIZARD_IMPORT("<<{wizard.import.", "}>>", "<<\\{wizard.import.[^<>\\n\\.\\{\\}]+\\}>>");

            private final String prefix;
            private final String postfix;
            private final String pattern;
            private final int prefixLen;
            private final int postfixLen;

            private CgenSegmentType() {
                this.prefix = "";
                this.postfix = "";
                this.pattern = "";
                this.prefixLen = 0;
                this.postfixLen = 0;
            }

            private CgenSegmentType(String _prefix, String _postfix, String _pattern) {
                this.prefix = _prefix;
                this.postfix = _postfix;
                this.pattern = _pattern;
                this.prefixLen = this.prefix.length();
                this.postfixLen = this.postfix.length();
            }

            public boolean isIdentifier() {
                return !this.pattern.isEmpty() && !this.prefix.isEmpty() && !this.postfix.isEmpty();
            }

            public String pattern() {
                return this.pattern;
            }

            public String postfix() {
                return this.postfix;
            }

            public int postfixLen() {
                return this.postfixLen;
            }

            public String prefix() {
                return this.prefix;
            }

            public int prefixLen() {
                return this.prefixLen;
            }
        }
    }

    private static class CgenSegmentComparator
    implements Comparator<CgenSegment>,
    Serializable {
        private static final long serialVersionUID = -9173391881285748824L;

        @Override
        public int compare(CgenSegment arg0, CgenSegment arg1) {
            if (arg0.startIdx < arg1.startIdx) {
                return -1;
            }
            if (arg0.startIdx > arg1.startIdx) {
                return 1;
            }
            return 0;
        }
    }
}

