/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.indexer.core.internal;

import com.nxp.s32ds.cle.cdt.indexer.core.IndexerService;
import com.nxp.s32ds.cle.cdt.indexer.core.internal.IndexerInstallerActivator;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CDTIndexerServiceImplementation
implements IndexerService {
    private Set<String> indexerKeys = new HashSet<String>();

    public CDTIndexerServiceImplementation() {
        this.indexerKeys.add("indexAllFiles");
        this.indexerKeys.add("indexUnusedHeadersWithDefaultLang");
        this.indexerKeys.add("indexUnusedHeadersWithAlternateLang");
        this.indexerKeys.add("indexOnOpen");
        this.indexerKeys.add("useHeuristicIncludeResolution");
        this.indexerKeys.add("skipIncludedFilesLargerThanMB");
        this.indexerKeys.add("skipFilesLargerThanMB");
        this.indexerKeys.add("skipReferences");
        this.indexerKeys.add("skipImplicitReferences");
        this.indexerKeys.add("skipTypeReferences");
        this.indexerKeys.add("skipMacroReferences");
        this.indexerKeys.add("indexAllHeaderVersions");
        this.indexerKeys.add("useActiveBuildConfiguration");
        this.indexerKeys.add("reindexOnConfigChange");
        this.indexerKeys.add("indexAllVersionsSpecificHeaders");
        this.indexerKeys.add("reindexOnIndexerChange");
        this.indexerKeys.add("enableIndexer");
        this.indexerKeys.add("preferenceScope");
        this.indexerKeys.add("indexerId");
    }

    @Override
    public Set<String> getIndexerKeys() {
        return this.indexerKeys;
    }

    @Override
    public void applayIndexerPreferences(Map<String, String> preferencesMap, IProject project) {
        if (this.indexerKeys.isEmpty()) {
            return;
        }
        if (preferencesMap.containsKey("preferenceScope")) {
            try {
                Integer scope = Integer.parseInt(preferencesMap.get("preferenceScope"));
                IndexerPreferences.setScope((IProject)project, (int)scope);
                Preferences projectPreferences = IndexerPreferences.getProjectPreferences((IProject)project);
                Properties properties = IndexerPreferences.getProperties((IProject)project);
                preferencesMap.entrySet().stream().filter(key -> this.indexerKeys.contains(key.getKey())).forEach(entry -> {
                    Object object = properties.put(entry.getKey(), entry.getValue());
                });
                IndexerPreferences.setProperties((IProject)project, (int)scope, (Properties)properties);
                ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
                ICProjectDescription prefs = prjDescMgr.getProjectDescription(project, true);
                String useActive = preferencesMap.get("useActiveBuildConfiguration");
                prefs.setConfigurationRelations(Boolean.parseBoolean(useActive) ? 2 : 1);
                projectPreferences.flush();
                prjDescMgr.setProjectDescription(project, prefs);
                CCoreInternals.savePreferences((IProject)project, (boolean)false);
            }
            catch (NumberFormatException | CoreException | BackingStoreException e) {
                IndexerInstallerActivator.getInstance().logError(e.getMessage());
            }
        }
    }
}

