/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model.watch;

import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdCompositeWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContext;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContextChangeListener;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContextManager;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModels;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchReadPolicyType;
import java.util.Collection;
import org.eclipse.cdt.dsf.service.DsfSession;

public class SvdCompositeWatchModelContextManager
extends SvdWatchContextManager {
    private final SvdCompositeWatchModel model;

    public SvdCompositeWatchModelContextManager(SvdCompositeWatchModel model) {
        this.model = model;
    }

    @Override
    public void addListener(SvdWatchContextChangeListener listener) {
        this.model.getModels().stream().forEach(m -> m.getContextManager().addListener(listener));
    }

    @Override
    public void removeListener(SvdWatchContextChangeListener listener) {
        this.model.getModels().stream().forEach(m -> m.getContextManager().removeListener(listener));
    }

    @Override
    public SvdWatchContext getContext(SvdRegister register) {
        return SvdWatchModels.getModel(register).getContextManager().getContext(register);
    }

    @Override
    public void sendReadRequest(DsfSession session, Collection<SvdRegister> registers) {
        SvdWatchModels.forEachModel(registers, (m, r) -> m.getContextManager().sendReadRequest(session, (Collection<SvdRegister>)r));
    }

    @Override
    public void setReadPolicyType(DsfSession session, SvdWatchReadPolicyType policyType, Collection<SvdRegister> registers) {
        SvdWatchModels.forEachModel(registers, (m, r) -> m.getContextManager().setReadPolicyType(session, policyType, (Collection<SvdRegister>)r));
    }

    @Override
    public void setContext(SvdRegister register, SvdWatchContext context) {
        SvdWatchModels.getModel(register).getContextManager().setContext(register, context);
    }
}

