/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model;

import com.nxp.s32ds.cdt.svd.model.SvdChildElement;
import com.nxp.s32ds.cdt.svd.model.SvdContainer;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheral;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheralGroup;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class SvdModelBase
extends SvdContainer {
    private final String uid;
    private final SvdSourceType type;

    protected SvdModelBase(String UID, SvdSourceType type) {
        this(UID, type, SvdPeripheralGroup.class);
    }

    public SvdModelBase(String UID, SvdSourceType type, Class<?> ... allowedClasses) {
        super(null, type.name(), null, allowedClasses);
        this.uid = UID;
        this.type = type;
    }

    public SvdSourceType getType() {
        return this.type;
    }

    @Override
    public SvdModelBase getModel() {
        return this;
    }

    @Override
    public SvdChildElement getByPath(String path) {
        String[] strings = SvdModelBase.convertToNull(PATH_SEPARATED_STRINGS.asArray(path));
        if (strings.length == 0) {
            return null;
        }
        if (this.type.name().equals(strings[0])) {
            return super.getByPath(PATH_SEPARATED_STRINGS.toString(Arrays.copyOfRange(strings, 1, strings.length)));
        }
        return super.getByPath(path);
    }

    public SvdChildElement getByShortPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path argument is null");
        }
        String[] strings = PATH_SEPARATED_STRINGS.asArray(path);
        Optional<SvdPeripheral> optional = this.getPeripherals().stream().filter(p -> strings[0].equals(p.getName())).findAny();
        if (!optional.isPresent()) {
            return null;
        }
        SvdPeripheral peripheral = optional.get();
        if (strings.length == 1) {
            return peripheral;
        }
        return peripheral.getByPath(PATH_SEPARATED_STRINGS.toString(Arrays.copyOfRange(strings, 1, strings.length)));
    }

    public List<SvdPeripheral> getPeripherals() {
        return this.getPeripheralGroups().stream().map(g -> g.getPeripherals()).flatMap(c -> c.stream()).collect(Collectors.toList());
    }

    public List<SvdPeripheralGroup> getPeripheralGroups() {
        return this.getElements(SvdPeripheralGroup.class);
    }

    public String getUID() {
        return this.uid;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.type, this.uid);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SvdModelBase)) {
            return false;
        }
        SvdModelBase other = (SvdModelBase)obj;
        return this.type == other.type && Objects.equals(this.uid, other.uid);
    }
}

