/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.parser;

import com.nxp.s32ds.cdt.internal.svd.Messages;
import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.svd.parser.SvdDeviceDescriptor;
import com.nxp.s32ds.cdt.svd.parser.SvdParser;
import com.nxp.s32ds.cdt.svd.parser.model.Device;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSource;
import com.nxp.s32ds.ext.orbit.jaxb.OrbitJAXBContextFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class SvdParserImpl
extends SvdParser {
    private static final String SCHEMA_PATH = "resources/schema/cmsis-svd.xsd";
    private static final Pattern SCHEMA_PATTERN = Pattern.compile("xs:noNamespaceSchemaLocation=\"([^\"]*)\"");
    private final Unmarshaller unmarshaller;
    private final SchemaFactory schemaFactory;

    public SvdParserImpl() throws JAXBException, SAXException, IOException {
        JAXBContext context = OrbitJAXBContextFactory.createContext(Device.class);
        this.unmarshaller = context.createUnmarshaller();
        this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = SvdActivator.getInstance().getPathUrl(SCHEMA_PATH);
        this.setUnmarshallerSchema(schemaUrl);
    }

    @Override
    public SvdDeviceDescriptor parse(SvdSource source) throws CoreException {
        String uid = source.getUID();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = source.getInputStream();){
                this.setSchemaFromSvdFile(uid);
                return new SvdDeviceDescriptor(uid, this.parse(new StreamSource(stream)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | JAXBException | SAXException e) {
            Throwable linkedException;
            Throwable cause = e;
            if (e instanceof JAXBException && (linkedException = ((JAXBException)e).getLinkedException()) != null) {
                cause = linkedException;
            }
            throw new CoreException(SvdActivator.getInstance().createError(NLS.bind((String)Messages.SvdParser_cannot_parse_file, (Object)uid), cause));
        }
    }

    private void setUnmarshallerSchema(URL schemaUrl) throws IOException, SAXException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = schemaUrl.openStream();){
            Schema schema = this.schemaFactory.newSchema(new StreamSource(stream));
            this.unmarshaller.setSchema(schema);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setSchemaFromSvdFile(String uid) throws IOException, SAXException {
        URL svdUrl = this.getURL(uid);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(svdUrl.openStream()));){
            while (true) {
                String nextLine;
                if ((nextLine = reader.readLine()) == null) {
                    return;
                }
                Matcher matcher = SCHEMA_PATTERN.matcher(nextLine);
                try {
                    if (!matcher.find()) continue;
                    URL schemaUrl = new URL(matcher.group(1));
                    this.setUnmarshallerSchema(schemaUrl);
                    return;
                }
                catch (MalformedURLException e) {
                    SvdActivator.getInstance().logError(e.getMessage(), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device parse(Source source) throws JAXBException {
        Unmarshaller unmarshaller = this.unmarshaller;
        synchronized (unmarshaller) {
            return (Device)this.unmarshaller.unmarshal(source, Device.class).getValue();
        }
    }

    private URL getURL(String uid) throws MalformedURLException {
        try {
            return new URL(uid);
        }
        catch (MalformedURLException malformedURLException) {
            String newUid = "file:///" + uid;
            return new URL(newUid);
        }
    }
}

