/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.memory;

import com.nxp.s32ds.cdt.svd.utils.SvdNumberToStrings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.osgi.util.NLS;

public class SvdDsfMemoryRange
implements Comparable<SvdDsfMemoryRange> {
    private final IAddress address;
    private final int size;
    private final int alignment;

    public SvdDsfMemoryRange(IAddress address, int size, int alignment) {
        if (size % alignment != 0) {
            throw new IllegalArgumentException("size must be multiple of alignment");
        }
        this.address = address;
        this.size = size;
        this.alignment = alignment;
    }

    public IAddress getAddress() {
        return this.address;
    }

    public int getSize() {
        return this.size;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public IAddress getLastAddress() {
        return this.address.add((long)(this.size - 1));
    }

    @Override
    public int compareTo(SvdDsfMemoryRange range) {
        int result = this.address.compareTo((Object)range.address);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.size, range.size);
        if (result != 0) {
            return result;
        }
        return Integer.compare(this.alignment, range.alignment);
    }

    public List<SvdDsfMemoryRange> join(SvdDsfMemoryRange range) {
        SvdDsfMemoryRange second;
        SvdDsfMemoryRange first;
        if (this.isTheSameRange(range)) {
            return Collections.singletonList(this.alignment >= range.alignment ? this : range);
        }
        if (this.contains(range)) {
            return this.joinContained(range);
        }
        if (range.contains(this)) {
            return range.joinContained(this);
        }
        if (this.address.compareTo((Object)range.address) < 0) {
            first = this;
            second = range;
        } else {
            first = range;
            second = this;
        }
        if (first.intersects(second)) {
            return first.joinIntersected(second);
        }
        if (first.touches(second)) {
            return first.joinTouched(second);
        }
        return Arrays.asList(first, second);
    }

    private List<SvdDsfMemoryRange> joinTouched(SvdDsfMemoryRange range) {
        if (this.alignment == range.alignment) {
            return Collections.singletonList(new SvdDsfMemoryRange(this.address, this.address.distanceTo(range.getAddress()).intValue() + range.getSize(), this.alignment));
        }
        return Arrays.asList(this, range);
    }

    private List<SvdDsfMemoryRange> joinIntersected(SvdDsfMemoryRange range) {
        int fullSize = this.address.distanceTo(range.getAddress()).intValue() + range.getSize();
        if (this.alignment == range.alignment && fullSize % this.alignment == 0) {
            return Collections.singletonList(new SvdDsfMemoryRange(this.address, fullSize, this.alignment));
        }
        if (this.alignment < range.alignment) {
            int newSize = SvdDsfMemoryRange.alignSize(this.address.distanceTo(range.getAddress()).intValue(), this.alignment);
            return Arrays.asList(this.subRange(0, newSize), range);
        }
        int newSize = SvdDsfMemoryRange.alignSize(fullSize - this.size, range.alignment);
        int offset = range.size - newSize;
        return Arrays.asList(this, range.subRange(offset, range.size));
    }

    private List<SvdDsfMemoryRange> joinContained(SvdDsfMemoryRange range) {
        if (!this.contains(range)) {
            throw new IllegalArgumentException(NLS.bind((String)"Range {0} does not contain range {1}", (Object)this, (Object)range));
        }
        if (this.alignment >= range.alignment) {
            return Collections.singletonList(this);
        }
        ArrayList<SvdDsfMemoryRange> result = new ArrayList<SvdDsfMemoryRange>();
        int distance0 = this.address.distanceTo(range.getAddress()).intValue();
        if (distance0 != 0) {
            result.add(this.subRange(0, SvdDsfMemoryRange.alignSize(distance0, this.alignment)));
        }
        result.add(range);
        int distance1 = distance0 + range.getSize();
        if (distance1 < this.size) {
            result.add(this.subRange(this.size - SvdDsfMemoryRange.alignSize(this.size - distance1, this.alignment), this.size));
        }
        return result;
    }

    private static int alignSize(int size, int alignment) {
        return size % alignment == 0 ? size : size / alignment * alignment + alignment;
    }

    private boolean isTheSameRange(SvdDsfMemoryRange range) {
        return this.address.equals((Object)range.address) && this.size == range.size;
    }

    public List<SvdDsfMemoryRange> delete(SvdDsfMemoryRange range) {
        ArrayList<SvdDsfMemoryRange> list = new ArrayList<SvdDsfMemoryRange>();
        if (!this.intersects(range)) {
            throw new IllegalArgumentException(NLS.bind((String)"Range {0} does not intersect range {1}", (Object)this, (Object)range));
        }
        int distance = range.getAddress().distanceTo(this.getAddress()).intValue();
        int offset = range.getSize() - distance;
        if (distance >= 0) {
            SvdDsfMemoryRange lastSubRange = this.subRange(this.size - SvdDsfMemoryRange.alignSize(this.size - offset, this.alignment), this.size);
            if (lastSubRange != null) {
                list.add(lastSubRange);
            }
        } else {
            SvdDsfMemoryRange lastSubRange;
            SvdDsfMemoryRange firstSubRange = this.subRange(0, SvdDsfMemoryRange.alignSize(-distance, this.alignment));
            if (firstSubRange != null) {
                list.add(firstSubRange);
            }
            if (offset < this.size && (lastSubRange = this.subRange(this.size - SvdDsfMemoryRange.alignSize(this.size - offset, this.alignment), this.size)) != null) {
                list.add(lastSubRange);
            }
        }
        return list;
    }

    private SvdDsfMemoryRange subRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IllegalArgumentException("Argument fromIndex(" + fromIndex + ") < 0");
        }
        if (toIndex > this.size) {
            throw new IllegalArgumentException("Argument toIndex(" + toIndex + ") > size");
        }
        if (fromIndex >= toIndex) {
            return null;
        }
        int size = toIndex - fromIndex;
        IAddress address = this.getAddress().add((long)fromIndex);
        return new SvdDsfMemoryRange(address, size, this.alignment);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.alignment, this.size);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SvdDsfMemoryRange)) {
            return false;
        }
        SvdDsfMemoryRange other = (SvdDsfMemoryRange)obj;
        return Objects.equals(this.address, other.address) && this.alignment == other.alignment && this.size == other.size;
    }

    public boolean contains(SvdDsfMemoryRange range) {
        return this.contains(range.getAddress(), range.getSize());
    }

    public boolean contains(IAddress address) {
        return SvdDsfMemoryRange.contains(this, address);
    }

    public boolean contains(IAddress address, int size) {
        IAddress add = address.add((long)(size - 1));
        return this.contains(address) && this.contains(add);
    }

    public boolean intersects(SvdDsfMemoryRange range) {
        return SvdDsfMemoryRange.contains(this, range.getAddress()) || SvdDsfMemoryRange.contains(range, this.getAddress());
    }

    public boolean touches(SvdDsfMemoryRange range) {
        if (this.intersects(range)) {
            return false;
        }
        int compareTo = this.getAddress().compareTo((Object)range.getAddress());
        if (compareTo < 0) {
            return SvdDsfMemoryRange.touches(this.getLastAddress(), range.getAddress());
        }
        if (compareTo > 0) {
            return SvdDsfMemoryRange.touches(range.getLastAddress(), this.getAddress());
        }
        return false;
    }

    public static boolean contains(SvdDsfMemoryRange range, IAddress address) {
        return range.getAddress().compareTo((Object)address) <= 0 && address.compareTo((Object)range.getLastAddress()) <= 0;
    }

    public static boolean touches(IAddress firstAddress, IAddress secondAddress) {
        return firstAddress.distanceTo(secondAddress).intValue() == 1;
    }

    public String toString() {
        return "[" + SvdNumberToStrings.toHexString(this.address, 32) + "-" + SvdNumberToStrings.toHexString(this.getLastAddress(), 32) + ":" + this.alignment + "]";
    }
}

