/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf;

import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.Messages;
import com.nxp.s32ds.cdt.svd.dsf.SvdDsfSessionCacheManager;
import com.nxp.s32ds.cdt.svd.job.SvdQueueJob;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequest;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequestor;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;

public abstract class SvdDsfUpdatableCache<B, V, R> {
    protected final DsfSession session;
    protected final DsfRequestor<B, V, R> requestor;
    private final AtomicReference<SvdQueueJob<DsfRequest<B, ?>>> jobReference = new AtomicReference();

    public SvdDsfUpdatableCache(DsfSession session, DsfRequestor<B, V, R> requestor) {
        this.session = session;
        this.requestor = requestor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdate() {
        AtomicReference<SvdQueueJob<DsfRequest<B, ?>>> atomicReference = this.jobReference;
        synchronized (atomicReference) {
            return this.jobReference.get() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IDMContext idmContext, Collection<B> ranges) {
        SvdTrace.trace("update start", new Object[0]);
        final long currentTimeMillis = System.currentTimeMillis();
        List requests = ranges.stream().map(range -> DsfRequest.readRequest((DsfSession)this.session, (IDMContext)idmContext, (Object)range)).collect(Collectors.toList());
        AtomicReference<SvdQueueJob<DsfRequest<B, ?>>> atomicReference = this.jobReference;
        synchronized (atomicReference) {
            SvdQueueJob job = this.jobReference.get();
            if (job != null) {
                job.cancel();
            }
            job = new SvdQueueJob<DsfRequest<B, ?>>(Messages.SvdDsfMemoryRangeCache_read_peripheral_registers, requests, r -> this.preform((DsfRequest<B, ?>)r)){

                public boolean belongsTo(Object family) {
                    return family == SvdDsfSessionCacheManager.UPDATE_JOB_FAMILY;
                }
            };
            job.setPriority(10);
            job.setUser(true);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    SvdDsfUpdatableCache.this.finishUpdate(event.getResult(), currentTimeMillis);
                }
            });
            job.schedule();
            this.jobReference.set(job);
        }
        SvdDsfSessionCacheManager.getInstance().fireUpdateStart(this.session);
    }

    public abstract void apply(B var1, R var2);

    private void preform(DsfRequest<B, ?> request) {
        try {
            DsfResponse response = (DsfResponse)this.requestor.requestRead(request).get();
            this.apply(request.base, response.result);
        }
        catch (InterruptedException interruptedException) {
            SvdActivator.getInstance().logError(NLS.bind((String)"Memory range {0} {1} request interrupted", (Object)request.base, (Object)request.type.typeName));
        }
        catch (ExecutionException e) {
            SvdActivator.getInstance().logError(NLS.bind((String)"Memory range {0} {1} request error", (Object)request.base, (Object)request.type.typeName), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelUpdate() {
        AtomicReference<SvdQueueJob<DsfRequest<B, ?>>> atomicReference = this.jobReference;
        synchronized (atomicReference) {
            SvdQueueJob<DsfRequest<B, ?>> job = this.jobReference.get();
            if (job == null) {
                return;
            }
            SvdTrace.trace("cancelUpdate", new Object[0]);
            job.cancel();
            this.jobReference.set(null);
        }
    }

    private void finishUpdate(IStatus status, long currentTimeMillis) {
        SvdDsfSessionCacheManager.getInstance().fireUpdateEnd(this.session);
        switch (status.getSeverity()) {
            case 0: {
                SvdTrace.trace("update finish for {}ms, fireCacheChanged", System.currentTimeMillis() - currentTimeMillis);
                SvdDsfSessionCacheManager.getInstance().fireCacheChanged(this.session);
                break;
            }
            case 8: {
                SvdTrace.trace("update canceled", new Object[0]);
                break;
            }
            default: {
                SvdActivator.getInstance().log(status);
            }
        }
    }
}

