/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.imports.processors;

import com.nxp.s32ds.cle.cdt.project.info.core.imports.PIReader;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.IOptionProcessor;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.OptionDelta;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.PIActivator;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;

public class ToolchainOptionProcessor
implements IOptionProcessor {
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private static final String SLASH = "/";
    private static final String BSLSH = "\\";
    private static final String I = "-I";
    private static final String D = "-D";
    private static final String U = "-U";
    private static final String T = "-T";
    private static final String L = "-L";
    private static final String LIB = "-l";
    private static final String TOOL_C_LINKER = "tool.c.linker";
    private static final String TOOL_ASSEMBLER = "tool.assembler";
    private static final String TOOL_C_COMPILER = "tool.c.compiler";
    private static final String TOOL_GHS_C_LINKER = "toolchain.cc_linker";
    private static final String TOOL_GHS_C_COMPILER = "toolchain.cc_compiler";
    private static final String GHS_C_COMPILER_OPTION_INCLUDE_PATHS = "cc_compiler.project.include_directories";
    private static final String GHS_C_COMPILER_OPTION_PREPROCESSOR_UNDEF_SYMBOLS = "cc_compiler.compiler_diagnostics_c_cplusplus_messages.undefined_preprocessor_symbols";
    private static final String GHS_C_COMPILER_OPTION_PREPROCESSOR_DEF_SYMBOLS = "cc_compiler.preprocessor.define_preprocessor_symbol";
    private static final String GHS_C_LINKER_OPTION_START_ADDRESS = "cc_linker.linker.start_address_symbol_start_address";
    private static final String GHS_C_LINKER_OPTION_LINKER_FILES = "cc_linker.linker.linker_directive_files_with_non_standard_extensions";
    private static final String GHS_C_LINKER_OPTION_LIBRARY_DIRECTORIES = "cc_linker.project.library_directories";
    private static final String GHS_C_LINKER_OPTION_LIBRARIES = "cc_linker.project.libraries";
    private static final String GNU_C_COMPILER_OPTION_INCLUDE_PATHS = "gnu.c.compiler.option.include.paths";
    private static final String GNU_BOTH_ASM_OPTION_INCLUDE_PATHS = "gnu.both.asm.option.include.paths";
    private static final String GNU_C_COMPILER_OPTION_INCLUDE_FILES = "gnu.c.compiler.option.include.files";
    private static final String GNU_C_COMPILER_OPTION_PREPROCESSOR_DEF_SYMBOLS = "gnu.c.compiler.option.preprocessor.def.symbols";
    private static final String GNU_C_COMPILER_OPTION_PREPROCESSOR_UNDEF_SYMBOLS = "gnu.c.compiler.option.preprocessor.undef.symbol";
    private static final String GNU_C_COMPILER_OPTION_OTHER = "gnu.c.compiler.option.misc.other";
    private static final String ASSEMBLER_OPTION_DEFS = "com.freescale.s32ds.cross.gnu.tool.assembler.option.defs";
    protected static final String GNU_C_LINK_OPTION_PATHS = "gnu.c.link.option.paths";
    private static final String CROSS_GNU_TOOL_C_LINKER = "com.freescale.s32ds.cross.gnu.tool.c.linker.option.scriptfile";
    private static final String TOOLCHAIN_SYSROOT_OPTION_NAME = "Sysroot";
    private static final Pattern SCRIPT_FILE_PATTERN = Pattern.compile("-T ?\"([^ ]*)\"|-T ?([^ ]*)");
    private static final Pattern LIBRARY_SEARCH_PATH_PATTERN = Pattern.compile("-L ?\"([^ ]*)\"|-L ?([^ ]*)");
    private static final Pattern SYSROOT_PATTERN = Pattern.compile("--sysroot=\"[^\"]+\"|--sysroot=[^ ]+");
    private static final Pattern INCLUDE_PATH_PATTERN = Pattern.compile("-I ?\"([^\"]+)\"|-I ?([^ ]+)");
    private static final Pattern LIBRARY_NAME_PATTERN = Pattern.compile("-l ?\"([^ ]*)\"|-l ?([^ ]*)");
    private static final Pattern INCLUDE_FILE_PATTERN = Pattern.compile("-include ?\"([^\"]+)\"|-include ?([^ ]+)");
    private static final Pattern DEFINED_SYMBOLS_PATTERN = Pattern.compile("(^|\\s)-D\\S*");
    private static final Pattern UNDEFINED_SYMBOLS_PATTERN = Pattern.compile("(^|\\s)-U\\S*");
    private static final String OTHER_OPTIONS_PREFIX = "-c -fmessage-length";
    private static final String GHS_START_ADDRESS_PREFIX = "-e ";

    protected List<OptionDelta> setToolOption(IConfiguration cfg, ITool tool, IOption option, PIReader piReader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String id = tool.getId();
        if (ToolchainOptionProcessor.isAssembler(id)) {
            result.addAll(this.setASMOption(cfg, tool, option, piReader));
        } else if (ToolchainOptionProcessor.isCCompiler(id)) {
            result.addAll(this.setCompilerOption(cfg, tool, option, piReader));
        } else if (ToolchainOptionProcessor.isLinker(id)) {
            result.addAll(this.setLinkerOption(cfg, tool, option, piReader));
        }
        return result;
    }

    protected List<OptionDelta> setToolChainOption(IConfiguration cfg, IOption option, PIReader piReader) {
        String findSysRootOptionValue;
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        IToolChain toolchain = cfg.getToolChain();
        if (TOOLCHAIN_SYSROOT_OPTION_NAME.equals(option.getName()) && (findSysRootOptionValue = this.findSysRootOptionValue(piReader)) != null) {
            result.add(ToolchainOptionProcessor.setSystemRoot(cfg, (IHoldsOptions)cfg.getToolChain(), option, findSysRootOptionValue));
        }
        result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)toolchain, option, piReader.getOptionsASM()));
        result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)toolchain, option, piReader.getOptionsLinker()));
        result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)toolchain, option, piReader.getOptionsCC()));
        return result;
    }

    private String findSysRootOptionValue(PIReader piReader) {
        if (!EMPTY.equals(this.findValue(SYSROOT_PATTERN, piReader.getOptionsASM()))) {
            return this.findValue(SYSROOT_PATTERN, piReader.getOptionsASM());
        }
        if (!EMPTY.equals(this.findValue(SYSROOT_PATTERN, piReader.getOptionsCC()))) {
            return this.findValue(SYSROOT_PATTERN, piReader.getOptionsCC());
        }
        if (!EMPTY.equals(this.findValue(SYSROOT_PATTERN, piReader.getOptionsLinker()))) {
            return this.findValue(SYSROOT_PATTERN, piReader.getOptionsLinker());
        }
        return null;
    }

    private List<OptionDelta> setASMOption(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String id = option.getId();
        List<String> optionsASM = reader.getOptionsASM();
        if (id.startsWith(GNU_BOTH_ASM_OPTION_INCLUDE_PATHS)) {
            result.addAll(this.setIncludePaths(cfg, iTool, option, optionsASM, reader));
        } else if (id.startsWith(ASSEMBLER_OPTION_DEFS)) {
            result.addAll(this.setDefinedSymbolsPattern(cfg, iTool, option, optionsASM));
        } else if (option.getApplicableValues().length > 0) {
            result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)iTool, option, optionsASM));
        } else if (TOOLCHAIN_SYSROOT_OPTION_NAME.equals(option.getName())) {
            result.add(ToolchainOptionProcessor.setSystemRoot(cfg, (IHoldsOptions)iTool, option, this.findValue(SYSROOT_PATTERN, optionsASM)));
        }
        return result;
    }

    protected List<OptionDelta> setLinkerOption(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        List<String> optionsCLinker = reader.getOptionsLinker();
        String id = option.getId();
        if (option.getApplicableValues().length > 0) {
            result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)iTool, option, optionsCLinker));
        } else if (TOOLCHAIN_SYSROOT_OPTION_NAME.equals(option.getName())) {
            result.add(ToolchainOptionProcessor.setSystemRoot(cfg, (IHoldsOptions)iTool, option, this.findValue(SYSROOT_PATTERN, optionsCLinker)));
        } else if (id.startsWith(CROSS_GNU_TOOL_C_LINKER) || id.endsWith(GHS_C_LINKER_OPTION_LINKER_FILES)) {
            result.addAll(this.setScriptFile(cfg, iTool, option, reader));
        } else if (id.startsWith(GNU_C_LINK_OPTION_PATHS) || id.endsWith(GHS_C_LINKER_OPTION_LIBRARY_DIRECTORIES)) {
            result.addAll(this.setLibrarySearchPath(cfg, iTool, option, reader));
        } else if (id.endsWith(GHS_C_LINKER_OPTION_LIBRARIES)) {
            result.addAll(this.setLibraries(cfg, iTool, option, optionsCLinker));
        } else if (id.endsWith(GHS_C_LINKER_OPTION_START_ADDRESS)) {
            result.addAll(this.setOtherOptions(cfg, iTool, option, optionsCLinker));
        }
        return result;
    }

    protected List<OptionDelta> setCompilerOption(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        List<String> optionsCompiler = reader.getOptionsCC();
        String id = option.getId();
        if (id.startsWith(GNU_C_COMPILER_OPTION_INCLUDE_PATHS) || id.endsWith(GHS_C_COMPILER_OPTION_INCLUDE_PATHS)) {
            result.addAll(this.setIncludePaths(cfg, iTool, option, optionsCompiler, reader));
        } else if (id.startsWith(GNU_C_COMPILER_OPTION_INCLUDE_FILES)) {
            result.addAll(this.setIncludeFiles(cfg, iTool, option, optionsCompiler, reader));
        } else if (id.startsWith(GNU_C_COMPILER_OPTION_PREPROCESSOR_DEF_SYMBOLS) || id.endsWith(GHS_C_COMPILER_OPTION_PREPROCESSOR_DEF_SYMBOLS)) {
            result.addAll(this.setPreprocessorDef(cfg, iTool, option, optionsCompiler));
        } else if (id.equals(GNU_C_COMPILER_OPTION_OTHER)) {
            result.addAll(this.setOtherOptions(cfg, iTool, option, optionsCompiler));
        } else if (id.startsWith(GNU_C_COMPILER_OPTION_PREPROCESSOR_UNDEF_SYMBOLS) || id.endsWith(GHS_C_COMPILER_OPTION_PREPROCESSOR_UNDEF_SYMBOLS)) {
            result.addAll(this.setPreprocessorUndef(cfg, iTool, option, optionsCompiler));
        } else if (option.getApplicableValues().length > 0) {
            result.addAll(this.setEnumerationOption(cfg, (IHoldsOptions)iTool, option, optionsCompiler));
        } else if (TOOLCHAIN_SYSROOT_OPTION_NAME.equals(option.getName())) {
            result.add(ToolchainOptionProcessor.setSystemRoot(cfg, (IHoldsOptions)iTool, option, this.findValue(SYSROOT_PATTERN, optionsCompiler)));
        }
        return result;
    }

    private static boolean isLinker(String toolId) {
        return toolId.contains(TOOL_C_LINKER) || toolId.contains(TOOL_GHS_C_LINKER);
    }

    private static boolean isAssembler(String toolId) {
        return toolId.contains(TOOL_ASSEMBLER);
    }

    private static boolean isCCompiler(String toolId) {
        return toolId.contains(TOOL_C_COMPILER) || toolId.contains(TOOL_GHS_C_COMPILER);
    }

    private List<OptionDelta> setPreprocessorDef(IConfiguration cfg, ITool tool, IOption option, List<String> optionsCompiler) {
        return this.setDefines(cfg, tool, option, optionsCompiler);
    }

    private List<OptionDelta> setDefinedSymbolsPattern(IConfiguration cfg, ITool tool, IOption option, List<String> optionsASM) {
        return this.setDefines(cfg, tool, option, optionsASM);
    }

    private List<OptionDelta> setDefines(IConfiguration cfg, ITool tool, IOption option, List<String> options) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(DEFINED_SYMBOLS_PATTERN, options).trim();
        if (!optional.equals(EMPTY)) {
            result.add(this.setOption(DEFINED_SYMBOLS_PATTERN, cfg, tool, option, optional, D));
        }
        return result;
    }

    private List<OptionDelta> setPreprocessorUndef(IConfiguration cfg, ITool tool, IOption option, List<String> options) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(UNDEFINED_SYMBOLS_PATTERN, options).trim();
        if (!optional.equals(EMPTY)) {
            result.add(this.setOption(UNDEFINED_SYMBOLS_PATTERN, cfg, tool, option, optional, U));
        }
        return result;
    }

    protected List<OptionDelta> setOtherOptions(IConfiguration cfg, ITool tool, IOption option, List<String> options) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        for (String value : options) {
            if (value.startsWith(OTHER_OPTIONS_PREFIX)) {
                result.add(new OptionDelta(cfg, (IHoldsOptions)tool, option, value));
                break;
            }
            if (!value.startsWith(GHS_START_ADDRESS_PREFIX)) continue;
            result.add(new OptionDelta(cfg, (IHoldsOptions)tool, option, value.replaceFirst(GHS_START_ADDRESS_PREFIX, EMPTY)));
            break;
        }
        return result;
    }

    private List<OptionDelta> setLibraries(IConfiguration cfg, ITool tool, IOption option, List<String> options) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(LIBRARY_NAME_PATTERN, options);
        if (!optional.equals(EMPTY)) {
            String[] files = optional.split(SPACE);
            int i = 0;
            while (i < files.length) {
                files[i] = files[i].replaceFirst(LIB, EMPTY);
                ++i;
            }
            result.add(new OptionDelta(cfg, (IHoldsOptions)tool, option, files));
        }
        return result;
    }

    protected List<OptionDelta> setScriptFile(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(SCRIPT_FILE_PATTERN, reader.getOptionsLinker());
        if (!optional.equals(EMPTY)) {
            CharSequence[] locations = optional.split(SPACE);
            int i = 0;
            while (i < locations.length) {
                locations[i] = this.replaceOldProjectLocationToNewInString((String)locations[i], cfg, reader);
                ++i;
            }
            String resStr = String.join((CharSequence)SPACE, locations);
            result.add(this.setOption(SCRIPT_FILE_PATTERN, cfg, iTool, option, resStr, T));
        }
        return result;
    }

    protected List<OptionDelta> setIncludePaths(IConfiguration cfg, ITool iTool, IOption option, List<String> optionValues, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(INCLUDE_PATH_PATTERN, optionValues);
        if (!optional.equals(EMPTY)) {
            optional = this.replaceOldProjectLocationToNewInString(optional, cfg, reader);
            result.add(this.setOption(INCLUDE_PATH_PATTERN, cfg, iTool, option, optional, I));
        }
        return result;
    }

    protected List<OptionDelta> setIncludeFiles(IConfiguration cfg, ITool iTool, IOption option, List<String> optionValues, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String optional = this.findValue(INCLUDE_FILE_PATTERN, optionValues);
        if (!optional.equals(EMPTY)) {
            optional = this.replaceOldProjectLocationToNewInString(optional, cfg, reader);
            result.add(this.setOption(INCLUDE_FILE_PATTERN, cfg, iTool, option, optional, I));
        }
        return result;
    }

    protected List<OptionDelta> setLibrarySearchPath(IConfiguration cfg, ITool iTool, IOption option, PIReader reader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        List<String> optionsCLinker = reader.getOptionsLinker();
        String optional = this.findValue(LIBRARY_SEARCH_PATH_PATTERN, optionsCLinker);
        if (!optional.equals(EMPTY)) {
            optional = this.replaceOldProjectLocationToNewInString(optional, cfg, reader);
            result.add(this.setOption(LIBRARY_SEARCH_PATH_PATTERN, cfg, iTool, option, optional, L));
        }
        return result;
    }

    protected List<OptionDelta> setEnumerationOption(IConfiguration cfg, IHoldsOptions holdsOptions, IOption iOption, List<String> values) {
        ArrayList<String> valuesToSet = new ArrayList<String>();
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        String[] stringArray = iOption.getApplicableValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String optionValueFromGUI = stringArray[n2];
            try {
                String commandValue = iOption.getCommand(iOption.getEnumeratedId(optionValueFromGUI));
                for (String xmlValue : values) {
                    if (commandValue.isEmpty() || !xmlValue.contains(commandValue)) continue;
                    valuesToSet.add(optionValueFromGUI);
                }
                if (!valuesToSet.isEmpty()) {
                    String valueToSet = ToolchainOptionProcessor.processCollisionValues(cfg, holdsOptions, valuesToSet);
                    String optionValueId = iOption.getEnumeratedId(valueToSet);
                    result.add(new OptionDelta(cfg, holdsOptions, iOption, optionValueId));
                }
            }
            catch (BuildException e) {
                PIActivator.getDefault().logError(e.getMessage());
            }
            ++n2;
        }
        return result;
    }

    protected static String processCollisionValues(IConfiguration cfg, IHoldsOptions holdsOptions, List<String> valuesToSet) {
        String valueToSet = null;
        int length = -1;
        for (String string : valuesToSet) {
            if (string.length() <= length) continue;
            length = string.length();
            valueToSet = string;
        }
        return valueToSet;
    }

    private static OptionDelta setSystemRoot(IConfiguration cfg, IHoldsOptions holdsOptions, IOption iOption, String value) {
        return new OptionDelta(cfg, holdsOptions, iOption, value);
    }

    protected OptionDelta setOption(Pattern pattern, IConfiguration cfg, ITool iTool, IOption option, String optional, String optionSymbol) {
        Matcher matcher = pattern.matcher(optional);
        LinkedHashSet<String> lines = new LinkedHashSet<String>();
        while (matcher.find()) {
            String targetOption = null;
            if (matcher.groupCount() > 1) {
                ToolchainOptionProcessor.setPathsOptions(cfg, optionSymbol, matcher, lines);
            } else {
                targetOption = matcher.group(0).replace(optionSymbol, EMPTY);
            }
            if (targetOption == null) continue;
            if (targetOption.startsWith(SPACE)) {
                targetOption = targetOption.substring(1);
            }
            lines.add(targetOption);
        }
        return new OptionDelta(cfg, (IHoldsOptions)iTool, option, lines.toArray(new String[lines.size()]));
    }

    private static void setPathsOptions(IConfiguration cfg, String optionSymbol, Matcher matcher, Set<String> lines) {
        int i = 1;
        while (i <= matcher.groupCount()) {
            String group;
            if ((I.equals(optionSymbol) || T.equals(optionSymbol) || L.equals(optionSymbol)) && (group = matcher.group(i)) != null) {
                if (ToolchainOptionProcessor.isContainsCDTVars(cfg, group) || Paths.get(group, new String[0]).isAbsolute()) {
                    lines.add(QUOTE + group + QUOTE);
                } else {
                    lines.add("\"${ProjDirPath}/" + ToolchainOptionProcessor.removePrefix(group.replace(BSLSH, SLASH)) + QUOTE);
                }
            }
            ++i;
        }
    }

    private static String removePrefix(String group) {
        while (group.startsWith("../") || group.startsWith("./")) {
            String string = group = group.startsWith("../") ? group.substring(3, group.length()) : group.substring(2, group.length());
        }
        return group;
    }

    private static boolean isContainsCDTVars(IConfiguration cfg, String group) {
        try {
            return Arrays.stream(CCorePlugin.getDefault().getCdtVariableManager().getVariables(ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)cfg))).filter(p -> group.contains(p.getName())).findAny().isPresent();
        }
        catch (Exception e) {
            PIActivator.getDefault().logError(e.getMessage());
            return false;
        }
    }

    protected String findValue(Pattern pattern, List<String> values) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : values) {
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                stringBuilder.append(matcher.group(0)).append(SPACE);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public List<OptionDelta> prepareChanges(IConfiguration cfg, PIReader piReader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        Arrays.stream(cfg.getToolChain().getOptions()).forEach(option -> {
            boolean bl = result.addAll(this.setToolChainOption(cfg, (IOption)option, piReader));
        });
        Arrays.stream(cfg.getToolChain().getTools()).forEach(tool -> Arrays.stream(tool.getOptions()).forEach(option -> result.addAll(this.setToolOption(cfg, (ITool)tool, (IOption)option, piReader))));
        return result;
    }
}

